/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<AttributeType, List<AttributeType>> subordinateTypes;
    private ConcurrentHashMap<String, AttributeType> attributeTypes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ObjectClass> objectClasses = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AttributeSyntax> syntaxes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MatchingRule> matchingRules = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ApproximateMatchingRule> approximateMatchingRules = new ConcurrentHashMap();
    private ConcurrentHashMap<String, EqualityMatchingRule> equalityMatchingRules = new ConcurrentHashMap();
    private ConcurrentHashMap<String, OrderingMatchingRule> orderingMatchingRules = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SubstringMatchingRule> substringMatchingRules = new ConcurrentHashMap();
    private ConcurrentHashMap<MatchingRule, MatchingRuleUse> matchingRuleUses = new ConcurrentHashMap();
    private ConcurrentHashMap<ObjectClass, DITContentRule> ditContentRules = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, DITStructureRule> ditStructureRulesByID = new ConcurrentHashMap();
    private ConcurrentHashMap<NameForm, DITStructureRule> ditStructureRulesByNameForm = new ConcurrentHashMap();
    private ConcurrentHashMap<ObjectClass, NameForm> nameFormsByOC = new ConcurrentHashMap();
    private ConcurrentHashMap<String, NameForm> nameFormsByName = new ConcurrentHashMap();
    private LinkedHashSet<AttributeValue> syntaxSet;
    private LinkedHashSet<AttributeValue> attributeTypeSet;
    private LinkedHashSet<AttributeValue> ditContentRuleSet;
    private LinkedHashSet<AttributeValue> ditStructureRuleSet;
    private LinkedHashSet<AttributeValue> matchingRuleSet;
    private LinkedHashSet<AttributeValue> matchingRuleUseSet;
    private LinkedHashSet<AttributeValue> nameFormSet;
    private LinkedHashSet<AttributeValue> objectClassSet;
    private long oldestModificationTime;
    private long youngestModificationTime;
    private LinkedHashSet<AttributeValue> synchronizationState = null;

    public Schema() {
        this.subordinateTypes = new ConcurrentHashMap();
        this.syntaxSet = new LinkedHashSet();
        this.attributeTypeSet = new LinkedHashSet();
        this.ditContentRuleSet = new LinkedHashSet();
        this.ditStructureRuleSet = new LinkedHashSet();
        this.matchingRuleSet = new LinkedHashSet();
        this.matchingRuleUseSet = new LinkedHashSet();
        this.nameFormSet = new LinkedHashSet();
        this.objectClassSet = new LinkedHashSet();
        this.youngestModificationTime = this.oldestModificationTime = System.currentTimeMillis();
    }

    public final ConcurrentHashMap<String, AttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public final LinkedHashSet<AttributeValue> getAttributeTypeSet() {
        return this.attributeTypeSet;
    }

    public boolean hasAttributeType(String lowerName) {
        return this.attributeTypes.containsKey(lowerName);
    }

    public final AttributeType getAttributeType(String lowerName) {
        return this.attributeTypes.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerAttributeType(AttributeType attributeType, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, AttributeType> concurrentHashMap = this.attributeTypes;
        synchronized (concurrentHashMap) {
            if (!overwriteExisting) {
                String oid = StaticUtils.toLowerCase(attributeType.getOID());
                if (this.attributeTypes.containsKey(oid)) {
                    AttributeType conflictingType = this.attributeTypes.get(oid);
                    int msgID = 196792;
                    String message = MessageHandler.getMessage(msgID, attributeType.getNameOrOID(), oid, conflictingType.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                for (String name : attributeType.getNormalizedNames()) {
                    if (!this.attributeTypes.containsKey(name)) continue;
                    AttributeType conflictingType = this.attributeTypes.get(name);
                    int msgID = 196793;
                    String message = MessageHandler.getMessage(msgID, attributeType.getNameOrOID(), name, conflictingType.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            this.attributeTypes.put(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String name : attributeType.getNormalizedNames()) {
                this.attributeTypes.put(name, attributeType);
            }
            AttributeType superiorType = attributeType.getSuperiorType();
            if (superiorType != null) {
                this.registerSubordinateType(attributeType, superiorType);
            }
            String valueString = attributeType.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.attributeTypeSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterAttributeType(AttributeType attributeType) {
        ConcurrentHashMap<String, AttributeType> concurrentHashMap = this.attributeTypes;
        synchronized (concurrentHashMap) {
            this.attributeTypes.remove(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String name : attributeType.getNormalizedNames()) {
                this.attributeTypes.remove(name, attributeType);
            }
            AttributeType superiorType = attributeType.getSuperiorType();
            if (superiorType != null) {
                this.deregisterSubordinateType(attributeType, superiorType);
            }
            String valueString = attributeType.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.attributeTypeSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    private final void registerSubordinateType(AttributeType attributeType, AttributeType superiorType) {
        List<AttributeType> subTypes = this.subordinateTypes.get(superiorType);
        if (subTypes == null) {
            superiorType.setMayHaveSubordinateTypes();
            subTypes = new LinkedList<AttributeType>();
            subTypes.add(attributeType);
            this.subordinateTypes.put(superiorType, subTypes);
        } else if (!subTypes.contains(attributeType)) {
            superiorType.setMayHaveSubordinateTypes();
            subTypes.add(attributeType);
            AttributeType higherSuperior = superiorType.getSuperiorType();
            if (higherSuperior != null) {
                this.registerSubordinateType(attributeType, higherSuperior);
            }
        }
    }

    private final void deregisterSubordinateType(AttributeType attributeType, AttributeType superiorType) {
        AttributeType higherSuperior;
        List<AttributeType> subTypes = this.subordinateTypes.get(superiorType);
        if (subTypes != null && subTypes.remove(attributeType) && (higherSuperior = superiorType.getSuperiorType()) != null) {
            this.deregisterSubordinateType(attributeType, higherSuperior);
        }
    }

    public final Iterable<AttributeType> getSubTypes(AttributeType attributeType) {
        List<AttributeType> subTypes = this.subordinateTypes.get(attributeType);
        if (subTypes == null) {
            return Collections.emptyList();
        }
        return subTypes;
    }

    public final ConcurrentHashMap<String, ObjectClass> getObjectClasses() {
        return this.objectClasses;
    }

    public final LinkedHashSet<AttributeValue> getObjectClassSet() {
        return this.objectClassSet;
    }

    public boolean hasObjectClass(String lowerName) {
        return this.objectClasses.containsKey(lowerName);
    }

    public final ObjectClass getObjectClass(String lowerName) {
        return this.objectClasses.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerObjectClass(ObjectClass objectClass, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, ObjectClass> concurrentHashMap = this.objectClasses;
        synchronized (concurrentHashMap) {
            if (!overwriteExisting) {
                String oid = StaticUtils.toLowerCase(objectClass.getOID());
                if (this.objectClasses.containsKey(oid)) {
                    ObjectClass conflictingClass = this.objectClasses.get(oid);
                    int msgID = 196794;
                    String message = MessageHandler.getMessage(msgID, objectClass.getNameOrOID(), oid, conflictingClass.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                for (String name : objectClass.getNormalizedNames()) {
                    if (!this.objectClasses.containsKey(name)) continue;
                    ObjectClass conflictingClass = this.objectClasses.get(name);
                    int msgID = 196795;
                    String message = MessageHandler.getMessage(msgID, objectClass.getNameOrOID(), name, conflictingClass.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            this.objectClasses.put(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (String name : objectClass.getNormalizedNames()) {
                this.objectClasses.put(name, objectClass);
            }
            String valueString = objectClass.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.objectClassSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterObjectClass(ObjectClass objectClass) {
        ConcurrentHashMap<String, ObjectClass> concurrentHashMap = this.objectClasses;
        synchronized (concurrentHashMap) {
            this.objectClasses.remove(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (String name : objectClass.getNormalizedNames()) {
                this.objectClasses.remove(name, objectClass);
            }
            String valueString = objectClass.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.objectClassSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<String, AttributeSyntax> getSyntaxes() {
        return this.syntaxes;
    }

    public final LinkedHashSet<AttributeValue> getSyntaxSet() {
        return this.syntaxSet;
    }

    public boolean hasSyntax(String lowerName) {
        return this.syntaxes.containsKey(lowerName);
    }

    public final AttributeSyntax getSyntax(String lowerName) {
        return this.syntaxes.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerSyntax(AttributeSyntax syntax, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, AttributeSyntax> concurrentHashMap = this.syntaxes;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting && this.syntaxes.containsKey(oid = StaticUtils.toLowerCase(syntax.getOID()))) {
                AttributeSyntax conflictingSyntax = this.syntaxes.get(oid);
                int msgID = 196796;
                String message = MessageHandler.getMessage(msgID, syntax.getSyntaxName(), oid, conflictingSyntax.getSyntaxName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
            }
            this.syntaxes.put(StaticUtils.toLowerCase(syntax.getOID()), syntax);
            String valueString = syntax.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.syntaxSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterSyntax(AttributeSyntax syntax) {
        ConcurrentHashMap<String, AttributeSyntax> concurrentHashMap = this.syntaxes;
        synchronized (concurrentHashMap) {
            this.syntaxes.remove(StaticUtils.toLowerCase(syntax.getOID()), syntax);
            String valueString = syntax.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.syntaxSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<String, MatchingRule> getMatchingRules() {
        return this.matchingRules;
    }

    public final LinkedHashSet<AttributeValue> getMatchingRuleSet() {
        return this.matchingRuleSet;
    }

    public boolean hasMatchingRule(String lowerName) {
        return this.matchingRules.containsKey(lowerName);
    }

    public final MatchingRule getMatchingRule(String lowerName) {
        return this.matchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerMatchingRule(MatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        if (matchingRule instanceof ApproximateMatchingRule) {
            this.registerApproximateMatchingRule((ApproximateMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof EqualityMatchingRule) {
            this.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof OrderingMatchingRule) {
            this.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof SubstringMatchingRule) {
            this.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, overwriteExisting);
        } else {
            ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
            synchronized (concurrentHashMap) {
                if (!overwriteExisting) {
                    String oid = StaticUtils.toLowerCase(matchingRule.getOID());
                    if (this.matchingRules.containsKey(oid)) {
                        MatchingRule conflictingRule = this.matchingRules.get(oid);
                        int msgID = 196797;
                        String message = MessageHandler.getMessage(msgID, matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                    }
                    String name = matchingRule.getName();
                    if (name != null && this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) {
                        MatchingRule conflictingRule = this.matchingRules.get(name);
                        int msgID = 196798;
                        String message = MessageHandler.getMessage(msgID, matchingRule.getOID(), name, conflictingRule.getOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                    }
                }
                this.matchingRules.put(StaticUtils.toLowerCase(matchingRule.getOID()), matchingRule);
                String name = matchingRule.getName();
                if (name != null) {
                    this.matchingRules.put(StaticUtils.toLowerCase(name), matchingRule);
                }
                String valueString = matchingRule.toString();
                ASN1OctetString rawValue = new ASN1OctetString(valueString);
                ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterMatchingRule(MatchingRule matchingRule) {
        if (matchingRule instanceof ApproximateMatchingRule) {
            this.deregisterApproximateMatchingRule((ApproximateMatchingRule)matchingRule);
        } else if (matchingRule instanceof EqualityMatchingRule) {
            this.deregisterEqualityMatchingRule((EqualityMatchingRule)matchingRule);
        } else if (matchingRule instanceof OrderingMatchingRule) {
            this.deregisterOrderingMatchingRule((OrderingMatchingRule)matchingRule);
        } else if (matchingRule instanceof SubstringMatchingRule) {
            this.deregisterSubstringMatchingRule((SubstringMatchingRule)matchingRule);
        } else {
            ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
            synchronized (concurrentHashMap) {
                this.matchingRules.remove(StaticUtils.toLowerCase(matchingRule.getOID()), matchingRule);
                String name = matchingRule.getName();
                if (name != null) {
                    this.matchingRules.remove(StaticUtils.toLowerCase(name), matchingRule);
                }
                String valueString = matchingRule.toString();
                ASN1OctetString rawValue = new ASN1OctetString(valueString);
                ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
            }
        }
    }

    public final ConcurrentHashMap<String, ApproximateMatchingRule> getApproximateMatchingRules() {
        return this.approximateMatchingRules;
    }

    public final ApproximateMatchingRule getApproximateMatchingRule(String lowerName) {
        return this.approximateMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerApproximateMatchingRule(ApproximateMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String name;
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    int msgID = 196797;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                name = matchingRule.getName();
                if (name != null && this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) {
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    int msgID = 196798;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.approximateMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.approximateMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterApproximateMatchingRule(ApproximateMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.approximateMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            String name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.approximateMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<String, EqualityMatchingRule> getEqualityMatchingRules() {
        return this.equalityMatchingRules;
    }

    public final EqualityMatchingRule getEqualityMatchingRule(String lowerName) {
        return this.equalityMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerEqualityMatchingRule(EqualityMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String name;
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    int msgID = 196797;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                name = matchingRule.getName();
                if (name != null && this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) {
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    int msgID = 196798;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.equalityMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.equalityMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterEqualityMatchingRule(EqualityMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.equalityMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            String name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.equalityMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<String, OrderingMatchingRule> getOrderingMatchingRules() {
        return this.orderingMatchingRules;
    }

    public final OrderingMatchingRule getOrderingMatchingRule(String lowerName) {
        return this.orderingMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerOrderingMatchingRule(OrderingMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String name;
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    int msgID = 196797;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                name = matchingRule.getName();
                if (name != null && this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) {
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    int msgID = 196798;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.orderingMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.orderingMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterOrderingMatchingRule(OrderingMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.orderingMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            String name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.orderingMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<String, SubstringMatchingRule> getSubstringMatchingRules() {
        return this.substringMatchingRules;
    }

    public final SubstringMatchingRule getSubstringMatchingRule(String lowerName) {
        return this.substringMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerSubstringMatchingRule(SubstringMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String name;
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    int msgID = 196797;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                name = matchingRule.getName();
                if (name != null && this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) {
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    int msgID = 196798;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.substringMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.substringMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterSubstringMatchingRule(SubstringMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.substringMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            String name = matchingRule.getName();
            if (name != null) {
                name = StaticUtils.toLowerCase(name);
                this.substringMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        return this.matchingRuleUses;
    }

    public final LinkedHashSet<AttributeValue> getMatchingRuleUseSet() {
        return this.matchingRuleUseSet;
    }

    public boolean hasMatchingRuleUse(MatchingRule matchingRule) {
        return this.matchingRuleUses.containsKey(matchingRule);
    }

    public final MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return this.matchingRuleUses.get(matchingRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerMatchingRuleUse(MatchingRuleUse matchingRuleUse, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<MatchingRule, MatchingRuleUse> concurrentHashMap = this.matchingRuleUses;
        synchronized (concurrentHashMap) {
            MatchingRule matchingRule = matchingRuleUse.getMatchingRule();
            if (!overwriteExisting && this.matchingRuleUses.containsKey(matchingRule)) {
                MatchingRuleUse conflictingUse = this.matchingRuleUses.get(matchingRule);
                int msgID = 196799;
                String message = MessageHandler.getMessage(msgID, matchingRuleUse.getName(), matchingRule.getNameOrOID(), conflictingUse.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
            }
            this.matchingRuleUses.put(matchingRule, matchingRuleUse);
            String valueString = matchingRuleUse.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleUseSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        ConcurrentHashMap<MatchingRule, MatchingRuleUse> concurrentHashMap = this.matchingRuleUses;
        synchronized (concurrentHashMap) {
            this.matchingRuleUses.remove(matchingRuleUse.getMatchingRule(), matchingRuleUse);
            String valueString = matchingRuleUse.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.matchingRuleUseSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final ConcurrentHashMap<ObjectClass, DITContentRule> getDITContentRules() {
        return this.ditContentRules;
    }

    public final LinkedHashSet<AttributeValue> getDITContentRuleSet() {
        return this.ditContentRuleSet;
    }

    public boolean hasDITContentRule(ObjectClass objectClass) {
        return this.ditContentRules.containsKey(objectClass);
    }

    public final DITContentRule getDITContentRule(ObjectClass objectClass) {
        return this.ditContentRules.get(objectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDITContentRule(DITContentRule ditContentRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<ObjectClass, DITContentRule> concurrentHashMap = this.ditContentRules;
        synchronized (concurrentHashMap) {
            ObjectClass objectClass = ditContentRule.getStructuralClass();
            if (!overwriteExisting && this.ditContentRules.containsKey(objectClass)) {
                DITContentRule conflictingRule = this.ditContentRules.get(objectClass);
                int msgID = 196800;
                String message = MessageHandler.getMessage(msgID, ditContentRule.getName(), objectClass.getNameOrOID(), conflictingRule.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
            }
            this.ditContentRules.put(objectClass, ditContentRule);
            String valueString = ditContentRule.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.ditContentRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterDITContentRule(DITContentRule ditContentRule) {
        ConcurrentHashMap<ObjectClass, DITContentRule> concurrentHashMap = this.ditContentRules;
        synchronized (concurrentHashMap) {
            this.ditContentRules.remove(ditContentRule.getStructuralClass(), ditContentRule);
            String valueString = ditContentRule.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.ditContentRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final LinkedHashSet<AttributeValue> getDITStructureRuleSet() {
        return this.ditStructureRuleSet;
    }

    public final ConcurrentHashMap<Integer, DITStructureRule> getDITStructureRulesByID() {
        return this.ditStructureRulesByID;
    }

    public final ConcurrentHashMap<NameForm, DITStructureRule> getDITStructureRulesByNameForm() {
        return this.ditStructureRulesByNameForm;
    }

    public boolean hasDITStructureRule(int ruleID) {
        return this.ditStructureRulesByID.containsKey(ruleID);
    }

    public boolean hasDITStructureRule(NameForm nameForm) {
        return this.ditStructureRulesByNameForm.containsKey(nameForm);
    }

    public final DITStructureRule getDITStructureRule(int ruleID) {
        return this.ditStructureRulesByID.get(ruleID);
    }

    public final DITStructureRule getDITStructureRule(NameForm nameForm) {
        return this.ditStructureRulesByNameForm.get(nameForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDITStructureRule(DITStructureRule ditStructureRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<NameForm, DITStructureRule> concurrentHashMap = this.ditStructureRulesByNameForm;
        synchronized (concurrentHashMap) {
            NameForm nameForm = ditStructureRule.getNameForm();
            int ruleID = ditStructureRule.getRuleID();
            if (!overwriteExisting) {
                if (this.ditStructureRulesByNameForm.containsKey(nameForm)) {
                    DITStructureRule conflictingRule = this.ditStructureRulesByNameForm.get(nameForm);
                    int msgID = 196801;
                    String message = MessageHandler.getMessage(msgID, ditStructureRule.getNameOrRuleID(), nameForm.getNameOrOID(), conflictingRule.getNameOrRuleID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                if (this.ditStructureRulesByID.containsKey(ruleID)) {
                    DITStructureRule conflictingRule = this.ditStructureRulesByID.get(ruleID);
                    int msgID = 196802;
                    String message = MessageHandler.getMessage(msgID, ditStructureRule.getNameOrRuleID(), ruleID, conflictingRule.getNameOrRuleID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            this.ditStructureRulesByNameForm.put(nameForm, ditStructureRule);
            this.ditStructureRulesByID.put(ruleID, ditStructureRule);
            String valueString = ditStructureRule.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.ditStructureRuleSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterDITStructureRule(DITStructureRule ditStructureRule) {
        ConcurrentHashMap<NameForm, DITStructureRule> concurrentHashMap = this.ditStructureRulesByNameForm;
        synchronized (concurrentHashMap) {
            this.ditStructureRulesByNameForm.remove(ditStructureRule.getNameForm(), ditStructureRule);
            this.ditStructureRulesByID.remove(ditStructureRule.getRuleID(), ditStructureRule);
            String valueString = ditStructureRule.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.ditStructureRuleSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public final LinkedHashSet<AttributeValue> getNameFormSet() {
        return this.nameFormSet;
    }

    public final ConcurrentHashMap<ObjectClass, NameForm> getNameFormsByObjectClass() {
        return this.nameFormsByOC;
    }

    public final ConcurrentHashMap<String, NameForm> getNameFormsByNameOrOID() {
        return this.nameFormsByName;
    }

    public boolean hasNameForm(ObjectClass objectClass) {
        return this.nameFormsByOC.containsKey(objectClass);
    }

    public boolean hasNameForm(String lowerName) {
        return this.nameFormsByName.containsKey(lowerName);
    }

    public final NameForm getNameForm(ObjectClass objectClass) {
        return this.nameFormsByOC.get(objectClass);
    }

    public final NameForm getNameForm(String lowerName) {
        return this.nameFormsByName.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerNameForm(NameForm nameForm, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<ObjectClass, NameForm> concurrentHashMap = this.nameFormsByOC;
        synchronized (concurrentHashMap) {
            ObjectClass objectClass = nameForm.getStructuralClass();
            if (!overwriteExisting) {
                if (this.nameFormsByOC.containsKey(objectClass)) {
                    NameForm conflictingNameForm = this.nameFormsByOC.get(objectClass);
                    int msgID = 196803;
                    String message = MessageHandler.getMessage(msgID, nameForm.getNameOrOID(), objectClass.getNameOrOID(), conflictingNameForm.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                String oid = StaticUtils.toLowerCase(nameForm.getOID());
                if (this.nameFormsByName.containsKey(oid)) {
                    NameForm conflictingNameForm = this.nameFormsByName.get(oid);
                    int msgID = 196804;
                    String message = MessageHandler.getMessage(msgID, nameForm.getNameOrOID(), oid, conflictingNameForm.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                for (String name : nameForm.getNames().keySet()) {
                    if (!this.nameFormsByName.containsKey(name)) continue;
                    NameForm conflictingNameForm = this.nameFormsByName.get(name);
                    int msgID = 196805;
                    String message = MessageHandler.getMessage(msgID, nameForm.getNameOrOID(), oid, conflictingNameForm.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            this.nameFormsByOC.put(objectClass, nameForm);
            this.nameFormsByName.put(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (String name : nameForm.getNames().keySet()) {
                this.nameFormsByName.put(name, nameForm);
            }
            String valueString = nameForm.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.nameFormSet.add(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterNameForm(NameForm nameForm) {
        ConcurrentHashMap<ObjectClass, NameForm> concurrentHashMap = this.nameFormsByOC;
        synchronized (concurrentHashMap) {
            this.nameFormsByOC.remove(nameForm.getStructuralClass(), nameForm);
            this.nameFormsByName.remove(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (String name : nameForm.getNames().keySet()) {
                this.nameFormsByName.remove(name, nameForm);
            }
            String valueString = nameForm.getDefinition();
            ASN1OctetString rawValue = new ASN1OctetString(valueString);
            ASN1OctetString normValue = new ASN1OctetString(StaticUtils.toLowerCase(valueString));
            this.nameFormSet.remove(new AttributeValue(rawValue, (ByteString)normValue));
        }
    }

    public long getOldestModificationTime() {
        return this.oldestModificationTime;
    }

    public void setOldestModificationTime(long oldestModificationTime) {
        this.oldestModificationTime = oldestModificationTime;
    }

    public long getYoungestModificationTime() {
        return this.youngestModificationTime;
    }

    public void setYoungestModificationTime(long youngestModificationTime) {
        this.youngestModificationTime = youngestModificationTime;
    }

    public final void rebuildDependentElements(SchemaFileElement element) throws DirectoryException {
        try {
            this.rebuildDependentElements(element, 0);
        }
        catch (DirectoryException de) {
            if (de.getMessageID() == 197187) {
                int msgID = 197187;
                String message = MessageHandler.getMessage(msgID, element.getDefinition());
                throw new DirectoryException(de.getResultCode(), message, msgID, de);
            }
            throw de;
        }
    }

    private final void rebuildDependentElements(SchemaFileElement element, int depth) throws DirectoryException {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (depth > 20) {
                            int msgID = 197187;
                            String message = MessageHandler.getMessage(msgID, element.getDefinition());
                            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
                        }
                        if (!(element instanceof AttributeType)) break block11;
                        AttributeType t = (AttributeType)element;
                        for (AttributeType at : this.attributeTypes.values()) {
                            if (at.getSuperiorType() == null || !at.getSuperiorType().equals(t)) continue;
                            AttributeType newAT = at.recreateFromDefinition();
                            this.deregisterAttributeType(at);
                            this.registerAttributeType(newAT, true);
                            this.rebuildDependentElements(at, depth + 1);
                        }
                        for (ObjectClass oc : this.objectClasses.values()) {
                            if (!oc.getRequiredAttributes().contains(t) && !oc.getOptionalAttributes().contains(t)) continue;
                            ObjectClass newOC = oc.recreateFromDefinition();
                            this.deregisterObjectClass(oc);
                            this.registerObjectClass(newOC, true);
                            this.rebuildDependentElements(oc, depth + 1);
                        }
                        for (NameForm nf : this.nameFormsByOC.values()) {
                            if (!nf.getRequiredAttributes().contains(t) && !nf.getOptionalAttributes().contains(t)) continue;
                            NameForm newNF = nf.recreateFromDefinition();
                            this.deregisterNameForm(nf);
                            this.registerNameForm(newNF, true);
                            this.rebuildDependentElements(nf, depth + 1);
                        }
                        for (DITContentRule dcr : this.ditContentRules.values()) {
                            if (!dcr.getRequiredAttributes().contains(t) && !dcr.getOptionalAttributes().contains(t) && !dcr.getProhibitedAttributes().contains(t)) continue;
                            DITContentRule newDCR = dcr.recreateFromDefinition();
                            this.deregisterDITContentRule(dcr);
                            this.registerDITContentRule(newDCR, true);
                            this.rebuildDependentElements(dcr, depth + 1);
                        }
                        for (MatchingRuleUse mru : this.matchingRuleUses.values()) {
                            if (!mru.getAttributes().contains(t)) continue;
                            MatchingRuleUse newMRU = mru.recreateFromDefinition();
                            this.deregisterMatchingRuleUse(mru);
                            this.registerMatchingRuleUse(newMRU, true);
                            this.rebuildDependentElements(mru, depth + 1);
                        }
                        break block12;
                    }
                    if (!(element instanceof ObjectClass)) break block13;
                    ObjectClass c = (ObjectClass)element;
                    for (ObjectClass oc : this.objectClasses.values()) {
                        if (oc.getSuperiorClass() == null || !oc.getSuperiorClass().equals(c)) continue;
                        ObjectClass newOC = oc.recreateFromDefinition();
                        this.deregisterObjectClass(oc);
                        this.registerObjectClass(newOC, true);
                        this.rebuildDependentElements(oc, depth + 1);
                    }
                    NameForm nf = this.nameFormsByOC.get(c);
                    if (nf != null) {
                        NameForm newNF = nf.recreateFromDefinition();
                        this.deregisterNameForm(nf);
                        this.registerNameForm(newNF, true);
                        this.rebuildDependentElements(nf, depth + 1);
                    }
                    for (DITContentRule dcr : this.ditContentRules.values()) {
                        if (!dcr.getStructuralClass().equals(c) && !dcr.getAuxiliaryClasses().contains(c)) continue;
                        DITContentRule newDCR = dcr.recreateFromDefinition();
                        this.deregisterDITContentRule(dcr);
                        this.registerDITContentRule(newDCR, true);
                        this.rebuildDependentElements(dcr, depth + 1);
                    }
                    break block12;
                }
                if (!(element instanceof NameForm)) break block14;
                NameForm n = (NameForm)element;
                DITStructureRule dsr = this.ditStructureRulesByNameForm.get(n);
                if (dsr == null) break block12;
                DITStructureRule newDSR = dsr.recreateFromDefinition();
                this.deregisterDITStructureRule(dsr);
                this.registerDITStructureRule(newDSR, true);
                this.rebuildDependentElements(dsr, depth + 1);
                break block12;
            }
            if (element instanceof DITStructureRule) {
                DITStructureRule d = (DITStructureRule)element;
                for (DITStructureRule dsr : this.ditStructureRulesByID.values()) {
                    if (!dsr.getSuperiorRules().contains(d)) continue;
                    DITStructureRule newDSR = dsr.recreateFromDefinition();
                    this.deregisterDITStructureRule(dsr);
                    this.registerDITStructureRule(newDSR, true);
                    this.rebuildDependentElements(dsr, depth + 1);
                }
            }
        }
    }

    public final Schema duplicate() {
        Schema dupSchema = new Schema();
        dupSchema.attributeTypes.putAll(this.attributeTypes);
        dupSchema.subordinateTypes.putAll(this.subordinateTypes);
        dupSchema.objectClasses.putAll(this.objectClasses);
        dupSchema.syntaxes.putAll(this.syntaxes);
        dupSchema.matchingRules.putAll(this.matchingRules);
        dupSchema.approximateMatchingRules.putAll(this.approximateMatchingRules);
        dupSchema.equalityMatchingRules.putAll(this.equalityMatchingRules);
        dupSchema.orderingMatchingRules.putAll(this.orderingMatchingRules);
        dupSchema.substringMatchingRules.putAll(this.substringMatchingRules);
        dupSchema.matchingRuleUses.putAll(this.matchingRuleUses);
        dupSchema.ditContentRules.putAll(this.ditContentRules);
        dupSchema.ditStructureRulesByID.putAll(this.ditStructureRulesByID);
        dupSchema.ditStructureRulesByNameForm.putAll(this.ditStructureRulesByNameForm);
        dupSchema.nameFormsByOC.putAll(this.nameFormsByOC);
        dupSchema.nameFormsByName.putAll(this.nameFormsByName);
        dupSchema.syntaxSet.addAll(this.syntaxSet);
        dupSchema.attributeTypeSet.addAll(this.attributeTypeSet);
        dupSchema.ditContentRuleSet.addAll(this.ditContentRuleSet);
        dupSchema.ditStructureRuleSet.addAll(this.ditStructureRuleSet);
        dupSchema.matchingRuleSet.addAll(this.matchingRuleSet);
        dupSchema.matchingRuleUseSet.addAll(this.matchingRuleUseSet);
        dupSchema.nameFormSet.addAll(this.nameFormSet);
        dupSchema.objectClassSet.addAll(this.objectClassSet);
        dupSchema.oldestModificationTime = this.oldestModificationTime;
        dupSchema.youngestModificationTime = this.youngestModificationTime;
        if (this.synchronizationState != null) {
            dupSchema.synchronizationState = new LinkedHashSet<AttributeValue>(this.synchronizationState);
        }
        return dupSchema;
    }

    public LinkedHashSet<AttributeValue> getSynchronizationState() {
        return this.synchronizationState;
    }

    public void setSynchronizationState(LinkedHashSet<AttributeValue> values) {
        this.synchronizationState = values;
    }

    public static void writeConcatenatedSchema() {
        String concatFilePath = null;
        try {
            LinkedHashSet<String> attributeTypes = new LinkedHashSet<String>();
            LinkedHashSet<String> objectClasses = new LinkedHashSet<String>();
            LinkedHashSet<String> nameForms = new LinkedHashSet<String>();
            LinkedHashSet<String> ditContentRules = new LinkedHashSet<String>();
            LinkedHashSet<String> ditStructureRules = new LinkedHashSet<String>();
            LinkedHashSet<String> matchingRuleUses = new LinkedHashSet<String>();
            Schema.genConcatenatedSchema(attributeTypes, objectClasses, nameForms, ditContentRules, ditStructureRules, matchingRuleUses);
            File configFile = new File(DirectoryServer.getConfigFile());
            File configDirectory = configFile.getParentFile();
            File upgradeDirectory = new File(configDirectory, "upgrade");
            File concatFile = new File(upgradeDirectory, "schema.ldif.current");
            concatFilePath = concatFile.getAbsolutePath();
            File tempFile = new File(concatFilePath + ".tmp");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile, false));
            writer.write("dn: " + DirectoryServer.getSchemaDN().toString());
            writer.newLine();
            writer.write("objectClass: top");
            writer.newLine();
            writer.write("objectClass: ldapSubentry");
            writer.newLine();
            writer.write("objectClass: subschema");
            writer.newLine();
            for (String line : attributeTypes) {
                writer.write("attributeTypes");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : objectClasses) {
                writer.write("objectClasses");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : nameForms) {
                writer.write("nameForms");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : ditContentRules) {
                writer.write("dITContentRules");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : ditStructureRules) {
                writer.write("dITStructureRules");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : matchingRuleUses) {
                writer.write("matchingRuleUse");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            writer.close();
            if (concatFile.exists()) {
                concatFile.delete();
            }
            tempFile.renameTo(concatFile);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, 9699624, String.valueOf(concatFilePath), StaticUtils.getExceptionMessage(e));
        }
    }

    public static void genConcatenatedSchema(LinkedHashSet<String> attributeTypes, LinkedHashSet<String> objectClasses, LinkedHashSet<String> nameForms, LinkedHashSet<String> ditContentRules, LinkedHashSet<String> ditStructureRules, LinkedHashSet<String> matchingRuleUses) throws IOException {
        String schemaDirectory = SchemaConfigManager.getSchemaDirectoryPath();
        TreeSet<String> schemaFileNames = new TreeSet<String>();
        for (File f : new File(schemaDirectory).listFiles()) {
            if (!f.isFile()) continue;
            schemaFileNames.add(f.getName());
        }
        for (String name : schemaFileNames) {
            String line;
            LinkedList<StringBuilder> lines = new LinkedList<StringBuilder>();
            BufferedReader reader = new BufferedReader(new FileReader(new File(schemaDirectory, name)));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                if (line.startsWith(" ")) {
                    ((StringBuilder)lines.getLast()).append(line.substring(1));
                    continue;
                }
                lines.add(new StringBuilder(line));
            }
            reader.close();
            for (StringBuilder buffer : lines) {
                String value;
                String line2 = buffer.toString().trim();
                if (line2.endsWith(" )")) {
                    line2 = line2.substring(0, line2.length() - 1) + "X-SCHEMA-FILE" + " '" + name + "' )";
                } else {
                    if (!line2.endsWith(")")) continue;
                    line2 = line2.substring(0, line2.length() - 1) + " " + "X-SCHEMA-FILE" + " '" + name + "' )";
                }
                String lowerLine = StaticUtils.toLowerCase(line2);
                if (lowerLine.startsWith("attributetypes")) {
                    value = line2.substring("attributeTypes".length() + 1).trim();
                    attributeTypes.add(value);
                    continue;
                }
                if (lowerLine.startsWith("objectclasses")) {
                    value = line2.substring("objectClasses".length() + 1).trim();
                    objectClasses.add(value);
                    continue;
                }
                if (lowerLine.startsWith("nameforms")) {
                    value = line2.substring("nameForms".length() + 1).trim();
                    nameForms.add(value);
                    continue;
                }
                if (lowerLine.startsWith("ditcontentrules")) {
                    value = line2.substring("dITContentRules".length() + 1).trim();
                    ditContentRules.add(value);
                    continue;
                }
                if (lowerLine.startsWith("ditstructurerules")) {
                    value = line2.substring("dITStructureRules".length() + 1).trim();
                    ditStructureRules.add(value);
                    continue;
                }
                if (!lowerLine.startsWith("matchingruleuse")) continue;
                value = line2.substring("matchingRuleUse".length() + 1).trim();
                matchingRuleUses.add(value);
            }
        }
    }

    public static void readConcatenatedSchema(String concatSchemaFile, LinkedHashSet<String> attributeTypes, LinkedHashSet<String> objectClasses, LinkedHashSet<String> nameForms, LinkedHashSet<String> ditContentRules, LinkedHashSet<String> ditStructureRules, LinkedHashSet<String> matchingRuleUses) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(concatSchemaFile));
        while ((line = reader.readLine()) != null) {
            String value;
            String lowerLine = StaticUtils.toLowerCase(line);
            if (lowerLine.startsWith("attributetypes")) {
                value = line.substring("attributeTypes".length() + 1).trim();
                attributeTypes.add(value);
                continue;
            }
            if (lowerLine.startsWith("objectclasses")) {
                value = line.substring("objectClasses".length() + 1).trim();
                objectClasses.add(value);
                continue;
            }
            if (lowerLine.startsWith("nameforms")) {
                value = line.substring("nameForms".length() + 1).trim();
                nameForms.add(value);
                continue;
            }
            if (lowerLine.startsWith("ditcontentrules")) {
                value = line.substring("dITContentRules".length() + 1).trim();
                ditContentRules.add(value);
                continue;
            }
            if (lowerLine.startsWith("ditstructurerules")) {
                value = line.substring("dITStructureRules".length() + 1).trim();
                ditStructureRules.add(value);
                continue;
            }
            if (!lowerLine.startsWith("matchingruleuse")) continue;
            value = line.substring("matchingRuleUse".length() + 1).trim();
            matchingRuleUses.add(value);
        }
        reader.close();
    }

    public static void compareConcatenatedSchema(LinkedHashSet<String> oldElements, LinkedHashSet<String> newElements, AttributeType elementType, LinkedList<Modification> mods) {
        AttributeType attributeTypesType = DirectoryServer.getAttributeType("attributetypes", true);
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        for (String s : oldElements) {
            if (newElements.contains(s)) continue;
            values.add(new AttributeValue(attributeTypesType, s));
        }
        if (!values.isEmpty()) {
            mods.add(new Modification(ModificationType.DELETE, new Attribute(elementType, elementType.getNameOrOID(), values)));
        }
        values.clear();
        for (String s : newElements) {
            if (oldElements.contains(s)) continue;
            values.add(new AttributeValue(attributeTypesType, s));
        }
        if (!values.isEmpty()) {
            mods.add(new Modification(ModificationType.ADD, new Attribute(elementType, elementType.getNameOrOID(), values)));
        }
    }
}

