/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DebugLogLevel;

public class SortKey {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType attributeType;
    private boolean ascending;
    private OrderingMatchingRule orderingRule;

    public SortKey(AttributeType attributeType, boolean ascending) {
        this.attributeType = attributeType;
        this.ascending = ascending;
        this.orderingRule = null;
    }

    public SortKey(AttributeType attributeType, boolean ascending, OrderingMatchingRule orderingRule) {
        this.attributeType = attributeType;
        this.ascending = ascending;
        this.orderingRule = orderingRule;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean ascending() {
        return this.ascending;
    }

    public OrderingMatchingRule getOrderingRule() {
        return this.orderingRule;
    }

    public int compareValues(AttributeValue value1, AttributeValue value2) {
        if (value1 == null) {
            if (value2 == null) {
                return 0;
            }
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        if (this.orderingRule == null) {
            try {
                OrderingMatchingRule rule = this.attributeType.getOrderingMatchingRule();
                if (rule == null) {
                    return 0;
                }
                if (this.ascending) {
                    return rule.compareValues(value1.getNormalizedValue(), value2.getNormalizedValue());
                }
                return rule.compareValues(value2.getNormalizedValue(), value1.getNormalizedValue());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return 0;
            }
        }
        try {
            if (this.ascending) {
                return this.orderingRule.compareValues(this.orderingRule.normalizeValue(value1.getValue()), this.orderingRule.normalizeValue(value2.getValue()));
            }
            return this.orderingRule.compareValues(this.orderingRule.normalizeValue(value2.getValue()), this.orderingRule.normalizeValue(value1.getValue()));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return 0;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SortKey(");
        if (this.ascending) {
            buffer.append("+");
        } else {
            buffer.append("-");
        }
        buffer.append(this.attributeType.getNameOrOID());
        if (this.orderingRule != null) {
            buffer.append(":");
            buffer.append(this.orderingRule.getNameOrOID());
        }
        buffer.append(")");
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.ascending) {
            ++hashCode;
        }
        hashCode += this.attributeType.hashCode();
        if (this.orderingRule != null) {
            hashCode += this.orderingRule.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortKey)) {
            return false;
        }
        SortKey s = (SortKey)o;
        if (this.ascending != s.ascending) {
            return false;
        }
        if (!this.attributeType.equals(s.attributeType)) {
            return false;
        }
        return !(this.orderingRule != null ? (s.orderingRule != null ? !this.orderingRule.equals(s.orderingRule) : !this.orderingRule.equals(s.attributeType.getOrderingMatchingRule())) : s.orderingRule != null && !this.attributeType.getOrderingMatchingRule().equals(s.orderingRule));
    }
}

