/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.Entry;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualAttribute
extends Attribute {
    private final Entry entry;
    private final VirtualAttributeProvider<? extends VirtualAttributeCfg> provider;
    private final VirtualAttributeRule rule;

    public VirtualAttribute(AttributeType attributeType, Entry entry, VirtualAttributeRule rule) {
        super(attributeType);
        this.entry = entry;
        this.rule = rule;
        this.provider = rule.getProvider();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public VirtualAttributeRule getVirtualAttributeRule() {
        return this.rule;
    }

    @Override
    public LinkedHashSet<AttributeValue> getValues() {
        return this.provider.getValues(this.entry, this.rule);
    }

    @Override
    public boolean hasValue() {
        return this.provider.hasValue(this.entry, this.rule);
    }

    @Override
    public boolean hasValue(AttributeValue value) {
        return this.provider.hasValue(this.entry, this.rule, value);
    }

    @Override
    public boolean hasAllValues(Collection<AttributeValue> values) {
        return this.provider.hasAllValues(this.entry, this.rule, values);
    }

    @Override
    public boolean hasAnyValue(Collection<AttributeValue> values) {
        return this.provider.hasAnyValue(this.entry, this.rule, values);
    }

    @Override
    public ConditionResult matchesSubstring(ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return this.provider.matchesSubstring(this.entry, this.rule, subInitial, subAny, subFinal);
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(AttributeValue value) {
        return this.provider.greaterThanOrEqualTo(this.entry, this.rule, value);
    }

    @Override
    public ConditionResult lessThanOrEqualTo(AttributeValue value) {
        return this.provider.lessThanOrEqualTo(this.entry, this.rule, value);
    }

    @Override
    public ConditionResult approximatelyEqualTo(AttributeValue value) {
        return this.provider.approximatelyEqualTo(this.entry, this.rule, value);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public Attribute duplicate(boolean omitValues) {
        return new VirtualAttribute(this.getAttributeType(), this.entry, this.rule);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("VirtualAttribute(");
        buffer.append(this.getAttributeType().getNameOrOID());
        buffer.append(", {");
        boolean firstValue = true;
        for (AttributeValue value : this.getValues()) {
            if (!firstValue) {
                buffer.append(", ");
            }
            value.toString(buffer);
            firstValue = false;
        }
        buffer.append("})");
    }
}

