/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.Set;
import org.opends.server.admin.std.meta.VirtualAttributeCfgDefn;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.Group;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualAttributeRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final AttributeType attributeType;
    private final Set<DN> baseDNs;
    private final Set<DN> groupDNs;
    private final Set<SearchFilter> filters;
    private final VirtualAttributeProvider<? extends VirtualAttributeCfg> provider;
    private final VirtualAttributeCfgDefn.ConflictBehavior conflictBehavior;

    public VirtualAttributeRule(AttributeType attributeType, VirtualAttributeProvider<? extends VirtualAttributeCfg> provider, Set<DN> baseDNs, Set<DN> groupDNs, Set<SearchFilter> filters, VirtualAttributeCfgDefn.ConflictBehavior conflictBehavior) {
        Validator.ensureNotNull(attributeType, provider, baseDNs, groupDNs);
        Validator.ensureNotNull(filters, (Object)conflictBehavior);
        this.attributeType = attributeType;
        this.provider = provider;
        this.baseDNs = baseDNs;
        this.groupDNs = groupDNs;
        this.filters = filters;
        this.conflictBehavior = conflictBehavior;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public VirtualAttributeProvider<? extends VirtualAttributeCfg> getProvider() {
        return this.provider;
    }

    public Set<DN> getBaseDNs() {
        return this.baseDNs;
    }

    public Set<DN> getGroupDNs() {
        return this.groupDNs;
    }

    public Set<SearchFilter> getFilters() {
        return this.filters;
    }

    public VirtualAttributeCfgDefn.ConflictBehavior getConflictBehavior() {
        return this.conflictBehavior;
    }

    public boolean appliesToEntry(Entry entry) {
        boolean found;
        if (this.conflictBehavior == VirtualAttributeCfgDefn.ConflictBehavior.REAL_OVERRIDES_VIRTUAL && entry.hasAttribute(this.attributeType)) {
            return false;
        }
        DN entryDN = entry.getDN();
        if (!this.baseDNs.isEmpty()) {
            found = false;
            for (DN dn : this.baseDNs) {
                if (!entryDN.isDescendantOf(dn)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (!this.filters.isEmpty()) {
            found = false;
            for (SearchFilter filter : this.filters) {
                try {
                    if (!filter.matchesEntry(entry)) continue;
                    found = true;
                    break;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (!found) {
                return false;
            }
        }
        if (!this.groupDNs.isEmpty()) {
            found = false;
            for (DN dn : this.groupDNs) {
                try {
                    Group group = DirectoryServer.getGroupManager().getGroupInstance(dn);
                    if (group == null || !group.isMember(entry)) continue;
                    found = true;
                    break;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        Iterator<Object> iterator;
        buffer.append("VirtualAttributeRule(attrType=");
        buffer.append(this.attributeType.getNameOrOID());
        buffer.append(", providerDN=\"");
        buffer.append(this.provider.getClass().getName());
        buffer.append("\", baseDNs={");
        if (!this.baseDNs.isEmpty()) {
            buffer.append("\"");
            iterator = this.baseDNs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append("\", \"");
                buffer.append(iterator.next());
            }
            buffer.append("\"");
        }
        buffer.append("}, groupDNs={");
        if (!this.groupDNs.isEmpty()) {
            buffer.append("\"");
            iterator = this.groupDNs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append("\", \"");
                buffer.append(iterator.next());
            }
            buffer.append("\"");
        }
        buffer.append("}, filters={");
        if (!this.filters.isEmpty()) {
            buffer.append("\"");
            iterator = this.filters.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append("\", \"");
                buffer.append(iterator.next());
            }
            buffer.append("\"");
        }
        buffer.append("}, conflictBehavior=");
        buffer.append((Object)this.conflictBehavior);
        buffer.append(")");
    }
}

