/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class ExpirationCheckTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;

    public ExpirationCheckTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Date currentDate = new Date();
        for (X509Certificate c : chain) {
            try {
                c.checkValidity(currentDate);
            }
            catch (CertificateExpiredException cee) {
                int msgID = 5505183;
                String message = MessageHandler.getMessage(msgID, c.getSubjectDN().getName(), String.valueOf(c.getNotAfter()));
                ErrorLogger.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                throw cee;
            }
            catch (CertificateNotYetValidException cnyve) {
                int msgID = 5505184;
                String message = MessageHandler.getMessage(msgID, c.getSubjectDN().getName(), String.valueOf(c.getNotBefore()));
                ErrorLogger.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                throw cnyve;
            }
        }
        this.trustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Date currentDate = new Date();
        for (X509Certificate c : chain) {
            try {
                c.checkValidity(currentDate);
            }
            catch (CertificateExpiredException cee) {
                int msgID = 5505185;
                String message = MessageHandler.getMessage(msgID, c.getSubjectDN().getName(), String.valueOf(c.getNotAfter()));
                ErrorLogger.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                throw cee;
            }
            catch (CertificateNotYetValidException cnyve) {
                int msgID = 5505186;
                String message = MessageHandler.getMessage(msgID, c.getSubjectDN().getName(), String.valueOf(c.getNotBefore()));
                ErrorLogger.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                throw cnyve;
            }
        }
        this.trustManager.checkServerTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

