/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.ServerConstants;

public class Validator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final boolean ENABLE_CHECKS = true;
    private static final String[] PARAM_DESCRIPTIONS = new String[]{"** A ZERO-BASED INDEX IS INVALID **", "(1st parameter)", "(2nd parameter)", "(3rd parameter)", "(4th parameter)", "(5th parameter)", "(6th parameter)", "(7th parameter)", "(8th parameter)", "(9th parameter)", "(10th parameter)"};
    private static long _errorCount = 0L;

    public static boolean ensureNotNull(Object param) throws AssertionError {
        if (param == null) {
            Validator.throwNull("");
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2) throws AssertionError {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3) throws AssertionError {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3, Object param4) throws AssertionError {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        if (param4 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[4]);
        }
        return true;
    }

    public static boolean ensureTrue(boolean condition) throws AssertionError {
        if (!condition) {
            Validator.ensureTrue(condition, "");
        }
        return true;
    }

    public static boolean ensureTrue(boolean condition, String message) throws AssertionError {
        if (!condition) {
            String fullMessage = Validator.generateLineSpecificErrorMessage("The specified condition must be true. " + message);
            Validator.logError(fullMessage);
            throw new AssertionError((Object)fullMessage);
        }
        return true;
    }

    public static synchronized long getErrorCount() {
        return _errorCount;
    }

    public static synchronized void resetErrorCount() {
        _errorCount = 0L;
    }

    private static synchronized void incrementErrorCount() {
        ++_errorCount;
    }

    private static String generateLineSpecificErrorMessage(String message) {
        return message + "  The error occurred at " + Validator.getOriginalCallerLineInfo();
    }

    private static void throwNull(String message) throws AssertionError {
        String fullMessage = Validator.generateLineSpecificErrorMessage("The specified parameter must not be null. " + message);
        Validator.logError(fullMessage);
        throw new AssertionError((Object)fullMessage);
    }

    private static void logError(String message) {
        Validator.incrementErrorCount();
        String messageWithStack = message + ServerConstants.EOL + Validator.getCallingStack();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugError(messageWithStack);
        }
        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, 5505172, messageWithStack);
    }

    private static String getOriginalCallerLineInfo() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        int callerIndex = Validator.getOriginalCallerStackIndex(stackElements);
        return stackElements[callerIndex].toString();
    }

    private static String getCallingStack() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        int callerIndex = Validator.getOriginalCallerStackIndex(stackElements);
        StringBuilder buffer = new StringBuilder();
        for (int i = callerIndex; i < stackElements.length; ++i) {
            StackTraceElement stackElement = stackElements[i];
            buffer.append(stackElement).append(ServerConstants.EOL);
        }
        return buffer.toString();
    }

    private static int getOriginalCallerStackIndex(StackTraceElement[] stack) {
        int i;
        StackTraceElement element = null;
        for (i = 0; i < stack.length && ((element = stack[i]).getClassName().equals(Validator.class.getName()) || element.getClassName().equals(Thread.class.getName())); ++i) {
        }
        return i;
    }
}

