/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.BuildVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionCompatibilityIssue {
    private static final Set<VersionCompatibilityIssue> VERSION_COMPATIBILITY_ISSUES = new HashSet<VersionCompatibilityIssue>();
    private static final Comparator<VersionCompatibilityIssue> VERSION_COMPARATOR;
    private Cause cause;
    private BuildVersion version;

    private static void register(Cause cause, BuildVersion version) {
        VERSION_COMPATIBILITY_ISSUES.add(new VersionCompatibilityIssue(cause, version));
    }

    public static List<VersionCompatibilityIssue> getAllEvents() {
        ArrayList<VersionCompatibilityIssue> issueList = new ArrayList<VersionCompatibilityIssue>(VERSION_COMPATIBILITY_ISSUES);
        Collections.sort(issueList, VERSION_COMPARATOR);
        return Collections.unmodifiableList(issueList);
    }

    public static List<VersionCompatibilityIssue> getEvents(Collection<Integer> excludeIds) {
        if (excludeIds == null) {
            excludeIds = Collections.emptySet();
        }
        ArrayList<VersionCompatibilityIssue> issueList = new ArrayList<VersionCompatibilityIssue>();
        for (VersionCompatibilityIssue evt : VERSION_COMPATIBILITY_ISSUES) {
            if (excludeIds.contains(evt.getCause().getId())) continue;
            issueList.add(evt);
        }
        Collections.sort(issueList, VERSION_COMPARATOR);
        return Collections.unmodifiableList(issueList);
    }

    public static List<VersionCompatibilityIssue> getEvents(BuildVersion from) {
        ArrayList<VersionCompatibilityIssue> issueList = new ArrayList<VersionCompatibilityIssue>();
        for (VersionCompatibilityIssue evt : VERSION_COMPATIBILITY_ISSUES) {
            BuildVersion evtVer = evt.getVersion();
            if (evtVer.compareTo(from) < 0) continue;
            issueList.add(evt);
        }
        Collections.sort(issueList, VERSION_COMPARATOR);
        return issueList;
    }

    private VersionCompatibilityIssue(Cause cause, BuildVersion version) {
        this.cause = cause;
        this.version = version;
    }

    public Cause getCause() {
        return this.cause;
    }

    public BuildVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return Integer.toString(this.cause.getId());
    }

    static {
        VersionCompatibilityIssue.register(Cause.DB_FORMAT_CHANGE_2, new BuildVersion(0, 9, 0, 2049L));
        VersionCompatibilityIssue.register(Cause.DB_FORMAT_CHANGE_1, new BuildVersion(0, 1, 0, 1582L));
        VersionCompatibilityIssue.register(Cause.BERKLEY_UPGRADE_1, new BuildVersion(0, 1, 0, 890L));
        VERSION_COMPARATOR = new Comparator<VersionCompatibilityIssue>(){

            @Override
            public int compare(VersionCompatibilityIssue o1, VersionCompatibilityIssue o2) {
                return o1.getVersion().compareTo(o2.getVersion());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        DB_FORMAT_CHANGE_2(3, MessageHandler.getMessage(0xF00005), MessageHandler.getMessage(0xF00006), Effect.REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED, Effect.UPGRADE_SHOW_WARNING_MESSAGE),
        DB_FORMAT_CHANGE_1(2, MessageHandler.getMessage(0xF00003), MessageHandler.getMessage(0xF00004), Effect.REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED, Effect.UPGRADE_SHOW_WARNING_MESSAGE),
        BERKLEY_UPGRADE_1(1, MessageHandler.getMessage(0xF00001), MessageHandler.getMessage(0xF00002), Effect.REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED, Effect.UPGRADE_SHOW_WARNING_MESSAGE);

        private int id;
        private Set<Effect> effects = new HashSet<Effect>();
        private String upgradeMsg;
        private String reversionMsg;

        static Cause fromId(int id) {
            Cause cause = null;
            EnumSet<Cause> es = EnumSet.allOf(Cause.class);
            for (Cause c : es) {
                if (c.getId() != id) continue;
                cause = c;
                break;
            }
            return cause;
        }

        private Cause(int id, String upgradeMessage, String reversionMessage, Effect ... effects) {
            this.id = id;
            this.upgradeMsg = upgradeMessage;
            this.reversionMsg = reversionMessage;
            if (effects != null) {
                for (Effect c : effects) {
                    this.effects.add(c);
                }
            }
        }

        public int getId() {
            return this.id;
        }

        public Set<Effect> getEffects() {
            return Collections.unmodifiableSet(this.effects);
        }

        public String getLocalizedUpgradeMessage() {
            return this.upgradeMsg;
        }

        public String getLocalizedReversionMessage() {
            return this.reversionMsg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Effect {
        REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED,
        UPGRADE_DATA_EXPORT_AND_REIMPORT_REQUIRED,
        UPGRADE_SHOW_INFO_MESSAGE,
        REVERSION_SHOW_INFO_MESSAGE,
        UPGRADE_SHOW_WARNING_MESSAGE,
        REVERSION_SHOW_WARNING_MESSAGE,
        UPGRADE_MANUAL_ACTION_REQUIRED,
        REVERSION_MANUAL_ACTION_REQUIRED,
        UPGRADE_NOT_POSSIBLE,
        REVERSION_NOT_POSSIBLE,
        NO_SERVER_RESTART_FOLLOWING_REVERSION;

    }
}

