/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import org.opends.server.messages.MessageHandler;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

public class IntegerArgument
extends Argument {
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private int lowerBound;
    private int upperBound;

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, String valuePlaceholder, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, descriptionID, descriptionArgs);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, String valuePlaceholder, boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, descriptionID, descriptionArgs);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (hasLowerBound && hasUpperBound && lowerBound > upperBound) {
            int msgID = 5505067;
            String message = MessageHandler.getMessage(msgID, name, lowerBound, upperBound);
            throw new ArgumentException(msgID, message);
        }
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, String valuePlaceholder, int defaultValue, String propertyName, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, String.valueOf(defaultValue), propertyName, descriptionID, descriptionArgs);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, String valuePlaceholder, int defaultValue, String propertyName, boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, String.valueOf(defaultValue), propertyName, descriptionID, descriptionArgs);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (hasLowerBound && hasUpperBound && lowerBound > upperBound) {
            int msgID = 5505067;
            String message = MessageHandler.getMessage(msgID, name, lowerBound, upperBound);
            throw new ArgumentException(msgID, message);
        }
    }

    public boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean valueIsAcceptable(String valueString, StringBuilder invalidReason) {
        int intValue;
        try {
            intValue = Integer.parseInt(valueString);
        }
        catch (Exception e) {
            int msgID = 5505062;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, this.getName()));
            return false;
        }
        if (this.hasLowerBound && intValue < this.lowerBound) {
            int msgID = 5505068;
            invalidReason.append(MessageHandler.getMessage(msgID, this.getName(), intValue, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && intValue > this.upperBound) {
            int msgID = 5505069;
            invalidReason.append(MessageHandler.getMessage(msgID, this.getName(), intValue, this.upperBound));
            return false;
        }
        return true;
    }
}

