/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubCommand {
    private boolean isHidden;
    private HashMap<Character, Argument> shortIDMap;
    private HashMap<String, Argument> longIDMap;
    private int descriptionID;
    private LinkedList<Argument> arguments;
    private String description;
    private String name;
    private SubCommandArgumentParser parser;
    private boolean allowsTrailingArguments;
    private int maxTrailingArguments;
    private int minTrailingArguments;
    private String trailingArgsDisplayName;

    public SubCommand(SubCommandArgumentParser parser, String name, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        this(parser, name, false, 0, 0, null, descriptionID, descriptionArgs);
    }

    public SubCommand(SubCommandArgumentParser parser, String name, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName, int descriptionID, Object ... descriptionArgs) throws ArgumentException {
        this.parser = parser;
        this.name = name;
        this.descriptionID = descriptionID;
        this.allowsTrailingArguments = allowsTrailingArguments;
        this.minTrailingArguments = minTrailingArguments;
        this.maxTrailingArguments = maxTrailingArguments;
        this.trailingArgsDisplayName = trailingArgsDisplayName;
        this.isHidden = false;
        String nameToCheck = name;
        if (parser.longArgumentsCaseSensitive()) {
            nameToCheck = StaticUtils.toLowerCase(name);
        }
        if (parser.hasSubCommand(nameToCheck)) {
            int msgID = 5505103;
            String message = MessageHandler.getMessage(msgID, name);
            throw new ArgumentException(msgID, message);
        }
        parser.addSubCommand(this);
        this.description = MessageHandler.getMessage(descriptionID, descriptionArgs);
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.arguments = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public int getDescriptionID() {
        return this.descriptionID;
    }

    public String getDescription() {
        return this.description;
    }

    public LinkedList<Argument> getArguments() {
        return this.arguments;
    }

    public Argument getArgument(Character shortID) {
        return this.shortIDMap.get(shortID);
    }

    public Argument getArgument(String longID) {
        return this.longIDMap.get(longID);
    }

    public Argument getArgumentForName(String name) {
        for (Argument a : this.arguments) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public void addArgument(Argument argument) throws ArgumentException {
        String longID;
        String argumentName = argument.getName();
        for (Argument a : this.arguments) {
            if (!argumentName.equals(a.getName())) continue;
            int msgID = 0x540050;
            String message = MessageHandler.getMessage(msgID, this.name, argumentName);
            throw new ArgumentException(msgID, message);
        }
        if (this.parser.hasGlobalArgument(argumentName)) {
            int msgID = 5505105;
            String message = MessageHandler.getMessage(msgID, argumentName, this.name);
            throw new ArgumentException(msgID, message);
        }
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            if (this.shortIDMap.containsKey(shortID)) {
                int msgID = 5505106;
                String message = MessageHandler.getMessage(msgID, argumentName, this.name, String.valueOf(shortID), this.shortIDMap.get(shortID).getName());
                throw new ArgumentException(msgID, message);
            }
            Argument arg = this.parser.getGlobalArgumentForShortID(shortID);
            if (arg != null) {
                int msgID = 5505107;
                String message = MessageHandler.getMessage(msgID, argumentName, this.name, String.valueOf(shortID), arg.getName());
                throw new ArgumentException(msgID, message);
            }
        }
        if ((longID = argument.getLongIdentifier()) != null) {
            if (!this.parser.longArgumentsCaseSensitive()) {
                longID = StaticUtils.toLowerCase(longID);
            }
            if (this.longIDMap.containsKey(longID)) {
                int msgID = 0x540054;
                String message = MessageHandler.getMessage(msgID, argumentName, this.name, longID, this.longIDMap.get(longID).getName());
                throw new ArgumentException(msgID, message);
            }
            Argument arg = this.parser.getGlobalArgumentForLongID(longID);
            if (arg != null) {
                int msgID = 0x540055;
                String message = MessageHandler.getMessage(msgID, argumentName, this.name, longID, arg.getName());
                throw new ArgumentException(msgID, message);
            }
        }
        this.arguments.add(argument);
        if (shortID != null) {
            this.shortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.longIDMap.put(longID, argument);
        }
    }

    public boolean allowsTrailingArguments() {
        return this.allowsTrailingArguments;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArguments;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArguments;
    }

    public String getTrailingArgumentsDisplayName() {
        return this.trailingArgsDisplayName;
    }

    public ArrayList<String> getTrailingArguments() {
        return this.parser.getTrailingArguments();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }
}

