/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PasswordExpiredControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.LeafWorkflowElement;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendBindOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBackendWorkflowElement
extends LeafWorkflowElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    Backend backend;

    public LocalBackendWorkflowElement(Backend backend) {
        this.backend = backend;
        if (this.backend != null) {
            this.isPrivate = this.backend.isPrivateBackend();
        }
    }

    @Override
    public void execute(Operation operation) {
        switch (operation.getOperationType()) {
            case BIND: {
                this.processBind((BindOperation)operation);
                break;
            }
            case SEARCH: {
                this.processSearch((SearchOperation)operation);
                break;
            }
            case ADD: {
                this.processAdd((AddOperation)operation);
                break;
            }
            case DELETE: {
                this.processDelete((DeleteOperation)operation);
                break;
            }
            case MODIFY: {
                this.processModify((ModifyOperation)operation);
                break;
            }
            case MODIFY_DN: {
                this.processModifyDN((ModifyDNOperation)operation);
                break;
            }
            case COMPARE: {
                this.processCompare((CompareOperation)operation);
                break;
            }
            case ABANDON: {
                break;
            }
            default: {
                Validator.ensureTrue(false);
            }
        }
    }

    public void processModify(ModifyOperation operation) {
        LocalBackendModifyOperation localOperation = new LocalBackendModifyOperation(operation);
        this.processLocalModify(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalModify(LocalBackendModifyOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 417[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processSearch(SearchOperation operation) {
        PostOperationPluginResult postOperationResult;
        boolean skipPostOperation;
        PluginConfigManager pluginConfigManager;
        LocalBackendSearchOperation localOp;
        block81: {
            localOp = new LocalBackendSearchOperation(operation);
            PersistentSearch persistentSearch = null;
            ClientConnection clientConnection = localOp.getClientConnection();
            pluginConfigManager = DirectoryServer.getPluginConfigManager();
            skipPostOperation = false;
            DN baseDN = localOp.getBaseDN();
            SearchFilter filter = localOp.getFilter();
            if (baseDN != null && filter != null) {
                boolean processSearch = true;
                List<Control> requestControls = localOp.getRequestControls();
                if (requestControls != null && !requestControls.isEmpty()) {
                    for (int i = 0; i < requestControls.size(); ++i) {
                        Entry authorizationEntry;
                        Control proxyControl;
                        Control c = requestControls.get(i);
                        String oid = c.getOID();
                        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(baseDN, localOp, c)) {
                            localOp.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                            int msgID = 262755;
                            localOp.appendErrorMessage(MessageHandler.getMessage(msgID, oid));
                            skipPostOperation = true;
                            break block81;
                        }
                        if (oid.equals("1.3.6.1.1.12")) {
                            LDAPAssertionRequestControl assertControl;
                            if (c instanceof LDAPAssertionRequestControl) {
                                assertControl = (LDAPAssertionRequestControl)c;
                            } else {
                                try {
                                    assertControl = LDAPAssertionRequestControl.decodeControl(c);
                                    requestControls.set(i, assertControl);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessage());
                                    break block81;
                                }
                            }
                            try {
                                Entry entry;
                                SearchFilter assertionFilter = assertControl.getSearchFilter();
                                try {
                                    entry = DirectoryServer.getEntry(baseDN);
                                }
                                catch (DirectoryException de) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                    }
                                    localOp.setResultCode(de.getResultCode());
                                    int msgID = 196979;
                                    localOp.appendErrorMessage(MessageHandler.getMessage(msgID, de.getErrorMessage()));
                                    break block81;
                                }
                                if (entry == null) {
                                    localOp.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                    int msgID = 196980;
                                    localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                                    break block81;
                                }
                                if (assertionFilter.matchesEntry(entry)) continue;
                                localOp.setResultCode(ResultCode.ASSERTION_FAILED);
                                localOp.appendErrorMessage(MessageHandler.getMessage(196981));
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(ResultCode.PROTOCOL_ERROR);
                                int msgID = 196982;
                                localOp.appendErrorMessage(MessageHandler.getMessage(msgID, de.getErrorMessage()));
                            }
                            break block81;
                        }
                        if (oid.equals("2.16.840.1.113730.3.4.12")) {
                            if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, localOp)) {
                                int msgID = 197203;
                                localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                                localOp.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                                break block81;
                            }
                            if (c instanceof ProxiedAuthV1Control) {
                                proxyControl = (ProxiedAuthV1Control)c;
                            } else {
                                try {
                                    proxyControl = ProxiedAuthV1Control.decodeControl(c);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessage());
                                    break block81;
                                }
                            }
                            try {
                                authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(de.getResultCode());
                                localOp.appendErrorMessage(de.getErrorMessage());
                                break block81;
                            }
                            localOp.setAuthorizationEntry(authorizationEntry);
                            if (authorizationEntry == null) {
                                localOp.setProxiedAuthorizationDN(DN.nullDN());
                                continue;
                            }
                            localOp.setProxiedAuthorizationDN(authorizationEntry.getDN());
                            continue;
                        }
                        if (oid.equals("2.16.840.1.113730.3.4.18")) {
                            if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, localOp)) {
                                int msgID = 197203;
                                localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                                localOp.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                                break block81;
                            }
                            if (c instanceof ProxiedAuthV2Control) {
                                proxyControl = (ProxiedAuthV2Control)c;
                            } else {
                                try {
                                    proxyControl = ProxiedAuthV2Control.decodeControl(c);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessage());
                                    break block81;
                                }
                            }
                            try {
                                authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(de.getResultCode());
                                localOp.appendErrorMessage(de.getErrorMessage());
                                break block81;
                            }
                            localOp.setAuthorizationEntry(authorizationEntry);
                            if (authorizationEntry == null) {
                                localOp.setProxiedAuthorizationDN(DN.nullDN());
                                continue;
                            }
                            localOp.setProxiedAuthorizationDN(authorizationEntry.getDN());
                            continue;
                        }
                        if (oid.equals("2.16.840.1.113730.3.4.3")) {
                            PersistentSearchControl psearchControl;
                            if (c instanceof PersistentSearchControl) {
                                psearchControl = (PersistentSearchControl)c;
                            } else {
                                try {
                                    psearchControl = PersistentSearchControl.decodeControl(c);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessage());
                                    break block81;
                                }
                            }
                            persistentSearch = new PersistentSearch(operation, psearchControl.getChangeTypes(), psearchControl.getReturnECs());
                            localOp.setPersistentSearch(persistentSearch);
                            if (!psearchControl.getChangesOnly()) continue;
                            processSearch = false;
                            continue;
                        }
                        if (oid.equals("1.3.6.1.4.1.7628.5.101.1")) {
                            localOp.setReturnLDAPSubentries(true);
                            continue;
                        }
                        if (oid.equals("1.2.826.0.1.3344810.2.3")) {
                            if (c instanceof MatchedValuesControl) {
                                localOp.setMatchedValuesControl((MatchedValuesControl)c);
                                continue;
                            }
                            try {
                                MatchedValuesControl matchedValuesControl = MatchedValuesControl.decodeControl(c);
                                localOp.setMatchedValuesControl(matchedValuesControl);
                                continue;
                            }
                            catch (LDAPException le) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                }
                                localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                localOp.appendErrorMessage(le.getMessage());
                                break block81;
                            }
                        } else {
                            if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                                localOp.setIncludeUsableControl(true);
                                continue;
                            }
                            if (oid.equals("2.16.840.1.113730.3.4.17")) {
                                localOp.setRealAttributesOnly(true);
                                continue;
                            }
                            if (oid.equals("2.16.840.1.113730.3.4.19")) {
                                localOp.setVirtualAttributesOnly(true);
                                continue;
                            }
                            if (!c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                            localOp.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                            int msgID = 196983;
                            localOp.appendErrorMessage(MessageHandler.getMessage(msgID, oid));
                        }
                        break block81;
                    }
                }
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(localOp)) {
                    localOp.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                    int msgID = 262659;
                    localOp.appendErrorMessage(MessageHandler.getMessage(msgID, String.valueOf(baseDN)));
                    skipPostOperation = true;
                } else {
                    if (localOp.getCancelRequest() != null) {
                        return;
                    }
                    PreOperationPluginResult preOpResult = pluginConfigManager.invokePreOperationSearchPlugins(localOp);
                    if (preOpResult.connectionTerminated()) {
                        localOp.setResultCode(ResultCode.CANCELED);
                        int msgID = 262369;
                        localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                        localOp.setProcessingStopTime();
                        return;
                    }
                    if (preOpResult.sendResponseImmediately()) {
                        skipPostOperation = true;
                    } else if (preOpResult.skipCoreProcessing()) {
                        skipPostOperation = false;
                    } else {
                        if (localOp.getCancelRequest() != null) {
                            return;
                        }
                        if (this.backend == null) {
                            localOp.setResultCode(ResultCode.NO_SUCH_OBJECT);
                            localOp.appendErrorMessage(MessageHandler.getMessage(196848, String.valueOf(baseDN)));
                        } else {
                            localOp.setResultCode(ResultCode.SUCCESS);
                            if (persistentSearch != null) {
                                DirectoryServer.registerPersistentSearch(persistentSearch);
                                localOp.setSendResponse(false);
                            }
                            try {
                                if (processSearch) {
                                    localOp.searchBackend(this.backend);
                                }
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(de.getResultCode());
                                localOp.appendErrorMessage(de.getErrorMessage());
                                localOp.setMatchedDN(de.getMatchedDN());
                                localOp.setReferralURLs(de.getReferralURLs());
                                if (persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(persistentSearch);
                                    localOp.setSendResponse(true);
                                }
                            }
                            catch (CancelledOperationException coe) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, coe);
                                }
                                CancelResult cancelResult = coe.getCancelResult();
                                localOp.setCancelResult(cancelResult);
                                localOp.setResultCode(cancelResult.getResultCode());
                                String message = coe.getMessage();
                                if (message != null && message.length() > 0) {
                                    localOp.appendErrorMessage(message);
                                }
                                if (persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(persistentSearch);
                                    localOp.setSendResponse(true);
                                }
                                skipPostOperation = true;
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                localOp.setResultCode(DirectoryServer.getServerErrorResultCode());
                                int msgID = 196878;
                                localOp.appendErrorMessage(MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e)));
                                if (persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(persistentSearch);
                                    localOp.setSendResponse(true);
                                }
                                skipPostOperation = true;
                            }
                        }
                    }
                }
            }
        }
        if (localOp.getCancelRequest() != null) {
            return;
        }
        if (!skipPostOperation && (postOperationResult = pluginConfigManager.invokePostOperationSearchPlugins(localOp)).connectionTerminated()) {
            localOp.setResultCode(ResultCode.CANCELED);
            int msgID = 262370;
            localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
            localOp.setProcessingStopTime();
            return;
        }
    }

    public void processBind(BindOperation operation) {
        LocalBackendBindOperation localOperation = new LocalBackendBindOperation(operation);
        this.processLocalBind(localOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processLocalBind(LocalBackendBindOperation localOp) {
        block170: {
            block171: {
                clientConnection = localOp.getClientConnection();
                returnAuthzID = false;
                sizeLimit = DirectoryServer.getSizeLimit();
                timeLimit = DirectoryServer.getTimeLimit();
                lookthroughLimit = DirectoryServer.getLookthroughLimit();
                idleTimeLimit = DirectoryServer.getIdleTimeLimit();
                skipPostOperation = false;
                pwPolicyState = null;
                pwPolicyErrorType = null;
                pwPolicyControlRequested = false;
                isGraceLogin = false;
                mustChangePassword = false;
                pwPolicyWarningType = null;
                pwPolicyWarningValue = -1;
                saslMechanism = localOp.getSASLMechanism();
                isFirstWarning = false;
                authenticatedUserEntry = null;
                pwPolicyState = null;
                pluginConfigManager = DirectoryServer.getPluginConfigManager();
                bindDN = localOp.getBindDN();
                if (AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(localOp)) break block171;
                localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                msgID = 262653;
                message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                localOp.setAuthFailureReason(msgID, message);
                skipPostOperation = true;
                break block170;
            }
            requestControls = localOp.getRequestControls();
            if (requestControls != null && !requestControls.isEmpty()) {
                for (i = 0; i < requestControls.size(); ++i) {
                    c = requestControls.get(i);
                    oid = c.getOID();
                    if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(bindDN, localOp, c)) {
                        localOp.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                        msgID = 262755;
                        localOp.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{oid}));
                        skipPostOperation = true;
                    } else {
                        if (oid.equals("2.16.840.1.113730.3.4.16")) {
                            returnAuthzID = true;
                            continue;
                        }
                        if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                            pwPolicyControlRequested = true;
                            continue;
                        }
                        if (!c.isCritical()) continue;
                        localOp.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                        msgID = 262538;
                        localOp.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{String.valueOf(oid)}));
                    }
                    break block170;
                }
            }
            switch (1.$SwitchMap$org$opends$server$types$AuthenticationType[localOp.getAuthenticationType().ordinal()]) {
                case 1: {
                    simplePassword = localOp.getSimplePassword();
                    if (simplePassword == null || simplePassword.value().length == 0) {
                        if (DirectoryServer.lockdownMode()) {
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            msgID = 262760;
                            localOp.setAuthFailureReason(msgID, MessageHandler.getMessage(msgID));
                            localOp.setProcessingStopTime();
                            AccessLogger.logBindResponse(localOp);
                            break;
                        }
                        if (DirectoryServer.bindWithDNRequiresPassword() && bindDN != null && !bindDN.isNullDN()) {
                            localOp.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                            msgID = 262565;
                            message = MessageHandler.getMessage(msgID);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        preOpResult = pluginConfigManager.invokePreOperationBindPlugins(localOp);
                        if (preOpResult.connectionTerminated()) {
                            localOp.setResultCode(ResultCode.CANCELED);
                            msgID = 262369;
                            localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                            return;
                        }
                        if (preOpResult.sendResponseImmediately()) {
                            skipPostOperation = true;
                            break;
                        }
                        if (preOpResult.skipCoreProcessing()) {
                            skipPostOperation = false;
                            break;
                        }
                        localOp.setResultCode(ResultCode.SUCCESS);
                        localOp.setAuthenticationInfo(new AuthenticationInfo());
                        break;
                    }
                    actualRootDN = DirectoryServer.getActualRootBindDN(bindDN);
                    if (actualRootDN != null) {
                        bindDN = actualRootDN;
                    }
                    userLock = null;
                    for (i = 0; i < 3 && (userLock = LockManager.lockRead(bindDN)) == null; ++i) {
                    }
                    if (userLock == null) {
                        msgID = 262363;
                        message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                        localOp.setResultCode(DirectoryServer.getServerErrorResultCode());
                        localOp.setAuthFailureReason(msgID, message);
                        break;
                    }
                    try {
                        try {
                            userEntry = this.backend.getEntry(bindDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(de.getMessageID(), de.getErrorMessage());
                            userEntry = null;
                            LockManager.unlock(bindDN, userLock);
                            break;
                        }
                        if (userEntry == null) {
                            msgID = 196826;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        localOp.setUserEntryDN(userEntry.getDN());
                        pwPolicyState = new PasswordPolicyState(userEntry, false, false);
                        policy = pwPolicyState.getPolicy();
                        pwType = policy.getPasswordAttribute();
                        pwAttr = userEntry.getAttribute(pwType);
                        if (pwAttr == null || pwAttr.isEmpty()) {
                            msgID = 196829;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        if (!(policy.getStateUpdateFailurePolicy() != PasswordPolicyCfgDefn.StateUpdateFailurePolicy.PROACTIVE || policy.getLockoutFailureCount() <= 0 && (policy.getLastLoginTimeAttribute() == null || policy.getLastLoginTimeFormat() == null) || DirectoryServer.getWritabilityMode() != WritabilityMode.DISABLED && this.backend.getWritabilityMode() != WritabilityMode.DISABLED || DirectoryServer.isRootDN(bindDN))) {
                            msgID = 197236;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        if (policy.requireSecureAuthentication() && !clientConnection.isSecure()) {
                            msgID = 197124;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        if (pwPolicyState.isDisabled()) {
                            msgID = 197125;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        if (pwPolicyState.isAccountExpired()) {
                            msgID = 197139;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, bindDN, msgID, message);
                            break;
                        }
                        if (pwPolicyState.lockedDueToFailures()) {
                            msgID = 197126;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        if (pwPolicyState.lockedDueToMaximumResetAge()) {
                            msgID = 197127;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, bindDN, msgID, message);
                            break;
                        }
                        if (pwPolicyState.lockedDueToIdleInterval()) {
                            msgID = 197128;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, bindDN, msgID, message);
                            break;
                        }
                        if (!pwPolicyState.isPasswordExpired()) ** GOTO lbl199
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                        }
                        if ((maxGraceLogins = policy.getGraceLoginCount()) <= 0 || !pwPolicyState.mayUseGraceLogin()) ** GOTO lbl193
                        graceLoginTimes = pwPolicyState.getGraceLoginTimes();
                        if (graceLoginTimes == null || graceLoginTimes.size() < maxGraceLogins) {
                            isGraceLogin = true;
                            mustChangePassword = true;
                            if (pwPolicyWarningType == null) {
                                pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                                pwPolicyWarningValue = maxGraceLogins - (graceLoginTimes.size() + 1);
                            }
                        } else {
                            msgID = 197129;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, msgID, message);
                            break;
lbl193:
                            // 1 sources

                            msgID = 197129;
                            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, msgID, message);
                            break;
lbl199:
                            // 1 sources

                            if (pwPolicyState.shouldWarn()) {
                                numSeconds = pwPolicyState.getSecondsUntilExpiration();
                                timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                                msgID = 66083;
                                message = MessageHandler.getMessage(msgID, new Object[]{timeToExpiration});
                                localOp.appendErrorMessage(message);
                                if (pwPolicyWarningType == null) {
                                    pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                    pwPolicyWarningValue = numSeconds;
                                }
                                isFirstWarning = pwPolicyState.isFirstWarning();
                            }
                        }
                        if (pwPolicyState.mustChangePassword()) {
                            mustChangePassword = true;
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                            }
                        }
                        if ((preOpResult = pluginConfigManager.invokePreOperationBindPlugins(localOp)).connectionTerminated()) {
                            localOp.setResultCode(ResultCode.CANCELED);
                            msgID = 262369;
                            localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                            return;
                        }
                        if (preOpResult.sendResponseImmediately()) {
                            skipPostOperation = true;
                            break;
                        }
                        if (preOpResult.skipCoreProcessing()) {
                            skipPostOperation = false;
                            break;
                        }
                        if (pwPolicyState.passwordMatches(simplePassword)) {
                            localOp.setResultCode(ResultCode.SUCCESS);
                            isRoot = DirectoryServer.isRootDN(userEntry.getDN());
                            if (DirectoryServer.lockdownMode() && !isRoot) {
                                localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                msgID = 262760;
                                localOp.setAuthFailureReason(msgID, MessageHandler.getMessage(msgID));
                                break;
                            }
                            localOp.setAuthenticationInfo(new AuthenticationInfo(userEntry, simplePassword, isRoot));
                            attrType = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                            attrList = userEntry.getAttribute(attrType);
                            if (attrList != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    msgID = 131467;
                                    message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userEntry.getDN())});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                } else {
                                    try {
                                        sizeLimit = Integer.parseInt(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        msgID = 131468;
                                        message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), String.valueOf(userEntry.getDN())});
                                        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                    }
                                }
                            }
                            if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    msgID = 131469;
                                    message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userEntry.getDN())});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                } else {
                                    try {
                                        timeLimit = Integer.parseInt(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        msgID = 131470;
                                        message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), String.valueOf(userEntry.getDN())});
                                        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                    }
                                }
                            }
                            if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-idle-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    msgID = 131702;
                                    message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userEntry.getDN())});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                } else {
                                    try {
                                        idleTimeLimit = 1000L * Long.parseLong(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        msgID = 131703;
                                        message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), String.valueOf(userEntry.getDN())});
                                        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                    }
                                }
                            }
                            if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    msgID = 131629;
                                    message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userEntry.getDN())});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                } else {
                                    try {
                                        lookthroughLimit = Integer.parseInt(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        msgID = 131630;
                                        message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), String.valueOf(userEntry.getDN())});
                                        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                    }
                                }
                            }
                            pwPolicyState.handleDeprecatedStorageSchemes(simplePassword);
                            pwPolicyState.clearFailureLockout();
                            if (isFirstWarning) {
                                pwPolicyState.setWarnedTime();
                                numSeconds = pwPolicyState.getSecondsUntilExpiration();
                                timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                                msgID = 66083;
                                message = MessageHandler.getMessage(msgID, new Object[]{timeToExpiration});
                                pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, bindDN, msgID, message);
                            }
                            if (isGraceLogin) {
                                pwPolicyState.updateGraceLoginTimes();
                            }
                            pwPolicyState.setLastLoginTime();
                            break;
                        }
                        msgID = 196887;
                        message = MessageHandler.getMessage(msgID);
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        localOp.setAuthFailureReason(msgID, message);
                        if (policy.getLockoutFailureCount() <= 0) break;
                        pwPolicyState.updateAuthFailureTimes();
                        if (!pwPolicyState.lockedDueToFailures()) break;
                        lockoutDuration = pwPolicyState.getSecondsUntilUnlock();
                        if (lockoutDuration > -1) {
                            notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                            msgID = 197156;
                            message = MessageHandler.getMessage(msgID, new Object[]{StaticUtils.secondsToTimeString(lockoutDuration)});
                        } else {
                            notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                            msgID = 197157;
                            message = MessageHandler.getMessage(msgID);
                        }
                        pwPolicyState.generateAccountStatusNotification(notificationType, localOp.getUserEntryDN(), msgID, message);
                        break;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        msgID = 196888;
                        message = MessageHandler.getMessage(msgID, new Object[]{StaticUtils.getExceptionMessage(e)});
                        localOp.setResultCode(DirectoryServer.getServerErrorResultCode());
                        localOp.setAuthFailureReason(msgID, message);
                        break;
                    }
                    finally {
                        LockManager.unlock(bindDN, userLock);
                    }
                }
                case 2: {
                    saslHandler = DirectoryServer.getSASLMechanismHandler(saslMechanism);
                    if (saslHandler == null) {
                        localOp.setResultCode(ResultCode.AUTH_METHOD_NOT_SUPPORTED);
                        msgID = 196830;
                        message = MessageHandler.getMessage(msgID, new Object[]{saslMechanism});
                        localOp.appendErrorMessage(message);
                        localOp.setAuthFailureReason(msgID, message);
                        break;
                    }
                    preOpResult = pluginConfigManager.invokePreOperationBindPlugins(localOp);
                    if (preOpResult.connectionTerminated()) {
                        localOp.setResultCode(ResultCode.CANCELED);
                        msgID = 262369;
                        localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
                        return;
                    }
                    if (preOpResult.sendResponseImmediately()) {
                        skipPostOperation = true;
                        break;
                    }
                    if (preOpResult.skipCoreProcessing()) {
                        skipPostOperation = false;
                        break;
                    }
                    saslHandler.processSASLBind(localOp);
                    if (DirectoryServer.lockdownMode() && (resultCode = localOp.getResultCode()) != ResultCode.SASL_BIND_IN_PROGRESS && (resultCode != ResultCode.SUCCESS || localOp.getSASLAuthUserEntry() == null || !DirectoryServer.isRootDN(localOp.getSASLAuthUserEntry().getDN()))) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        msgID = 262760;
                        localOp.setAuthFailureReason(msgID, MessageHandler.getMessage(msgID));
                        break;
                    }
                    saslAuthUserEntry = localOp.getSASLAuthUserEntry();
                    if (saslAuthUserEntry == null) {
                        pwPolicyState = null;
                        userDNString = null;
                    } else {
                        try {
                            pwPolicyState = new PasswordPolicyState(saslAuthUserEntry, false, false);
                            localOp.setUserEntryDN(saslAuthUserEntry.getDN());
                            userDNString = String.valueOf(localOp.getUserEntryDN());
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            localOp.setResponseData(de);
                            break;
                        }
                    }
                    if (pwPolicyState == null) ** GOTO lbl473
                    policy = pwPolicyState.getPolicy();
                    if (policy.getStateUpdateFailurePolicy() == PasswordPolicyCfgDefn.StateUpdateFailurePolicy.PROACTIVE && (policy.getLockoutFailureCount() > 0 || policy.getLastLoginTimeAttribute() != null && policy.getLastLoginTimeFormat() != null) && (DirectoryServer.getWritabilityMode() == WritabilityMode.DISABLED || this.backend.getWritabilityMode() == WritabilityMode.DISABLED)) {
                        if (!DirectoryServer.isRootDN(bindDN)) {
                            msgID = 197236;
                            message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                    } else {
                        if (pwPolicyState.isDisabled()) {
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            msgID = 197125;
                            message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                            localOp.setAuthFailureReason(msgID, message);
                            break;
                        }
                        if (pwPolicyState.isAccountExpired()) {
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            msgID = 197139;
                            message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                            localOp.setAuthFailureReason(msgID, message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, bindDN, msgID, message);
                            break;
                        }
                    }
                    if (policy.requireSecureAuthentication() && !clientConnection.isSecure() && !saslHandler.isSecure(saslMechanism)) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        msgID = 197131;
                        message = MessageHandler.getMessage(msgID, new Object[]{saslMechanism, userDNString});
                        localOp.setAuthFailureReason(msgID, message);
                        break;
                    }
                    if (pwPolicyState.lockedDueToFailures()) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        msgID = 197126;
                        message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                        localOp.setAuthFailureReason(msgID, message);
                        break;
                    }
                    if (pwPolicyState.lockedDueToIdleInterval()) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        msgID = 197128;
                        message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                        localOp.setAuthFailureReason(msgID, message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, bindDN, msgID, message);
                        break;
                    }
                    if (!saslHandler.isPasswordBased(saslMechanism)) ** GOTO lbl473
                    if (pwPolicyState.lockedDueToMaximumResetAge()) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        msgID = 197127;
                        message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                        localOp.setAuthFailureReason(msgID, message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, bindDN, msgID, message);
                        break;
                    }
                    if (!pwPolicyState.isPasswordExpired()) ** GOTO lbl463
                    if (pwPolicyErrorType == null) {
                        pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    }
                    if ((maxGraceLogins = policy.getGraceLoginCount()) <= 0 || !pwPolicyState.mayUseGraceLogin()) ** GOTO lbl457
                    graceLoginTimes = pwPolicyState.getGraceLoginTimes();
                    if (graceLoginTimes == null || graceLoginTimes.size() < maxGraceLogins) {
                        isGraceLogin = true;
                        mustChangePassword = true;
                        if (pwPolicyWarningType == null) {
                            pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                            pwPolicyWarningValue = maxGraceLogins - (graceLoginTimes.size() + 1);
                        }
                    } else {
                        msgID = 197129;
                        message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        localOp.setAuthFailureReason(msgID, message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, msgID, message);
                        break;
lbl457:
                        // 1 sources

                        msgID = 197129;
                        message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(bindDN)});
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        localOp.setAuthFailureReason(msgID, message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, msgID, message);
                        break;
lbl463:
                        // 1 sources

                        if (pwPolicyState.shouldWarn()) {
                            numSeconds = pwPolicyState.getSecondsUntilExpiration();
                            timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                            msgID = 66083;
                            message = MessageHandler.getMessage(msgID, new Object[]{timeToExpiration});
                            localOp.appendErrorMessage(message);
                            if (pwPolicyWarningType == null) {
                                pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                pwPolicyWarningValue = numSeconds;
                            }
                            isFirstWarning = pwPolicyState.isFirstWarning();
                        }
                    }
lbl473:
                    // 6 sources

                    if ((resultCode = localOp.getResultCode()) == ResultCode.SUCCESS) {
                        if (pwPolicyState == null) break;
                        if (saslHandler.isPasswordBased(saslMechanism) && pwPolicyState.mustChangePassword()) {
                            mustChangePassword = true;
                        }
                        if (isFirstWarning) {
                            pwPolicyState.setWarnedTime();
                            numSeconds = pwPolicyState.getSecondsUntilExpiration();
                            timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                            msgID = 66083;
                            message = MessageHandler.getMessage(msgID, new Object[]{timeToExpiration});
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, bindDN, msgID, message);
                        }
                        if (isGraceLogin) {
                            pwPolicyState.updateGraceLoginTimes();
                        }
                        pwPolicyState.setLastLoginTime();
                        attrType = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                        attrList = saslAuthUserEntry.getAttribute(attrType);
                        if (attrList != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                            v = (AttributeValue)iterator.next();
                            if (iterator.hasNext()) {
                                msgID = 131467;
                                message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                                ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                            } else {
                                try {
                                    sizeLimit = Integer.parseInt(v.getStringValue());
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    msgID = 131468;
                                    message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), userDNString});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                }
                            }
                        }
                        if ((attrList = saslAuthUserEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                            v = (AttributeValue)iterator.next();
                            if (iterator.hasNext()) {
                                msgID = 131469;
                                message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                                ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                            } else {
                                try {
                                    timeLimit = Integer.parseInt(v.getStringValue());
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    msgID = 131470;
                                    message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), userDNString});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                }
                            }
                        }
                        if ((attrList = saslAuthUserEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-idle-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                            v = (AttributeValue)iterator.next();
                            if (iterator.hasNext()) {
                                msgID = 131702;
                                message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userDNString)});
                                ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                            } else {
                                try {
                                    idleTimeLimit = 1000L * Long.parseLong(v.getStringValue());
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    msgID = 131703;
                                    message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), String.valueOf(userDNString)});
                                    ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                                }
                            }
                        }
                        if ((attrList = saslAuthUserEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) == null || attrList.size() != 1 || !(iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) break;
                        v = (AttributeValue)iterator.next();
                        if (iterator.hasNext()) {
                            msgID = 131629;
                            message = MessageHandler.getMessage(msgID, new Object[]{userDNString});
                            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                            break;
                        }
                        try {
                            lookthroughLimit = Integer.parseInt(v.getStringValue());
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            msgID = 131630;
                            message = MessageHandler.getMessage(msgID, new Object[]{v.getStringValue(), userDNString});
                            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                        }
                        break;
                    }
                    if (resultCode == ResultCode.SASL_BIND_IN_PROGRESS || pwPolicyState == null || !saslHandler.isPasswordBased(saslMechanism) || pwPolicyState.getPolicy().getLockoutFailureCount() <= 0) break;
                    pwPolicyState.updateAuthFailureTimes();
                    if (!pwPolicyState.lockedDueToFailures()) break;
                    lockoutDuration = pwPolicyState.getSecondsUntilUnlock();
                    if (lockoutDuration > -1) {
                        notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                        msgID = 197156;
                        message = MessageHandler.getMessage(msgID, new Object[]{StaticUtils.secondsToTimeString(lockoutDuration)});
                    } else {
                        notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                        msgID = 197157;
                        message = MessageHandler.getMessage(msgID);
                    }
                    pwPolicyState.generateAccountStatusNotification(notificationType, localOp.getUserEntryDN(), msgID, message);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        try {
            if (pwPolicyState != null) {
                pwPolicyState.updateUserEntry();
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            localOp.setResponseData(de);
        }
        if (!skipPostOperation && (postOpResult = pluginConfigManager.invokePostOperationBindPlugins(localOp)).connectionTerminated()) {
            localOp.setResultCode(ResultCode.CANCELED);
            msgID = 262369;
            localOp.appendErrorMessage(MessageHandler.getMessage(msgID));
            return;
        }
        authInfo = localOp.getAuthenticationInfo();
        if (localOp.getResultCode() == ResultCode.SUCCESS && authInfo != null) {
            authenticatedUserEntry = authInfo.getAuthenticationEntry();
            clientConnection.setAuthenticationInfo(authInfo);
            clientConnection.setSizeLimit(sizeLimit);
            clientConnection.setTimeLimit(timeLimit);
            clientConnection.setIdleTimeLimit(idleTimeLimit);
            clientConnection.setLookthroughLimit(lookthroughLimit);
            clientConnection.setMustChangePassword(mustChangePassword);
            if (returnAuthzID) {
                localOp.addResponseControl(new AuthorizationIdentityResponseControl(authInfo.getAuthorizationDN()));
            }
        }
        if (localOp.getResultCode() == ResultCode.SUCCESS) {
            if (pwPolicyControlRequested) {
                pwpControl = new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType);
                localOp.addResponseControl(pwpControl);
            } else if (pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                localOp.addResponseControl(new PasswordExpiredControl());
            } else if (pwPolicyWarningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                localOp.addResponseControl(new PasswordExpiringControl(pwPolicyWarningValue));
            }
        } else if (pwPolicyControlRequested) {
            pwpControl = new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType);
            localOp.addResponseControl(pwpControl);
        } else if (pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
            localOp.addResponseControl(new PasswordExpiredControl());
        }
        localOp.setProcessingStopTime();
    }

    public void processAdd(AddOperation operation) {
        LocalBackendAddOperation localOperation = new LocalBackendAddOperation(operation);
        this.processLocalAdd(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalAdd(LocalBackendAddOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 400[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processDelete(DeleteOperation operation) {
        LocalBackendDeleteOperation localOperation = new LocalBackendDeleteOperation(operation);
        this.processLocalDelete(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalDelete(LocalBackendDeleteOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 78[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processCompare(CompareOperation operation) {
        LocalBackendCompareOperation localOperation = new LocalBackendCompareOperation(operation);
        this.processLocalCompare(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalCompare(LocalBackendCompareOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 26[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processModifyDN(ModifyDNOperation op) {
        LocalBackendModifyDNOperation localOp = new LocalBackendModifyDNOperation(op);
        this.processLocalModifyDN(localOp);
    }

    /*
     * Exception decompiling
     */
    private void processLocalModifyDN(LocalBackendModifyDNOperation op) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 249[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final <O extends Operation, L> void attachLocalOperation(O globalOperation, L currentLocalOperation) {
        List existingAttachment = (List)globalOperation.getAttachment("LocalBackendOperations");
        ArrayList<L> newAttachment = new ArrayList<L>();
        if (existingAttachment != null) {
            newAttachment.addAll(existingAttachment);
        }
        newAttachment.add(currentLocalOperation);
        globalOperation.setAttachment("LocalBackendOperations", newAttachment);
    }
}

