/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ServerLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyCache {
    private ADSContext adsContext;
    private ApplicationTrustManager trustManager;
    private String dn;
    private String pwd;
    private Set<ServerDescriptor> servers = new HashSet<ServerDescriptor>();
    private Set<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
    private final boolean isMultiThreaded = true;
    private static final int MULTITHREAD_TIMEOUT = 10000;
    private static final Logger LOG = Logger.getLogger(TopologyCache.class.getName());

    public TopologyCache(ADSContext adsContext, ApplicationTrustManager trustManager) throws TopologyCacheException {
        this.adsContext = adsContext;
        this.trustManager = trustManager;
        try {
            this.dn = (String)adsContext.getDirContext().getEnvironment().get("java.naming.security.principal");
            this.pwd = (String)adsContext.getDirContext().getEnvironment().get("java.naming.security.credentials");
        }
        catch (NamingException ne) {
            throw new TopologyCacheException(TopologyCacheException.Type.BUG, (Throwable)ne);
        }
    }

    public void reloadTopology() throws TopologyCacheException {
        this.suffixes.clear();
        this.servers.clear();
        try {
            Set<Map<ADSContext.ServerProperty, Object>> adsServers = this.adsContext.readServerRegistry();
            HashSet<ServerLoader> threadSet = new HashSet<ServerLoader>();
            for (Map<ADSContext.ServerProperty, Object> serverProperties : adsServers) {
                ServerLoader t = this.getServerLoader(serverProperties);
                t.start();
                threadSet.add(t);
            }
            this.joinThreadSet(threadSet);
            HashMap<LdapName, HashSet<SuffixDescriptor>> hmSuffixes = new HashMap<LdapName, HashSet<SuffixDescriptor>>();
            for (ServerLoader loader : threadSet) {
                ServerDescriptor descriptor = loader.getServerDescriptor();
                for (ReplicaDescriptor replica : descriptor.getReplicas()) {
                    LOG.log(Level.INFO, "Handling replica with dn: " + replica.getSuffix().getDN());
                    boolean suffixFound = false;
                    LdapName dn = new LdapName(replica.getSuffix().getDN());
                    HashSet<SuffixDescriptor> sufs = (HashSet<SuffixDescriptor>)hmSuffixes.get(dn);
                    if (sufs != null) {
                        Iterator it = sufs.iterator();
                        while (it.hasNext() && !suffixFound) {
                            SuffixDescriptor suffix = (SuffixDescriptor)it.next();
                            Iterator<String> it2 = suffix.getReplicationServers().iterator();
                            while (it2.hasNext() && !suffixFound) {
                                if (!replica.getReplicationServers().contains(it2.next())) continue;
                                suffixFound = true;
                                Set<ReplicaDescriptor> replicas = suffix.getReplicas();
                                replicas.add(replica);
                                suffix.setReplicas(replicas);
                                replica.setSuffix(suffix);
                            }
                        }
                    }
                    if (suffixFound) continue;
                    if (sufs == null) {
                        sufs = new HashSet<SuffixDescriptor>();
                        hmSuffixes.put(dn, sufs);
                    }
                    sufs.add(replica.getSuffix());
                    this.suffixes.add(replica.getSuffix());
                }
                this.servers.add(descriptor);
            }
        }
        catch (ADSContextException ade) {
            throw new TopologyCacheException(ade);
        }
        catch (Throwable t) {
            throw new TopologyCacheException(TopologyCacheException.Type.BUG, t);
        }
    }

    public Set<ServerDescriptor> getServers() {
        HashSet<ServerDescriptor> copy = new HashSet<ServerDescriptor>();
        copy.addAll(this.servers);
        return copy;
    }

    public Set<SuffixDescriptor> getSuffixes() {
        HashSet<SuffixDescriptor> copy = new HashSet<SuffixDescriptor>();
        copy.addAll(this.suffixes);
        return copy;
    }

    private void joinThreadSet(Set<ServerLoader> threadSet) {
        Date startDate = new Date();
        for (ServerLoader t : threadSet) {
            long timeToJoin = 10000L - System.currentTimeMillis() + startDate.getTime();
            try {
                if (timeToJoin > 0L) {
                    t.join(10000L);
                }
            }
            catch (InterruptedException ie) {
                LOG.log(Level.INFO, ie + " caught and ignored", ie);
            }
            if (!t.isAlive()) continue;
            t.interrupt();
        }
        Date endDate = new Date();
        long workingTime = endDate.getTime() - startDate.getTime();
        LOG.log(Level.INFO, "Loading ended at " + workingTime + " ms");
    }

    private ServerLoader getServerLoader(Map<ADSContext.ServerProperty, Object> serverProperties) {
        return new ServerLoader(serverProperties, this.dn, this.pwd, this.trustManager.createCopy());
    }
}

