/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.quicksetup.util.Utils;

public class BaseDNDescriptor
implements Comparable {
    private int missingChanges;
    private DatabaseDescriptor db;
    private int ageOfOldestMissingChange;
    private Type type;
    private String baseDn;

    public BaseDNDescriptor(Type type, String baseDn, DatabaseDescriptor db, int ageOfOldestMissingChange, int missingChanges) {
        this.baseDn = baseDn;
        this.db = db;
        this.type = type;
        this.ageOfOldestMissingChange = ageOfOldestMissingChange;
        this.missingChanges = missingChanges;
    }

    public String getDn() {
        return this.baseDn;
    }

    public boolean equals(Object v) {
        boolean equals = false;
        if (this != v) {
            if (v instanceof BaseDNDescriptor) {
                BaseDNDescriptor desc = (BaseDNDescriptor)v;
                equals = this.getType() == desc.getType() && Utils.areDnsEqual(this.getDn(), desc.getDn()) && this.getAgeOfOldestMissingChange() == desc.getAgeOfOldestMissingChange() && this.getMissingChanges() == desc.getMissingChanges() && this.getDatabase().getBackendID().equals(desc.getDatabase().getBackendID()) && this.getDatabase().getEntries() == desc.getDatabase().getEntries();
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return (this.getType().toString() + this.getAgeOfOldestMissingChange() + this.getDn() + this.getDatabase().getBackendID() + this.getMissingChanges()).hashCode();
    }

    public int compareTo(Object o) {
        int returnValue = -1;
        if (o instanceof BaseDNDescriptor) {
            BaseDNDescriptor desc = (BaseDNDescriptor)o;
            returnValue = desc.getDn().compareTo(this.getDn());
        }
        return returnValue;
    }

    public int getMissingChanges() {
        return this.missingChanges;
    }

    public int getAgeOfOldestMissingChange() {
        return this.ageOfOldestMissingChange;
    }

    public Type getType() {
        return this.type;
    }

    public DatabaseDescriptor getDatabase() {
        return this.db;
    }

    void setType(Type type) {
        this.type = type;
    }

    void setDatabase(DatabaseDescriptor db) {
        this.db = db;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NOT_REPLICATED,
        REPLICATED;

    }
}

