/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.File;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConfigFromFile;
import org.opends.guitools.statuspanel.ConfigFromLDAP;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.guitools.statuspanel.ServerStatusDescriptor;
import org.opends.guitools.statuspanel.event.ServerStatusChangeEvent;
import org.opends.guitools.statuspanel.event.ServerStatusChangeListener;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;

public class ServerStatusPooler {
    private String dn;
    private String pwd;
    private ApplicationTrustManager trustManager;
    private ServerStatusDescriptor lastDescriptor;
    private boolean stopPooling;
    private Thread poolingThread;
    private HashSet<ServerStatusChangeListener> listeners = new HashSet();
    private boolean starting;
    private boolean stopping;
    private ConfigFromFile offLineConf = new ConfigFromFile();
    private ConfigFromLDAP onLineConf = new ConfigFromLDAP();
    private int nTriesWithErrorOnline;
    private ConnectionProtocolPolicy policy;
    private static final int OFFLINE_POOLING_PERIOD = 6000;
    private static final int ONLINE_POOLING_PERIOD = 4000;
    private static final Logger LOG = Logger.getLogger(ServerStatusPooler.class.getName());

    public ServerStatusPooler(ConnectionProtocolPolicy policy) {
        this.offLineConf.readConfiguration();
        this.policy = policy;
    }

    public void startPooling() {
        this.stopPooling = false;
        this.poolingThread = new Thread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    ServerStatusPooler.this.nTriesWithErrorOnline = 0;
                    while (!ServerStatusPooler.this.stopPooling) {
                        long poolingPeriod;
                        long t2;
                        long t1 = System.currentTimeMillis();
                        ServerStatusDescriptor desc = ServerStatusPooler.this.generateDescriptor();
                        if (!desc.equals(ServerStatusPooler.this.lastDescriptor)) {
                            ServerStatusPooler.this.lastDescriptor = desc;
                            ServerStatusPooler.this.notifyListeners(ServerStatusPooler.this.lastDescriptor);
                        }
                        if ((t2 = System.currentTimeMillis()) - t1 >= (poolingPeriod = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED ? 4000L : 6000L)) continue;
                        try {
                            Thread.sleep(poolingPeriod - (t2 - t1));
                        }
                        catch (Exception ex) {
                            if (ServerStatusPooler.this.stopPooling) continue;
                            throw ex;
                            return;
                        }
                    }
                }
                catch (Throwable t) {
                    if (ServerStatusPooler.this.stopPooling) return;
                    t.printStackTrace();
                }
            }
        });
        this.poolingThread.start();
    }

    public void stopPooling() {
        this.stopPooling = true;
        try {
            this.onLineConf.closeConnection();
            this.poolingThread.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ServerStatusDescriptor getLastDescriptor() {
        return this.lastDescriptor;
    }

    public void beginServerStart() {
        this.starting = true;
    }

    public void endServerStart() {
        this.starting = false;
    }

    public void beginServerStop() {
        this.stopping = true;
    }

    public void endServerStop() {
        this.stopping = false;
    }

    public void addServerStatusChangeListener(ServerStatusChangeListener l) {
        this.listeners.add(l);
    }

    public void removeServerStatusChangeListener(ServerStatusChangeListener l) {
        this.listeners.remove(l);
    }

    public boolean isAuthenticated() {
        return this.dn != null && this.pwd != null;
    }

    public void setAuthentication(String dn, String pwd, ApplicationTrustManager trustManager) throws ConfigException {
        this.dn = dn;
        this.pwd = pwd;
        this.trustManager = trustManager;
        if (this.poolingThread != null && this.poolingThread.isAlive() && !this.stopPooling) {
            this.stopPooling = true;
            this.poolingThread.interrupt();
            try {
                this.poolingThread.join(5000L);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.poolingThread = null;
            this.onLineConf.setConnectionInfo(this.offLineConf, this.policy, dn, pwd, trustManager);
            this.startPooling();
        } else {
            this.onLineConf.setConnectionInfo(this.offLineConf, this.policy, dn, pwd, trustManager);
        }
    }

    private void notifyListeners(ServerStatusDescriptor desc) {
        ServerStatusChangeEvent ev = new ServerStatusChangeEvent(desc);
        for (ServerStatusChangeListener l : this.listeners) {
            l.statusChanged(ev);
        }
    }

    private ServerStatusDescriptor generateDescriptor() {
        ServerStatusDescriptor desc = new ServerStatusDescriptor();
        desc.setAuthenticated(this.dn != null && this.pwd != null);
        if (this.starting) {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STARTING);
        } else if (this.stopping) {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STOPPING);
        } else if (Installation.getLocal().getStatus().isServerRunning()) {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STARTED);
        } else {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STOPPED);
        }
        desc.setInstallPath(new File(Utils.getInstallPathFromClasspath()));
        desc.setOpenDSVersion(DynamicConstants.FULL_VERSION_STRING);
        if (desc.getStatus() != ServerStatusDescriptor.ServerStatus.STARTED) {
            this.updateDescriptorWithOffLineInfo(desc);
        } else {
            try {
                if (this.dn == null || this.pwd == null) {
                    desc.setAdministrativeUsers(new HashSet<String>());
                    desc.setDatabases(new HashSet<DatabaseDescriptor>());
                    desc.setListeners(new HashSet<ListenerDescriptor>());
                    desc.setOpenConnections(-1);
                } else {
                    this.updateDescriptorWithOnLineInfo(desc);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return desc;
    }

    private void updateDescriptorWithOffLineInfo(ServerStatusDescriptor desc) {
        this.offLineConf.readConfiguration();
        desc.setAdministrativeUsers(this.offLineConf.getAdministrativeUsers());
        desc.setDatabases(this.offLineConf.getDatabases());
        desc.setListeners(this.offLineConf.getListeners());
        desc.setErrorMessage(this.offLineConf.getErrorMessage());
        if (this.dn != null && this.pwd != null) {
            try {
                this.onLineConf.setConnectionInfo(this.offLineConf, this.policy, this.dn, this.pwd, this.trustManager);
            }
            catch (ConfigException ce) {
                LOG.log(Level.WARNING, "Error retrieving LDAP URL: " + ce, ce);
            }
        }
        desc.setOpenConnections(-1);
        desc.setJavaVersion(null);
    }

    private void updateDescriptorWithOnLineInfo(ServerStatusDescriptor desc) {
        this.onLineConf.readConfiguration();
        desc.setAdministrativeUsers(this.onLineConf.getAdministrativeUsers());
        desc.setDatabases(this.onLineConf.getDatabases());
        desc.setListeners(this.onLineConf.getListeners());
        desc.setErrorMessage(this.onLineConf.getErrorMessage());
        desc.setJavaVersion(this.onLineConf.getJavaVersion());
        desc.setOpenConnections(this.onLineConf.getOpenConnections());
        if (desc.getErrorMessage() != null) {
            ++this.nTriesWithErrorOnline;
            if (this.nTriesWithErrorOnline >= 5) {
                this.offLineConf.readConfiguration();
                try {
                    this.onLineConf.setConnectionInfo(this.offLineConf, this.policy, this.dn, this.pwd, this.trustManager);
                }
                catch (ConfigException ce) {
                    desc.setErrorMessage(ce.getMessageObject());
                }
                this.nTriesWithErrorOnline = 0;
            }
        }
    }
}

