/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import org.opends.guitools.statuspanel.BaseDNDescriptor;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConfigFromFile;
import org.opends.guitools.statuspanel.ConfigFromLDAP;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.guitools.statuspanel.ServerStatusDescriptor;
import org.opends.guitools.statuspanel.ui.DatabasesTableModel;
import org.opends.guitools.statuspanel.ui.ListenersTableModel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.core.DirectoryServer;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

class StatusCli
extends SecureConnectionCliParser {
    private String[] args;
    private boolean displayMustAuthenticateLegend;
    private boolean displayMustStartLegend;
    private static final Logger LOG = Logger.getLogger(StatusCli.class.getName());

    public static void main(String[] args) {
        QuickSetupLog.disableConsoleLogging();
        StatusCli cli = new StatusCli(args);
        System.exit(cli.run());
    }

    StatusCli(String[] args) {
        super(StatusCli.class.getName(), AdminToolMessages.INFO_STATUS_CLI_USAGE_DESCRIPTION.get(), false);
        this.args = args;
        DirectoryServer.bootstrapClient();
    }

    int run() {
        try {
            ArrayList<Argument> defaultArgs = new ArrayList<Argument>(this.createGlobalArguments(System.err));
            defaultArgs.remove(this.portArg);
            defaultArgs.remove(this.hostNameArg);
            defaultArgs.remove(this.verboseArg);
            this.initializeGlobalArguments(defaultArgs);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            System.err.println(Utils.wrap(message));
            return DsFrameworkCliReturnCode.ERROR_UNEXPECTED.getReturnCode();
        }
        try {
            this.parseArguments(this.args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            System.err.println(Utils.wrap(message));
            System.err.println(this.getUsage());
            return DsFrameworkCliReturnCode.ERROR_PARSING_ARGS.getReturnCode();
        }
        if (this.usageOrVersionDisplayed()) {
            return DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
        }
        int v = this.validateGlobalOptions(System.err);
        if (v != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            System.err.println(this.getUsage());
            return v;
        }
        boolean isServerRunning = Installation.getLocal().getStatus().isServerRunning();
        ConfigFromFile offLineConf = new ConfigFromFile();
        offLineConf.readConfiguration();
        try {
            if (isServerRunning) {
                String directoryManagerDn = this.getBindDN();
                String directoryManagerPwd = this.getBindPassword(directoryManagerDn, System.out, System.err);
                if (directoryManagerDn == null) {
                    directoryManagerDn = "";
                }
                if (directoryManagerPwd == null) {
                    directoryManagerPwd = "";
                }
                ServerStatusDescriptor desc = this.createServerStatusDescriptor(directoryManagerDn, directoryManagerPwd);
                ConfigFromLDAP onLineConf = new ConfigFromLDAP();
                if (this.startTLSArg.isPresent()) {
                    ConnectionProtocolPolicy connectionProtocolPolicy = ConnectionProtocolPolicy.USE_STARTTLS;
                }
                ConnectionProtocolPolicy policy = this.useSSLArg.isPresent() ? ConnectionProtocolPolicy.USE_LDAPS : ConnectionProtocolPolicy.USE_MOST_SECURE_AVAILABLE;
                onLineConf.setConnectionInfo(offLineConf, policy, directoryManagerDn, directoryManagerPwd, this.getTrustManager());
                onLineConf.readConfiguration();
                this.updateDescriptorWithOnLineInfo(desc, onLineConf);
                this.writeStatus(desc);
            } else {
                ServerStatusDescriptor desc = this.createServerStatusDescriptor(null, null);
                this.updateDescriptorWithOffLineInfo(desc, offLineConf);
                this.writeStatus(desc);
            }
        }
        catch (ConfigException ce) {
            System.err.println(Utils.wrap(ce.getMessageObject()));
        }
        return DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
    }

    private ServerStatusDescriptor createServerStatusDescriptor(String dn, String pwd) {
        ServerStatusDescriptor desc = new ServerStatusDescriptor();
        desc.setAuthenticated(dn != null && pwd != null);
        if (Installation.getLocal().getStatus().isServerRunning()) {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STARTED);
        } else {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STOPPED);
        }
        desc.setInstallPath(new File(Utils.getInstallPathFromClasspath()));
        desc.setOpenDSVersion(DynamicConstants.FULL_VERSION_STRING);
        return desc;
    }

    private void updateDescriptorWithOffLineInfo(ServerStatusDescriptor desc, ConfigFromFile offLineConf) {
        desc.setAdministrativeUsers(offLineConf.getAdministrativeUsers());
        desc.setDatabases(offLineConf.getDatabases());
        desc.setListeners(offLineConf.getListeners());
        desc.setErrorMessage(offLineConf.getErrorMessage());
        desc.setOpenConnections(-1);
        desc.setJavaVersion(null);
    }

    private void updateDescriptorWithOnLineInfo(ServerStatusDescriptor desc, ConfigFromLDAP onLineConf) {
        desc.setAdministrativeUsers(onLineConf.getAdministrativeUsers());
        desc.setDatabases(onLineConf.getDatabases());
        desc.setListeners(onLineConf.getListeners());
        desc.setErrorMessage(onLineConf.getErrorMessage());
        desc.setJavaVersion(onLineConf.getJavaVersion());
        desc.setOpenConnections(onLineConf.getOpenConnections());
    }

    private void writeStatus(ServerStatusDescriptor desc) {
        Message[] labels = new Message[]{AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), AdminToolMessages.INFO_JAVA_VERSION_LABEL.get()};
        int labelWidth = 0;
        for (int i = 0; i < labels.length; ++i) {
            labelWidth = Math.max(labelWidth, labels[i].length());
        }
        System.out.println();
        Message title = AdminToolMessages.INFO_SERVER_STATUS_TITLE.get();
        System.out.println(this.centerTitle(title));
        this.writeStatusContents(desc, labelWidth);
        this.writeCurrentConnectionContents(desc, labelWidth);
        System.out.println();
        title = AdminToolMessages.INFO_SERVER_DETAILS_TITLE.get();
        System.out.println(this.centerTitle(title));
        this.writeAdministrativeUserContents(desc, labelWidth);
        this.writeInstallPathContents(desc, labelWidth);
        this.writeVersionContents(desc, labelWidth);
        this.writeJavaVersionContents(desc, labelWidth);
        System.out.println();
        this.writeListenerContents(desc);
        System.out.println();
        this.writeDatabaseContents(desc);
        this.writeErrorContents(desc);
        if (this.displayMustStartLegend) {
            System.out.println();
            System.out.println(Utils.wrap(AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_CLI_LEGEND.get()));
        } else if (this.displayMustAuthenticateLegend) {
            System.out.println();
            System.out.println(Utils.wrap(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LEGEND.get()));
        }
        System.out.println();
    }

    private void writeStatusContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        Message status;
        switch (desc.getStatus()) {
            case STARTED: {
                status = AdminToolMessages.INFO_SERVER_STARTED_LABEL.get();
                break;
            }
            case STOPPED: {
                status = AdminToolMessages.INFO_SERVER_STOPPED_LABEL.get();
                break;
            }
            case STARTING: {
                status = AdminToolMessages.INFO_SERVER_STARTING_LABEL.get();
                break;
            }
            case STOPPING: {
                status = AdminToolMessages.INFO_SERVER_STOPPING_LABEL.get();
                break;
            }
            case UNKNOWN: {
                status = AdminToolMessages.INFO_SERVER_UNKNOWN_STATUS_LABEL.get();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status: " + (Object)((Object)desc.getStatus()));
            }
        }
        this.writeLabelValue(AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), status, maxLabelWidth);
    }

    private void writeCurrentConnectionContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        int nConn;
        Message text = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED ? ((nConn = desc.getOpenConnections()) >= 0 ? Message.raw(String.valueOf(nConn), new Object[0]) : (!desc.isAuthenticated() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText())) : this.getNotAvailableBecauseServerIsDownText();
        this.writeLabelValue(AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), text, maxLabelWidth);
    }

    private void writeAdministrativeUserContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        Set<String> administrators = desc.getAdministrativeUsers();
        if (administrators.size() > 0) {
            TreeSet<String> ordered = new TreeSet<String>();
            ordered.addAll(administrators);
            String first = (String)ordered.iterator().next();
            this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), Message.raw(first, new Object[0]), maxLabelWidth);
            Iterator it = ordered.iterator();
            it.next();
            while (it.hasNext()) {
                this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), Message.raw((CharSequence)it.next(), new Object[0]), maxLabelWidth);
            }
        } else {
            Message text = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED ? (!desc.isAuthenticated() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText()) : this.getNotAvailableText();
            this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), text, maxLabelWidth);
        }
    }

    private void writeInstallPathContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        File path = desc.getInstallPath();
        this.writeLabelValue(AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), Message.raw(path.toString(), new Object[0]), maxLabelWidth);
    }

    private void writeVersionContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        String openDSVersion = desc.getOpenDSVersion();
        this.writeLabelValue(AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), Message.raw(openDSVersion, new Object[0]), maxLabelWidth);
    }

    private void writeJavaVersionContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        Message text;
        if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
            text = Message.raw(desc.getJavaVersion(), new Object[0]);
            if (text == null) {
                text = !desc.isAuthenticated() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText();
            }
        } else {
            text = this.getNotAvailableBecauseServerIsDownText();
        }
        this.writeLabelValue(AdminToolMessages.INFO_JAVA_VERSION_LABEL.get(), text, maxLabelWidth);
    }

    private void writeListenerContents(ServerStatusDescriptor desc) {
        Message title = AdminToolMessages.INFO_LISTENERS_TITLE.get();
        System.out.println(this.centerTitle(title));
        Set<ListenerDescriptor> listeners = desc.getListeners();
        if (listeners.size() == 0) {
            if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    System.out.println(Utils.wrap(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get()));
                } else {
                    System.out.println(Utils.wrap(AdminToolMessages.INFO_NO_LISTENERS_FOUND.get()));
                }
            } else {
                System.out.println(Utils.wrap(AdminToolMessages.INFO_NO_LISTENERS_FOUND.get()));
            }
        } else {
            ListenersTableModel listenersTableModel = new ListenersTableModel();
            listenersTableModel.setData(desc.getListeners());
            this.writeTableModel(listenersTableModel, desc);
        }
    }

    private void writeDatabaseContents(ServerStatusDescriptor desc) {
        Message title = AdminToolMessages.INFO_DATABASES_TITLE.get();
        System.out.println(this.centerTitle(title));
        Set<DatabaseDescriptor> databases = desc.getDatabases();
        if (databases.size() == 0) {
            if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    System.out.println(Utils.wrap(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get()));
                } else {
                    System.out.println(Utils.wrap(AdminToolMessages.INFO_NO_DBS_FOUND.get()));
                }
            } else {
                System.out.println(Utils.wrap(AdminToolMessages.INFO_NO_DBS_FOUND.get()));
            }
        } else {
            DatabasesTableModel databasesTableModel = new DatabasesTableModel(true);
            HashSet<BaseDNDescriptor> replicas = new HashSet<BaseDNDescriptor>();
            Set<DatabaseDescriptor> dbs = desc.getDatabases();
            for (DatabaseDescriptor db : dbs) {
                replicas.addAll(db.getBaseDns());
            }
            databasesTableModel.setData(replicas);
            this.writeDatabasesTableModel(databasesTableModel, desc);
        }
    }

    private void writeErrorContents(ServerStatusDescriptor desc) {
        Message errorMsg = desc.getErrorMessage();
        if (errorMsg != null) {
            System.out.println();
            System.out.println(Utils.wrap(errorMsg));
        }
    }

    private Message getNotAvailableBecauseServerIsDownText() {
        this.displayMustStartLegend = true;
        return AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_CLI_LABEL.get();
    }

    private Message getNotAvailableBecauseAuthenticationIsRequiredText() {
        this.displayMustAuthenticateLegend = true;
        return AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get();
    }

    private Message getNotAvailableText() {
        return QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get();
    }

    private void writeTableModel(TableModel tableModel, ServerStatusDescriptor desc) {
        int i;
        int j;
        int i2;
        int[] maxWidths = new int[tableModel.getColumnCount()];
        for (i2 = 0; i2 < maxWidths.length; ++i2) {
            maxWidths[i2] = tableModel.getColumnName(i2).length();
        }
        for (i2 = 0; i2 < tableModel.getRowCount(); ++i2) {
            for (int j2 = 0; j2 < maxWidths.length; ++j2) {
                Object v = tableModel.getValueAt(i2, j2);
                if (v == null) continue;
                if (v instanceof String) {
                    maxWidths[j2] = Math.max(maxWidths[j2], ((String)v).length());
                    continue;
                }
                if (v instanceof Integer) {
                    int nEntries = (Integer)v;
                    Message text = nEntries >= 0 ? Message.raw(String.valueOf(nEntries), new Object[0]) : (!desc.isAuthenticated() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText());
                    maxWidths[j2] = Math.max(maxWidths[j2], text.length());
                    continue;
                }
                throw new IllegalStateException("Unknown object type: " + v);
            }
        }
        int totalWidth = 0;
        for (int i3 = 0; i3 < maxWidths.length; ++i3) {
            if (i3 < maxWidths.length - 1) {
                int n = i3;
                maxWidths[n] = maxWidths[n] + 5;
            }
            totalWidth += maxWidths[i3];
        }
        MessageBuilder headerLine = new MessageBuilder();
        for (int i4 = 0; i4 < maxWidths.length; ++i4) {
            String header = tableModel.getColumnName(i4);
            headerLine.append(header);
            int extra = maxWidths[i4] - header.length();
            for (j = 0; j < extra; ++j) {
                headerLine.append(" ");
            }
        }
        System.out.println(Utils.wrap(headerLine.toMessage()));
        MessageBuilder t = new MessageBuilder();
        for (i = 0; i < headerLine.length(); ++i) {
            t.append("=");
        }
        System.out.println(Utils.wrap(t.toMessage()));
        for (i = 0; i < tableModel.getRowCount(); ++i) {
            MessageBuilder line = new MessageBuilder();
            for (j = 0; j < tableModel.getColumnCount(); ++j) {
                int extra = maxWidths[j];
                Object v = tableModel.getValueAt(i, j);
                if (v != null) {
                    if (v instanceof String) {
                        line.append((String)v);
                        extra -= ((String)v).length();
                    } else if (v instanceof Integer) {
                        int nEntries = (Integer)v;
                        if (nEntries >= 0) {
                            line.append(nEntries);
                        } else if (!desc.isAuthenticated()) {
                            line.append(this.getNotAvailableBecauseAuthenticationIsRequiredText());
                        } else {
                            line.append(this.getNotAvailableText());
                        }
                    } else {
                        throw new IllegalStateException("Unknown object type: " + v);
                    }
                }
                for (int k = 0; k < extra; ++k) {
                    line.append(" ");
                }
            }
            System.out.println(Utils.wrap(line.toMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDatabasesTableModel(DatabasesTableModel tableModel, ServerStatusDescriptor desc) {
        boolean isRunning = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED;
        int labelWidth = 0;
        Message[] labels = new Message[tableModel.getColumnCount()];
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Message header = i == 5 ? AdminToolMessages.INFO_AGE_OF_OLDEST_MISSING_CHANGE_COLUMN_CLI.get() : Message.raw(tableModel.getColumnName(i), new Object[0]);
            labels[i] = new MessageBuilder(header).append(":").toMessage();
            labelWidth = Math.max(labelWidth, labels[i].length());
        }
        Message replicatedLabel = AdminToolMessages.INFO_SUFFIX_REPLICATED_LABEL.get();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (i > 0) {
                System.out.println();
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                Message value;
                Object v = tableModel.getValueAt(i, j);
                if (v != null) {
                    if (v instanceof String) {
                        value = Message.raw((String)v, new Object[0]);
                    } else if (v instanceof Message) {
                        value = (Message)v;
                    } else {
                        if (!(v instanceof Integer)) throw new IllegalStateException("Unknown object type: " + v);
                        int nEntries = (Integer)v;
                        if (nEntries >= 0) {
                            value = Message.raw(String.valueOf(nEntries), new Object[0]);
                        } else {
                            if (!isRunning) {
                                value = this.getNotAvailableBecauseServerIsDownText();
                            }
                            value = !desc.isAuthenticated() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText();
                        }
                    }
                } else {
                    value = Message.EMPTY;
                }
                if (value.equals(this.getNotAvailableText())) {
                    if (!isRunning) {
                        value = this.getNotAvailableBecauseServerIsDownText();
                    }
                    if (!desc.isAuthenticated()) {
                        value = this.getNotAvailableBecauseAuthenticationIsRequiredText();
                    }
                }
                boolean doWrite = true;
                if (!(j != 4 && j != 5 || replicatedLabel.equals(tableModel.getValueAt(i, 3)))) {
                    doWrite = false;
                }
                if (!doWrite) continue;
                this.writeLabelValue(labels[j], value, labelWidth);
            }
        }
    }

    private void writeLabelValue(Message label, Message value, int maxLabelWidth) {
        MessageBuilder buf = new MessageBuilder();
        buf.append(label);
        int extra = maxLabelWidth - label.length();
        for (int i = 0; i < extra; ++i) {
            buf.append(" ");
        }
        buf.append(" ").append(String.valueOf(value));
        System.out.println(Utils.wrap(buf.toMessage()));
    }

    private Message centerTitle(Message text) {
        Message centered;
        if (text.length() <= Utils.getCommandLineMaxLineWidth() - 8) {
            MessageBuilder buf = new MessageBuilder();
            int extra = Math.min(10, (Utils.getCommandLineMaxLineWidth() - 8 - text.length()) / 2);
            for (int i = 0; i < extra; ++i) {
                buf.append(" ");
            }
            buf.append("--- " + text + " ---");
            centered = buf.toMessage();
        } else {
            centered = text;
        }
        return centered;
    }
}

