/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.guitools.statuspanel.ServerStatusDescriptor;
import org.opends.guitools.statuspanel.ServerStatusPooler;
import org.opends.guitools.statuspanel.event.ServerStatusChangeEvent;
import org.opends.guitools.statuspanel.event.ServerStatusChangeListener;
import org.opends.guitools.statuspanel.event.StatusPanelButtonListener;
import org.opends.guitools.statuspanel.ui.LoginDialog;
import org.opends.guitools.statuspanel.ui.StatusPanelDialog;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.MessageDescriptor;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ui.ProgressDialog;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.DirectoryServer;

public class StatusPanelController
implements ServerStatusChangeListener,
StatusPanelButtonListener {
    private LoginDialog loginDialog;
    private StatusPanelDialog controlPanelDialog;
    private ProgressDialog progressDialog;
    private ServerStatusPooler serverStatusPooler;
    private HtmlProgressMessageFormatter formatter = new HtmlProgressMessageFormatter();
    private boolean isStarting;
    private boolean isStopping;
    private boolean isRestarting;
    private boolean mustDisplayAuthenticateDialog;
    private ServerStatusDescriptor desc;
    private Message lastDetail;
    private Message lastSummary;
    private Thread progressUpdater;
    private ApplicationTrustManager trustManager;
    private static final int UPDATE_PERIOD = 500;
    private static final ConnectionProtocolPolicy CONNECTION_POLICY = ConnectionProtocolPolicy.USE_MOST_SECURE_AVAILABLE;

    public void initialize(String[] args) {
        DirectoryServer.bootstrapClient();
        this.initLookAndFeel();
        this.trustManager = new ApplicationTrustManager(null);
        this.getLoginDialog();
        this.getProgressDialog();
        this.serverStatusPooler = new ServerStatusPooler(CONNECTION_POLICY);
        this.serverStatusPooler.addServerStatusChangeListener(this);
        this.serverStatusPooler.startPooling();
        this.desc = this.serverStatusPooler.getLastDescriptor();
        while (this.desc == null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.desc = this.serverStatusPooler.getLastDescriptor();
        }
    }

    public void display() {
        this.getStatusPanelDialog().packAndShow();
        if (!this.isAuthenticated() && this.desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
            this.authenticateClicked();
        }
    }

    public void statusChanged(final ServerStatusChangeEvent ev) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getStatusPanelDialog().updateContents(ev.getStatusDescriptor());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusPanelController.this.getStatusPanelDialog().updateContents(ev.getStatusDescriptor());
                }
            });
        }
    }

    public void quitClicked() {
        this.serverStatusPooler.stopPooling();
        System.exit(0);
    }

    public void startClicked() {
        if (this.isStarting) {
            if (!this.getProgressDialog().isVisible()) {
                this.getProgressDialog().setVisible(true);
            }
        } else if (this.isStopping) {
            Thread.dumpStack();
        } else if (this.isRestarting) {
            Thread.dumpStack();
        } else {
            this.isStarting = true;
            this.lastDetail = null;
            this.getProgressDialog().setSummary(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()));
            this.getProgressDialog().setDetails(Message.EMPTY);
            this.serverStatusPooler.beginServerStart();
            this.getProgressDialog().setCloseButtonEnabled(false);
            this.getStatusPanelDialog().setStartButtonEnabled(false);
            this.getStatusPanelDialog().setStopButtonEnabled(false);
            this.getStatusPanelDialog().setRestartButtonEnabled(false);
            this.getStatusPanelDialog().setAuthenticateButtonEnabled(false);
            if (!this.getProgressDialog().isVisible()) {
                this.getProgressDialog().pack();
                Utilities.centerOnComponent(this.getProgressDialog(), this.getStatusPanelDialog());
                this.getProgressDialog().setVisible(true);
            }
            BackgroundTask task = new BackgroundTask(){

                public Object processBackgroundTask() {
                    if (StatusPanelController.this.progressUpdater == null) {
                        StatusPanelController.this.runProgressUpdater();
                    }
                    StatusPanelController.this.mustDisplayAuthenticateDialog = StatusPanelController.this.startServer() && !StatusPanelController.this.isAuthenticated();
                    StatusPanelController.this.serverStatusPooler.endServerStart();
                    return null;
                }

                public void backgroundTaskCompleted(Object value, Throwable t) {
                    if (t != null) {
                        t.printStackTrace();
                    }
                    StatusPanelController.this.getStatusPanelDialog().setStartButtonEnabled(true);
                    StatusPanelController.this.getStatusPanelDialog().setStopButtonEnabled(true);
                    StatusPanelController.this.getStatusPanelDialog().setRestartButtonEnabled(true);
                    StatusPanelController.this.getStatusPanelDialog().setAuthenticateButtonEnabled(!StatusPanelController.this.isAuthenticated());
                    StatusPanelController.this.getProgressDialog().setCloseButtonEnabled(true);
                    StatusPanelController.this.isStarting = false;
                }
            };
            task.startBackgroundTask();
        }
    }

    public void stopClicked() {
        if (this.isStopping) {
            if (!this.getProgressDialog().isVisible()) {
                this.getProgressDialog().setVisible(true);
            }
        } else if (this.isStarting) {
            Thread.dumpStack();
        } else if (this.isRestarting) {
            Thread.dumpStack();
        } else {
            boolean stopServer = this.confirmStop();
            if (stopServer) {
                this.isStopping = true;
                this.lastDetail = null;
                this.getProgressDialog().setSummary(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()));
                this.getProgressDialog().setDetails(Message.EMPTY);
                this.serverStatusPooler.beginServerStop();
                this.getProgressDialog().setCloseButtonEnabled(false);
                this.getStatusPanelDialog().setStartButtonEnabled(false);
                this.getStatusPanelDialog().setStopButtonEnabled(false);
                this.getStatusPanelDialog().setRestartButtonEnabled(false);
                this.getStatusPanelDialog().setAuthenticateButtonEnabled(false);
                if (!this.getProgressDialog().isVisible()) {
                    this.getProgressDialog().pack();
                    Utilities.centerOnComponent(this.getProgressDialog(), this.getStatusPanelDialog());
                    this.getProgressDialog().setVisible(true);
                }
                BackgroundTask task = new BackgroundTask(){

                    public Object processBackgroundTask() {
                        if (StatusPanelController.this.progressUpdater == null) {
                            StatusPanelController.this.runProgressUpdater();
                        }
                        StatusPanelController.this.stopServer();
                        StatusPanelController.this.serverStatusPooler.endServerStop();
                        StatusPanelController.this.mustDisplayAuthenticateDialog = false;
                        return null;
                    }

                    public void backgroundTaskCompleted(Object value, Throwable t) {
                        if (t != null) {
                            t.printStackTrace();
                        }
                        StatusPanelController.this.getStatusPanelDialog().setStartButtonEnabled(true);
                        StatusPanelController.this.getStatusPanelDialog().setStopButtonEnabled(true);
                        StatusPanelController.this.getStatusPanelDialog().setRestartButtonEnabled(true);
                        StatusPanelController.this.getStatusPanelDialog().setAuthenticateButtonEnabled(false);
                        StatusPanelController.this.getProgressDialog().setCloseButtonEnabled(true);
                        StatusPanelController.this.isStopping = false;
                    }
                };
                task.startBackgroundTask();
            }
        }
    }

    public void restartClicked() {
        if (this.isRestarting) {
            if (!this.getProgressDialog().isVisible()) {
                this.getProgressDialog().setVisible(true);
            }
        } else if (this.isStopping) {
            Thread.dumpStack();
        } else if (this.isStarting) {
            Thread.dumpStack();
        } else {
            boolean restartServer = this.confirmRestart();
            if (restartServer) {
                this.isRestarting = true;
                this.lastDetail = null;
                this.getProgressDialog().setSummary(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()));
                this.getProgressDialog().setDetails(Message.EMPTY);
                this.serverStatusPooler.beginServerStop();
                this.getProgressDialog().setCloseButtonEnabled(false);
                this.getStatusPanelDialog().setStartButtonEnabled(false);
                this.getStatusPanelDialog().setStopButtonEnabled(false);
                this.getStatusPanelDialog().setRestartButtonEnabled(false);
                this.getStatusPanelDialog().setAuthenticateButtonEnabled(false);
                if (!this.getProgressDialog().isVisible()) {
                    this.getProgressDialog().pack();
                    Utilities.centerOnComponent(this.getProgressDialog(), this.getStatusPanelDialog());
                    this.getProgressDialog().setVisible(true);
                }
                BackgroundTask task = new BackgroundTask(){

                    public Object processBackgroundTask() {
                        if (StatusPanelController.this.progressUpdater == null) {
                            StatusPanelController.this.runProgressUpdater();
                        }
                        if (StatusPanelController.this.stopServer()) {
                            StatusPanelController.this.serverStatusPooler.endServerStop();
                            StatusPanelController.this.serverStatusPooler.beginServerStart();
                            StatusPanelController.this.mustDisplayAuthenticateDialog = StatusPanelController.this.startServer() && !StatusPanelController.this.isAuthenticated();
                            StatusPanelController.this.serverStatusPooler.endServerStart();
                        } else {
                            StatusPanelController.this.serverStatusPooler.endServerStop();
                            StatusPanelController.this.mustDisplayAuthenticateDialog = false;
                        }
                        return null;
                    }

                    public void backgroundTaskCompleted(Object value, Throwable t) {
                        if (t != null) {
                            t.printStackTrace();
                        }
                        StatusPanelController.this.getStatusPanelDialog().setStartButtonEnabled(true);
                        StatusPanelController.this.getStatusPanelDialog().setStopButtonEnabled(true);
                        StatusPanelController.this.getStatusPanelDialog().setRestartButtonEnabled(true);
                        StatusPanelController.this.getStatusPanelDialog().setAuthenticateButtonEnabled(!StatusPanelController.this.isAuthenticated());
                        StatusPanelController.this.getProgressDialog().setCloseButtonEnabled(true);
                        StatusPanelController.this.isRestarting = false;
                    }
                };
                task.startBackgroundTask();
            }
        }
    }

    public void authenticateClicked() {
        this.getLoginDialog().pack();
        Utilities.centerOnComponent(this.getLoginDialog(), this.getStatusPanelDialog());
        this.getLoginDialog().setVisible(true);
        if (!this.getLoginDialog().isCancelled()) {
            try {
                this.serverStatusPooler.setAuthentication(this.getLoginDialog().getDirectoryManagerDn(), this.getLoginDialog().getDirectoryManagerPwd(), this.trustManager);
            }
            catch (ConfigException ce) {
                Utilities.displayError(this.getLoginDialog(), ce.getMessageObject(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                this.getLoginDialog().toFront();
            }
        }
    }

    private void initLookAndFeel() {
        UIFactory.initialize();
    }

    private LoginDialog getLoginDialog() {
        if (this.loginDialog == null) {
            this.loginDialog = new LoginDialog(this.getStatusPanelDialog(), this.trustManager, CONNECTION_POLICY);
            this.loginDialog.setModal(true);
        }
        return this.loginDialog;
    }

    private ProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog(this.getStatusPanelDialog());
            this.progressDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent ev) {
                    if (StatusPanelController.this.mustDisplayAuthenticateDialog) {
                        StatusPanelController.this.mustDisplayAuthenticateDialog = false;
                        StatusPanelController.this.authenticateClicked();
                    }
                }
            });
        }
        return this.progressDialog;
    }

    private StatusPanelDialog getStatusPanelDialog() {
        if (this.controlPanelDialog == null) {
            this.controlPanelDialog = new StatusPanelDialog();
            this.controlPanelDialog.addButtonListener(this);
        }
        return this.controlPanelDialog;
    }

    protected boolean startServer() {
        boolean started;
        block11: {
            started = false;
            if (this.isRestarting) {
                this.updateProgress(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()), this.getTaskSeparator());
            }
            this.updateProgress(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()), this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_PROGRESS_STARTING.get()));
            ArrayList<String> argList = new ArrayList<String>();
            Installation installation = Installation.getLocal();
            argList.add(Utils.getPath(installation.getServerStartCommandFile()));
            String[] args = new String[argList.size()];
            argList.toArray(args);
            ProcessBuilder pb = new ProcessBuilder(args);
            Map<String, String> env = pb.environment();
            env.put("JAVA_HOME", System.getProperty("java.home"));
            env.remove("JAVA_BIN");
            try {
                Process process = pb.start();
                BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
                new ProgressReader(err, true, true);
                new ProgressReader(out, false, true);
                int returnValue = process.waitFor();
                if (returnValue == 0) {
                    boolean running = false;
                    for (int i = 0; i < 5 && !running; ++i) {
                        running = Installation.getLocal().getStatus().isServerRunning();
                    }
                    if (!running) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (!running) {
                        this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_START_ERROR.get()), this.getFormattedError(AdminToolMessages.ERR_STARTING_SERVER_GENERIC.get(), true));
                    } else {
                        this.updateProgress(this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_START_SUCCESS.get()), Message.EMPTY);
                        started = true;
                    }
                    break block11;
                }
                Message msg = QuickSetupMessages.INFO_ERROR_STARTING_SERVER_CODE.get(String.valueOf(returnValue));
                this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_START_ERROR.get()), msg);
            }
            catch (IOException ioe) {
                Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STARTING_SERVER.get(), ioe);
                this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_START_ERROR.get()), msg);
            }
            catch (InterruptedException ie) {
                Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STARTING_SERVER.get(), ie);
                this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_START_ERROR.get()), msg);
            }
        }
        return started;
    }

    private boolean stopServer() {
        boolean stopped = false;
        this.updateProgress(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()), this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_PROGRESS_STOPPING.get()));
        ArrayList<String> argList = new ArrayList<String>();
        Installation installation = Installation.getLocal();
        argList.add(Utils.getPath(installation.getServerStopCommandFile()));
        String[] args = new String[argList.size()];
        argList.toArray(args);
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put("JAVA_HOME", System.getProperty("java.home"));
        env.remove("JAVA_BIN");
        try {
            Process process = pb.start();
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new ProgressReader(err, true, false);
            new ProgressReader(out, false, false);
            int returnValue = process.waitFor();
            int clientSideError = 91;
            if ((returnValue == clientSideError || returnValue == 0) && Utils.isWindows()) {
                int nTries = 10;
                for (int i = 0; i < nTries && !stopped; ++i) {
                    boolean bl = stopped = !Installation.getLocal().getStatus().isServerRunning();
                    if (stopped) continue;
                    Message msg = new MessageBuilder(this.getFormattedLog(QuickSetupMessages.INFO_PROGRESS_SERVER_WAITING_TO_STOP.get())).append(this.getLineBreak()).toMessage();
                    this.updateProgress(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()), msg);
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!stopped) {
                    returnValue = -1;
                }
            }
            if (returnValue == clientSideError) {
                Message msg = new MessageBuilder(this.getLineBreak()).append(this.getFormattedLog(QuickSetupMessages.INFO_PROGRESS_SERVER_ALREADY_STOPPED.get())).append(this.getLineBreak()).toMessage();
                if (!this.isRestarting) {
                    this.updateProgress(this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_STOP_SUCCESS.get()), msg);
                } else {
                    this.updateProgress(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOP_SUCCESS.get()), msg);
                }
                stopped = true;
            } else if (returnValue != 0) {
                Message msg = QuickSetupMessages.INFO_ERROR_STOPPING_SERVER_CODE.get(String.valueOf(returnValue));
                this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_STOP_ERROR.get()), msg);
            } else {
                Message msg = this.getFormattedLog(QuickSetupMessages.INFO_PROGRESS_SERVER_STOPPED.get());
                if (!this.isRestarting) {
                    this.updateProgress(this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_STOP_SUCCESS.get()), msg);
                } else {
                    this.updateProgress(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOP_SUCCESS.get()), msg);
                }
                stopped = true;
            }
        }
        catch (IOException ioe) {
            Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STOPPING_SERVER.get(), ioe);
            this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_STOP_ERROR.get()), msg);
        }
        catch (InterruptedException ie) {
            Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_STOPPING_SERVER.get(), ie);
            this.updateProgress(this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_STOP_ERROR.get()), msg);
        }
        return stopped;
    }

    private synchronized void updateProgress(Message summary, Message newDetail) {
        this.lastDetail = this.lastDetail == null ? newDetail : new MessageBuilder(this.lastDetail).append(newDetail).toMessage();
        this.lastSummary = summary;
    }

    private void runProgressUpdater() {
        this.progressUpdater = new Thread(){

            public void run() {
                try {
                    Message lastDisplayedSummary = null;
                    Message lastDisplayedDetail = null;
                    while (true) {
                        if (StatusPanelController.this.lastSummary != null && StatusPanelController.this.lastSummary != lastDisplayedSummary) {
                            lastDisplayedSummary = StatusPanelController.this.lastSummary;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    StatusPanelController.this.getProgressDialog().setSummary(StatusPanelController.this.lastSummary);
                                }
                            });
                        }
                        if (StatusPanelController.this.lastDetail != null && StatusPanelController.this.lastDetail != lastDisplayedDetail) {
                            lastDisplayedDetail = StatusPanelController.this.lastDetail;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    StatusPanelController.this.getProgressDialog().setDetails(StatusPanelController.this.lastDetail);
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
            }
        };
        this.progressUpdater.start();
    }

    private Message getFormattedSummary(Message text) {
        return this.formatter.getFormattedSummary(text);
    }

    private Message getFormattedSuccess(Message text) {
        return this.formatter.getFormattedSuccess(text);
    }

    private Message getFormattedError(Message text) {
        return this.formatter.getFormattedError(text, false);
    }

    private Message getFormattedError(Message text, boolean applyMargin) {
        return this.formatter.getFormattedError(text, applyMargin);
    }

    private Message getFormattedLogError(Message text) {
        return this.formatter.getFormattedLogError(text);
    }

    private Message getFormattedLog(Message text) {
        return this.formatter.getFormattedLog(text);
    }

    private Message getLineBreak() {
        return this.formatter.getLineBreak();
    }

    private Message getTaskSeparator() {
        return this.formatter.getTaskSeparator();
    }

    private Message getFormattedProgressWithLineBreak(Message text) {
        return new MessageBuilder(text).append(this.getLineBreak()).toMessage();
    }

    private boolean confirmStop() {
        return Utilities.displayConfirmation(this.getStatusPanelDialog(), AdminToolMessages.INFO_CONFIRM_STOP_MESSAGE.get(), AdminToolMessages.INFO_CONFIRM_STOP_TITLE.get());
    }

    private boolean confirmRestart() {
        return Utilities.displayConfirmation(this.getStatusPanelDialog(), AdminToolMessages.INFO_CONFIRM_RESTART_MESSAGE.get(), AdminToolMessages.INFO_CONFIRM_RESTART_TITLE.get());
    }

    private boolean isAuthenticated() {
        return this.serverStatusPooler.isAuthenticated();
    }

    private class ProgressReader {
        private boolean isFirstLine;
        private Message errorMsg;

        public ProgressReader(final BufferedReader reader, final boolean isError, final boolean isStart) {
            final MessageDescriptor.Arg0 errorTag = isError ? QuickSetupMessages.INFO_ERROR_READING_ERROROUTPUT : QuickSetupMessages.INFO_ERROR_READING_OUTPUT;
            this.isFirstLine = true;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            MessageBuilder buf = new MessageBuilder();
                            if (!ProgressReader.this.isFirstLine) {
                                buf.append(StatusPanelController.this.formatter.getLineBreak());
                            }
                            if (isError) {
                                buf.append(StatusPanelController.this.getFormattedLogError(Message.raw(line, new Object[0])));
                            } else {
                                buf.append(StatusPanelController.this.getFormattedLog(Message.raw(line, new Object[0])));
                            }
                            Message summary = isStart ? StatusPanelController.this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()) : StatusPanelController.this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get());
                            StatusPanelController.this.updateProgress(summary, buf.toMessage());
                            ProgressReader.this.isFirstLine = false;
                            line = reader.readLine();
                        }
                    }
                    catch (IOException ioe) {
                        ProgressReader.this.errorMsg = Utils.getThrowableMsg(errorTag.get(), ioe);
                    }
                    catch (Throwable t) {
                        ProgressReader.this.errorMsg = Utils.getThrowableMsg(errorTag.get(), t);
                    }
                }
            });
            t.start();
        }

        public Message getErrorMessage() {
            return this.errorMsg;
        }
    }
}

