/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.guitools.statuspanel.SplashScreen;
import org.opends.guitools.statuspanel.StatusLog;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;

public class StatusPanelLauncher {
    public static final String LOG_FILE_PREFIX = "opends-status-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private static final Logger LOG = Logger.getLogger(StatusPanelLauncher.class.getName());

    public static void main(String[] args) {
        try {
            StatusLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX));
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        boolean printUsage = false;
        boolean printVersion = false;
        if (args != null && args.length > 4) {
            printUsage = true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-H") || args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-?")) {
                printUsage = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-V") && !args[i].equalsIgnoreCase("--version")) continue;
            printVersion = true;
        }
        if (printVersion) {
            try {
                DirectoryServer.printVersion(System.out);
            }
            catch (IOException e) {
                // empty catch block
            }
            System.exit(1);
        } else if (printUsage) {
            StatusPanelLauncher.printUsage(System.out);
            System.exit(1);
        } else {
            int exitCode = StatusPanelLauncher.launchGuiStatusPanel(args);
            if (exitCode != 0) {
                String logFileName = null;
                if (StatusLog.getLogFile() != null) {
                    logFileName = StatusLog.getLogFile().toString();
                }
                if (logFileName != null) {
                    System.err.println(StaticUtils.wrapText(AdminToolMessages.ERR_STATUS_PANEL_LAUNCHER_GUI_LAUNCH_FAILED_DETAILS.get(logFileName), Utils.getCommandLineMaxLineWidth()));
                } else {
                    System.err.println(StaticUtils.wrapText(AdminToolMessages.ERR_STATUS_PANEL_LAUNCHER_GUI_LAUNCH_FAILED.get(), Utils.getCommandLineMaxLineWidth()));
                }
                System.exit(exitCode);
            }
        }
    }

    private static int launchGuiStatusPanel(final String[] args) {
        final int[] returnValue = new int[]{-1};
        Thread t = new Thread(new Runnable(){

            public void run() {
                block4: {
                    try {
                        Utils.setMacOSXMenuBar(AdminToolMessages.INFO_STATUSPANEL_DIALOG_TITLE.get());
                        SplashScreen.main(args);
                        returnValue[0] = 0;
                    }
                    catch (Throwable t) {
                        if (!StatusLog.isInitialized()) break block4;
                        LOG.log(Level.WARNING, "Error launching GUI: " + t);
                        StringBuilder buf = new StringBuilder();
                        while (t != null) {
                            StackTraceElement[] stack = t.getStackTrace();
                            for (int i = 0; i < stack.length; ++i) {
                                buf.append(stack[i].toString() + "\n");
                            }
                            if ((t = t.getCause()) == null) continue;
                            buf.append("Root cause:\n");
                        }
                        LOG.log(Level.WARNING, buf.toString());
                    }
                }
            }
        });
        PrintStream printStream = System.err;
        System.setErr(new EmptyPrintStream());
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        System.setErr(printStream);
        return returnValue[0];
    }

    private static void printUsage(PrintStream stream) {
        ArgumentParser argParser = new ArgumentParser(StatusPanelLauncher.class.getName(), AdminToolMessages.INFO_STATUS_PANEL_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        String scriptName = Utils.isWindows() ? "status-panel.bat" : "status-panel";
        System.setProperty("org.opends.server.scriptName", scriptName);
        try {
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
            String msg = argParser.getUsage();
            stream.println(msg);
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }

    static class EmptyPrintStream
    extends PrintStream {
        public EmptyPrintStream() {
            super(new ByteArrayOutputStream(), true);
        }

        public void println(String msg) {
        }
    }
}

