/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConfigFromFile;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginDialog
extends JDialog {
    private static final long serialVersionUID = 9049606381601152500L;
    private JFrame parent;
    private JLabel lDn;
    private JLabel lPwd;
    private JTextField tfDn;
    private JTextField tfPwd;
    private JButton cancelButton;
    private JButton okButton;
    private boolean isCancelled = true;
    private ConfigFromFile conf;
    private ApplicationTrustManager trustManager;
    private ConnectionProtocolPolicy policy;
    private String usedUrl;
    private static final Logger LOG = Logger.getLogger(LoginDialog.class.getName());

    public LoginDialog(JFrame parent, ApplicationTrustManager trustManager, ConnectionProtocolPolicy policy) {
        super(parent);
        this.setTitle(AdminToolMessages.INFO_LOGIN_DIALOG_TITLE.get().toString());
        this.parent = parent;
        this.getContentPane().add(this.createPanel());
        if (trustManager == null) {
            throw new IllegalArgumentException("The trustmanager cannot be null.");
        }
        this.trustManager = trustManager;
        this.policy = policy;
        this.setPreferredSize(new Dimension(500, 250));
        this.addComponentListener(new MinimumSizeComponentListener(this, 500, 250));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.cancelButton.setEnabled(true);
        this.okButton.setEnabled(true);
        if (visible) {
            this.tfPwd.setText("");
            this.tfPwd.requestFocusInWindow();
            UIFactory.setTextStyle(this.lDn, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            UIFactory.setTextStyle(this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            this.getRootPane().setDefaultButton(this.okButton);
        }
        super.setVisible(visible);
    }

    public String getDirectoryManagerDn() {
        return this.tfDn.getText();
    }

    public String getDirectoryManagerPwd() {
        return this.tfPwd.getText();
    }

    private JPanel createPanel() {
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)UIFactory.makeJLabel(UIFactory.IconType.INFORMATION_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        Message msg = AdminToolMessages.INFO_LOGIN_DIALOG_MSG.get();
        JEditorPane textPane = UIFactory.makeHtmlPane(msg, UIFactory.INSTRUCTIONS_FONT);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        p1.add((Component)textPane, gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setOpaque(false);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.lDn = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_LOGIN_DN_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lDn, gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        this.tfDn = UIFactory.makeJTextField(Message.raw(this.getProposedAdministrativeUserDn(), new Object[0]), AdminToolMessages.INFO_LOGIN_DN_TOOLTIP.get(), 20, UIFactory.TextStyle.TEXTFIELD);
        p2.add((Component)this.tfDn, gbc);
        gbc.insets.top = 0;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.lPwd = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_LOGIN_PWD_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lPwd, gbc);
        gbc.insets.left = 10;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        JPanel p3 = new JPanel(new GridBagLayout());
        p3.setOpaque(false);
        this.tfPwd = UIFactory.makeJPasswordField(null, AdminToolMessages.INFO_LOGIN_PWD_TOOLTIP.get(), 15, UIFactory.TextStyle.PASSWORD_FIELD);
        p2.add((Component)p3, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        p3.add((Component)this.tfPwd, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p3.add(Box.createHorizontalGlue(), gbc);
        gbc.fill = 2;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 0;
        p1.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        p1.add((Component)p2, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 3;
        p1.add(Box.createVerticalGlue(), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 3;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.okButton = UIFactory.makeJButton(QuickSetupMessages.INFO_OK_BUTTON_LABEL.get(), AdminToolMessages.INFO_LOGIN_OK_BUTTON_TOOLTIP.get());
        buttonPanel.add((Component)this.okButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LoginDialog.this.okClicked();
            }
        });
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        this.cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), AdminToolMessages.INFO_LOGIN_CANCEL_BUTTON_TOOLTIP.get());
        buttonPanel.add((Component)this.cancelButton, gbc);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LoginDialog.this.cancelClicked();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        p.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)buttonPanel, gbc);
        return p;
    }

    private String getProposedAdministrativeUserDn() {
        Set<String> dns = this.getAdministrativeUserDns();
        String dn = dns.size() > 0 ? dns.iterator().next() : null;
        return dn;
    }

    private void cancelClicked() {
        this.isCancelled = true;
        this.dispose();
    }

    private void okClicked() {
        BackgroundTask worker = new BackgroundTask(){

            public Object processBackgroundTask() throws NamingException, ConfigException {
                Boolean isServerRunning = Boolean.TRUE;
                InitialContext ctx = null;
                try {
                    String ldapUrl = LoginDialog.this.getConfig().getLDAPURL();
                    String startTlsUrl = LoginDialog.this.getConfig().getStartTLSURL();
                    String ldapsUrl = LoginDialog.this.getConfig().getLDAPSURL();
                    switch (LoginDialog.this.policy) {
                        case USE_STARTTLS: {
                            if (startTlsUrl != null) {
                                LoginDialog.this.usedUrl = startTlsUrl;
                                ctx = Utils.createStartTLSContext(startTlsUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null, LoginDialog.this.getTrustManager(), null);
                                break;
                            }
                            throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                        }
                        case USE_LDAPS: {
                            if (ldapsUrl != null) {
                                LoginDialog.this.usedUrl = ldapsUrl;
                                ctx = Utils.createLdapsContext(ldapsUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null, LoginDialog.this.getTrustManager());
                                break;
                            }
                            throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                        }
                        case USE_LDAP: {
                            if (ldapUrl != null) {
                                LoginDialog.this.usedUrl = ldapUrl;
                                ctx = Utils.createLdapContext(ldapUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null);
                                break;
                            }
                            throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                        }
                        case USE_MOST_SECURE_AVAILABLE: {
                            if (ldapsUrl != null) {
                                LoginDialog.this.usedUrl = ldapsUrl;
                                ctx = Utils.createLdapsContext(ldapsUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null, LoginDialog.this.getTrustManager());
                                break;
                            }
                            if (startTlsUrl != null) {
                                LoginDialog.this.usedUrl = startTlsUrl;
                                ctx = Utils.createStartTLSContext(startTlsUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null, LoginDialog.this.getTrustManager(), null);
                                break;
                            }
                            if (ldapUrl != null) {
                                LoginDialog.this.usedUrl = ldapUrl;
                                ctx = Utils.createLdapContext(ldapUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null);
                                break;
                            }
                            throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                        }
                        case USE_LESS_SECURE_AVAILABLE: {
                            if (ldapUrl != null) {
                                LoginDialog.this.usedUrl = ldapUrl;
                                ctx = Utils.createLdapContext(ldapUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null);
                                break;
                            }
                            if (ldapsUrl != null) {
                                LoginDialog.this.usedUrl = ldapsUrl;
                                ctx = Utils.createLdapsContext(ldapsUrl, LoginDialog.this.tfDn.getText(), LoginDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null, LoginDialog.this.getTrustManager());
                                break;
                            }
                            throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                        }
                        default: {
                            throw new IllegalStateException("Unknown connection policy: " + (Object)((Object)LoginDialog.this.policy));
                        }
                    }
                    SearchControls searchControls = new SearchControls();
                    searchControls.setCountLimit(1L);
                    searchControls.setSearchScope(0);
                    searchControls.setReturningAttributes(new String[]{"dn"});
                    ((InitialDirContext)ctx).search("cn=config", "objectclass=*", searchControls);
                }
                catch (NamingException ne) {
                    if (LoginDialog.this.isServerRunning()) {
                        throw ne;
                    }
                    isServerRunning = Boolean.FALSE;
                }
                catch (ConfigException e) {
                    throw e;
                }
                catch (IllegalStateException ise) {
                    throw ise;
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unexpected throwable.", t);
                }
                finally {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                return isServerRunning;
            }

            public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
                if (throwable != null) {
                    LOG.log(Level.INFO, "Error connecting: " + throwable, throwable);
                    if (Utils.isCertificateException(throwable)) {
                        ApplicationTrustManager.Cause cause = LoginDialog.this.trustManager.getLastRefusedCause();
                        LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                        UserDataCertificateException.Type excType = null;
                        if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
                            excType = UserDataCertificateException.Type.NOT_TRUSTED;
                        } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
                            excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
                        } else {
                            Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), throwable);
                            LoginDialog.this.displayError(msg, QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                        if (excType != null) {
                            int p;
                            String h;
                            try {
                                URI uri = new URI(LoginDialog.this.usedUrl);
                                h = uri.getHost();
                                p = uri.getPort();
                            }
                            catch (Throwable t) {
                                LOG.log(Level.WARNING, "Error parsing ldap url of ldap url.", t);
                                h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                                p = -1;
                            }
                            UserDataCertificateException udce = new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), throwable, h, p, LoginDialog.this.getTrustManager().getLastRefusedChain(), LoginDialog.this.getTrustManager().getLastRefusedAuthType(), excType);
                            LoginDialog.this.handleCertificateException(udce);
                        }
                    } else if (throwable instanceof NamingException) {
                        boolean dnInvalid = false;
                        boolean pwdInvalid = false;
                        String dn = LoginDialog.this.tfDn.getText();
                        ArrayList<Message> possibleCauses = new ArrayList<Message>();
                        if ("".equals(dn.trim())) {
                            dnInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_EMPTY_DIRECTORY_MANAGER_DN.get());
                        } else if (!Utils.isDn(dn)) {
                            dnInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_DN.get());
                        } else {
                            boolean found = false;
                            Iterator it = LoginDialog.this.getAdministrativeUserDns().iterator();
                            while (it.hasNext() && !found) {
                                found = Utils.areDnsEqual(dn, (String)it.next());
                            }
                            if (!found) {
                                dnInvalid = true;
                                possibleCauses.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_IN_CONFIG.get());
                            }
                        }
                        if ("".equals(LoginDialog.this.tfPwd.getText())) {
                            pwdInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_EMPTY_PWD.get());
                        }
                        if (dnInvalid) {
                            UIFactory.setTextStyle(LoginDialog.this.lDn, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(LoginDialog.this.lDn, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                            pwdInvalid = true;
                        }
                        if (pwdInvalid) {
                            UIFactory.setTextStyle(LoginDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(LoginDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                        }
                        if (possibleCauses.size() > 0) {
                            LoginDialog.this.displayError(AdminToolMessages.ERR_CANNOT_CONNECT_TO_LOGIN_WITH_CAUSE.get(Utils.getMessageFromCollection(possibleCauses, "\n")), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        } else {
                            LoginDialog.this.displayError(AdminToolMessages.ERR_CANNOT_CONNECT_WITH_ADS_CREDENTIALS_WITHOUT_CAUSE.get(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                    } else if (throwable instanceof ConfigException) {
                        LoginDialog.this.displayError(((ConfigException)throwable).getMessageObject(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    } else {
                        throwable.printStackTrace();
                        LoginDialog.this.displayError(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    }
                    LoginDialog.this.cancelButton.setEnabled(true);
                    LoginDialog.this.okButton.setEnabled(true);
                } else {
                    if (Boolean.FALSE.equals(returnValue)) {
                        LoginDialog.this.displayInformationMessage(AdminToolMessages.INFO_LOGIN_DIALOG_SERVER_NOT_RUNNING_MSG.get(), AdminToolMessages.INFO_LOGIN_DIALOG_SERVER_NOT_RUNNING_TITLE.get());
                    }
                    UIFactory.setTextStyle(LoginDialog.this.lDn, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                    UIFactory.setTextStyle(LoginDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                    LoginDialog.this.isCancelled = false;
                    LoginDialog.this.cancelButton.setEnabled(true);
                    LoginDialog.this.okButton.setEnabled(true);
                    LoginDialog.this.dispose();
                }
            }
        };
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        worker.startBackgroundTask();
    }

    private void displayError(Message msg, Message title) {
        Utilities.displayError(this.parent, msg, title);
        this.toFront();
    }

    private void displayInformationMessage(Message msg, Message title) {
        Utilities.displayInformationMessage(this.parent, msg, title);
        this.toFront();
    }

    private Set<String> getAdministrativeUserDns() {
        return this.getConfig().getAdministrativeUsers();
    }

    private boolean isServerRunning() {
        return Installation.getLocal().getStatus().isServerRunning();
    }

    private ConfigFromFile getConfig() {
        if (this.conf == null) {
            this.conf = new ConfigFromFile();
            this.conf.readConfiguration();
        }
        return this.conf;
    }

    private ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    private void handleCertificateException(UserDataCertificateException ce) {
        CertificateDialog dlg = new CertificateDialog(this.parent, ce);
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.isAccepted()) {
            X509Certificate[] chain = ce.getChain();
            String authType = ce.getAuthType();
            String host = ce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                this.getTrustManager().acceptCertificate(chain, authType, host);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoginDialog.this.okClicked();
                    }
                });
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            LoginDialog dlg = new LoginDialog(new JFrame(), new ApplicationTrustManager(null), ConnectionProtocolPolicy.USE_MOST_SECURE_AVAILABLE);
            dlg.pack();
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

