/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.File;
import java.util.logging.Logger;
import org.opends.guitools.uninstaller.UninstallLauncher;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;

public class UninstallGuiLauncher
extends UninstallLauncher {
    public static final String LOG_FILE_PREFIX = "opends-uninstall-cli-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private static final Logger LOG = Logger.getLogger(UninstallGuiLauncher.class.getName());
    private ArgumentParser argParser;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX), "org.opends.guitools.uninstaller");
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        new UninstallGuiLauncher(args).launch();
    }

    public UninstallGuiLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "uninstall-gui.bat" : "uninstall-gui";
        System.setProperty("org.opends.server.scriptName", scriptName);
    }

    protected void initializeParser() {
        this.argParser = new ArgumentParser(this.getClass().getName(), AdminToolMessages.INFO_UNINSTALL_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            BooleanArgument showUsageArg = new BooleanArgument("showUsage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
            this.argParser.addArgument(showUsageArg);
            this.argParser.setUsageArgument(showUsageArg);
            this.argParser.parseArguments(this.args);
        }
        catch (ArgumentException ae) {
            System.err.println(StaticUtils.wrapText(ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage()), Utils.getCommandLineMaxLineWidth()));
        }
    }

    public void launch() {
        if (this.shouldPrintVersion()) {
            if (!this.argParser.usageOrVersionDisplayed()) {
                this.printVersion();
            }
            System.exit(ApplicationReturnCode.ReturnCode.PRINT_VERSION.getReturnCode());
        } else if (this.shouldPrintUsage()) {
            if (!this.argParser.usageOrVersionDisplayed()) {
                this.printUsage(false);
            }
            System.exit(ApplicationReturnCode.ReturnCode.SUCCESSFUL.getReturnCode());
        } else {
            this.willLaunchGui();
            int exitCode = this.launchGui(this.args);
            if (exitCode != 0) {
                File logFile = QuickSetupLog.getLogFile();
                if (logFile != null) {
                    this.guiLaunchFailed(logFile.toString());
                } else {
                    this.guiLaunchFailed(null);
                }
                System.exit(exitCode);
            }
        }
    }

    protected boolean isCli() {
        return false;
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }
}

