/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.File;
import java.util.logging.Logger;
import org.opends.guitools.uninstaller.Uninstaller;
import org.opends.guitools.uninstaller.UninstallerArgumentParser;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;

public class UninstallLauncher
extends Launcher {
    public static final String LOG_FILE_PREFIX = "opends-uninstall-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private static final Logger LOG = Logger.getLogger(UninstallLauncher.class.getName());
    private UninstallerArgumentParser argParser;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX), "org.opends.guitools.uninstaller");
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        new UninstallLauncher(args).launch();
    }

    public UninstallLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "uninstall.bat" : "uninstall";
        System.setProperty("org.opends.server.scriptName", scriptName);
        this.initializeParser();
    }

    protected void initializeParser() {
        this.argParser = new UninstallerArgumentParser(this.getClass().getName(), AdminToolMessages.INFO_UNINSTALL_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            this.argParser.initializeGlobalArguments(System.err);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, Utils.getCommandLineMaxLineWidth()));
        }
    }

    protected boolean isCli() {
        return true;
    }

    protected void guiLaunchFailed(String logFilePath) {
        if (logFilePath != null) {
            System.err.println(AdminToolMessages.ERR_UNINSTALL_LAUNCHER_GUI_LAUNCHED_FAILED_DETAILS.get(logFilePath));
        } else {
            System.err.println(AdminToolMessages.ERR_UNINSTALL_LAUNCHER_GUI_LAUNCHED_FAILED.get());
        }
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }

    protected void willLaunchGui() {
        System.out.println(AdminToolMessages.INFO_UNINSTALL_LAUNCHER_LAUNCHING_GUI.get());
        System.setProperty("org.opends.quicksetup.Application.class", Uninstaller.class.getName());
    }

    protected CliApplication createCliApplication() {
        return new Uninstaller();
    }

    protected Message getFrameTitle() {
        return AdminToolMessages.INFO_FRAME_UNINSTALL_TITLE.get();
    }
}

