/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.UserData;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class UninstallerArgumentParser
extends SecureConnectionCliParser {
    private BooleanArgument interactive;
    private BooleanArgument forceOnError;
    private BooleanArgument quiet;
    private BooleanArgument removeAll;
    private BooleanArgument removeServerLibraries;
    private BooleanArgument removeDatabases;
    private BooleanArgument removeLogFiles;
    private BooleanArgument removeConfigurationFiles;
    private BooleanArgument removeBackupFiles;
    private BooleanArgument removeLDIFFiles;
    private StringArgument adminUidArg;
    private StringArgument referencedHostNameArg;

    public UninstallerArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public void initializeGlobalArguments(OutputStream outStream) throws ArgumentException {
        LinkedHashSet<Argument> args = new LinkedHashSet<Argument>();
        this.removeAll = new BooleanArgument("remove-all", Character.valueOf('a'), "remove-all", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_ALL.get());
        args.add(this.removeAll);
        this.removeServerLibraries = new BooleanArgument("server-libraries", Character.valueOf('l'), "server-libraries", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_SERVER_LIBRARIES.get());
        args.add(this.removeServerLibraries);
        this.removeDatabases = new BooleanArgument("databases", Character.valueOf('d'), "databases", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_DATABASES.get());
        args.add(this.removeDatabases);
        this.removeLogFiles = new BooleanArgument("log-files", Character.valueOf('L'), "log-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_LOG_FILES.get());
        args.add(this.removeLogFiles);
        this.removeConfigurationFiles = new BooleanArgument("configuration-files", Character.valueOf('c'), "configuration-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_CONFIGURATION_FILES.get());
        args.add(this.removeConfigurationFiles);
        this.removeBackupFiles = new BooleanArgument("backup-files", Character.valueOf('b'), "backup-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_BACKUP_FILES.get());
        args.add(this.removeBackupFiles);
        this.removeLDIFFiles = new BooleanArgument("ldif-files", Character.valueOf('e'), "ldif-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_LDIF_FILES.get());
        args.add(this.removeLDIFFiles);
        this.interactive = new BooleanArgument("interactive", INTERACTIVE_OPTION_SHORT, "interactive", ToolMessages.INFO_DESCRIPTION_INTERACTIVE.get());
        args.add(this.interactive);
        this.forceOnError = new BooleanArgument("forceOnError", Character.valueOf('f'), "forceOnError", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_FORCE.get());
        args.add(this.forceOnError);
        this.quiet = new BooleanArgument("quiet", SecureConnectionCliParser.QUIET_OPTION_SHORT, "quiet", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_SILENT.get());
        args.add(this.quiet);
        this.adminUidArg = new StringArgument("adminUID", Character.valueOf('I'), "adminUID", false, false, true, "adminUID", "admin", null, AdminToolMessages.INFO_DESCRIPTION_ADMIN_UID.get());
        ArrayList<Argument> defaultArgs = new ArrayList<Argument>(this.createGlobalArguments(System.err));
        int index = defaultArgs.indexOf(this.bindDnArg);
        if (index != -1) {
            defaultArgs.add(index, this.adminUidArg);
            defaultArgs.remove(this.bindDnArg);
        } else {
            defaultArgs.add(this.adminUidArg);
        }
        defaultArgs.remove(this.hostNameArg);
        defaultArgs.remove(this.portArg);
        defaultArgs.remove(this.verboseArg);
        UserData uData = new UserData();
        this.referencedHostNameArg = new StringArgument("referencedHostName", Character.valueOf('h'), "referencedHostName", false, false, true, "{host}", uData.getHostName(), null, AdminToolMessages.INFO_DESCRIPTION_REFERENCED_HOST.get());
        defaultArgs.add(this.referencedHostNameArg);
        args.addAll(defaultArgs);
        this.initializeGlobalArguments(args);
    }

    public boolean isInteractive() {
        return this.interactive.isPresent();
    }

    public boolean isForceOnError() {
        return this.forceOnError.isPresent();
    }

    public boolean isQuiet() {
        return this.quiet.isPresent();
    }

    public boolean removeAll() {
        return this.removeAll.isPresent();
    }

    public boolean removeServerLibraries() {
        return this.removeServerLibraries.isPresent();
    }

    public boolean removeDatabases() {
        return this.removeDatabases.isPresent();
    }

    public boolean removeConfigurationFiles() {
        return this.removeConfigurationFiles.isPresent();
    }

    public boolean removeBackupFiles() {
        return this.removeBackupFiles.isPresent();
    }

    public boolean removeLDIFFiles() {
        return this.removeLDIFFiles.isPresent();
    }

    public boolean removeLogFiles() {
        return this.removeLogFiles.isPresent();
    }

    public String getAdministratorUID() {
        String uid = null;
        if (this.adminUidArg.isPresent()) {
            uid = this.adminUidArg.getValue();
        }
        return uid;
    }

    public String getDefaultAdministratorUID() {
        return this.adminUidArg.getDefaultValue();
    }

    public String getReferencedHostName() {
        String hostName = null;
        if (this.referencedHostNameArg.isPresent()) {
            hostName = this.referencedHostNameArg.getValue();
        }
        return hostName;
    }

    public String getDefaultReferencedHostName() {
        return this.referencedHostNameArg.getDefaultValue();
    }

    public int validateGlobalOptions(MessageBuilder buf) {
        if (this.interactive.isPresent() && this.forceOnError.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.interactive.getLongIdentifier(), this.forceOnError.getLongIdentifier());
            if (buf.length() > 0) {
                buf.append(EOL);
            }
            buf.append(message);
        }
        if (this.removeAll.isPresent()) {
            BooleanArgument[] removeArgs = new BooleanArgument[]{this.removeServerLibraries, this.removeDatabases, this.removeLogFiles, this.removeConfigurationFiles, this.removeBackupFiles, this.removeLDIFFiles};
            for (int i = 0; i < removeArgs.length; ++i) {
                if (!removeArgs[i].isPresent()) continue;
                Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.removeAll.getLongIdentifier(), removeArgs[i].getLongIdentifier());
                if (buf.length() > 0) {
                    buf.append(EOL);
                }
                buf.append(message);
            }
        }
        int returnValue = buf.length() > 0 ? DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode() : DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
        return returnValue;
    }
}

