/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.opends.messages.Category;
import org.opends.messages.MessageDescriptor;
import org.opends.messages.Severity;

public class Message
implements CharSequence,
Formattable,
Comparable {
    public static final Message EMPTY = Message.raw("", new Object[0]);
    protected MessageDescriptor descriptor;
    protected Object[] args;

    public static Message raw(CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            message = new MessageDescriptor.Raw(formatString).get(args);
        }
        return message;
    }

    public static Message raw(Category category, Severity severity, CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            MessageDescriptor.Raw md = new MessageDescriptor.Raw(formatString, category, severity);
            message = md.get(args);
        }
        return message;
    }

    public static Message fromObject(Object object, Object ... arguments) {
        Message message = null;
        if (object != null) {
            String cs = object.toString();
            message = Message.raw(cs, arguments);
        }
        return message;
    }

    public static String toString(Message message) {
        return message != null ? message.toString() : null;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        String s;
        String fmt = this.descriptor.getFormatString(locale);
        if (this.descriptor.requiresFormatter()) {
            try {
                s = new Formatter(locale).format(locale, fmt, this.args).toString();
            }
            catch (IllegalFormatException e) {
                s = fmt;
            }
        } else {
            s = fmt;
        }
        if (s == null) {
            s = "";
        }
        return s;
    }

    public MessageDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int length() {
        return this.length(Locale.getDefault());
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.charAt(Locale.getDefault(), index);
    }

    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public char charAt(Locale locale, int index) throws IndexOutOfBoundsException {
        return this.toString(locale).charAt(index);
    }

    public CharSequence subSequence(Locale locale, int start, int end) throws IndexOutOfBoundsException {
        return this.toString(locale).subSequence(start, end);
    }

    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        Locale l = formatter.locale();
        formatter.format(l, this.descriptor.getFormatString(l), this.args);
    }

    Message(MessageDescriptor descriptor, Object ... args) {
        this.descriptor = descriptor;
        this.args = args;
    }

    public int compareTo(Object o) {
        Message thatMessage = (Message)o;
        return this.toString().compareTo(thatMessage.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.toString().equals(message.toString());
    }

    public int hashCode() {
        int result = 31 * this.toString().hashCode();
        return result;
    }
}

