/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.opends.messages.Message;

public class MessageBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -3292823563904285315L;
    StringBuilder sb = new StringBuilder();
    List<Message> messages = new LinkedList<Message>();
    Locale locale;

    public MessageBuilder() {
        this(Locale.getDefault());
    }

    public MessageBuilder(Message message) {
        this.append(message);
    }

    public MessageBuilder(String message) {
        this.append(message);
    }

    public MessageBuilder(MessageBuilder mb) {
        for (Message msg : mb.messages) {
            this.messages.add(msg);
        }
        this.sb.append((CharSequence)this.sb);
        this.locale = mb.locale;
    }

    public MessageBuilder(Locale locale) {
        this.locale = locale;
    }

    public MessageBuilder append(Message message) {
        if (message != null) {
            this.sb.append(message.toString(this.locale));
            this.messages.add(message);
        }
        return this;
    }

    public MessageBuilder append(int number) {
        this.append(String.valueOf(number));
        return this;
    }

    public MessageBuilder append(Object object) {
        if (object != null) {
            this.append(String.valueOf(object));
        }
        return this;
    }

    public MessageBuilder append(CharSequence rawString) {
        if (rawString != null) {
            this.sb.append(rawString);
            this.messages.add(Message.raw(rawString, new Object[0]));
        }
        return this;
    }

    public MessageBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    public MessageBuilder append(char c) {
        return this.append(String.valueOf(c));
    }

    public String toString() {
        return this.sb.toString();
    }

    public String toString(Locale locale) {
        StringBuilder sb = new StringBuilder();
        for (Message m : this.messages) {
            sb.append(m.toString(locale));
        }
        return sb.toString();
    }

    public Message toMessage() {
        return Message.raw(this.sb.toString(), new Object[0]);
    }

    public Message toMessage(Locale locale) {
        return Message.raw(this.toString(locale), new Object[0]);
    }

    public int length() {
        return this.length(Locale.getDefault());
    }

    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.charAt(Locale.getDefault(), index);
    }

    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public char charAt(Locale locale, int index) throws IndexOutOfBoundsException {
        return this.toString(locale).charAt(index);
    }

    public CharSequence subSequence(Locale locale, int start, int end) throws IndexOutOfBoundsException {
        return this.toString(locale).subSequence(start, end);
    }
}

