/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildInformation
implements Comparable {
    private static final Logger LOG = Logger.getLogger(BuildInformation.class.getName());
    private static final String NAME = "Name";
    private static final String BUILD_ID = "Build ID";
    private static final String MAJOR_VERSION = "Major Version";
    private static final String MINOR_VERSION = "Minor Version";
    private static final String POINT_VERSION = "Point Version";
    private static final String REVISION_NUMBER = "Revision Number";
    private static final String VERSION_QUALIFIER = "Version Qualifier";
    private static final String INCOMPATIBILITY_EVENTS = "Upgrade Event IDs";
    private static final String FIX_IDS = "Fix IDs";
    private static final String DEBUG_BUILD = "Debug Build";
    private static final String BUILD_OS = "Build OS";
    private static final String BUILD_USER = "Build User";
    private static final String BUILD_JAVA_VERSION = "Build Java Version";
    private static final String BUILD_JAVA_VENDOR = "Build Java Vendor";
    private static final String BUILD_JVM_VERSION = "Build JVM Version";
    private static final String BUILD_JVM_VENDOR = "Build JVM Vendor";
    private Map<String, String> values = new HashMap<String, String>();

    public static BuildInformation create(Installation installation) throws ApplicationException {
        BuildInformation bi = new BuildInformation();
        ArrayList<String> args = new ArrayList<String>();
        args.add(Utils.getPath(installation.getServerStartCommandFile()));
        args.add("-F");
        ProcessBuilder pb = new ProcessBuilder(args);
        InputStream is = null;
        try {
            Map<String, String> env = pb.environment();
            env.put("JAVA_HOME", System.getProperty("java.home"));
            env.remove("JAVA_BIN");
            Process process = pb.start();
            is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            bi.values.put(NAME, line);
            while (null != (line = reader.readLine())) {
                int colonIndex = line.indexOf(58);
                if (-1 == colonIndex) continue;
                String name = line.substring(0, colonIndex).trim();
                String value = line.substring(colonIndex + 1).trim();
                bi.values.put(name, value);
            }
        }
        catch (IOException e) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BUILD_INFO.get(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        BuildInformation.checkNotNull(bi.values, NAME, MAJOR_VERSION, MINOR_VERSION, POINT_VERSION, REVISION_NUMBER);
        return bi;
    }

    public static BuildInformation fromBuildString(String bn) throws IllegalArgumentException {
        Pattern p = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+))");
        Matcher m = p.matcher(bn);
        if (!m.matches()) {
            throw new IllegalArgumentException("'" + bn + "' is not a build string");
        }
        BuildInformation bi = new BuildInformation();
        try {
            bi.values.put(MAJOR_VERSION, m.group(2));
            bi.values.put(MINOR_VERSION, m.group(3));
            bi.values.put(POINT_VERSION, m.group(4));
            bi.values.put(REVISION_NUMBER, m.group(5));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing build number " + bn);
        }
        return bi;
    }

    public static BuildInformation getCurrent() throws ApplicationException {
        BuildInformation bi = new BuildInformation();
        bi.values.put(NAME, DynamicConstants.FULL_VERSION_STRING);
        bi.values.put(BUILD_ID, "20070825171542Z");
        bi.values.put(MAJOR_VERSION, String.valueOf(1));
        bi.values.put(MINOR_VERSION, String.valueOf(0));
        bi.values.put(POINT_VERSION, String.valueOf(0));
        bi.values.put(VERSION_QUALIFIER, String.valueOf(""));
        bi.values.put(REVISION_NUMBER, String.valueOf(2794L));
        bi.values.put(FIX_IDS, "");
        bi.values.put(DEBUG_BUILD, String.valueOf(false));
        bi.values.put(BUILD_OS, "SunOS 5.10 x86");
        bi.values.put(BUILD_USER, "builds");
        bi.values.put(BUILD_JAVA_VERSION, "1.5.0_10");
        bi.values.put(BUILD_JAVA_VENDOR, "Sun Microsystems Inc.");
        bi.values.put(BUILD_JVM_VERSION, "1.5.0_10-b03");
        bi.values.put(BUILD_JVM_VENDOR, "Sun Microsystems Inc.");
        BuildInformation.checkNotNull(bi.values, NAME, MAJOR_VERSION, MINOR_VERSION, POINT_VERSION, REVISION_NUMBER);
        return bi;
    }

    public String getName() {
        return this.values.get(NAME);
    }

    public String getBuildId() {
        return this.values.get(BUILD_ID);
    }

    public Integer getMajorVersion() {
        return new Integer(this.values.get(MAJOR_VERSION));
    }

    public Integer getMinorVersion() {
        return new Integer(this.values.get(MINOR_VERSION));
    }

    public Integer getPointVersion() {
        return new Integer(this.values.get(POINT_VERSION));
    }

    public String getVersionQualifier() {
        return this.values.get(VERSION_QUALIFIER);
    }

    public Integer getRevisionNumber() {
        return new Integer(this.values.get(REVISION_NUMBER));
    }

    public Set<Integer> getIncompatibilityEventIds() {
        HashSet<Integer> ids = null;
        String idString = this.values.get(INCOMPATIBILITY_EVENTS);
        if (idString != null) {
            String[] sa;
            ids = new HashSet<Integer>();
            for (String s : sa = idString.split(",")) {
                try {
                    ids.add(Integer.parseInt(s));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.INFO, "invalid upgrade incompatability ID " + s);
                }
            }
        }
        return ids;
    }

    public String getBuildString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajorVersion());
        sb.append(".");
        sb.append(this.getMinorVersion());
        sb.append(".");
        sb.append(this.getPointVersion());
        sb.append(".");
        sb.append(this.getRevisionNumber());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        String id = this.getBuildId();
        if (id != null) {
            sb.append(" (").append(QuickSetupMessages.INFO_GENERAL_BUILD_ID.get()).append(": ").append(id).append(")");
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        BuildInformation bi = (BuildInformation)o;
        if (this.getMajorVersion().equals(bi.getMajorVersion())) {
            if (this.getMinorVersion().equals(bi.getMinorVersion())) {
                if (this.getPointVersion().equals(bi.getPointVersion())) {
                    if (this.getRevisionNumber().equals(bi.getRevisionNumber())) {
                        return 0;
                    }
                    if (this.getRevisionNumber() < bi.getRevisionNumber()) {
                        return -1;
                    }
                } else if (this.getPointVersion() < bi.getPointVersion()) {
                    return -1;
                }
            } else if (this.getMinorVersion() < bi.getMinorVersion()) {
                return -1;
            }
        } else if (this.getMajorVersion() < bi.getMajorVersion()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.compareTo(o) == 0;
    }

    public int hashCode() {
        int hc = 11;
        hc = 31 * hc + this.getMajorVersion().hashCode();
        hc = 31 * hc + this.getMinorVersion().hashCode();
        hc = 31 * hc + this.getPointVersion().hashCode();
        hc = 31 * hc + this.getRevisionNumber().hashCode();
        return hc;
    }

    private static void checkNotNull(Map values, String ... props) throws ApplicationException {
        for (String prop : props) {
            if (null != values.get(prop)) continue;
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.TOOL_ERROR, QuickSetupMessages.INFO_ERROR_PROP_VALUE.get(prop), null);
        }
    }
}

