/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliApplicationHelper {
    private static final Logger LOG = Logger.getLogger(CliApplication.class.getName());
    public static final String PROMPT_FORMAT = "%s%n[%s]:";
    private BooleanArgument interactiveArg = null;
    private BooleanArgument quietArg = null;

    protected Message promptConfirm(Message prompt, Message defaultValue, Message[] validValues) {
        this.printLineBreak();
        boolean isValid = false;
        Message response = null;
        while (!isValid) {
            Message msg = Message.raw(PROMPT_FORMAT, prompt, defaultValue);
            System.out.print(msg);
            System.out.flush();
            response = Message.raw(this.readLine(), new Object[0]);
            if (response.toString().equals("")) {
                response = defaultValue;
            }
            for (int i = 0; i < validValues.length && !isValid; ++i) {
                isValid = validValues[i].toString().equalsIgnoreCase(response.toString());
            }
        }
        return response;
    }

    protected String promptForString(Message prompt, String defaultValue) {
        String response;
        block3: {
            this.printLineBreak();
            String wrappedPrompt = StaticUtils.wrapText(prompt, Utils.getCommandLineMaxLineWidth());
            while (true) {
                System.out.print(wrappedPrompt);
                if (defaultValue == null) {
                    System.out.print(": ");
                } else {
                    System.out.print("[");
                    System.out.print(defaultValue);
                    System.out.print("]: ");
                }
                System.out.flush();
                response = this.readLine();
                if (!response.equals("")) break block3;
                if (defaultValue != null) break;
                Message message = QuickSetupMessages.INFO_ERROR_EMPTY_RESPONSE.get();
                System.err.println(StaticUtils.wrapText(message, Utils.getCommandLineMaxLineWidth()));
            }
            return defaultValue;
        }
        return response;
    }

    protected String promptForPassword(Message msg) {
        String pwd;
        this.printLineBreak();
        String wrappedPrompt = StaticUtils.wrapText(msg, Utils.getCommandLineMaxLineWidth());
        System.out.print(wrappedPrompt + " ");
        System.out.flush();
        try {
            char[] pwChars = PasswordReader.readPassword();
            pwd = pwChars == null || pwChars.length == 0 ? null : new String(pwChars);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error reading password: " + t, t);
            pwd = null;
        }
        return pwd;
    }

    public String readLine() {
        return this.readLine(System.in, System.err);
    }

    public String readLine(InputStream in, PrintStream err) {
        try {
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = in.read()) >= 0 && b != 10) {
                if (b == 13) {
                    int b2 = in.read();
                    if (b2 == 10) break;
                    baos.write(b);
                    baos.write(b2);
                    continue;
                }
                baos.write(b);
            }
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            err.println(QuickSetupMessages.INFO_CLI_ERROR_READING_STDIN.get().toString());
            return null;
        }
    }

    protected boolean isQuiet(String[] args) {
        boolean isQuiet = false;
        for (int i = 0; i < args.length && !isQuiet; ++i) {
            if (!args[i].equalsIgnoreCase("--quiet") && !args[i].equalsIgnoreCase("-Q")) continue;
            isQuiet = true;
        }
        return isQuiet;
    }

    protected void validateArguments(UserData userData, String[] args, Set<String> validArgs) throws UserDataException {
        ArrayList<Message> errors = new ArrayList<Message>();
        for (String arg1 : args) {
            if (validArgs.contains(arg1)) continue;
            errors.add(QuickSetupMessages.INFO_CLI_UNKNOWN_ARGUMENT.get(arg1));
        }
        if (errors.size() > 0) {
            MessageBuilder mb = new MessageBuilder();
            for (Message error : errors) {
                mb.append(error);
                mb.append(Constants.LINE_SEPARATOR);
                mb.append(Constants.LINE_SEPARATOR);
            }
            throw new UserDataException(null, mb.toMessage());
        }
    }

    protected boolean isQuiet() {
        return this.quietArg != null && this.quietArg.isPresent();
    }

    protected boolean isInteractive() {
        return this.interactiveArg != null && this.interactiveArg.isPresent();
    }

    protected ArgumentParser createArgumentParser(String mainClass, Message description, boolean caseSensitive) {
        ArgumentParser argParser = new ArgumentParser(mainClass, description, caseSensitive);
        try {
            this.interactiveArg = new BooleanArgument("noninteractive session", SecureConnectionCliParser.INTERACTIVE_OPTION_SHORT, "interactive", null);
            argParser.addArgument(this.interactiveArg);
            this.quietArg = new BooleanArgument("silent session", SecureConnectionCliParser.QUIET_OPTION_SHORT, "quiet", null);
            argParser.addArgument(this.quietArg);
        }
        catch (ArgumentException e) {
            LOG.log(Level.INFO, "error", e);
        }
        return argParser;
    }

    protected void printErrorMessage(Message msg) {
        System.err.println(StaticUtils.wrapText(msg, Utils.getCommandLineMaxLineWidth()));
    }

    protected void printErrorMessage(String msg) {
        System.err.println(StaticUtils.wrapText(msg, Utils.getCommandLineMaxLineWidth()));
    }

    protected void printLineBreak() {
        System.out.println();
    }

    protected boolean promptForCertificateConfirmation(Throwable t, ApplicationTrustManager trustManager, String usedUrl) {
        boolean returnValue = false;
        ApplicationTrustManager.Cause cause = trustManager.getLastRefusedCause();
        LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
        UserDataCertificateException.Type excType = null;
        if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
            excType = UserDataCertificateException.Type.NOT_TRUSTED;
        } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
            excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
        } else {
            System.err.println();
            Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), t);
            this.printErrorMessage(msg);
        }
        if (excType != null) {
            int p;
            String h;
            try {
                URI uri = new URI(usedUrl);
                h = uri.getHost();
                p = uri.getPort();
            }
            catch (Throwable t1) {
                LOG.log(Level.WARNING, "Error parsing ldap url of ldap url.", t1);
                h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                p = -1;
            }
            UserDataCertificateException udce = new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), t, h, p, trustManager.getLastRefusedChain(), trustManager.getLastRefusedAuthType(), excType);
            returnValue = this.handleCertificateException(udce, trustManager, true);
        }
        return returnValue;
    }

    private boolean handleCertificateException(UserDataCertificateException udce, ApplicationTrustManager trustManager, boolean displayErrorMessage) {
        boolean accepted = false;
        Message msg = udce.getType() == UserDataCertificateException.Type.NOT_TRUSTED ? QuickSetupMessages.INFO_CERTIFICATE_NOT_TRUSTED_TEXT_CLI.get(udce.getHost(), String.valueOf(udce.getPort()), udce.getHost(), String.valueOf(udce.getPort())) : QuickSetupMessages.INFO_CERTIFICATE_NAME_MISMATCH_TEXT_CLI.get(udce.getHost(), String.valueOf(udce.getPort()), udce.getHost(), udce.getHost(), String.valueOf(udce.getPort()), udce.getHost(), String.valueOf(udce.getPort()));
        if (displayErrorMessage) {
            this.printLineBreak();
            this.printErrorMessage(msg);
        }
        Message[] validValues = new Message[]{AdminToolMessages.INFO_CLI_ACCEPT_CERTIFICATE_LONG.get(), AdminToolMessages.INFO_CLI_REJECT_CERTIFICATE_LONG.get(), AdminToolMessages.INFO_CLI_VIEW_CERTIFICATE_LONG.get(), AdminToolMessages.INFO_CLI_ACCEPT_CERTIFICATE_SHORT.get(), AdminToolMessages.INFO_CLI_REJECT_CERTIFICATE_SHORT.get(), AdminToolMessages.INFO_CLI_VIEW_CERTIFICATE_SHORT.get()};
        Message answer = this.promptConfirm(AdminToolMessages.INFO_CLI_ACCEPT_CERTIFICATE_PROMPT.get(), validValues[0], validValues);
        if (AdminToolMessages.INFO_CLI_REJECT_CERTIFICATE_LONG.get().toString().equalsIgnoreCase(answer.toString()) || AdminToolMessages.INFO_CLI_REJECT_CERTIFICATE_SHORT.get().toString().equalsIgnoreCase(answer.toString())) {
            accepted = false;
        } else if (AdminToolMessages.INFO_CLI_VIEW_CERTIFICATE_LONG.get().toString().equalsIgnoreCase(answer.toString()) || AdminToolMessages.INFO_CLI_VIEW_CERTIFICATE_SHORT.get().toString().equalsIgnoreCase(answer.toString())) {
            this.printLineBreak();
            this.displayCertificate(udce);
            accepted = this.handleCertificateException(udce, trustManager, false);
        } else {
            X509Certificate[] chain = udce.getChain();
            String authType = udce.getAuthType();
            String host = udce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                trustManager.acceptCertificate(chain, authType, host);
                accepted = true;
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
        return accepted;
    }

    private void displayCertificate(UserDataCertificateException udce) {
        Message[] labels = new Message[]{QuickSetupMessages.INFO_CERTIFICATE_SUBJECT_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_ISSUED_BY_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_VALID_FROM_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_EXPIRES_ON_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_TYPE_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_SERIAL_NUMBER_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_SIGNATURE_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_SIGNATURE_ALGORITHM_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_VERSION_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_PUBLIC_KEY_LABEL.get()};
        for (int i = 0; i < udce.getChain().length; ++i) {
            X509Certificate cert = udce.getChain()[i];
            String[] values = new String[]{cert.getSubjectX500Principal().getName().toString(), cert.getIssuerX500Principal().getName().toString(), CertificateDialog.getValidFrom(cert), CertificateDialog.getExpiresOn(cert), cert.getType(), String.valueOf(cert.getSerialNumber()), CertificateDialog.getSignature(cert).toString(), String.valueOf(cert.getSigAlgName()), String.valueOf(cert.getVersion()), cert.getPublicKey().toString()};
            for (int j = 0; j < labels.length; ++j) {
                System.out.println(StaticUtils.wrapText(labels[j] + " " + values[j], Utils.getCommandLineMaxLineWidth()));
            }
        }
        System.out.flush();
    }
}

