/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;

public class CurrentInstallStatus {
    private static final Logger LOG = Logger.getLogger(CurrentInstallStatus.class.getName());
    private boolean isInstalled;
    private boolean canOverwriteCurrentInstall;
    private Message installationMsg;

    public CurrentInstallStatus() {
        if (Utils.isWebStart()) {
            this.isInstalled = false;
        } else {
            Installation installation = Installation.getLocal();
            boolean dbFileExists = false;
            ArrayList<Message> msgs = new ArrayList<Message>();
            if (installation.getStatus().isServerRunning()) {
                msgs.add(QuickSetupMessages.INFO_INSTALLSTATUS_SERVERRUNNING.get(String.valueOf(this.getPort())));
            }
            if (this.dbFilesExist()) {
                dbFileExists = true;
                msgs.add(QuickSetupMessages.INFO_INSTALLSTATUS_DBFILEEXIST.get());
            }
            if (this.isConfigFileModified()) {
                msgs.add(QuickSetupMessages.INFO_INSTALLSTATUS_CONFIGFILEMODIFIED.get());
            }
            this.canOverwriteCurrentInstall = msgs.size() == 1 && dbFileExists;
            boolean bl = this.isInstalled = msgs.size() > 0;
            if (this.canOverwriteCurrentInstall) {
                this.installationMsg = QuickSetupMessages.INFO_INSTALLSTATUS_CANOVERWRITECURRENTINSTALL_MSG.get();
            } else if (this.isInstalled) {
                MessageBuilder buf = new MessageBuilder();
                buf.append("<ul>");
                for (Message msg : msgs) {
                    buf.append("\n<li>");
                    buf.append(msg);
                    buf.append("</li>");
                }
                buf.append("</ul>");
                this.installationMsg = QuickSetupMessages.INFO_INSTALLSTATUS_INSTALLED.get(buf.toString());
            }
        }
        if (!this.isInstalled) {
            this.installationMsg = QuickSetupMessages.INFO_INSTALLSTATUS_NOT_INSTALLED.get();
        }
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public boolean canOverwriteCurrentInstall() {
        return this.canOverwriteCurrentInstall;
    }

    public Message getInstallationMsg() {
        return this.installationMsg;
    }

    private int getPort() {
        int port = -1;
        try {
            port = Installation.getLocal().getCurrentConfiguration().getPort();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Failed to get port", ioe);
        }
        return port;
    }

    private boolean dbFilesExist() {
        boolean dbFilesExist = false;
        File dbDir = Installation.getLocal().getDatabasesDirectory();
        File[] children = dbDir.listFiles();
        if (children != null && children.length > 0) {
            dbFilesExist = true;
        }
        return dbFilesExist;
    }

    private boolean isConfigFileModified() {
        boolean mod = false;
        try {
            mod = Installation.getLocal().getCurrentConfiguration().hasBeenModified();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "failed to determine if config modified", ioe);
        }
        return mod;
    }
}

