/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

public class SecurityOptions {
    private boolean enableSSL;
    private boolean enableStartTLS;
    private int sslPort = 636;
    private CertificateType certificateType;
    private String keyStorePath;
    private String keyStorePassword;
    private String aliasToUse;

    private SecurityOptions() {
    }

    public static SecurityOptions createNoCertificateOptions() {
        SecurityOptions ops = new SecurityOptions();
        ops.setCertificateType(CertificateType.NO_CERTIFICATE);
        ops.setEnableSSL(false);
        ops.setEnableStartTLS(false);
        return ops;
    }

    public static SecurityOptions createSelfSignedCertificateOptions(boolean enableSSL, boolean enableStartTLS, int sslPort) {
        SecurityOptions ops = new SecurityOptions();
        ops.setCertificateType(CertificateType.SELF_SIGNED_CERTIFICATE);
        SecurityOptions.updateCertificateOptions(ops, enableSSL, enableStartTLS, sslPort, null);
        return ops;
    }

    public static SecurityOptions createJKSCertificateOptions(String keystorePath, String keystorePwd, boolean enableSSL, boolean enableStartTLS, int sslPort, String aliasToUse) {
        SecurityOptions ops = new SecurityOptions();
        ops.setCertificateType(CertificateType.JKS);
        ops.setKeyStorePath(keystorePath);
        ops.setKeyStorePassword(keystorePwd);
        SecurityOptions.updateCertificateOptions(ops, enableSSL, enableStartTLS, sslPort, aliasToUse);
        return ops;
    }

    public static SecurityOptions createPKCS11CertificateOptions(String keystorePwd, boolean enableSSL, boolean enableStartTLS, int sslPort, String aliasToUse) {
        SecurityOptions ops = new SecurityOptions();
        ops.setCertificateType(CertificateType.PKCS11);
        ops.setKeyStorePassword(keystorePwd);
        SecurityOptions.updateCertificateOptions(ops, enableSSL, enableStartTLS, sslPort, aliasToUse);
        return ops;
    }

    public static SecurityOptions createPKCS12CertificateOptions(String keystorePath, String keystorePwd, boolean enableSSL, boolean enableStartTLS, int sslPort, String aliasToUse) {
        SecurityOptions ops = new SecurityOptions();
        ops.setCertificateType(CertificateType.PKCS12);
        ops.setKeyStorePath(keystorePath);
        ops.setKeyStorePassword(keystorePwd);
        SecurityOptions.updateCertificateOptions(ops, enableSSL, enableStartTLS, sslPort, aliasToUse);
        return ops;
    }

    public CertificateType getCertificateType() {
        return this.certificateType;
    }

    private void setCertificateType(CertificateType certificateType) {
        this.certificateType = certificateType;
    }

    public boolean getEnableSSL() {
        return this.enableSSL;
    }

    private void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public boolean getEnableStartTLS() {
        return this.enableStartTLS;
    }

    private void setEnableStartTLS(boolean enableStartTLS) {
        this.enableStartTLS = enableStartTLS;
    }

    public String getKeystorePassword() {
        return this.keyStorePassword;
    }

    private void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeystorePath() {
        return this.keyStorePath;
    }

    private void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    private static void updateCertificateOptions(SecurityOptions ops, boolean enableSSL, boolean enableStartTLS, int sslPort, String aliasToUse) {
        if (!enableSSL && !enableStartTLS) {
            throw new IllegalArgumentException("You must enable SSL or StartTLS to use a certificate.");
        }
        ops.setEnableSSL(enableSSL);
        ops.setEnableStartTLS(enableStartTLS);
        ops.setSslPort(sslPort);
        ops.setAliasToUse(aliasToUse);
    }

    public int getSslPort() {
        return this.sslPort;
    }

    void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public String getAliasToUse() {
        return this.aliasToUse;
    }

    void setAliasToUse(String aliasToUse) {
        this.aliasToUse = aliasToUse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateType {
        NO_CERTIFICATE,
        SELF_SIGNED_CERTIFICATE,
        JKS,
        PKCS11,
        PKCS12;

    }
}

