/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installandupgrader.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.BrowseActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.installandupgrader.InstallAndUpgrader;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;

public class WelcomePanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = 8696606861642491768L;
    private JLabel lblServerLocation;
    private JTextComponent tcServerLocation;
    private JRadioButton rbInstall;
    private JRadioButton rbUpgrade;
    private JButton butBrowse;
    private InstallAndUpgrader appl;
    private boolean initialized = false;

    public WelcomePanel(InstallAndUpgrader application) {
        super(application);
        this.appl = application;
    }

    public void beginDisplay(UserData data) {
        super.beginDisplay(data);
        if (!this.initialized) {
            this.tcServerLocation.setText(data.getServerLocation());
            boolean isUpgrade = this.appl.getInstallAndUpgradeUserData().isUpgrade();
            this.rbInstall.setSelected(!isUpgrade);
            this.rbUpgrade.setSelected(isUpgrade);
            this.initialized = true;
        }
        this.checkEnablingState();
    }

    public Object getFieldValue(FieldName fieldName) {
        Object v = null;
        if (FieldName.SERVER_TO_UPGRADE_LOCATION.equals((Object)fieldName)) {
            v = this.tcServerLocation.getText();
        } else if (FieldName.IS_UPGRADE.equals((Object)fieldName)) {
            v = this.rbUpgrade.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        return v;
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        UIFactory.TextStyle style = invalid ? UIFactory.TextStyle.PRIMARY_FIELD_INVALID : UIFactory.TextStyle.PRIMARY_FIELD_VALID;
        if (FieldName.SERVER_TO_UPGRADE_LOCATION.equals((Object)fieldName)) {
            UIFactory.setTextStyle(this.lblServerLocation, style);
        }
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_INSTALLANDUPGRADE_WELCOME_PANEL_TITLE.get();
    }

    protected Message getInstructions() {
        return QuickSetupMessages.INFO_INSTALLANDUPGRADE_WELCOME_PANEL_INSTRUCTIONS.get("OpenDS-1.0.0-build004", "20070825171542Z");
    }

    protected Component createInputPanel() {
        JPanel p = UIFactory.makeJPanel();
        p.setLayout(new GridBagLayout());
        this.rbInstall = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_INSTALLANDUPGRADER_RBINSTALL_LABEL.get(), QuickSetupMessages.INFO_INSTALLANDUPGRADER_RBINSTALL_TOOLTIP.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        this.rbUpgrade = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_INSTALLANDUPGRADER_RBUPGRADE_LABEL.get(), QuickSetupMessages.INFO_INSTALLANDUPGRADER_RBUPGRADE_TOOLTIP.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbInstall);
        group.add(this.rbUpgrade);
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                WelcomePanel.this.checkEnablingState();
                ButtonEvent be = new ButtonEvent(ev.getSource(), ButtonName.INPUT_PANEL_BUTTON);
                WelcomePanel.this.notifyButtonListeners(be);
            }
        };
        this.rbInstall.addActionListener(l);
        this.rbUpgrade.addActionListener(l);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        p.add((Component)this.rbInstall, gbc);
        gbc.insets.top = 5;
        p.add((Component)this.rbUpgrade, gbc);
        gbc.insets.left = 35;
        p.add(this.createUpgraderPanel(), gbc);
        gbc.insets.top = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        p.add(Box.createVerticalGlue(), gbc);
        return p;
    }

    private void checkEnablingState() {
        boolean enable = this.rbUpgrade.isSelected();
        this.lblServerLocation.setEnabled(enable);
        this.tcServerLocation.setEnabled(enable);
        this.butBrowse.setEnabled(enable);
    }

    private Component createUpgraderPanel() {
        LabelFieldDescriptor serverLocationDescriptor = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_LOCATION_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_LOCATION_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 20);
        JPanel pnlBuildInfo = UIFactory.makeJPanel();
        pnlBuildInfo.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        UserData userData = this.getApplication().getUserData();
        this.lblServerLocation = UIFactory.makeJLabel(serverLocationDescriptor);
        this.tcServerLocation = UIFactory.makeJTextComponent(serverLocationDescriptor, userData.getServerLocation());
        this.butBrowse = UIFactory.makeJButton(QuickSetupMessages.INFO_BROWSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_BROWSE_BUTTON_TOOLTIP.get());
        BrowseActionListener l = new BrowseActionListener(this.tcServerLocation, BrowseActionListener.BrowseType.LOCATION_DIRECTORY, this.getMainWindow());
        this.butBrowse.addActionListener(l);
        JPanel pnlBrowser = Utilities.createBrowseButtonPanel(this.lblServerLocation, this.tcServerLocation, this.butBrowse);
        pnlBrowser.setOpaque(false);
        gbc.insets.left = 10;
        gbc.anchor = 23;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        pnlBuildInfo.add((Component)pnlBrowser, gbc);
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 21;
        JPanel fill = UIFactory.makeJPanel();
        pnlBuildInfo.add((Component)fill, gbc);
        JPanel c = pnlBuildInfo;
        return c;
    }
}

