/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.Rdn;
import javax.swing.JPanel;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.UserDataConfirmationException;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.ConfiguredReplication;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.InstallProgressStep;
import org.opends.quicksetup.installer.InstallerHelper;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.PeerNotFoundException;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.installer.ui.DataOptionsPanel;
import org.opends.quicksetup.installer.ui.DataReplicationPanel;
import org.opends.quicksetup.installer.ui.GlobalAdministratorPanel;
import org.opends.quicksetup.installer.ui.InstallReviewPanel;
import org.opends.quicksetup.installer.ui.InstallWelcomePanel;
import org.opends.quicksetup.installer.ui.RemoteReplicationPortsPanel;
import org.opends.quicksetup.installer.ui.ServerSettingsPanel;
import org.opends.quicksetup.installer.ui.SuffixesToReplicatePanel;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.FinishedPanel;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.ProgressPanel;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.CertificateManager;
import org.opends.server.util.SetupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Installer
extends GuiApplication {
    private TopologyCache lastLoadedCache;
    boolean forceToDisplaySetup = false;
    protected boolean canceled = false;
    Map<ServerDescriptor, ConfiguredReplication> hmConfiguredRemoteReplication = new HashMap<ServerDescriptor, ConfiguredReplication>();
    private static final int MIN_DIRECTORY_MANAGER_PWD = 1;
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    public static final int MIN_PORT_VALUE = 1;
    public static final int MAX_PORT_VALUE = 65535;
    private static final int MIN_NUMBER_ENTRIES = 1;
    private static final int MAX_NUMBER_ENTRIES = 10000;
    protected Set<InstallProgressStep> completedProgress = new HashSet<InstallProgressStep>();
    private List<WizardStep> lstSteps = new ArrayList<WizardStep>();
    private final HashSet<WizardStep> SUBSTEPS = new HashSet();
    private HashMap<WizardStep, WizardStep> hmPreviousSteps;
    private char[] selfSignedCertPw;
    private boolean registeredNewServerOnRemote;
    private boolean createdAdministrator;
    private boolean createdRemoteAds;
    protected static final String CONFIG_CLASS_NAME = "org.opends.server.extensions.ConfigFileHandler";
    protected static final String SELF_SIGNED_CERT_ALIAS = "server-cert";
    private InstallProgressStep currentProgressStep;

    public Installer() {
        this.SUBSTEPS.add(Step.CREATE_GLOBAL_ADMINISTRATOR);
        this.SUBSTEPS.add(Step.SUFFIXES_OPTIONS);
        this.SUBSTEPS.add(Step.NEW_SUFFIX_OPTIONS);
        this.SUBSTEPS.add(Step.REMOTE_REPLICATION_PORTS);
        this.hmPreviousSteps = new HashMap();
        this.selfSignedCertPw = null;
        this.currentProgressStep = InstallProgressStep.NOT_STARTED;
        this.lstSteps.add(Step.WELCOME);
        this.lstSteps.add(Step.SERVER_SETTINGS);
        this.lstSteps.add(Step.REPLICATION_OPTIONS);
        this.lstSteps.add(Step.CREATE_GLOBAL_ADMINISTRATOR);
        this.lstSteps.add(Step.SUFFIXES_OPTIONS);
        this.lstSteps.add(Step.REMOTE_REPLICATION_PORTS);
        this.lstSteps.add(Step.NEW_SUFFIX_OPTIONS);
        this.lstSteps.add(Step.REVIEW);
        this.lstSteps.add(Step.PROGRESS);
        this.lstSteps.add(Step.FINISHED);
        try {
            if (!QuickSetupLog.isInitialized()) {
                QuickSetupLog.initLogFileHandler(File.createTempFile("opends-setup-", ".log"));
            }
        }
        catch (IOException e) {
            System.err.println("Failed to initialize log");
        }
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    @Override
    public UserData createUserData() {
        UserData ud = new UserData();
        ud.setServerLocation(Utils.getDefaultServerLocation());
        return ud;
    }

    @Override
    public void forceToDisplay() {
        this.forceToDisplaySetup = true;
    }

    @Override
    public boolean canGoBack(WizardStep step) {
        return step != Step.WELCOME && step != Step.PROGRESS && step != Step.FINISHED;
    }

    @Override
    public boolean canGoForward(WizardStep step) {
        return step != Step.REVIEW && step != Step.PROGRESS && step != Step.FINISHED;
    }

    @Override
    public boolean canFinish(WizardStep step) {
        return step == Step.REVIEW;
    }

    @Override
    public boolean canQuit(WizardStep step) {
        return step != Step.PROGRESS && step != Step.FINISHED;
    }

    @Override
    public boolean isSubStep(WizardStep step) {
        return this.SUBSTEPS.contains(step);
    }

    @Override
    public boolean isVisible(WizardStep step, UserData userData) {
        DataReplicationOptions repl;
        SuffixesToReplicateOptions suf;
        boolean isVisible = step == Step.CREATE_GLOBAL_ADMINISTRATOR ? userData.mustCreateAdministrator() : (step == Step.NEW_SUFFIX_OPTIONS ? ((suf = userData.getSuffixesToReplicateOptions()) != null ? suf.getType() != SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES : false) : (step == Step.SUFFIXES_OPTIONS ? ((repl = userData.getReplicationOptions()) != null ? repl.getType() != DataReplicationOptions.Type.STANDALONE && repl.getType() != DataReplicationOptions.Type.FIRST_IN_TOPOLOGY : false) : (step == Step.REMOTE_REPLICATION_PORTS ? this.isVisible((WizardStep)Step.SUFFIXES_OPTIONS, userData) && userData.getRemoteWithNoReplicationPort().size() > 0 && userData.getSuffixesToReplicateOptions().getType() == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES : true)));
        return isVisible;
    }

    @Override
    public boolean isVisible(WizardStep step, QuickSetup qs) {
        return this.isVisible(step, this.getUserData());
    }

    @Override
    public boolean finishClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep != Step.REVIEW) {
            throw new IllegalStateException("Cannot click on finish when we are not in the Review window");
        }
        this.updateUserDataForReviewPanel(qs);
        qs.launch();
        qs.setCurrentStep(Step.PROGRESS);
        return false;
    }

    @Override
    public void nextClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on next from progress step");
        }
        if (cStep == Step.REVIEW) {
            throw new IllegalStateException("Cannot click on next from review step");
        }
        if (cStep == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on next from finished step");
        }
    }

    @Override
    public void closeClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            if (this.isFinished() || qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_CLOSE_INSTALL_MSG.get(), QuickSetupMessages.INFO_CONFIRM_CLOSE_INSTALL_TITLE.get())) {
                qs.quit();
            }
        } else if (cStep == Step.FINISHED) {
            qs.quit();
        } else {
            throw new IllegalStateException("Close only can be clicked on PROGRESS step");
        }
    }

    @Override
    public boolean isFinished() {
        return this.getCurrentProgressStep() == InstallProgressStep.FINISHED_SUCCESSFULLY || this.getCurrentProgressStep() == InstallProgressStep.FINISHED_CANCELED || this.getCurrentProgressStep() == InstallProgressStep.FINISHED_WITH_ERROR;
    }

    @Override
    public void cancel() {
        this.setCurrentProgressStep(InstallProgressStep.WAITING_TO_CANCEL);
        this.notifyListeners(null);
        this.canceled = true;
    }

    @Override
    public void quitClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.FINISHED) {
            qs.quit();
        } else {
            if (cStep == Step.PROGRESS) {
                throw new IllegalStateException("Cannot click on quit from progress step");
            }
            if (this.installStatus.isInstalled()) {
                qs.quit();
            } else if (qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_QUIT_INSTALL_MSG.get(), QuickSetupMessages.INFO_CONFIRM_QUIT_INSTALL_TITLE.get())) {
                qs.quit();
            }
        }
    }

    @Override
    public ButtonName getInitialFocusButtonName() {
        ButtonName name = null;
        name = !this.installStatus.isInstalled() || this.forceToDisplaySetup ? ButtonName.NEXT : (this.installStatus.canOverwriteCurrentInstall() ? ButtonName.CONTINUE_INSTALL : ButtonName.QUIT);
        return name;
    }

    @Override
    public JPanel createFramePanel(QuickSetupDialog dlg) {
        JPanel p = this.installStatus.isInstalled() && !this.forceToDisplaySetup ? dlg.getInstalledPanel() : super.createFramePanel(dlg);
        return p;
    }

    @Override
    public Set<? extends WizardStep> getWizardSteps() {
        return Collections.unmodifiableSet(new HashSet<WizardStep>(this.lstSteps));
    }

    @Override
    public QuickSetupStepPanel createWizardStepPanel(WizardStep step) {
        QuickSetupStepPanel p = null;
        if (step == Step.WELCOME) {
            p = new InstallWelcomePanel(this);
        } else if (step == Step.SERVER_SETTINGS) {
            p = new ServerSettingsPanel(this);
        } else if (step == Step.REPLICATION_OPTIONS) {
            p = new DataReplicationPanel(this);
        } else if (step == Step.CREATE_GLOBAL_ADMINISTRATOR) {
            p = new GlobalAdministratorPanel(this);
        } else if (step == Step.SUFFIXES_OPTIONS) {
            p = new SuffixesToReplicatePanel(this);
        } else if (step == Step.REMOTE_REPLICATION_PORTS) {
            p = new RemoteReplicationPortsPanel(this);
        } else if (step == Step.NEW_SUFFIX_OPTIONS) {
            p = new DataOptionsPanel(this);
        } else if (step == Step.REVIEW) {
            p = new InstallReviewPanel(this);
        } else if (step == Step.PROGRESS) {
            p = new ProgressPanel(this);
        } else if (step == Step.FINISHED) {
            p = new FinishedPanel(this);
        }
        return p;
    }

    @Override
    public void windowClosing(QuickSetupDialog dlg, WindowEvent evt) {
        if (this.installStatus.isInstalled() && this.forceToDisplaySetup) {
            dlg.notifyButtonEvent(ButtonName.QUIT);
        } else if (dlg.getDisplayedStep() == Step.PROGRESS) {
            dlg.notifyButtonEvent(ButtonName.CLOSE);
        } else {
            dlg.notifyButtonEvent(ButtonName.QUIT);
        }
    }

    @Override
    public Message getCloseButtonToolTip() {
        return QuickSetupMessages.INFO_CLOSE_BUTTON_INSTALL_TOOLTIP.get();
    }

    @Override
    public Message getQuitButtonToolTip() {
        return QuickSetupMessages.INFO_QUIT_BUTTON_INSTALL_TOOLTIP.get();
    }

    @Override
    public Message getFinishButtonToolTip() {
        return QuickSetupMessages.INFO_FINISH_BUTTON_INSTALL_TOOLTIP.get();
    }

    @Override
    public int getExtraDialogHeight() {
        return 75;
    }

    @Override
    public void previousClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.WELCOME) {
            throw new IllegalStateException("Cannot click on previous from progress step");
        }
        if (cStep == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on previous from progress step");
        }
        if (cStep == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on previous from finished step");
        }
    }

    @Override
    public Message getFrameTitle() {
        return QuickSetupMessages.INFO_FRAME_INSTALL_TITLE.get();
    }

    @Override
    public void setWizardDialogState(QuickSetupDialog dlg, UserData userData, WizardStep step) {
        if (!this.installStatus.isInstalled() || this.forceToDisplaySetup) {
            if (step == Step.REVIEW) {
                dlg.setFocusOnButton(ButtonName.FINISH);
                dlg.setDefaultButton(ButtonName.FINISH);
            } else if (step == Step.WELCOME) {
                dlg.setDefaultButton(ButtonName.NEXT);
                dlg.setFocusOnButton(ButtonName.NEXT);
            } else if (step == Step.PROGRESS || step == Step.FINISHED) {
                dlg.setDefaultButton(ButtonName.CLOSE);
                dlg.setFocusOnButton(ButtonName.CLOSE);
            } else {
                dlg.setDefaultButton(ButtonName.NEXT);
            }
        }
    }

    @Override
    public ProgressStep getCurrentProgressStep() {
        return this.currentProgressStep;
    }

    @Override
    public WizardStep getFirstWizardStep() {
        return Step.WELCOME;
    }

    @Override
    public WizardStep getNextWizardStep(WizardStep step) {
        WizardStep next = null;
        if (step == Step.REPLICATION_OPTIONS) {
            if (this.getUserData().mustCreateAdministrator()) {
                next = Step.CREATE_GLOBAL_ADMINISTRATOR;
            } else {
                switch (this.getUserData().getReplicationOptions().getType()) {
                    case FIRST_IN_TOPOLOGY: {
                        next = Step.NEW_SUFFIX_OPTIONS;
                        break;
                    }
                    case STANDALONE: {
                        next = Step.NEW_SUFFIX_OPTIONS;
                        break;
                    }
                    default: {
                        next = Step.SUFFIXES_OPTIONS;
                        break;
                    }
                }
            }
        } else if (step == Step.SUFFIXES_OPTIONS) {
            switch (this.getUserData().getSuffixesToReplicateOptions().getType()) {
                case REPLICATE_WITH_EXISTING_SUFFIXES: {
                    if (this.getUserData().getRemoteWithNoReplicationPort().size() > 0) {
                        next = Step.REMOTE_REPLICATION_PORTS;
                        break;
                    }
                    next = Step.REVIEW;
                    break;
                }
                default: {
                    next = Step.NEW_SUFFIX_OPTIONS;
                    break;
                }
            }
        } else if (step == Step.REMOTE_REPLICATION_PORTS) {
            next = Step.REVIEW;
        } else {
            int i = this.lstSteps.indexOf(step);
            if (i != -1 && i + 1 < this.lstSteps.size()) {
                next = this.lstSteps.get(i + 1);
            }
        }
        if (next != null) {
            this.hmPreviousSteps.put(next, step);
        }
        return next;
    }

    @Override
    public LinkedHashSet<WizardStep> getOrderedSteps() {
        LinkedHashSet<WizardStep> orderedSteps = new LinkedHashSet<WizardStep>();
        orderedSteps.add(Step.WELCOME);
        orderedSteps.add(Step.SERVER_SETTINGS);
        orderedSteps.add(Step.REPLICATION_OPTIONS);
        orderedSteps.add(Step.CREATE_GLOBAL_ADMINISTRATOR);
        orderedSteps.add(Step.SUFFIXES_OPTIONS);
        orderedSteps.add(Step.REMOTE_REPLICATION_PORTS);
        orderedSteps.add(Step.NEW_SUFFIX_OPTIONS);
        orderedSteps.add(Step.REVIEW);
        orderedSteps.add(Step.PROGRESS);
        orderedSteps.add(Step.FINISHED);
        return orderedSteps;
    }

    @Override
    public WizardStep getPreviousWizardStep(WizardStep step) {
        int i;
        WizardStep prev = this.hmPreviousSteps.get(step);
        if (prev == null && (i = this.lstSteps.indexOf(step)) != -1 && i > 0) {
            prev = this.lstSteps.get(i - 1);
        }
        return prev;
    }

    @Override
    public WizardStep getFinishedStep() {
        return Step.FINISHED;
    }

    protected void uninstallServices() {
        if (this.completedProgress.contains(InstallProgressStep.ENABLING_WINDOWS_SERVICE)) {
            try {
                new InstallerHelper().disableWindowsService();
            }
            catch (ApplicationException ae) {
                LOG.log(Level.INFO, "Error disabling Windows service", ae);
            }
        }
        this.unconfigureRemote();
    }

    protected File createTemplateFile() throws ApplicationException {
        try {
            return SetupUtils.createTemplateFile(this.getUserData().getNewSuffixOptions().getBaseDn(), this.getUserData().getNewSuffixOptions().getNumberEntries());
        }
        catch (IOException ioe) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CREATING_TEMP_FILE.get(), ioe);
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.FILE_SYSTEM_ACCESS_ERROR, failedMsg, ioe);
        }
    }

    protected void configureServer() throws ApplicationException {
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CONFIGURING.get()));
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(CONFIG_CLASS_NAME);
        argList.add("-c");
        argList.add(Utils.getPath(this.getInstallation().getCurrentConfigurationFile()));
        argList.add("-p");
        argList.add(String.valueOf(this.getUserData().getServerPort()));
        SecurityOptions sec = this.getUserData().getSecurityOptions();
        if (sec.getEnableSSL()) {
            argList.add("-P");
            argList.add(String.valueOf(sec.getSslPort()));
        }
        if (sec.getEnableStartTLS()) {
            argList.add("-q");
        }
        switch (sec.getCertificateType()) {
            case SELF_SIGNED_CERTIFICATE: {
                argList.add("-k");
                argList.add("cn=JKS,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                break;
            }
            case JKS: {
                argList.add("-k");
                argList.add("cn=JKS,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                argList.add("-m");
                argList.add(sec.getKeystorePath());
                argList.add("-a");
                argList.add(sec.getAliasToUse());
                break;
            }
            case PKCS12: {
                argList.add("-k");
                argList.add("cn=PKCS12,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                argList.add("-m");
                argList.add(sec.getKeystorePath());
                argList.add("-a");
                argList.add(sec.getAliasToUse());
                break;
            }
            case PKCS11: {
                argList.add("-k");
                argList.add("cn=PKCS11,cn=Key Manager Providers,cn=config");
                argList.add("-t");
                argList.add("cn=JKS,cn=Trust Manager Providers,cn=config");
                argList.add("-a");
                argList.add(sec.getAliasToUse());
                break;
            }
            case NO_CERTIFICATE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown certificate type: " + (Object)((Object)sec.getCertificateType()));
            }
        }
        argList.add("-D");
        argList.add(this.getUserData().getDirectoryManagerDn());
        argList.add("-w");
        argList.add(this.getUserData().getDirectoryManagerPwd());
        if (this.createNotReplicatedSuffix()) {
            argList.add("-b");
            argList.add(this.getUserData().getNewSuffixOptions().getBaseDn());
        } else {
            Set<SuffixDescriptor> suffixesToReplicate = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
            for (SuffixDescriptor suffix : suffixesToReplicate) {
                argList.add("-b");
                argList.add(suffix.getDN());
            }
        }
        argList.add("-R");
        argList.add(this.getInstallation().getRootDirectory().getAbsolutePath());
        String[] args = new String[argList.size()];
        argList.toArray(args);
        try {
            InstallerHelper helper = new InstallerHelper();
            int result = helper.invokeConfigureServer(args);
            if (result != 0) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_ERROR_CONFIGURING.get(), null);
            }
        }
        catch (Throwable t) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONFIGURING.get(), t), t);
        }
        try {
            SecurityOptions.CertificateType certType = sec.getCertificateType();
            if (certType != SecurityOptions.CertificateType.NO_CERTIFICATE) {
                this.notifyListeners(this.getLineBreak());
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_UPDATING_CERTIFICATES.get()));
            }
            switch (certType) {
                case NO_CERTIFICATE: {
                    break;
                }
                case SELF_SIGNED_CERTIFICATE: {
                    String pwd = this.getSelfSignedCertificatePwd();
                    CertificateManager certManager = new CertificateManager(this.getSelfSignedKeystorePath(), "JKS", pwd);
                    certManager.generateSelfSignedCertificate(SELF_SIGNED_CERT_ALIAS, this.getSelfSignedCertificateSubjectDN(), this.getSelfSignedCertificateValidity());
                    this.exportCertificate(certManager, SELF_SIGNED_CERT_ALIAS, this.getTemporaryCertificatePath());
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", pwd);
                    trustManager.addCertificate(SELF_SIGNED_CERT_ALIAS, new File(this.getTemporaryCertificatePath()));
                    Utils.createFile(this.getKeystorePinPath(), pwd);
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case JKS: {
                    CertificateManager certManager = new CertificateManager(sec.getKeystorePath(), "JKS", sec.getKeystorePassword());
                    this.exportCertificate(certManager, sec.getAliasToUse(), this.getTemporaryCertificatePath());
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", sec.getKeystorePassword());
                    trustManager.addCertificate(sec.getAliasToUse(), new File(this.getTemporaryCertificatePath()));
                    Utils.createFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case PKCS12: {
                    CertificateManager certManager = new CertificateManager(sec.getKeystorePath(), "PKCS12", sec.getKeystorePassword());
                    this.exportCertificate(certManager, sec.getAliasToUse(), this.getTemporaryCertificatePath());
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", sec.getKeystorePassword());
                    trustManager.addCertificate(sec.getAliasToUse(), new File(this.getTemporaryCertificatePath()));
                    Utils.createFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    File f = new File(this.getTemporaryCertificatePath());
                    f.delete();
                    break;
                }
                case PKCS11: {
                    CertificateManager certManager = new CertificateManager("NONE", "PKCS11", sec.getKeystorePassword());
                    this.exportCertificate(certManager, sec.getAliasToUse(), this.getTemporaryCertificatePath());
                    CertificateManager trustManager = new CertificateManager(this.getTrustManagerPath(), "JKS", sec.getKeystorePassword());
                    trustManager.addCertificate(sec.getAliasToUse(), new File(this.getTemporaryCertificatePath()));
                    Utils.createFile(this.getKeystorePinPath(), sec.getKeystorePassword());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown certificate type: " + (Object)((Object)certType));
                }
            }
            if (certType != SecurityOptions.CertificateType.NO_CERTIFICATE) {
                this.notifyListeners(this.getFormattedDone());
            }
        }
        catch (Throwable t) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONFIGURING_CERTIFICATE.get(), t), t);
        }
    }

    private void createBaseEntry() throws ApplicationException {
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_BASE_ENTRY.get(this.getUserData().getNewSuffixOptions().getBaseDn())));
        InstallerHelper helper = new InstallerHelper();
        String baseDn = this.getUserData().getNewSuffixOptions().getBaseDn();
        File tempFile = helper.createBaseEntryTempFile(baseDn);
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(CONFIG_CLASS_NAME);
        argList.add("-f");
        argList.add(Utils.getPath(this.getInstallation().getCurrentConfigurationFile()));
        argList.add("-n");
        argList.add(this.getBackendName());
        argList.add("-l");
        argList.add(tempFile.getAbsolutePath());
        argList.add("-q");
        String[] args = new String[argList.size()];
        argList.toArray(args);
        try {
            int result = helper.invokeImportLDIF(args);
            if (result != 0) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BASE_ENTRY.get(), null);
            }
        }
        catch (Throwable t) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CREATING_BASE_ENTRY.get(), t), t);
        }
        this.notifyListeners(this.getFormattedDone());
    }

    private void importLDIF() throws ApplicationException {
        MessageBuilder mb = new MessageBuilder();
        mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORTING_LDIF.get(this.getUserData().getNewSuffixOptions().getLDIFPath())));
        mb.append(this.getLineBreak());
        this.notifyListeners(mb.toMessage());
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(CONFIG_CLASS_NAME);
        argList.add("-f");
        argList.add(Utils.getPath(this.getInstallation().getCurrentConfigurationFile()));
        argList.add("-n");
        argList.add(this.getBackendName());
        argList.add("-l");
        argList.add(this.getUserData().getNewSuffixOptions().getLDIFPath());
        String[] args = new String[argList.size()];
        argList.toArray(args);
        try {
            InstallerHelper helper = new InstallerHelper();
            int result = helper.invokeImportLDIF(args);
            if (result != 0) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), null);
            }
        }
        catch (Throwable t) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), t), t);
        }
    }

    private void importAutomaticallyGenerated() throws ApplicationException {
        File templatePath = this.createTemplateFile();
        int nEntries = this.getUserData().getNewSuffixOptions().getNumberEntries();
        MessageBuilder mb = new MessageBuilder();
        mb.append(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_IMPORT_AUTOMATICALLY_GENERATED.get(String.valueOf(nEntries))));
        mb.append(this.getLineBreak());
        this.notifyListeners(mb.toMessage());
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(CONFIG_CLASS_NAME);
        argList.add("-f");
        argList.add(Utils.getPath(this.getInstallation().getCurrentConfigurationFile()));
        argList.add("-n");
        argList.add(this.getBackendName());
        argList.add("-t");
        argList.add(templatePath.getAbsolutePath());
        argList.add("-s");
        argList.add("0");
        String[] args = new String[argList.size()];
        argList.toArray(args);
        try {
            InstallerHelper helper = new InstallerHelper();
            int result = helper.invokeImportLDIF(args);
            if (result != 0) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_ERROR_IMPORT_LDIF_TOOL_RETURN_CODE.get(Integer.toString(result)), null);
            }
        }
        catch (Throwable t) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORT_AUTOMATICALLY_GENERATED.get(Utils.listToString(argList, " "), t.getLocalizedMessage()), t), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unconfigureRemote() {
        InitialContext ctx = null;
        if (this.registeredNewServerOnRemote || this.createdAdministrator || this.createdRemoteAds) {
            DataReplicationOptions repl = this.getUserData().getReplicationOptions();
            AuthenticationData auth = repl.getAuthenticationData();
            String ldapUrl = this.getLdapUrl(auth);
            String dn = auth.getDn();
            String pwd = auth.getPwd();
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_UNCONFIGURING_ADS_ON_REMOTE.get(this.getHostDisplay(auth))));
            try {
                if (auth.useSecureConnection()) {
                    ApplicationTrustManager trustManager = this.getTrustManager();
                    trustManager.setHost(auth.getHostName());
                    ctx = Utils.createLdapsContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, trustManager);
                } else {
                    ctx = Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
                }
                ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
                if (this.createdRemoteAds) {
                    adsContext.removeAdminData();
                } else {
                    block27: {
                        if (this.registeredNewServerOnRemote) {
                            try {
                                adsContext.unregisterServer(this.getNewServerAdsProperties());
                            }
                            catch (ADSContextException ace) {
                                if (ace.getError() == ADSContextException.ErrorType.NOT_YET_REGISTERED) break block27;
                                throw ace;
                            }
                        }
                    }
                    if (this.createdAdministrator) {
                        adsContext.deleteAdministrator(this.getAdministratorProperties());
                    }
                }
                this.notifyListeners(this.getFormattedDone());
                this.notifyListeners(this.getLineBreak());
            }
            catch (Throwable t) {
                this.notifyListeners(this.getFormattedError(t, true));
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        InstallerHelper helper = new InstallerHelper();
        for (ServerDescriptor server : this.hmConfiguredRemoteReplication.keySet()) {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_UNCONFIGURING_REPLICATION_REMOTE.get(server.getHostPort(true))));
            try {
                ctx = this.getRemoteConnection(server, this.getTrustManager());
                helper.unconfigureReplication((InitialLdapContext)ctx, this.hmConfiguredRemoteReplication.get(server), server.getHostPort(true));
            }
            catch (ApplicationException ae) {
                this.notifyListeners(this.getFormattedError(ae, true));
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.notifyListeners(this.getFormattedDone());
            this.notifyListeners(this.getLineBreak());
        }
    }

    protected void configureReplication() throws ApplicationException {
        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CONFIGURING_REPLICATION.get()));
        InstallerHelper helper = new InstallerHelper();
        HashSet<Integer> knownServerIds = new HashSet<Integer>();
        HashSet<Integer> knownReplicationServerIds = new HashSet<Integer>();
        if (this.lastLoadedCache != null) {
            for (SuffixDescriptor suffix : this.lastLoadedCache.getSuffixes()) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    knownServerIds.add(replica.getReplicationId());
                }
            }
            for (ServerDescriptor server : this.lastLoadedCache.getServers()) {
                Object v = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_ID);
                if (v == null) continue;
                knownReplicationServerIds.add((Integer)v);
            }
        } else {
            for (SuffixDescriptor suffix : this.getUserData().getSuffixesToReplicateOptions().getAvailableSuffixes()) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    knownServerIds.add(replica.getReplicationId());
                    Object v = replica.getServer().getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_ID);
                    if (v == null) continue;
                    knownReplicationServerIds.add((Integer)v);
                }
            }
        }
        HashSet<String> dns = new HashSet<String>();
        DataReplicationOptions rep = this.getUserData().getReplicationOptions();
        String newReplicationServer = this.getLocalReplicationServer();
        HashMap<String, Set<String>> replicationServers = new HashMap<String, Set<String>>();
        if (rep.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY) {
            String dn = this.getUserData().getNewSuffixOptions().getBaseDn();
            dns.add(dn);
            HashSet<String> h = new HashSet<String>();
            h.add(newReplicationServer);
            replicationServers.put(dn, h);
        } else {
            Set<SuffixDescriptor> suffixes = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                dns.add(suffix.getDN());
                HashSet<String> h = new HashSet<String>();
                h.addAll(suffix.getReplicationServers());
                h.add(newReplicationServer);
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    ServerDescriptor server = replica.getServer();
                    Integer replicationPort = this.getUserData().getRemoteWithNoReplicationPort().get(server);
                    if (replicationPort == null) continue;
                    h.add(server.getHostName() + ":" + replicationPort);
                }
                replicationServers.put(suffix.getDN(), h);
            }
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLocalContext();
            helper.configureReplication(ctx, dns, replicationServers, this.getUserData().getReplicationOptions().getReplicationPort(), this.getLocalHostPort(), knownReplicationServerIds, knownServerIds);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (NamingException ne) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), ne);
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, failedMsg, ne);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t) {}
        }
        this.notifyListeners(this.getFormattedDone());
        this.notifyListeners(this.getLineBreak());
        this.checkAbort();
        if (rep.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY) {
            HashMap<ServerDescriptor, HashSet<ReplicaDescriptor>> hm = new HashMap<ServerDescriptor, HashSet<ReplicaDescriptor>>();
            for (SuffixDescriptor suffix : this.getUserData().getSuffixesToReplicateOptions().getSuffixes()) {
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    HashSet<ReplicaDescriptor> replicas = (HashSet<ReplicaDescriptor>)hm.get(replica.getServer());
                    if (replicas == null) {
                        replicas = new HashSet<ReplicaDescriptor>();
                        hm.put(replica.getServer(), replicas);
                    }
                    replicas.add(replica);
                }
            }
            for (ServerDescriptor server : hm.keySet()) {
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CONFIGURING_REPLICATION_REMOTE.get(server.getHostPort(true))));
                Integer v = (Integer)server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_PORT);
                int replicationPort = v != null ? v.intValue() : this.getUserData().getRemoteWithNoReplicationPort().get(server).intValue();
                dns = new HashSet();
                for (ReplicaDescriptor replica : (Set)hm.get(server)) {
                    dns.add(replica.getSuffix().getDN());
                }
                ctx = this.getRemoteConnection(server, this.getTrustManager());
                ConfiguredReplication repl = helper.configureReplication(ctx, dns, replicationServers, replicationPort, server.getHostPort(true), knownReplicationServerIds, knownServerIds);
                this.hmConfiguredRemoteReplication.put(server, repl);
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.notifyListeners(this.getFormattedDone());
                this.notifyListeners(this.getLineBreak());
                this.checkAbort();
            }
        }
    }

    protected void enableWindowsService() throws ApplicationException {
        this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_ENABLING_WINDOWS_SERVICE.get()));
        InstallerHelper helper = new InstallerHelper();
        helper.enableWindowsService();
    }

    protected void initSummaryMap(Map<InstallProgressStep, Message> hmSummary) {
        hmSummary.put(InstallProgressStep.NOT_STARTED, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_INSTALL_NOT_STARTED.get()));
        hmSummary.put(InstallProgressStep.DOWNLOADING, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_DOWNLOADING.get()));
        hmSummary.put(InstallProgressStep.EXTRACTING, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_EXTRACTING.get()));
        hmSummary.put(InstallProgressStep.CONFIGURING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CONFIGURING.get()));
        hmSummary.put(InstallProgressStep.CREATING_BASE_ENTRY, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CREATING_BASE_ENTRY.get()));
        hmSummary.put(InstallProgressStep.IMPORTING_LDIF, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_IMPORTING_LDIF.get()));
        hmSummary.put(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_IMPORTING_AUTOMATICALLY_GENERATED.get()));
        hmSummary.put(InstallProgressStep.CONFIGURING_REPLICATION, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CONFIGURING_REPLICATION.get()));
        hmSummary.put(InstallProgressStep.STARTING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()));
        hmSummary.put(InstallProgressStep.STOPPING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()));
        hmSummary.put(InstallProgressStep.CONFIGURING_ADS, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CONFIGURING_ADS.get()));
        hmSummary.put(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_INITIALIZE_REPLICATED_SUFFIXES.get()));
        hmSummary.put(InstallProgressStep.ENABLING_WINDOWS_SERVICE, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_ENABLING_WINDOWS_SERVICE.get()));
        hmSummary.put(InstallProgressStep.WAITING_TO_CANCEL, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_WAITING_TO_CANCEL.get()));
        hmSummary.put(InstallProgressStep.CANCELING, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_CANCELING.get()));
        Installation installation = this.getInstallation();
        String cmd = Utils.getPath(installation.getStatusPanelCommandFile());
        cmd = UIFactory.applyFontToHtml(cmd, UIFactory.INSTRUCTIONS_MONOSPACE_FONT);
        hmSummary.put(InstallProgressStep.FINISHED_SUCCESSFULLY, this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_SUCCESSFULLY.get(this.formatter.getFormattedText(Message.raw(this.getInstallationPath(), new Object[0])), QuickSetupMessages.INFO_GENERAL_SERVER_STOPPED.get(), cmd)));
        hmSummary.put(InstallProgressStep.FINISHED_CANCELED, this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_CANCELED.get()));
        hmSummary.put(InstallProgressStep.FINISHED_WITH_ERROR, this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_WITH_ERROR.get(QuickSetupMessages.INFO_GENERAL_SERVER_STOPPED.get(), cmd)));
    }

    protected void updateSummaryWithServerState(Map<InstallProgressStep, Message> hmSummary) {
        Installation installation = this.getInstallation();
        String cmd = Utils.getPath(installation.getStatusPanelCommandFile());
        cmd = UIFactory.applyFontToHtml(cmd, UIFactory.INSTRUCTIONS_MONOSPACE_FONT);
        Message status = installation.getStatus().isServerRunning() ? QuickSetupMessages.INFO_GENERAL_SERVER_STARTED.get() : QuickSetupMessages.INFO_GENERAL_SERVER_STOPPED.get();
        hmSummary.put(InstallProgressStep.FINISHED_SUCCESSFULLY, this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_SUCCESSFULLY.get(this.formatter.getFormattedText(Message.raw(this.getInstallationPath(), new Object[0])), status, cmd)));
        hmSummary.put(InstallProgressStep.FINISHED_WITH_ERROR, this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_INSTALL_FINISHED_WITH_ERROR.get(status, cmd)));
    }

    protected void checkAbort() throws ApplicationException {
        if (this.canceled) {
            this.setCurrentProgressStep(InstallProgressStep.CANCELING);
            this.notifyListeners(null);
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CANCELLED, QuickSetupMessages.INFO_UPGRADE_CANCELED.get(), null);
        }
    }

    protected void writeJavaHome() {
        try {
            SetupUtils.writeSetJavaHome(this.getInstallationPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateUserData(WizardStep cStep, QuickSetup qs) throws UserDataException {
        if (cStep == Step.SERVER_SETTINGS) {
            this.updateUserDataForServerSettingsPanel(qs);
        } else if (cStep == Step.REPLICATION_OPTIONS) {
            this.updateUserDataForReplicationOptionsPanel(qs);
        } else if (cStep == Step.CREATE_GLOBAL_ADMINISTRATOR) {
            this.updateUserDataForCreateAdministratorPanel(qs);
        } else if (cStep == Step.SUFFIXES_OPTIONS) {
            this.updateUserDataForSuffixesOptionsPanel(qs);
        } else if (cStep == Step.REMOTE_REPLICATION_PORTS) {
            this.updateUserDataForRemoteReplicationPorts(qs);
        } else if (cStep == Step.NEW_SUFFIX_OPTIONS) {
            this.updateUserDataForNewSuffixOptionsPanel(qs);
        } else if (cStep == Step.REVIEW) {
            this.updateUserDataForReviewPanel(qs);
        }
    }

    protected String getBackendName() {
        return "userRoot";
    }

    protected void setCurrentProgressStep(InstallProgressStep currentProgressStep) {
        if (currentProgressStep != null) {
            this.completedProgress.add(currentProgressStep);
        }
        this.currentProgressStep = currentProgressStep;
    }

    protected void createData() throws ApplicationException {
        if (this.createNotReplicatedSuffix()) {
            switch (this.getUserData().getNewSuffixOptions().getType()) {
                case CREATE_BASE_ENTRY: {
                    this.currentProgressStep = InstallProgressStep.CREATING_BASE_ENTRY;
                    this.notifyListeners(this.getTaskSeparator());
                    this.createBaseEntry();
                    break;
                }
                case IMPORT_FROM_LDIF_FILE: {
                    this.currentProgressStep = InstallProgressStep.IMPORTING_LDIF;
                    this.notifyListeners(this.getTaskSeparator());
                    this.importLDIF();
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    this.currentProgressStep = InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED;
                    this.notifyListeners(this.getTaskSeparator());
                    this.importAutomaticallyGenerated();
                }
            }
        }
    }

    protected void initializeSuffixes() throws ApplicationException {
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLocalContext();
        }
        catch (Throwable t) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), t);
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t1) {
                // empty catch block
            }
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, failedMsg, t);
        }
        Set<SuffixDescriptor> suffixes = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
        int i = 0;
        for (SuffixDescriptor suffix : suffixes) {
            String dn = suffix.getDN();
            ReplicaDescriptor replica = suffix.getReplicas().iterator().next();
            ServerDescriptor server = replica.getServer();
            String hostPort = server.getHostPort(true);
            this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(dn, hostPort)));
            this.notifyListeners(this.getLineBreak());
            try {
                int replicationId = replica.getReplicationId();
                if (replicationId == -1) {
                    InitialContext rCtx = null;
                    try {
                        rCtx = this.getRemoteConnection(server, this.getTrustManager());
                        ServerDescriptor s = ServerDescriptor.createStandalone((InitialLdapContext)rCtx);
                        for (ReplicaDescriptor r : s.getReplicas()) {
                            if (!Utils.areDnsEqual(r.getSuffix().getDN(), dn)) continue;
                            replicationId = r.getReplicationId();
                        }
                    }
                    catch (NamingException ne) {
                        throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(server.getHostPort(true), ne.getLocalizedMessage()), ne);
                    }
                    finally {
                        try {
                            rCtx.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                int nTries = 5;
                boolean initDone = false;
                while (!initDone) {
                    try {
                        this.initializeSuffix(ctx, replicationId, dn, true, hostPort);
                        initDone = true;
                    }
                    catch (PeerNotFoundException pnfe) {
                        LOG.log(Level.INFO, "Peer could not be found");
                        if (nTries == 1) {
                            throw new ApplicationException(ApplicationReturnCode.ReturnCode.APPLICATION_ERROR, pnfe.getMessageObject(), null);
                        }
                        try {
                            Thread.sleep((5 - nTries) * 3000);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    --nTries;
                }
            }
            catch (ApplicationException ae) {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Throwable t1) {
                    // empty catch block
                }
                throw ae;
            }
            if (i > 0) {
                this.notifyListeners(this.getLineBreak());
            }
            ++i;
            this.checkAbort();
        }
    }

    protected void updateADS() throws ApplicationException {
        DataReplicationOptions repl = this.getUserData().getReplicationOptions();
        boolean remoteServer = repl.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY;
        InitialContext localCtx = null;
        if (remoteServer) {
            AuthenticationData auth = repl.getAuthenticationData();
            String ldapUrl = this.getLdapUrl(auth);
            String dn = auth.getDn();
            String pwd = auth.getPwd();
            InitialContext ctx = null;
            try {
                if (auth.useSecureConnection()) {
                    ApplicationTrustManager trustManager = this.getTrustManager();
                    trustManager.setHost(auth.getHostName());
                    ctx = Utils.createLdapsContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, trustManager);
                } else {
                    ctx = Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
                }
                ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
                if (adsContext.hasAdminData()) {
                    if (this.getUserData().mustCreateAdministrator()) {
                        try {
                            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADMINISTRATOR.get()));
                            adsContext.createAdministrator(this.getAdministratorProperties());
                            this.createdAdministrator = true;
                            this.notifyListeners(this.getFormattedDone());
                            this.notifyListeners(this.getLineBreak());
                            this.checkAbort();
                        }
                        catch (ADSContextException ade) {
                            if (ade.getError() == ADSContextException.ErrorType.ALREADY_REGISTERED) {
                                this.notifyListeners(this.getFormattedWarning(QuickSetupMessages.INFO_ADMINISTRATOR_ALREADY_REGISTERED.get()));
                            }
                            throw ade;
                        }
                    }
                } else {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADS_ON_REMOTE.get(this.getHostDisplay(auth))));
                    adsContext.createAdminData(null);
                    adsContext.createAdministrator(this.getAdministratorProperties());
                    adsContext.registerServer(this.getRemoteServerProperties(auth.getHostName(), adsContext.getDirContext()));
                    this.createdRemoteAds = true;
                    this.notifyListeners(this.getFormattedDone());
                    this.notifyListeners(this.getLineBreak());
                    this.checkAbort();
                }
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADS.get()));
                try {
                    localCtx = this.createLocalContext();
                }
                catch (Throwable t) {
                    Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), t);
                    throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, failedMsg, t);
                }
                try {
                    ADSContext localAdsContext = new ADSContext((InitialLdapContext)localCtx);
                    localAdsContext.createAdministrationSuffix(null);
                }
                catch (ADSContextException ace) {
                    throw ace;
                }
                catch (Throwable t) {
                    throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
                }
                this.notifyListeners(this.getFormattedDone());
                this.notifyListeners(this.getLineBreak());
                this.checkAbort();
                this.lastLoadedCache = new TopologyCache(adsContext, this.getTrustManager());
                this.lastLoadedCache.reloadTopology();
                HashSet<Integer> knownServerIds = new HashSet<Integer>();
                HashSet<Integer> knownReplicationServerIds = new HashSet<Integer>();
                HashSet<String> replicationServers = new HashSet<String>();
                replicationServers.add(this.getLocalReplicationServer());
                HashSet<ServerDescriptor> remoteWithAds = new HashSet<ServerDescriptor>();
                for (SuffixDescriptor suffix : this.lastLoadedCache.getSuffixes()) {
                    for (ReplicaDescriptor replica : suffix.getReplicas()) {
                        knownServerIds.add(replica.getReplicationId());
                    }
                    if (!Utils.areDnsEqual(suffix.getDN(), ADSContext.getAdministrationSuffixDN())) continue;
                    replicationServers.addAll(suffix.getReplicationServers());
                    for (ReplicaDescriptor replica : suffix.getReplicas()) {
                        ServerDescriptor server = replica.getServer();
                        Object e = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.IS_REPLICATION_SERVER);
                        if (Boolean.TRUE.equals(e)) {
                            replicationServers.add(server.getHostName() + ":" + server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_PORT));
                        }
                        remoteWithAds.add(server);
                    }
                }
                for (ServerDescriptor server : this.lastLoadedCache.getServers()) {
                    Object v = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_ID);
                    if (v == null) continue;
                    knownReplicationServerIds.add((Integer)v);
                }
                InstallerHelper helper = new InstallerHelper();
                HashSet<String> dns = new HashSet<String>();
                dns.add(ADSContext.getAdministrationSuffixDN());
                HashMap<String, Set<String>> hmRepServers = new HashMap<String, Set<String>>();
                hmRepServers.put(ADSContext.getAdministrationSuffixDN(), replicationServers);
                for (ServerDescriptor server : remoteWithAds) {
                    Integer replicationPort = (Integer)server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.REPLICATION_SERVER_PORT);
                    if (replicationPort == null) continue;
                    InitialLdapContext rCtx = this.getRemoteConnection(server, this.getTrustManager());
                    helper.configureReplication(rCtx, dns, hmRepServers, replicationPort, server.getHostPort(true), knownReplicationServerIds, knownServerIds);
                    try {
                        rCtx.close();
                    }
                    catch (Throwable t) {}
                }
                if (0 != adsContext.registerOrUpdateServer(this.getNewServerAdsProperties())) {
                    LOG.log(Level.WARNING, "Server was already registered. Updating server registration.");
                }
                this.registeredNewServerOnRemote = true;
                helper.configureReplication((InitialLdapContext)localCtx, dns, hmRepServers, this.getUserData().getReplicationOptions().getReplicationPort(), this.getLocalHostPort(), knownReplicationServerIds, knownServerIds);
                ServerDescriptor server = ServerDescriptor.createStandalone((InitialLdapContext)ctx);
                for (ReplicaDescriptor replica : server.getReplicas()) {
                    if (!Utils.areDnsEqual(replica.getSuffix().getDN(), ADSContext.getAdministrationSuffixDN())) continue;
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_ADS.get()));
                    int replicationId = replica.getReplicationId();
                    int nTries = 5;
                    boolean initDone = false;
                    while (!initDone) {
                        try {
                            this.initializeSuffix((InitialLdapContext)localCtx, replicationId, ADSContext.getAdministrationSuffixDN(), false, server.getHostPort(true));
                            initDone = true;
                        }
                        catch (PeerNotFoundException pnfe) {
                            LOG.log(Level.INFO, "Peer could not be found");
                            if (nTries == 1) {
                                throw new ApplicationException(ApplicationReturnCode.ReturnCode.APPLICATION_ERROR, pnfe.getMessageObject(), null);
                            }
                            try {
                                Thread.sleep((5 - nTries) * 3000);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        --nTries;
                    }
                    this.notifyListeners(this.getFormattedDone());
                    this.notifyListeners(this.getLineBreak());
                    this.checkAbort();
                }
            }
            catch (NoPermissionException x) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_PERMISSIONS.get(this.getHostDisplay(auth)), x);
            }
            catch (NamingException ne) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(this.getHostDisplay(auth), ne.getLocalizedMessage()), ne);
            }
            catch (TopologyCacheException tpe) {
                LOG.log(Level.WARNING, "Error reloading topology cache to configure ADS replication.", tpe);
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_BUG_MSG.get(), tpe);
            }
            catch (ADSContextException ace) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_REMOTE_ADS_EXCEPTION.get(this.getHostDisplay(auth), ace.getReason()), ace);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
                if (localCtx != null) {
                    try {
                        localCtx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        } else {
            try {
                this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_ADS.get()));
                try {
                    localCtx = this.createLocalContext();
                }
                catch (Throwable t) {
                    Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), t);
                    throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, failedMsg, t);
                }
                try {
                    ADSContext localAdsContext = new ADSContext((InitialLdapContext)localCtx);
                    localAdsContext.createAdminData(null);
                    localAdsContext.registerServer(this.getNewServerAdsProperties());
                    if (this.getUserData().mustCreateAdministrator()) {
                        localAdsContext.createAdministrator(this.getAdministratorProperties());
                    }
                }
                catch (ADSContextException ace) {
                    throw ace;
                }
                catch (Throwable t) {
                    throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
                }
                int replicationPort = this.getUserData().getReplicationOptions().getReplicationPort();
                HashSet<String> dns = new HashSet<String>();
                dns.add(ADSContext.getAdministrationSuffixDN());
                HashMap<String, Set<String>> hmReplicationServers = new HashMap<String, Set<String>>();
                HashSet<String> replicationServers = new HashSet<String>();
                String newReplicationServer = this.getLocalReplicationServer();
                replicationServers.add(newReplicationServer);
                hmReplicationServers.put(ADSContext.getAdministrationSuffixDN(), replicationServers);
                InstallerHelper helper = new InstallerHelper();
                helper.configureReplication((InitialLdapContext)localCtx, dns, hmReplicationServers, replicationPort, this.getLocalHostPort(), new HashSet<Integer>(), new HashSet<Integer>());
                this.notifyListeners(this.getFormattedDone());
                this.notifyListeners(this.getLineBreak());
            }
            catch (ADSContextException ace) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_ADS_EXCEPTION.get(ace.toString()), ace);
            }
            finally {
                if (localCtx != null) {
                    try {
                        localCtx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    protected boolean createNotReplicatedSuffix() {
        DataReplicationOptions repl = this.getUserData().getReplicationOptions();
        SuffixesToReplicateOptions suf = this.getUserData().getSuffixesToReplicateOptions();
        boolean createSuffix = repl.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY || repl.getType() == DataReplicationOptions.Type.STANDALONE || suf.getType() == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        return createSuffix;
    }

    protected boolean mustConfigureReplication() {
        return this.getUserData().getReplicationOptions().getType() != DataReplicationOptions.Type.STANDALONE;
    }

    protected boolean mustCreateAds() {
        return this.getUserData().getReplicationOptions().getType() != DataReplicationOptions.Type.STANDALONE;
    }

    protected boolean mustStart() {
        return this.getUserData().getStartServer() || this.mustCreateAds();
    }

    protected boolean mustStop() {
        return !this.getUserData().getStartServer() && this.mustCreateAds();
    }

    protected boolean mustInitializeSuffixes() {
        return this.getUserData().getReplicationOptions().getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY;
    }

    private String getLdapUrl(AuthenticationData auth) {
        String ldapUrl = auth.useSecureConnection() ? "ldaps://" + auth.getHostName() + ":" + auth.getPort() : "ldap://" + auth.getHostName() + ":" + auth.getPort();
        return ldapUrl;
    }

    private String getHostDisplay(AuthenticationData auth) {
        return auth.getHostName() + ":" + auth.getPort();
    }

    private Map<ADSContext.ServerProperty, Object> getNewServerAdsProperties() {
        HashMap<ADSContext.ServerProperty, Object> serverProperties = new HashMap<ADSContext.ServerProperty, Object>();
        serverProperties.put(ADSContext.ServerProperty.HOST_NAME, this.getUserData().getHostName());
        serverProperties.put(ADSContext.ServerProperty.LDAP_PORT, String.valueOf(this.getUserData().getServerPort()));
        serverProperties.put(ADSContext.ServerProperty.LDAP_ENABLED, "true");
        SecurityOptions sec = this.getUserData().getSecurityOptions();
        if (sec.getEnableSSL()) {
            serverProperties.put(ADSContext.ServerProperty.LDAPS_PORT, String.valueOf(sec.getSslPort()));
            serverProperties.put(ADSContext.ServerProperty.LDAPS_ENABLED, "true");
        } else {
            serverProperties.put(ADSContext.ServerProperty.LDAPS_PORT, "636");
            serverProperties.put(ADSContext.ServerProperty.LDAPS_ENABLED, "false");
        }
        if (sec.getEnableStartTLS()) {
            serverProperties.put(ADSContext.ServerProperty.STARTTLS_ENABLED, "true");
        } else {
            serverProperties.put(ADSContext.ServerProperty.STARTTLS_ENABLED, "false");
        }
        serverProperties.put(ADSContext.ServerProperty.JMX_PORT, "1689");
        serverProperties.put(ADSContext.ServerProperty.JMX_ENABLED, "false");
        String path = Utils.isWebStart() ? this.getUserData().getServerLocation() : Utils.getInstallPathFromClasspath();
        serverProperties.put(ADSContext.ServerProperty.INSTANCE_PATH, path);
        String serverID = serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME) + ":" + this.getUserData().getServerPort();
        serverProperties.put(ADSContext.ServerProperty.ID, serverID);
        serverProperties.put(ADSContext.ServerProperty.HOST_OS, Utils.getOSString());
        return serverProperties;
    }

    private Map<ADSContext.AdministratorProperty, Object> getAdministratorProperties() {
        HashMap<ADSContext.AdministratorProperty, Object> adminProperties = new HashMap<ADSContext.AdministratorProperty, Object>();
        adminProperties.put(ADSContext.AdministratorProperty.UID, this.getUserData().getGlobalAdministratorUID());
        adminProperties.put(ADSContext.AdministratorProperty.PASSWORD, this.getUserData().getGlobalAdministratorPassword());
        adminProperties.put(ADSContext.AdministratorProperty.DESCRIPTION, QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_DESCRIPTION.get().toString());
        return adminProperties;
    }

    private void updateUserDataForServerSettingsPanel(QuickSetup qs) throws UserDataException {
        int defaultJMXPort;
        String hostName;
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        Message confirmationMsg = null;
        if (Utils.isWebStart()) {
            String serverLocation = qs.getFieldStringValue(FieldName.SERVER_LOCATION);
            if (serverLocation == null || "".equals(serverLocation.trim())) {
                errorMsgs.add(QuickSetupMessages.INFO_EMPTY_SERVER_LOCATION.get());
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (!Utils.parentDirectoryExists(serverLocation)) {
                String existingParentDirectory = null;
                File f = new File(serverLocation);
                while (existingParentDirectory == null && f != null) {
                    if ((f = f.getParentFile()) == null || !f.exists()) continue;
                    if (f.isDirectory()) {
                        existingParentDirectory = f.getAbsolutePath();
                        continue;
                    }
                    f = null;
                }
                if (existingParentDirectory == null) {
                    errorMsgs.add(QuickSetupMessages.INFO_PARENT_DIRECTORY_COULD_NOT_BE_FOUND.get(serverLocation));
                    qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
                } else if (!Utils.canWrite(existingParentDirectory)) {
                    errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_NOT_WRITABLE.get(existingParentDirectory));
                    qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
                } else if (!Utils.hasEnoughSpace(existingParentDirectory, this.getRequiredInstallSpace())) {
                    long requiredInMb = this.getRequiredInstallSpace() / 0x100000L;
                    errorMsgs.add(QuickSetupMessages.INFO_NOT_ENOUGH_DISK_SPACE.get(existingParentDirectory, String.valueOf(requiredInMb)));
                    qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
                } else {
                    confirmationMsg = QuickSetupMessages.INFO_PARENT_DIRECTORY_DOES_NOT_EXIST_CONFIRMATION.get(serverLocation);
                    this.getUserData().setServerLocation(serverLocation);
                }
            } else if (Utils.fileExists(serverLocation)) {
                errorMsgs.add(QuickSetupMessages.INFO_FILE_EXISTS.get(serverLocation));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (Utils.directoryExistsAndIsNotEmpty(serverLocation)) {
                errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_EXISTS_NOT_EMPTY.get(serverLocation));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (!Utils.canWrite(serverLocation)) {
                errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_NOT_WRITABLE.get(serverLocation));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (!Utils.hasEnoughSpace(serverLocation, this.getRequiredInstallSpace())) {
                long requiredInMb = this.getRequiredInstallSpace() / 0x100000L;
                errorMsgs.add(QuickSetupMessages.INFO_NOT_ENOUGH_DISK_SPACE.get(serverLocation, String.valueOf(requiredInMb)));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else if (Utils.isWindows() && serverLocation.indexOf("%") != -1) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_CHAR_IN_PATH.get("%"));
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, true);
            } else {
                this.getUserData().setServerLocation(serverLocation);
                qs.displayFieldInvalid(FieldName.SERVER_LOCATION, false);
            }
        }
        if ((hostName = qs.getFieldStringValue(FieldName.HOST_NAME)) == null || hostName.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_HOST_NAME.get());
            qs.displayFieldInvalid(FieldName.HOST_NAME, true);
        } else {
            qs.displayFieldInvalid(FieldName.HOST_NAME, false);
            this.getUserData().setHostName(hostName);
        }
        String sPort = qs.getFieldStringValue(FieldName.SERVER_PORT);
        int port = -1;
        try {
            port = Integer.parseInt(sPort);
            if (port < 1 || port > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else if (!Utils.canUseAsPort(port)) {
                if (Utils.isPriviledgedPort(port)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(port)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(port)));
                }
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else {
                this.getUserData().setServerPort(port);
                qs.displayFieldInvalid(FieldName.SERVER_PORT, false);
            }
        }
        catch (NumberFormatException nfe) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
            qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
        }
        SecurityOptions sec = (SecurityOptions)qs.getFieldValue(FieldName.SECURITY_OPTIONS);
        int securePort = sec.getSslPort();
        if (sec.getEnableSSL()) {
            if (securePort < 1 || securePort > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_SECURE_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
            } else if (!Utils.canUseAsPort(securePort)) {
                if (Utils.isPriviledgedPort(securePort)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(securePort)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(securePort)));
                }
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
            } else if (port == securePort) {
                errorMsgs.add(QuickSetupMessages.INFO_EQUAL_PORTS.get());
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, true);
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else {
                this.getUserData().setSecurityOptions(sec);
                qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, false);
            }
        } else {
            this.getUserData().setSecurityOptions(sec);
            qs.displayFieldInvalid(FieldName.SECURITY_OPTIONS, false);
        }
        String dmDn = qs.getFieldStringValue(FieldName.DIRECTORY_MANAGER_DN);
        if (dmDn == null || dmDn.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_DIRECTORY_MANAGER_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, true);
        } else if (!Utils.isDn(dmDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, true);
        } else if (Utils.isConfigurationDn(dmDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_DIRECTORY_MANAGER_DN_IS_CONFIG_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, true);
        } else {
            this.getUserData().setDirectoryManagerDn(dmDn);
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_DN, false);
        }
        String pwd1 = qs.getFieldStringValue(FieldName.DIRECTORY_MANAGER_PWD);
        String pwd2 = qs.getFieldStringValue(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM);
        if (pwd1 == null) {
            pwd1 = "";
        }
        boolean pwdValid = true;
        if (!pwd1.equals(pwd2)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_EQUAL_PWD.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, true);
            pwdValid = false;
        }
        if (pwd1.length() < 1) {
            errorMsgs.add(QuickSetupMessages.INFO_PWD_TOO_SHORT.get(String.valueOf(1)));
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD, true);
            if (pwd2 == null || pwd2.length() < 1) {
                qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, true);
            }
            pwdValid = false;
        }
        if (pwdValid) {
            this.getUserData().setDirectoryManagerPwd(pwd1);
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD, false);
            qs.displayFieldInvalid(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, false);
        }
        if ((defaultJMXPort = UserData.getDefaultJMXPort(new int[]{port, securePort})) != -1) {
            this.getUserData().setServerJMXPort(-1);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.SERVER_SETTINGS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
        if (confirmationMsg != null) {
            throw new UserDataConfirmationException(Step.SERVER_SETTINGS, confirmationMsg);
        }
    }

    private void updateUserDataForReplicationOptionsPanel(QuickSetup qs) throws UserDataException {
        boolean hasGlobalAdministrators = false;
        Integer replicationPort = -1;
        String host = null;
        Integer port = null;
        String dn = null;
        String pwd = null;
        boolean isSecure = Boolean.TRUE.equals(qs.getFieldValue(FieldName.REMOTE_SERVER_IS_SECURE_PORT));
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        DataReplicationOptions.Type type = (DataReplicationOptions.Type)((Object)qs.getFieldValue(FieldName.REPLICATION_OPTIONS));
        host = qs.getFieldStringValue(FieldName.REMOTE_SERVER_HOST);
        dn = qs.getFieldStringValue(FieldName.REMOTE_SERVER_DN);
        pwd = qs.getFieldStringValue(FieldName.REMOTE_SERVER_PWD);
        if (type != DataReplicationOptions.Type.STANDALONE) {
            replicationPort = this.checkReplicationPort(qs, errorMsgs);
        }
        UserDataConfirmationException confirmEx = null;
        switch (type) {
            case IN_EXISTING_TOPOLOGY: {
                String sPort = qs.getFieldStringValue(FieldName.REMOTE_SERVER_PORT);
                this.checkRemoteHostPortDnAndPwd(host, sPort, dn, pwd, qs, errorMsgs);
                if (errorMsgs.size() != 0) break;
                port = Integer.parseInt(sPort);
                boolean[] globalAdmin = new boolean[]{hasGlobalAdministrators};
                String[] effectiveDn = new String[]{dn};
                try {
                    this.updateUserDataWithADS(host, port, dn, pwd, qs, errorMsgs, globalAdmin, effectiveDn);
                }
                catch (UserDataConfirmationException e) {
                    confirmEx = e;
                }
                hasGlobalAdministrators = globalAdmin[0];
                dn = effectiveDn[0];
                break;
            }
            case STANDALONE: {
                this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.NO_SUFFIX_TO_REPLICATE, new HashSet(), new HashSet()));
                break;
            }
            case FIRST_IN_TOPOLOGY: {
                this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY, new HashSet(), new HashSet()));
                break;
            }
            default: {
                throw new IllegalStateException("Do not know what to do with type: " + (Object)((Object)type));
            }
        }
        if (errorMsgs.size() == 0) {
            AuthenticationData auth = new AuthenticationData();
            auth.setHostName(host);
            if (port != null) {
                auth.setPort(port);
            }
            auth.setDn(dn);
            auth.setPwd(pwd);
            auth.setUseSecureConnection(isSecure);
            DataReplicationOptions repl = new DataReplicationOptions(type, auth, replicationPort);
            this.getUserData().setReplicationOptions(repl);
            this.getUserData().createAdministrator(!hasGlobalAdministrators && type == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.REPLICATION_OPTIONS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
        if (confirmEx != null) {
            throw confirmEx;
        }
    }

    private int checkReplicationPort(QuickSetup qs, ArrayList<Message> errorMsgs) {
        int replicationPort = -1;
        String sPort = qs.getFieldStringValue(FieldName.REPLICATION_PORT);
        try {
            replicationPort = Integer.parseInt(sPort);
            if (replicationPort < 1 || replicationPort > 65535) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_REPLICATION_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                qs.displayFieldInvalid(FieldName.SERVER_PORT, true);
            } else if (!Utils.canUseAsPort(replicationPort)) {
                if (Utils.isPriviledgedPort(replicationPort)) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(replicationPort)));
                } else {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(replicationPort)));
                }
                qs.displayFieldInvalid(FieldName.REPLICATION_PORT, true);
            } else {
                SecurityOptions sec = this.getUserData().getSecurityOptions();
                if (replicationPort == this.getUserData().getServerPort() || replicationPort == this.getUserData().getServerJMXPort() || replicationPort == sec.getSslPort() && sec.getEnableSSL()) {
                    errorMsgs.add(QuickSetupMessages.INFO_REPLICATION_PORT_ALREADY_CHOSEN_FOR_OTHER_PROTOCOL.get());
                    qs.displayFieldInvalid(FieldName.REPLICATION_PORT, true);
                } else {
                    qs.displayFieldInvalid(FieldName.REPLICATION_PORT, false);
                }
            }
        }
        catch (NumberFormatException nfe) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_REPLICATION_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
            qs.displayFieldInvalid(FieldName.REPLICATION_PORT, true);
        }
        return replicationPort;
    }

    private void checkRemoteHostPortDnAndPwd(String host, String sPort, String dn, String pwd, QuickSetup qs, ArrayList<Message> errorMsgs) {
        if (host == null || host.length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_REMOTE_HOST.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, true);
        } else {
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, false);
        }
        try {
            Integer.parseInt(sPort);
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, false);
        }
        catch (Throwable t) {
            errorMsgs.add(QuickSetupMessages.INFO_INVALID_REMOTE_PORT.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, true);
        }
        if (dn == null || dn.length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_REMOTE_DN.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
        } else {
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, false);
        }
        if (pwd == null || pwd.length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_REMOTE_PWD.get());
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
        } else {
            qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDataWithADS(String host, int port, String dn, String pwd, QuickSetup qs, ArrayList<Message> errorMsgs, boolean[] hasGlobalAdministrators, String[] effectiveDn) throws UserDataException {
        block32: {
            host = Utils.getHostNameForLdapUrl(host);
            boolean isSecure = Boolean.TRUE.equals(qs.getFieldValue(FieldName.REMOTE_SERVER_IS_SECURE_PORT));
            String ldapUrl = isSecure ? "ldaps://" + host + ":" + port : "ldap://" + host + ":" + port;
            InitialContext ctx = null;
            ApplicationTrustManager trustManager = this.getTrustManager();
            trustManager.setHost(host);
            trustManager.resetLastRefusedItems();
            try {
                effectiveDn[0] = dn;
                try {
                    ctx = isSecure ? Utils.createLdapsContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, trustManager) : Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
                }
                catch (Throwable t) {
                    if (!Utils.isCertificateException(t)) {
                        effectiveDn[0] = dn = ADSContext.getAdministratorDN(dn);
                        ctx = isSecure ? Utils.createLdapsContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, trustManager) : Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
                    }
                    throw t;
                }
                ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
                if (adsContext.hasAdminData()) {
                    Set<Map<ADSContext.AdministratorProperty, Object>> administrators = adsContext.readAdministratorRegistry();
                    hasGlobalAdministrators[0] = administrators.size() > 0;
                    Set<TopologyCacheException> exceptions = this.updateUserDataWithSuffixesInADS(adsContext, trustManager);
                    LinkedHashSet<String> exceptionMsgs = new LinkedHashSet<String>();
                    for (TopologyCacheException e : exceptions) {
                        switch (e.getType()) {
                            case NOT_GLOBAL_ADMINISTRATOR: {
                                Message errorMsg = QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get();
                                throw new UserDataException(Step.REPLICATION_OPTIONS, errorMsg);
                            }
                            case GENERIC_CREATING_CONNECTION: {
                                int p;
                                String h;
                                if (e.getCause() == null || !Utils.isCertificateException(e.getCause())) break;
                                ApplicationTrustManager.Cause cause = null;
                                if (e.getTrustManager() != null) {
                                    cause = e.getTrustManager().getLastRefusedCause();
                                }
                                LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                                UserDataCertificateException.Type excType = cause == ApplicationTrustManager.Cause.NOT_TRUSTED ? UserDataCertificateException.Type.NOT_TRUSTED : (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH ? UserDataCertificateException.Type.HOST_NAME_MISMATCH : null);
                                if (excType == null) break;
                                try {
                                    URI uri = new URI(e.getLdapUrl());
                                    h = uri.getHost();
                                    p = uri.getPort();
                                }
                                catch (Throwable t) {
                                    LOG.log(Level.WARNING, "Error parsing ldap url of TopologyCacheException.", t);
                                    h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                                    p = -1;
                                }
                                throw new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), e.getCause(), h, p, e.getTrustManager().getLastRefusedChain(), e.getTrustManager().getLastRefusedAuthType(), excType);
                            }
                        }
                        exceptionMsgs.add(this.getStringRepresentation(e));
                    }
                    if (exceptionMsgs.size() > 0) {
                        Message confirmationMsg = QuickSetupMessages.INFO_ERROR_READING_REGISTERED_SERVERS_CONFIRM.get(Utils.getStringFromCollection(exceptionMsgs, "n"));
                        throw new UserDataConfirmationException(Step.REPLICATION_OPTIONS, confirmationMsg);
                    }
                    break block32;
                }
                this.updateUserDataWithSuffixesInServer((InitialLdapContext)ctx);
            }
            catch (UserDataException ude) {
                throw ude;
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Error connecting to remote server.", t);
                if (Utils.isCertificateException(t)) {
                    ApplicationTrustManager.Cause cause = trustManager.getLastRefusedCause();
                    LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                    UserDataCertificateException.Type excType = cause == ApplicationTrustManager.Cause.NOT_TRUSTED ? UserDataCertificateException.Type.NOT_TRUSTED : (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH ? UserDataCertificateException.Type.HOST_NAME_MISMATCH : null);
                    if (excType != null) {
                        throw new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(host, String.valueOf(port)), t, host, port, trustManager.getLastRefusedChain(), trustManager.getLastRefusedAuthType(), excType);
                    }
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(host + ":" + port, t.toString()));
                    break block32;
                }
                if (t instanceof AuthenticationException) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_AUTHENTICATION.get());
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
                    break block32;
                }
                if (t instanceof NoPermissionException) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_PERMISSIONS.get(host + ":" + port));
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
                    break block32;
                }
                if (t instanceof NamingException) {
                    errorMsgs.add(QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(host + ":" + port, t.toString()));
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_HOST, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PORT, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_DN, true);
                    qs.displayFieldInvalid(FieldName.REMOTE_SERVER_PWD, true);
                    break block32;
                }
                if (t instanceof ADSContextException) {
                    String[] args = new String[]{host + ":" + port, t.toString()};
                    errorMsgs.add(QuickSetupMessages.INFO_REMOTE_ADS_EXCEPTION.get(host + ":" + port, t.toString()));
                    break block32;
                }
                throw new UserDataException(Step.REPLICATION_OPTIONS, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    private void updateUserDataForCreateAdministratorPanel(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        String uid = qs.getFieldStringValue(FieldName.GLOBAL_ADMINISTRATOR_UID);
        if (uid == null || uid.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_ADMINISTRATOR_UID.get());
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_UID, true);
        } else {
            this.getUserData().setGlobalAdministratorUID(uid);
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_UID, false);
        }
        String pwd1 = qs.getFieldStringValue(FieldName.GLOBAL_ADMINISTRATOR_PWD);
        String pwd2 = qs.getFieldStringValue(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM);
        if (pwd1 == null) {
            pwd1 = "";
        }
        boolean pwdValid = true;
        if (!pwd1.equals(pwd2)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_EQUAL_PWD.get());
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, true);
            pwdValid = false;
        }
        if (pwd1.length() < 1) {
            errorMsgs.add(QuickSetupMessages.INFO_PWD_TOO_SHORT.get(String.valueOf(1)));
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD, true);
            if (pwd2 == null || pwd2.length() < 1) {
                qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, true);
            }
            pwdValid = false;
        }
        if (pwdValid) {
            this.getUserData().setGlobalAdministratorPassword(pwd1);
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD, false);
            qs.displayFieldInvalid(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, false);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.CREATE_GLOBAL_ADMINISTRATOR, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    private void updateUserDataForSuffixesOptionsPanel(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        if (qs.getFieldValue(FieldName.SUFFIXES_TO_REPLICATE_OPTIONS) == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES) {
            Set s = (Set)qs.getFieldValue(FieldName.SUFFIXES_TO_REPLICATE);
            if (s.size() == 0) {
                errorMsgs.add(QuickSetupMessages.INFO_NO_SUFFIXES_CHOSEN_TO_REPLICATE.get());
                qs.displayFieldInvalid(FieldName.SUFFIXES_TO_REPLICATE, true);
            } else {
                HashSet<SuffixDescriptor> chosen = new HashSet<SuffixDescriptor>();
                for (Object o : s) {
                    chosen.add((SuffixDescriptor)o);
                }
                qs.displayFieldInvalid(FieldName.SUFFIXES_TO_REPLICATE, false);
                Set<SuffixDescriptor> available = this.getUserData().getSuffixesToReplicateOptions().getAvailableSuffixes();
                SuffixesToReplicateOptions options = new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES, available, chosen);
                this.getUserData().setSuffixesToReplicateOptions(options);
            }
            this.getUserData().setRemoteWithNoReplicationPort(this.getRemoteWithNoReplicationPort(this.getUserData()));
        } else {
            Set<SuffixDescriptor> available = this.getUserData().getSuffixesToReplicateOptions().getAvailableSuffixes();
            Set<SuffixDescriptor> chosen = this.getUserData().getSuffixesToReplicateOptions().getSuffixes();
            SuffixesToReplicateOptions options = new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY, available, chosen);
            this.getUserData().setSuffixesToReplicateOptions(options);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.SUFFIXES_OPTIONS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    private void updateUserDataForRemoteReplicationPorts(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        Map<ServerDescriptor, Integer> servers = this.getUserData().getRemoteWithNoReplicationPort();
        Map hm = (Map)qs.getFieldValue(FieldName.REMOTE_REPLICATION_PORT);
        for (ServerDescriptor server : servers.keySet()) {
            String hostName = server.getHostName();
            int replicationPort = -1;
            String sPort = (String)hm.get(server.getId());
            try {
                replicationPort = Integer.parseInt(sPort);
                if (replicationPort < 1 || replicationPort > 65535) {
                    errorMsgs.add(QuickSetupMessages.INFO_INVALID_REMOTE_REPLICATION_PORT_VALUE_RANGE.get(server.getHostPort(true), String.valueOf(1), String.valueOf(65535)));
                }
                if (hostName.equalsIgnoreCase(this.getUserData().getHostName())) {
                    int securePort = -1;
                    if (this.getUserData().getSecurityOptions().getEnableSSL()) {
                        securePort = this.getUserData().getSecurityOptions().getSslPort();
                    }
                    if (replicationPort == this.getUserData().getServerPort() || replicationPort == this.getUserData().getServerJMXPort() || replicationPort == this.getUserData().getReplicationOptions().getReplicationPort() || replicationPort == securePort) {
                        errorMsgs.add(QuickSetupMessages.INFO_REMOTE_REPLICATION_PORT_ALREADY_CHOSEN_FOR_OTHER_PROTOCOL.get(server.getHostPort(true)));
                    }
                }
                servers.put(server, replicationPort);
            }
            catch (NumberFormatException nfe) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_REMOTE_REPLICATION_PORT_VALUE_RANGE.get(hostName, String.valueOf(1), String.valueOf(65535)));
            }
        }
        if (errorMsgs.size() > 0) {
            qs.displayFieldInvalid(FieldName.REMOTE_REPLICATION_PORT, true);
            throw new UserDataException(Step.REMOTE_REPLICATION_PORTS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
        qs.displayFieldInvalid(FieldName.REMOTE_REPLICATION_PORT, false);
        this.getUserData().setRemoteWithNoReplicationPort(servers);
    }

    private void updateUserDataForNewSuffixOptionsPanel(QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        NewSuffixOptions dataOptions = null;
        boolean validBaseDn = false;
        String baseDn = qs.getFieldStringValue(FieldName.DIRECTORY_BASE_DN);
        if (baseDn == null || baseDn.trim().length() == 0) {
            errorMsgs.add(QuickSetupMessages.INFO_EMPTY_BASE_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, true);
        } else if (!Utils.isDn(baseDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_NOT_A_BASE_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, true);
        } else if (Utils.isConfigurationDn(baseDn)) {
            errorMsgs.add(QuickSetupMessages.INFO_BASE_DN_IS_CONFIGURATION_DN.get());
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, true);
        } else {
            qs.displayFieldInvalid(FieldName.DIRECTORY_BASE_DN, false);
            validBaseDn = true;
        }
        NewSuffixOptions.Type type = (NewSuffixOptions.Type)((Object)qs.getFieldValue(FieldName.DATA_OPTIONS));
        switch (type) {
            case IMPORT_FROM_LDIF_FILE: {
                String ldifPath = qs.getFieldStringValue(FieldName.LDIF_PATH);
                if (ldifPath == null || ldifPath.trim().equals("")) {
                    errorMsgs.add(QuickSetupMessages.INFO_NO_LDIF_PATH.get());
                    qs.displayFieldInvalid(FieldName.LDIF_PATH, true);
                    break;
                }
                if (!Utils.fileExists(ldifPath)) {
                    errorMsgs.add(QuickSetupMessages.INFO_LDIF_FILE_DOES_NOT_EXIST.get());
                    qs.displayFieldInvalid(FieldName.LDIF_PATH, true);
                    break;
                }
                if (!validBaseDn) break;
                dataOptions = new NewSuffixOptions(type, baseDn, ldifPath);
                qs.displayFieldInvalid(FieldName.LDIF_PATH, false);
                break;
            }
            case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                int startErrors = errorMsgs.size();
                String nEntries = qs.getFieldStringValue(FieldName.NUMBER_ENTRIES);
                if (nEntries == null || nEntries.trim().equals("")) {
                    errorMsgs.add(QuickSetupMessages.INFO_NO_NUMBER_ENTRIES.get());
                    qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, true);
                } else {
                    boolean nEntriesValid = false;
                    try {
                        int n = Integer.parseInt(nEntries);
                        nEntriesValid = n >= 1 && n <= 10000;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (!nEntriesValid) {
                        errorMsgs.add(QuickSetupMessages.INFO_INVALID_NUMBER_ENTRIES_RANGE.get(String.valueOf(1), String.valueOf(10000)));
                        qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, true);
                    } else {
                        qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, false);
                    }
                }
                if (startErrors != errorMsgs.size() || !validBaseDn) break;
                dataOptions = new NewSuffixOptions(type, baseDn, new Integer(nEntries));
                break;
            }
            default: {
                qs.displayFieldInvalid(FieldName.LDIF_PATH, false);
                qs.displayFieldInvalid(FieldName.NUMBER_ENTRIES, false);
                if (!validBaseDn) break;
                dataOptions = new NewSuffixOptions(type, baseDn);
            }
        }
        if (dataOptions != null) {
            this.getUserData().setNewSuffixOptions(dataOptions);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(Step.NEW_SUFFIX_OPTIONS, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    private void updateUserDataForReviewPanel(QuickSetup qs) {
        Boolean b = (Boolean)qs.getFieldValue(FieldName.SERVER_START);
        this.getUserData().setStartServer(b);
        b = (Boolean)qs.getFieldValue(FieldName.ENABLE_WINDOWS_SERVICE);
        this.getUserData().setEnableWindowsService(b);
    }

    private long getRequiredInstallSpace() {
        return 0xF00000L;
    }

    private Map<ADSContext.ServerProperty, Object> getRemoteServerProperties(String hostName, InitialLdapContext ctx) throws NamingException {
        ServerDescriptor server = ServerDescriptor.createStandalone(ctx);
        HashMap<ADSContext.ServerProperty, Object> serverProperties = new HashMap<ADSContext.ServerProperty, Object>();
        serverProperties.put(ADSContext.ServerProperty.HOST_NAME, hostName);
        ADSContext.ServerProperty[][] adsProperties = new ADSContext.ServerProperty[][]{{ADSContext.ServerProperty.LDAP_PORT, ADSContext.ServerProperty.LDAP_ENABLED}, {ADSContext.ServerProperty.LDAPS_PORT, ADSContext.ServerProperty.LDAPS_ENABLED}, {ADSContext.ServerProperty.JMX_PORT, ADSContext.ServerProperty.JMX_ENABLED}, {ADSContext.ServerProperty.JMXS_PORT, ADSContext.ServerProperty.JMXS_ENABLED}};
        ServerDescriptor.ServerProperty[][] properties = new ServerDescriptor.ServerProperty[][]{{ServerDescriptor.ServerProperty.LDAP_PORT, ServerDescriptor.ServerProperty.LDAP_ENABLED}, {ServerDescriptor.ServerProperty.LDAPS_PORT, ServerDescriptor.ServerProperty.LDAPS_ENABLED}, {ServerDescriptor.ServerProperty.JMX_PORT, ServerDescriptor.ServerProperty.JMX_ENABLED}, {ServerDescriptor.ServerProperty.JMXS_PORT, ServerDescriptor.ServerProperty.JMXS_ENABLED}};
        for (int i = 0; i < properties.length; ++i) {
            ArrayList portNumbers = (ArrayList)server.getServerProperties().get((Object)properties[i][0]);
            if (portNumbers == null) continue;
            ArrayList enabled = (ArrayList)server.getServerProperties().get((Object)properties[i][1]);
            boolean enabledFound = false;
            for (int j = 0; j < enabled.size() && !enabledFound; ++j) {
                if (!Boolean.TRUE.equals(enabled.get(j))) continue;
                enabledFound = true;
                serverProperties.put(adsProperties[i][0], String.valueOf(portNumbers.get(j)));
            }
            if (!enabledFound && portNumbers.size() > 0) {
                serverProperties.put(adsProperties[i][0], String.valueOf(portNumbers.get(0)));
            }
            serverProperties.put(adsProperties[i][1], enabledFound ? "true" : "false");
        }
        serverProperties.put(ADSContext.ServerProperty.ID, server.getHostPort(true));
        return serverProperties;
    }

    private Set<TopologyCacheException> updateUserDataWithSuffixesInADS(ADSContext adsContext, ApplicationTrustManager trustManager) throws TopologyCacheException {
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        SuffixesToReplicateOptions suf = this.getUserData().getSuffixesToReplicateOptions();
        SuffixesToReplicateOptions.Type type = suf == null || suf.getType() == SuffixesToReplicateOptions.Type.NO_SUFFIX_TO_REPLICATE ? suf.getType() : SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        this.lastLoadedCache = new TopologyCache(adsContext, trustManager);
        this.lastLoadedCache.reloadTopology();
        Set<SuffixDescriptor> suffixes = this.lastLoadedCache.getSuffixes();
        this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(type, suffixes, suf.getSuffixes()));
        Set<ServerDescriptor> servers = this.lastLoadedCache.getServers();
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        return exceptions;
    }

    private void updateUserDataWithSuffixesInServer(InitialLdapContext ctx) throws NamingException {
        SuffixesToReplicateOptions suf = this.getUserData().getSuffixesToReplicateOptions();
        HashSet<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
        SuffixesToReplicateOptions.Type type = suf == null ? SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY : suf.getType();
        ServerDescriptor s = ServerDescriptor.createStandalone(ctx);
        Set<ReplicaDescriptor> replicas = s.getReplicas();
        for (ReplicaDescriptor replica : replicas) {
            suffixes.add(replica.getSuffix());
        }
        this.getUserData().setSuffixesToReplicateOptions(new SuffixesToReplicateOptions(type, suffixes, suf.getSuffixes()));
    }

    protected String getSelfSignedKeystorePath() {
        String parentFile = Utils.getPath(this.getInstallationPath(), "config");
        return Utils.getPath(parentFile, "keystore");
    }

    private String getTrustManagerPath() {
        String parentFile = Utils.getPath(this.getInstallationPath(), "config");
        return Utils.getPath(parentFile, "truststore");
    }

    private String getTemporaryCertificatePath() {
        String parentFile = Utils.getPath(this.getInstallationPath(), "config");
        return Utils.getPath(parentFile, "server-cert.txt");
    }

    private String getKeystorePinPath() {
        String parentFile = Utils.getPath(this.getInstallationPath(), "config");
        return Utils.getPath(parentFile, "keystore.pin");
    }

    private int getSelfSignedCertificateValidity() {
        return 730;
    }

    private String getSelfSignedCertificateSubjectDN() {
        return "cn=" + Rdn.escapeValue(this.getUserData().getHostName()) + ",O=OpenDS Self-Signed Certificate";
    }

    protected String getSelfSignedCertificatePwd() {
        if (this.selfSignedCertPw == null) {
            this.selfSignedCertPw = this.createSelfSignedCertificatePwd();
        }
        return new String(this.selfSignedCertPw);
    }

    private char[] createSelfSignedCertificatePwd() {
        int pwdLength = 50;
        char[] pwd = new char[pwdLength];
        Random random = new Random();
        for (int pos = 0; pos < pwdLength; ++pos) {
            char nextChar;
            int type = Installer.getRandomInt(random, 3);
            pwd[pos] = nextChar = this.getRandomChar(random, type);
        }
        return pwd;
    }

    private void exportCertificate(CertificateManager certManager, String alias, String path) throws CertificateEncodingException, IOException, KeyStoreException {
        Certificate certificate = certManager.getCertificate(alias);
        byte[] certificateBytes = certificate.getEncoded();
        FileOutputStream outputStream = new FileOutputStream(path, false);
        outputStream.write(certificateBytes);
        outputStream.close();
    }

    private char getRandomChar(Random random, int type) {
        char generatedChar;
        int next = random.nextInt();
        switch (type) {
            case 0: {
                int d = next % 10;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 48);
                break;
            }
            case 1: {
                int d = next % 26;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 97);
                break;
            }
            default: {
                int d = next % 26;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 65);
            }
        }
        return generatedChar;
    }

    private Map<ServerDescriptor, Integer> getRemoteWithNoReplicationPort(UserData userData) {
        HashMap<ServerDescriptor, Integer> servers = new HashMap<ServerDescriptor, Integer>();
        Set<SuffixDescriptor> suffixes = userData.getSuffixesToReplicateOptions().getSuffixes();
        for (SuffixDescriptor suffix : suffixes) {
            for (ReplicaDescriptor replica : suffix.getReplicas()) {
                ServerDescriptor server = replica.getServer();
                Object v = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.IS_REPLICATION_SERVER);
                if (Boolean.TRUE.equals(v)) continue;
                servers.put(server, 8989);
            }
        }
        return servers;
    }

    private InitialLdapContext createLocalContext() throws NamingException {
        String ldapUrl = "ldap://" + Utils.getHostNameForLdapUrl(this.getUserData().getHostName()) + ":" + this.getUserData().getServerPort();
        String dn = this.getUserData().getDirectoryManagerDn();
        String pwd = this.getUserData().getDirectoryManagerPwd();
        return Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
    }

    private InitialLdapContext getRemoteConnection(ServerDescriptor server, ApplicationTrustManager trustManager) throws ApplicationException {
        AuthenticationData auth = this.getUserData().getReplicationOptions().getAuthenticationData();
        if (!server.isRegistered()) {
            HashMap<ADSContext.ServerProperty, Object> adsProperties = new HashMap<ADSContext.ServerProperty, Object>();
            adsProperties.put(ADSContext.ServerProperty.HOST_NAME, server.getHostName());
            if (auth.useSecureConnection()) {
                adsProperties.put(ADSContext.ServerProperty.LDAPS_PORT, String.valueOf(auth.getPort()));
                adsProperties.put(ADSContext.ServerProperty.LDAPS_ENABLED, "true");
            } else {
                adsProperties.put(ADSContext.ServerProperty.LDAP_PORT, String.valueOf(auth.getPort()));
                adsProperties.put(ADSContext.ServerProperty.LDAP_ENABLED, "true");
            }
            server.setAdsProperties(adsProperties);
        }
        return this.getRemoteConnection(server, auth.getDn(), auth.getPwd(), trustManager);
    }

    private void initializeSuffix(InitialLdapContext ctx, int replicaId, String suffixDn, boolean displayProgress, String sourceServerDisplay) throws ApplicationException, PeerNotFoundException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-initialize-from-remote-replica");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.InitializeTask");
        attrs.put("ds-task-initialize-domain-dn", suffixDn);
        attrs.put("ds-task-initialize-replica-server-id", String.valueOf(replicaId));
        while (!taskCreated) {
            String id = "quicksetup-initialize" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_LAUNCHING_INITIALIZATION.get(sourceServerDisplay), ne), ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-unprocessed-entry-count", "ds-task-processed-entry-count", "ds-task-log-message", "ds-task-state"});
        Message lastDisplayedMsg = null;
        String lastLogMsg = null;
        long lastTimeMsgDisplayed = -1L;
        int totalEntries = 0;
        while (!isOver) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String state;
                InstallerHelper helper;
                String logMsg;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = res.next();
                if (displayProgress) {
                    Message msg;
                    String sProcessed = Utils.getFirstValue(sr, "ds-task-processed-entry-count");
                    String sUnprocessed = Utils.getFirstValue(sr, "ds-task-unprocessed-entry-count");
                    int processed = -1;
                    int unprocessed = -1;
                    if (sProcessed != null) {
                        processed = Integer.parseInt(sProcessed);
                    }
                    if (sUnprocessed != null) {
                        unprocessed = Integer.parseInt(sUnprocessed);
                    }
                    totalEntries = Math.max(totalEntries, processed + unprocessed);
                    if (processed != -1 && unprocessed != -1) {
                        if (processed + unprocessed > 0) {
                            int perc = 100 * processed / (processed + unprocessed);
                            msg = QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PERCENTAGE.get(sProcessed, String.valueOf(perc));
                        } else {
                            msg = null;
                        }
                    } else {
                        msg = processed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PROCESSED.get(sProcessed) : (unprocessed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_UNPROCESSED.get(sUnprocessed) : lastDisplayedMsg);
                    }
                    if (msg != null) {
                        long currentTime = System.currentTimeMillis();
                        long minRefreshPeriod = totalEntries < 100 ? 0L : (totalEntries < 1000 ? 1000L : (totalEntries < 10000 ? 5000L : 10000L));
                        if (!msg.equals(lastDisplayedMsg) && currentTime - minRefreshPeriod > lastTimeMsgDisplayed && !msg.equals(lastDisplayedMsg)) {
                            this.notifyListeners(this.getFormattedProgress(msg));
                            lastDisplayedMsg = msg;
                            this.notifyListeners(this.getLineBreak());
                            lastTimeMsgDisplayed = currentTime;
                        }
                    }
                }
                if ((logMsg = Utils.getFirstValue(sr, "ds-task-log-message")) != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                Message errorMsg = lastLogMsg == null ? QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_NO_LOG.get(sourceServerDisplay, state, sourceServerDisplay) : QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_LOG.get(sourceServerDisplay, lastLogMsg, state, sourceServerDisplay);
                if (helper.isCompletedWithErrors(state)) {
                    this.notifyListeners(this.getFormattedWarning(errorMsg));
                    continue;
                }
                if (!helper.isSuccessful(state) || helper.isStoppedByError(state)) {
                    ApplicationException ae = new ApplicationException(ApplicationReturnCode.ReturnCode.APPLICATION_ERROR, errorMsg, null);
                    if (lastLogMsg == null || helper.isPeersNotFoundError(lastLogMsg)) {
                        throw new PeerNotFoundException(errorMsg);
                    }
                    throw ae;
                }
                if (!displayProgress) continue;
                this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get()));
            }
            catch (NameNotFoundException x) {
                isOver = true;
                this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get()));
            }
            catch (NamingException ne) {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_POOLING_INITIALIZATION.get(sourceServerDisplay), ne), ne);
            }
        }
    }

    private String getLocalReplicationServer() {
        return this.getUserData().getHostName() + ":" + this.getUserData().getReplicationOptions().getReplicationPort();
    }

    private String getLocalHostPort() {
        return this.getUserData().getHostName() + ":" + this.getUserData().getServerPort();
    }

    private static int getRandomInt(Random random, int modulo) {
        int value = 0;
        value = random.nextInt() & modulo;
        return value;
    }
}

