/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.naming.ldap.InitialLdapContext;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ReplicationMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.installer.ConfiguredDomain;
import org.opends.quicksetup.installer.ConfiguredReplication;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.MultimasterDomainCfgClient;
import org.opends.server.admin.std.client.MultimasterSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.MultimasterDomainCfgDefn;
import org.opends.server.admin.std.meta.MultimasterSynchronizationProviderCfgDefn;
import org.opends.server.admin.std.meta.ReplicationServerCfgDefn;
import org.opends.server.backends.task.TaskState;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.tools.ConfigureDS;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerHelper {
    private static final Logger LOG = Logger.getLogger(InstallerHelper.class.getName());
    private static final int MAX_ID_VALUE = Short.MAX_VALUE;
    private static final String DOMAIN_BASE_NAME = "domain ";

    public int invokeConfigureServer(String[] args) throws ApplicationException {
        return ConfigureDS.configMain(args);
    }

    public int invokeImportLDIF(String[] args) throws ApplicationException {
        return ImportLDIF.mainImportLDIF(args);
    }

    public String getStartedId() {
        return String.valueOf(CoreMessages.NOTE_DIRECTORY_SERVER_STARTED.getId());
    }

    public void enableWindowsService() throws ApplicationException {
        int code = ConfigureWindowsService.enableService(System.out, System.err);
        Message errorMessage = QuickSetupMessages.INFO_ERROR_ENABLING_WINDOWS_SERVICE.get();
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.WINDOWS_SERVICE_ERROR, errorMessage, null);
            }
        }
    }

    public void disableWindowsService() throws ApplicationException {
        int code = ConfigureWindowsService.disableService(System.out, System.err);
        if (code == 3) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.WINDOWS_SERVICE_ERROR, QuickSetupMessages.INFO_ERROR_DISABLING_WINDOWS_SERVICE.get(""), null);
        }
    }

    public File createBaseEntryTempFile(String baseDn) throws ApplicationException {
        File ldifFile;
        try {
            ldifFile = File.createTempFile("opends-base-entry", ".ldif");
            ldifFile.deleteOnExit();
        }
        catch (IOException ioe) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CREATING_TEMP_FILE.get(), ioe);
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.FILE_SYSTEM_ACCESS_ERROR, failedMsg, ioe);
        }
        try {
            LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFile.getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
            LDIFWriter writer = new LDIFWriter(exportConfig);
            DN dn = DN.decode(baseDn);
            Entry entry = StaticUtils.createEntry(dn);
            writer.writeEntry(entry);
            writer.close();
        }
        catch (DirectoryException de) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), de), de);
        }
        catch (LDIFException le) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), le), le);
        }
        catch (IOException ioe) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), ioe), ioe);
        }
        catch (Throwable t) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
        }
        return ldifFile;
    }

    public ConfiguredReplication configureReplication(InitialLdapContext remoteCtx, Set<String> dns, Map<String, Set<String>> replicationServers, int replicationPort, String serverDisplay, Set<Integer> usedReplicationServerIds, Set<Integer> usedServerIds) throws ApplicationException {
        try {
            boolean replicationServerCreated;
            boolean synchProviderEnabled;
            boolean synchProviderCreated;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(remoteCtx));
            RootCfgClient root = mCtx.getRootConfiguration();
            MultimasterSynchronizationProviderCfgClient sync = null;
            try {
                sync = (MultimasterSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (ManagedObjectNotFoundException monfe) {
                // empty catch block
            }
            if (sync == null) {
                MultimasterSynchronizationProviderCfgDefn provider = MultimasterSynchronizationProviderCfgDefn.getInstance();
                sync = root.createSynchronizationProvider(provider, "Multimaster Synchronization", new ArrayList<DefaultBehaviorException>());
                sync.setJavaImplementationClass(MultimasterReplication.class.getName());
                sync.setEnabled(Boolean.TRUE);
                synchProviderCreated = true;
                synchProviderEnabled = false;
            } else {
                synchProviderCreated = false;
                if (!sync.isEnabled().booleanValue()) {
                    sync.setEnabled(Boolean.TRUE);
                    synchProviderEnabled = true;
                } else {
                    synchProviderEnabled = false;
                }
            }
            sync.commit();
            ReplicationServerCfgClient replicationServer = null;
            if (!sync.hasReplicationServer()) {
                int id = this.getReplicationId(usedReplicationServerIds);
                usedReplicationServerIds.add(id);
                replicationServer = sync.createReplicationServer(ReplicationServerCfgDefn.getInstance(), new ArrayList<DefaultBehaviorException>());
                replicationServer.setReplicationServerId(id);
                replicationServer.setReplicationPort(replicationPort);
                replicationServerCreated = true;
            } else {
                replicationServer = sync.getReplicationServer();
                usedReplicationServerIds.add(replicationServer.getReplicationServerId());
                replicationServerCreated = false;
            }
            Set<String> servers = replicationServer.getReplicationServer();
            if (servers == null) {
                servers = new HashSet();
            }
            Set<String> oldServers = new HashSet<String>();
            oldServers.addAll(servers);
            for (Set<String> rs : replicationServers.values()) {
                servers.addAll(rs);
            }
            replicationServer.setReplicationServer(servers);
            replicationServer.commit();
            HashSet<String> newReplicationServers = new HashSet<String>();
            newReplicationServers.addAll(servers);
            newReplicationServers.removeAll(oldServers);
            String[] domainNames = sync.listMultimasterDomains();
            if (domainNames == null) {
                domainNames = new String[]{};
            }
            HashSet<ConfiguredDomain> domainsConf = new HashSet<ConfiguredDomain>();
            MultimasterDomainCfgClient[] domains = new MultimasterDomainCfgClient[domainNames.length];
            for (int i = 0; i < domains.length; ++i) {
                domains[i] = sync.getMultimasterDomain(domainNames[i]);
            }
            for (String dn : dns) {
                boolean isCreated;
                MultimasterDomainCfgClient domain = null;
                String domainName = null;
                for (int i = 0; i < domains.length && domain == null; ++i) {
                    if (!Utils.areDnsEqual(dn, domains[i].getReplicationDN().toString())) continue;
                    domain = domains[i];
                    domainName = domainNames[i];
                }
                if (domain == null) {
                    int domainId = this.getReplicationId(usedServerIds);
                    usedServerIds.add(domainId);
                    domainName = this.getDomainName(domainNames, domainId);
                    domain = sync.createMultimasterDomain(MultimasterDomainCfgDefn.getInstance(), domainName, new ArrayList<DefaultBehaviorException>());
                    domain.setServerId(domainId);
                    domain.setReplicationDN(DN.decode(dn));
                    isCreated = true;
                } else {
                    isCreated = false;
                }
                oldServers = domain.getReplicationServer();
                if (oldServers == null) {
                    oldServers = new TreeSet();
                }
                servers = replicationServers.get(dn);
                domain.setReplicationServer(servers);
                usedServerIds.add(domain.getServerId());
                domain.commit();
                TreeSet<String> addedServers = new TreeSet<String>();
                addedServers.addAll(servers);
                addedServers.removeAll(oldServers);
                ConfiguredDomain domainConf = new ConfiguredDomain(domainName, isCreated, addedServers);
                domainsConf.add(domainConf);
            }
            return new ConfiguredReplication(synchProviderCreated, synchProviderEnabled, replicationServerCreated, newReplicationServers, domainsConf);
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public void unconfigureReplication(InitialLdapContext remoteCtx, ConfiguredReplication replConf, String serverDisplay) throws ApplicationException {
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(remoteCtx));
            RootCfgClient root = mCtx.getRootConfiguration();
            if (replConf.isSynchProviderCreated()) {
                try {
                    root.removeSynchronizationProvider("Multimaster Synchronization");
                }
                catch (ManagedObjectNotFoundException monfe) {}
            } else {
                try {
                    ReplicationServerCfgClient replicationServer;
                    SortedSet<String> replServers;
                    MultimasterSynchronizationProviderCfgClient sync = (MultimasterSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
                    if (replConf.isSynchProviderEnabled()) {
                        sync.setEnabled(Boolean.FALSE);
                    }
                    if (replConf.isReplicationServerCreated()) {
                        sync.removeReplicationServer();
                    } else if (sync.hasReplicationServer() && (replServers = (replicationServer = sync.getReplicationServer()).getReplicationServer()) != null) {
                        replServers.removeAll(replConf.getNewReplicationServers());
                        replicationServer.setReplicationServer(replServers);
                        replicationServer.commit();
                    }
                    for (ConfiguredDomain domain : replConf.getDomainsConf()) {
                        if (domain.isCreated()) {
                            sync.removeMultimasterDomain(domain.getDomainName());
                            continue;
                        }
                        try {
                            MultimasterDomainCfgClient d = sync.getMultimasterDomain(domain.getDomainName());
                            SortedSet<String> replServers2 = d.getReplicationServer();
                            if (replServers2 == null) continue;
                            replServers2.removeAll(domain.getAddedReplicationServers());
                            d.setReplicationServer(replServers2);
                            d.commit();
                        }
                        catch (ManagedObjectNotFoundException monfe) {}
                    }
                    sync.commit();
                }
                catch (ManagedObjectNotFoundException monfe) {}
            }
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public boolean isDone(String sState) {
        TaskState state = TaskState.fromString(sState);
        return TaskState.isDone(state);
    }

    public boolean isSuccessful(String sState) {
        TaskState state = TaskState.fromString(sState);
        return TaskState.isSuccessful(state);
    }

    public boolean isCompletedWithErrors(String sState) {
        TaskState state = TaskState.fromString(sState);
        return state == TaskState.COMPLETED_WITH_ERRORS;
    }

    public boolean isStoppedByError(String sState) {
        TaskState state = TaskState.fromString(sState);
        return state == TaskState.STOPPED_BY_ERROR;
    }

    public boolean isPeersNotFoundError(String logMsg) {
        return logMsg.indexOf("=" + ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.getId()) != -1;
    }

    private int getReplicationId(Set<Integer> usedIds) {
        Random r = new Random();
        int id = 0;
        while (id == 0 || usedIds.contains(id)) {
            id = r.nextInt(Short.MAX_VALUE);
        }
        return id;
    }

    private String getDomainName(String[] existingDomains, int newDomainId) {
        String domainName = DOMAIN_BASE_NAME + newDomainId;
        boolean nameExists = true;
        int j = 0;
        while (nameExists) {
            boolean found = false;
            for (int i = 0; i < existingDomains.length && !found; ++i) {
                found = existingDomains[i].equalsIgnoreCase(domainName);
            }
            if (found) {
                domainName = DOMAIN_BASE_NAME + newDomainId + "-" + j;
            } else {
                nameExists = false;
            }
            ++j;
        }
        return domainName;
    }
}

