/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.BrowseActionListener;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;

public class DataOptionsPanel
extends QuickSetupStepPanel {
    private Component lastFocusComponent;
    private static final long serialVersionUID = 1815782841921928118L;
    private UserData defaultUserData;
    private HashMap<FieldName, JLabel> hmLabels = new HashMap();
    private HashMap<FieldName, JTextComponent> hmFields = new HashMap();
    private HashMap<NewSuffixOptions.Type, JRadioButton> hmRadioButtons = new HashMap();
    private JButton ldifBrowseButton;

    public DataOptionsPanel(GuiApplication application) {
        super(application);
        this.defaultUserData = application.getUserData();
        this.populateComponentMaps();
        this.addDocumentListeners();
        this.addFocusListeners();
        this.addActionListeners();
    }

    public Object getFieldValue(FieldName fieldName) {
        Object value = null;
        if (fieldName == FieldName.DATA_OPTIONS) {
            for (NewSuffixOptions.Type type : this.hmRadioButtons.keySet()) {
                if (!this.hmRadioButtons.get((Object)type).isSelected()) continue;
                value = type;
                break;
            }
        } else {
            JTextComponent field = this.getField(fieldName);
            if (field != null) {
                value = field.getText();
            }
        }
        return value;
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        JLabel label = this.getLabel(fieldName);
        if (label != null) {
            UIFactory.TextStyle style = fieldName != FieldName.DIRECTORY_BASE_DN ? (invalid ? UIFactory.TextStyle.SECONDARY_FIELD_INVALID : UIFactory.TextStyle.SECONDARY_FIELD_VALID) : (invalid ? UIFactory.TextStyle.PRIMARY_FIELD_INVALID : UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            UIFactory.setTextStyle(label, style);
        }
    }

    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        gbc.anchor = 17;
        panel.add((Component)this.getLabel(FieldName.DIRECTORY_BASE_DN), gbc);
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.gridwidth = -1;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        auxPanel.add((Component)this.getField(FieldName.DIRECTORY_BASE_DN), gbc);
        gbc.gridwidth = 0;
        gbc.insets.left = 10;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        auxPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        panel.add((Component)auxPanel, gbc);
        int h1 = this.getLabel((FieldName)FieldName.DATA_OPTIONS).getPreferredSize().height;
        int h2 = this.getRadioButton((NewSuffixOptions.Type)NewSuffixOptions.Type.CREATE_BASE_ENTRY).getPreferredSize().height;
        int additionalInset = Math.abs(h2 - h1) / 2;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 10 + additionalInset;
        gbc.insets.left = 0;
        gbc.anchor = 18;
        panel.add((Component)this.getLabel(FieldName.DATA_OPTIONS), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.top = 10;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        panel.add((Component)this.createRadioButtonPanel(), gbc);
        this.addVerticalGlue(panel);
        return panel;
    }

    private JPanel createRadioButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setOpaque(false);
        gbc.gridwidth = 0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)this.getRadioButton(NewSuffixOptions.Type.CREATE_BASE_ENTRY), gbc);
        gbc.insets.top = 0;
        panel.add((Component)this.getRadioButton(NewSuffixOptions.Type.LEAVE_DATABASE_EMPTY), gbc);
        panel.add((Component)this.getRadioButton(NewSuffixOptions.Type.IMPORT_FROM_LDIF_FILE), gbc);
        JPanel auxPanel = this.createBrowseButtonPanel(FieldName.LDIF_PATH, this.getLDIFBrowseButton());
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.top = 0;
        gbc.insets.left = 35;
        panel.add((Component)auxPanel, gbc);
        gbc.insets.left = 0;
        panel.add((Component)this.getRadioButton(NewSuffixOptions.Type.IMPORT_AUTOMATICALLY_GENERATED_DATA), gbc);
        auxPanel = this.createNumberEntriesPanel();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.top = 5;
        gbc.insets.left = 35;
        panel.add((Component)auxPanel, gbc);
        return panel;
    }

    private JPanel createNumberEntriesPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        gbc.gridwidth = 3;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weightx = 0.0;
        panel.add((Component)this.getLabel(FieldName.NUMBER_ENTRIES), gbc);
        --gbc.gridwidth;
        gbc.weightx = 0.1;
        gbc.insets.left = 5;
        panel.add((Component)this.getField(FieldName.NUMBER_ENTRIES), gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    private JPanel createBrowseButtonPanel(FieldName fieldName, JButton browseButton) {
        return Utilities.createBrowseButtonPanel(this.getLabel(fieldName), this.getField(fieldName), browseButton);
    }

    protected Message getInstructions() {
        return QuickSetupMessages.INFO_DATA_OPTIONS_PANEL_INSTRUCTIONS.get();
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_DATA_OPTIONS_PANEL_TITLE.get();
    }

    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    private Object getDefaultValue(FieldName fieldName) {
        Object value;
        switch (fieldName) {
            case DIRECTORY_BASE_DN: {
                value = this.defaultUserData.getNewSuffixOptions().getBaseDn();
                break;
            }
            case DATA_OPTIONS: {
                value = this.defaultUserData.getNewSuffixOptions().getType();
                break;
            }
            case LDIF_PATH: {
                value = this.defaultUserData.getNewSuffixOptions().getLDIFPath();
                break;
            }
            case NUMBER_ENTRIES: {
                value = this.defaultUserData.getNewSuffixOptions().getNumberEntries();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field name: " + (Object)((Object)fieldName));
            }
        }
        return value;
    }

    private String getDefaultStringValue(FieldName fieldName) {
        String value = null;
        Object v = this.getDefaultValue(fieldName);
        if (v != null) {
            value = v instanceof String ? (String)v : String.valueOf(v);
        }
        return value;
    }

    private void populateComponentMaps() {
        HashMap<FieldName, LabelFieldDescriptor> hm = new HashMap<FieldName, LabelFieldDescriptor>();
        hm.put(FieldName.DIRECTORY_BASE_DN, new LabelFieldDescriptor(QuickSetupMessages.INFO_BASE_DN_LABEL.get(), QuickSetupMessages.INFO_BASE_DN_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 20));
        hm.put(FieldName.LDIF_PATH, new LabelFieldDescriptor(QuickSetupMessages.INFO_IMPORT_PATH_LABEL.get(), QuickSetupMessages.INFO_IMPORT_PATH_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.SECONDARY, 20));
        hm.put(FieldName.NUMBER_ENTRIES, new LabelFieldDescriptor(QuickSetupMessages.INFO_NUMBER_ENTRIES_LABEL.get(), QuickSetupMessages.INFO_NUMBER_ENTRIES_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.SECONDARY, 7));
        for (FieldName fieldName : hm.keySet()) {
            LabelFieldDescriptor desc = (LabelFieldDescriptor)hm.get((Object)fieldName);
            String defaultValue = this.getDefaultStringValue(fieldName);
            JTextComponent field = UIFactory.makeJTextComponent(desc, defaultValue);
            this.hmFields.put(fieldName, field);
            JLabel l = UIFactory.makeJLabel(desc);
            l.setLabelFor(field);
            this.hmLabels.put(fieldName, l);
        }
        JLabel dataLabel = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_DIRECTORY_DATA_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        this.hmLabels.put(FieldName.DATA_OPTIONS, dataLabel);
        JRadioButton rb = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_CREATE_BASE_ENTRY_LABEL.get(this.getDefaultStringValue(FieldName.DIRECTORY_BASE_DN)), QuickSetupMessages.INFO_CREATE_BASE_ENTRY_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.hmRadioButtons.put(NewSuffixOptions.Type.CREATE_BASE_ENTRY, rb);
        dataLabel.setLabelFor(rb);
        rb = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_LEAVE_DATABASE_EMPTY_LABEL.get(), QuickSetupMessages.INFO_LEAVE_DATABASE_EMPTY_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.hmRadioButtons.put(NewSuffixOptions.Type.LEAVE_DATABASE_EMPTY, rb);
        rb = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_IMPORT_DATA_FROM_LDIF_LABEL.get(), QuickSetupMessages.INFO_IMPORT_DATA_FROM_LDIF_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.hmRadioButtons.put(NewSuffixOptions.Type.IMPORT_FROM_LDIF_FILE, rb);
        rb = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_IMPORT_AUTOMATICALLY_GENERATED_LABEL.get(), QuickSetupMessages.INFO_IMPORT_AUTOMATICALLY_GENERATED_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.hmRadioButtons.put(NewSuffixOptions.Type.IMPORT_AUTOMATICALLY_GENERATED_DATA, rb);
        NewSuffixOptions.Type defaultType = (NewSuffixOptions.Type)((Object)this.getDefaultValue(FieldName.DATA_OPTIONS));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (NewSuffixOptions.Type type : this.hmRadioButtons.keySet()) {
            rb = this.hmRadioButtons.get((Object)type);
            rb.setSelected(type == defaultType);
            buttonGroup.add(rb);
        }
        this.checkEnablingState();
    }

    private JButton getLDIFBrowseButton() {
        if (this.ldifBrowseButton == null) {
            this.ldifBrowseButton = UIFactory.makeJButton(QuickSetupMessages.INFO_BROWSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_BROWSE_BUTTON_TOOLTIP.get());
            BrowseActionListener l = new BrowseActionListener(this.getField(FieldName.LDIF_PATH), BrowseActionListener.BrowseType.OPEN_LDIF_FILE, this.getMainWindow());
            this.ldifBrowseButton.addActionListener(l);
        }
        return this.ldifBrowseButton;
    }

    private void addDocumentListeners() {
        JTextComponent tf = this.getField(FieldName.DIRECTORY_BASE_DN);
        tf.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                Message newLabel = QuickSetupMessages.INFO_CREATE_BASE_ENTRY_LABEL.get((String)DataOptionsPanel.this.getFieldValue(FieldName.DIRECTORY_BASE_DN));
                JRadioButton rb = DataOptionsPanel.this.getRadioButton(NewSuffixOptions.Type.CREATE_BASE_ENTRY);
                rb.setText(newLabel.toString());
            }

            public void insertUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }

            public void removeUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }
        });
    }

    private void addFocusListeners() {
        FocusListener l = new FocusListener(){

            public void focusGained(FocusEvent e) {
                DataOptionsPanel.this.lastFocusComponent = e.getComponent();
                if (DataOptionsPanel.this.lastFocusComponent == DataOptionsPanel.this.getField(FieldName.LDIF_PATH)) {
                    DataOptionsPanel.this.getRadioButton(NewSuffixOptions.Type.IMPORT_FROM_LDIF_FILE).setSelected(true);
                } else if (DataOptionsPanel.this.lastFocusComponent == DataOptionsPanel.this.getField(FieldName.NUMBER_ENTRIES)) {
                    DataOptionsPanel.this.getRadioButton(NewSuffixOptions.Type.IMPORT_AUTOMATICALLY_GENERATED_DATA).setSelected(true);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        };
        for (JTextComponent tf : this.hmFields.values()) {
            tf.addFocusListener(l);
        }
        for (JRadioButton rb : this.hmRadioButtons.values()) {
            rb.addFocusListener(l);
        }
        this.getLDIFBrowseButton().addFocusListener(l);
        this.lastFocusComponent = this.getField(FieldName.DIRECTORY_BASE_DN);
    }

    private void addActionListeners() {
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataOptionsPanel.this.checkEnablingState();
            }
        };
        for (JRadioButton rb : this.hmRadioButtons.values()) {
            rb.addActionListener(l);
        }
    }

    private void checkEnablingState() {
        boolean importLDIF = this.getRadioButton(NewSuffixOptions.Type.IMPORT_FROM_LDIF_FILE).isSelected();
        boolean automaticData = this.getRadioButton(NewSuffixOptions.Type.IMPORT_AUTOMATICALLY_GENERATED_DATA).isSelected();
        this.getField(FieldName.LDIF_PATH).setEnabled(importLDIF);
        this.getLDIFBrowseButton().setEnabled(importLDIF);
        this.getField(FieldName.NUMBER_ENTRIES).setEnabled(automaticData);
        this.getLabel(FieldName.LDIF_PATH).setEnabled(importLDIF);
        this.getLabel(FieldName.NUMBER_ENTRIES).setEnabled(automaticData);
    }

    private JLabel getLabel(FieldName fieldName) {
        return this.hmLabels.get((Object)fieldName);
    }

    private JTextComponent getField(FieldName fieldName) {
        return this.hmFields.get((Object)fieldName);
    }

    private JRadioButton getRadioButton(NewSuffixOptions.Type type) {
        return this.hmRadioButtons.get((Object)type);
    }
}

