/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupPanel;
import org.opends.quicksetup.ui.UIFactory;

public class QuickSetupErrorPanel
extends QuickSetupPanel {
    private static final long serialVersionUID = 1765037717593522233L;
    private HashSet<ButtonActionListener> buttonListeners = new HashSet();
    private JButton quitButton;
    private JButton continueButton;

    public QuickSetupErrorPanel(GuiApplication application, CurrentInstallStatus installStatus) {
        super(application);
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)UIFactory.makeJLabel(UIFactory.IconType.WARNING_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets.left = 0;
        JEditorPane tf = UIFactory.makeHtmlPane(installStatus.getInstallationMsg(), UIFactory.INSTRUCTIONS_FONT);
        tf.setOpaque(false);
        tf.setEditable(false);
        p1.add((Component)tf, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 3;
        p1.add(Box.createVerticalGlue(), gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 3;
        p2.add(Box.createHorizontalGlue(), gbc);
        this.quitButton = UIFactory.makeJButton(QuickSetupMessages.INFO_QUIT_BUTTON_LABEL.get(), QuickSetupMessages.INFO_QUIT_BUTTON_INSTALL_TOOLTIP.get());
        final ButtonName fQuitButtonName = ButtonName.QUIT;
        ActionListener quitListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ButtonEvent be = new ButtonEvent(ev.getSource(), fQuitButtonName);
                for (ButtonActionListener li : QuickSetupErrorPanel.this.buttonListeners) {
                    li.buttonActionPerformed(be);
                }
            }
        };
        this.quitButton.addActionListener(quitListener);
        this.continueButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CONTINUE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_CONTINUE_BUTTON_INSTALL_TOOLTIP.get());
        final ButtonName fContinueButtonName = ButtonName.CONTINUE_INSTALL;
        ActionListener continueListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ButtonEvent be = new ButtonEvent(ev.getSource(), fContinueButtonName);
                for (ButtonActionListener li : QuickSetupErrorPanel.this.buttonListeners) {
                    li.buttonActionPerformed(be);
                }
            }
        };
        this.continueButton.addActionListener(continueListener);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        p2.add((Component)this.continueButton, gbc);
        this.continueButton.setVisible(installStatus.canOverwriteCurrentInstall());
        gbc.insets.left = 5;
        gbc.gridwidth = 0;
        p2.add((Component)this.quitButton, gbc);
        this.setLayout(new GridBagLayout());
        this.setBackground(UIFactory.DEFAULT_BACKGROUND);
        this.setOpaque(true);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        this.add((Component)p2, gbc);
    }

    public void addButtonActionListener(ButtonActionListener l) {
        this.buttonListeners.add(l);
    }

    public void removeButtonActionListener(ButtonActionListener l) {
        this.buttonListeners.remove(l);
    }

    public JButton getQuitButton() {
        return this.quitButton;
    }

    public JButton getContinueInstallButton() {
        return this.continueButton;
    }
}

