/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.WebBrowserException;

public class WebBrowserErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1063837373763193941L;
    private JFrame parent;
    private String url;

    public WebBrowserErrorDialog(JFrame parent, WebBrowserException ex) {
        super(parent);
        this.setTitle(QuickSetupMessages.INFO_ERROR_BROWSER_DISPLAY_TITLE.get().toString());
        this.parent = parent;
        this.url = ex.getUrl();
        this.getContentPane().add(this.createPanel());
    }

    public void packAndShow() {
        this.pack();
        int minWidth = (int)this.getPreferredSize().getWidth();
        int minHeight = (int)this.getPreferredSize().getHeight();
        this.addComponentListener(new MinimumSizeComponentListener(this, minWidth, minHeight));
        Utilities.centerOnComponent(this, this.parent);
        this.setVisible(true);
    }

    private JPanel createPanel() {
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)UIFactory.makeJLabel(UIFactory.IconType.WARNING_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = -1;
        Insets pInsets = UIFactory.getCurrentStepPanelInsets();
        gbc.insets.left = 0;
        gbc.fill = 1;
        Message msg = QuickSetupMessages.INFO_ERROR_BROWSER_DISPLAY_MSG.get(this.url);
        JEditorPane tf = UIFactory.makeHtmlPane(msg, UIFactory.ERROR_DIALOG_FONT);
        tf.setOpaque(false);
        tf.setEditable(false);
        p1.add((Component)tf, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        JButton copyButton = UIFactory.makeJButton(QuickSetupMessages.INFO_ERROR_BROWSER_COPY_BUTTON_LABEL.get(), QuickSetupMessages.INFO_ERROR_BROWSER_COPY_BUTTON_TOOLTIP.get());
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StringSelection s = new StringSelection(WebBrowserErrorDialog.this.url);
                WebBrowserErrorDialog.this.getToolkit().getSystemClipboard().setContents(s, s);
            }
        });
        gbc.insets.left = 10;
        gbc.insets.right = pInsets.right;
        gbc.fill = 0;
        p1.add((Component)copyButton, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 3;
        p1.add(Box.createVerticalGlue(), gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        p2.add(Box.createHorizontalGlue(), gbc);
        JButton closeButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CLOSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_ERROR_BROWSER_CLOSE_BUTTON_TOOLTIP.get());
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        p2.add((Component)closeButton, gbc);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                WebBrowserErrorDialog.this.dispose();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        p.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)p2, gbc);
        return p;
    }

    public static void main(String[] args) {
        try {
            WebBrowserErrorDialog dlg = new WebBrowserErrorDialog(new JFrame(), new WebBrowserException("http://opends.org", Message.raw("toto", new Object[0]), null));
            dlg.packAndShow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

