/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.upgrader.Reverter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;

public class ReversionLauncher
extends Launcher {
    public static final Character DIRECTORY_OPTION_SHORT = Character.valueOf('d');
    public static final String DIRECTORY_OPTION_LONG = "directory";
    public static final Character MOST_RECENT_OPTION_SHORT = Character.valueOf('m');
    public static final String MOST_RECENT_OPTION_LONG = "mostRecent";
    private static final String LOG_FILE_PREFIX = "opends-revert-";
    private ArgumentParser argParser;
    private BooleanArgument showUsage;
    private FileBasedArgument dir;
    private BooleanArgument mostRecent;
    private BooleanArgument quiet;
    private BooleanArgument interactive;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        new ReversionLauncher(args).launch();
    }

    public File getFilesDirectory() {
        File f = null;
        String s = this.dir.getValue();
        if (s != null) {
            f = new File(s);
        }
        return f;
    }

    public boolean useMostRecentUpgrade() {
        return this.mostRecent.isPresent();
    }

    protected boolean isCli() {
        return true;
    }

    protected Message getFrameTitle() {
        return null;
    }

    protected CliApplication createCliApplication() {
        return new Reverter();
    }

    protected void willLaunchGui() {
    }

    protected void guiLaunchFailed(String logFileName) {
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }

    protected ReversionLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "revert.bat" : "revert";
        System.setProperty("org.opends.server.scriptName", scriptName);
        this.argParser = new ArgumentParser(this.getClass().getName(), QuickSetupMessages.INFO_REVERT_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            this.dir = new FileBasedArgument(DIRECTORY_OPTION_LONG, DIRECTORY_OPTION_SHORT, DIRECTORY_OPTION_LONG, false, false, "{directory}", null, null, ToolMessages.INFO_REVERT_DESCRIPTION_DIRECTORY.get());
            this.argParser.addArgument(this.dir);
            this.mostRecent = new BooleanArgument(MOST_RECENT_OPTION_LONG, MOST_RECENT_OPTION_SHORT, MOST_RECENT_OPTION_LONG, ToolMessages.INFO_REVERT_DESCRIPTION_RECENT.get());
            this.argParser.addArgument(this.mostRecent);
            this.interactive = new BooleanArgument("interactive", Character.valueOf('i'), "interactive", ToolMessages.INFO_REVERT_DESCRIPTION_INTERACTIVE.get());
            this.argParser.addArgument(this.interactive);
            this.quiet = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_REVERT_DESCRIPTION_SILENT.get());
            this.argParser.addArgument(this.quiet);
            this.showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.argParser.addArgument(this.showUsage);
            this.argParser.setUsageArgument(this.showUsage);
            this.argParser.parseArguments(args);
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }

    private void validate(ArgumentParser argParser) {
    }
}

