/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;

public class UpgradeLauncher
extends Launcher {
    public static final String LOG_FILE_PREFIX = "opends-upgrade-";
    private static final Logger LOG = Logger.getLogger(UpgradeLauncher.class.getName());
    public static final Character FILE_OPTION_SHORT = Character.valueOf('f');
    public static final String FILE_OPTION_LONG = "file";
    private ArgumentParser argParser;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        new UpgradeLauncher(args).launch();
    }

    protected Message getFrameTitle() {
        return QuickSetupMessages.INFO_FRAME_UPGRADE_TITLE.get();
    }

    protected boolean isCli() {
        return true;
    }

    protected void printUsage(boolean toStdErr) {
        try {
            ArgumentParser argParser = this.getArgumentParser();
            if (argParser != null) {
                String msg = argParser.getUsage();
                this.printUsage(msg, toStdErr);
            }
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }

    protected CliApplication createCliApplication() {
        return new Upgrader();
    }

    protected void willLaunchGui() {
        System.out.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_LAUNCHING_GUI.get());
        System.setProperty("org.opends.quicksetup.Application.class", "org.opends.quicksetup.upgrader.Upgrader");
    }

    protected void guiLaunchFailed(String logFilePath) {
        if (logFilePath != null) {
            System.err.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_GUI_LAUNCHED_FAILED_DETAILS.get(logFilePath));
        } else {
            System.err.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_GUI_LAUNCHED_FAILED.get());
        }
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }

    protected UpgradeLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "upgrade.bat" : "upgrade";
        System.setProperty("org.opends.server.scriptName", scriptName);
        this.argParser = new ArgumentParser(this.getClass().getName(), QuickSetupMessages.INFO_UPGRADE_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            FileBasedArgument file = new FileBasedArgument(FILE_OPTION_LONG, FILE_OPTION_SHORT, FILE_OPTION_LONG, false, false, "{file}", null, null, ToolMessages.INFO_UPGRADE_DESCRIPTION_FILE.get());
            this.argParser.addArgument(file);
            BooleanArgument interactive = new BooleanArgument("interactive", SecureConnectionCliParser.INTERACTIVE_OPTION_SHORT, "interactive", ToolMessages.INFO_UPGRADE_DESCRIPTION_INTERACTIVE.get());
            this.argParser.addArgument(interactive);
            BooleanArgument quiet = new BooleanArgument("quiet", SecureConnectionCliParser.QUIET_OPTION_SHORT, "quiet", ToolMessages.INFO_UPGRADE_DESCRIPTION_SILENT.get());
            this.argParser.addArgument(quiet);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.argParser.addArgument(showUsage);
            this.argParser.setUsageArgument(showUsage);
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }
}

