/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ProgressStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum UpgradeProgressStep implements ProgressStep
{
    NOT_STARTED(QuickSetupMessages.INFO_SUMMARY_UPGRADE_NOT_STARTED.get(), 0),
    DOWNLOADING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_DOWNLOADING.get(), 10),
    EXTRACTING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_EXTRACTING.get(), 20),
    INITIALIZING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_INITIALIZING.get(), 30),
    CHECK_SERVER_HEALTH(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CHECK_SERVER_HEALTH.get(), 35),
    CALCULATING_SCHEMA_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CALCULATING_SCHEMA_CUSTOMIZATION.get(), 40),
    CALCULATING_CONFIGURATION_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CALCULATING_CONFIG_CUSTOMIZATION.get(), 48),
    BACKING_UP_DATABASES(QuickSetupMessages.INFO_SUMMARY_UPGRADE_BACKING_UP_DB.get(), 50),
    BACKING_UP_FILESYSTEM(QuickSetupMessages.INFO_SUMMARY_UPGRADE_BACKING_UP_FILES.get(), 52),
    UPGRADING_COMPONENTS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_UPGRADING_COMPONENTS.get(), 60),
    PREPARING_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_PREPARING_CUSTOMIZATIONS.get(), 65),
    APPLYING_SCHEMA_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_APPLYING_SCHEMA_CUSTOMIZATION.get(), 70),
    APPLYING_CONFIGURATION_CUSTOMIZATIONS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_APPLYING_CONFIG_CUSTOMIZATION.get(), 75),
    VERIFYING(QuickSetupMessages.INFO_SUMMARY_UPGRADE_VERIFYING.get(), 80),
    STARTING_SERVER(QuickSetupMessages.INFO_SUMMARY_STARTING.get(), 90),
    STOPPING_SERVER(QuickSetupMessages.INFO_SUMMARY_STOPPING.get(), 90),
    RECORDING_HISTORY(QuickSetupMessages.INFO_SUMMARY_UPGRADE_HISTORY.get(), 97),
    CLEANUP(QuickSetupMessages.INFO_SUMMARY_UPGRADE_CLEANUP.get(), 99),
    ABORT(QuickSetupMessages.INFO_SUMMARY_UPGRADE_ABORT.get(), 99),
    FINISHED_WITH_ERRORS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_ERRORS.get(), 100),
    FINISHED_WITH_WARNINGS(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_WARNINGS.get(), 100),
    FINISHED_CANCELED(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_CANCELED.get(), 100),
    FINISHED(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_SUCCESSFULLY.get("", ""), 100);

    private Message summaryMsg;
    private int progress;

    private UpgradeProgressStep(Message summaryMsg, int progress) {
        this.summaryMsg = summaryMsg;
        this.progress = progress;
    }

    public Message getSummaryMesssage() {
        return this.summaryMsg;
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isLast() {
        return this == FINISHED || this == FINISHED_WITH_ERRORS || this == FINISHED_WITH_WARNINGS || this == FINISHED_CANCELED;
    }

    @Override
    public boolean isError() {
        return this == FINISHED_WITH_ERRORS;
    }
}

