/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;

public class HtmlProgressMessageFormatter
implements ProgressMessageFormatter {
    private static final Logger LOG = Logger.getLogger(HtmlProgressMessageFormatter.class.getName());
    private Message doneHtml;
    private Message errorHtml;
    private String PARAM_SEPARATOR = "&&&&";
    private static Message SPACE = Message.raw("&nbsp;", new Object[0]);

    public Message getFormattedText(Message text) {
        return Message.raw(this.getHtml(String.valueOf(text)), new Object[0]);
    }

    public Message getFormattedSummary(Message text) {
        return new MessageBuilder("<html>").append(UIFactory.applyFontToHtml(String.valueOf(text), UIFactory.PROGRESS_FONT)).toMessage();
    }

    public Message getFormattedError(Message text, boolean applyMargin) {
        String html = !Utils.containsHtml(String.valueOf(text)) ? UIFactory.getIconHtml(UIFactory.IconType.ERROR_LARGE) + SPACE + SPACE + UIFactory.applyFontToHtml(this.getHtml(String.valueOf(text)), UIFactory.PROGRESS_ERROR_FONT) : UIFactory.getIconHtml(UIFactory.IconType.ERROR_LARGE) + SPACE + SPACE + UIFactory.applyFontToHtml(String.valueOf(text), UIFactory.PROGRESS_FONT);
        String result = UIFactory.applyErrorBackgroundToHtml(html);
        if (applyMargin) {
            result = UIFactory.applyMargin(result, 10, 0, 0, 0);
        }
        return Message.raw(result, new Object[0]);
    }

    public Message getFormattedWarning(Message text, boolean applyMargin) {
        String html = !Utils.containsHtml(String.valueOf(text)) ? UIFactory.getIconHtml(UIFactory.IconType.WARNING_LARGE) + SPACE + SPACE + UIFactory.applyFontToHtml(this.getHtml(String.valueOf(text)), UIFactory.PROGRESS_WARNING_FONT) : UIFactory.getIconHtml(UIFactory.IconType.WARNING_LARGE) + SPACE + SPACE + UIFactory.applyFontToHtml(String.valueOf(text), UIFactory.PROGRESS_FONT);
        String result = UIFactory.applyWarningBackgroundToHtml(html);
        if (applyMargin) {
            result = UIFactory.applyMargin(result, 10, 0, 0, 0);
        }
        return Message.raw(result, new Object[0]);
    }

    public Message getFormattedSuccess(Message text) {
        String html = UIFactory.getIconHtml(UIFactory.IconType.INFORMATION_LARGE) + SPACE + SPACE + UIFactory.applyFontToHtml(String.valueOf(text), UIFactory.PROGRESS_FONT);
        return Message.raw(UIFactory.applySuccessfulBackgroundToHtml(html), new Object[0]);
    }

    public Message getFormattedLogError(Message text) {
        String html = this.getHtml(String.valueOf(text));
        return Message.raw(UIFactory.applyFontToHtml(html, UIFactory.PROGRESS_LOG_ERROR_FONT), new Object[0]);
    }

    public Message getFormattedLog(Message text) {
        String html = this.getHtml(String.valueOf(text));
        return Message.raw(UIFactory.applyFontToHtml(html, UIFactory.PROGRESS_LOG_FONT), new Object[0]);
    }

    public Message getFormattedDone() {
        if (this.doneHtml == null) {
            String html = this.getHtml(QuickSetupMessages.INFO_PROGRESS_DONE.get().toString());
            this.doneHtml = Message.raw(UIFactory.applyFontToHtml(html, UIFactory.PROGRESS_DONE_FONT), new Object[0]);
        }
        return Message.raw(this.doneHtml, new Object[0]);
    }

    public Message getFormattedError() {
        if (this.errorHtml == null) {
            String html = this.getHtml(QuickSetupMessages.INFO_PROGRESS_ERROR.get().toString());
            this.errorHtml = Message.raw(UIFactory.applyFontToHtml(html, UIFactory.PROGRESS_ERROR_FONT), new Object[0]);
        }
        return Message.raw(this.errorHtml, new Object[0]);
    }

    public Message getFormattedWithPoints(Message text) {
        String html = this.getHtml(String.valueOf(text));
        String points = SPACE + this.getHtml(QuickSetupMessages.INFO_PROGRESS_POINTS.get().toString()) + SPACE;
        MessageBuilder buf = new MessageBuilder();
        buf.append(UIFactory.applyFontToHtml(html, UIFactory.PROGRESS_FONT)).append(UIFactory.applyFontToHtml(points, UIFactory.PROGRESS_POINTS_FONT));
        return buf.toMessage();
    }

    public Message getFormattedProgress(Message text) {
        return Message.raw(UIFactory.applyFontToHtml(this.getHtml(String.valueOf(text)), UIFactory.PROGRESS_FONT), new Object[0]);
    }

    public Message getFormattedError(Throwable t, boolean applyMargin) {
        String openDiv = "<div style=\"margin-left:5px; margin-top:10px\">";
        String hideText = UIFactory.applyFontToHtml(QuickSetupMessages.INFO_HIDE_EXCEPTION_DETAILS.get().toString(), UIFactory.PROGRESS_FONT);
        String showText = UIFactory.applyFontToHtml(QuickSetupMessages.INFO_SHOW_EXCEPTION_DETAILS.get().toString(), UIFactory.PROGRESS_FONT);
        String closeDiv = "</div>";
        StringBuilder stackBuf = new StringBuilder();
        stackBuf.append(this.getHtmlStack(t));
        for (Throwable root = t.getCause(); root != null; root = root.getCause()) {
            stackBuf.append(this.getHtml(QuickSetupMessages.INFO_EXCEPTION_ROOT_CAUSE.get().toString())).append("<br>");
            stackBuf.append(this.getHtmlStack(root));
        }
        String stackText = UIFactory.applyFontToHtml(stackBuf.toString(), UIFactory.STACK_FONT);
        StringBuilder buf = new StringBuilder();
        String msg = t.getMessage();
        if (msg != null) {
            buf.append(UIFactory.applyFontToHtml(this.getHtml(t.getMessage()), UIFactory.PROGRESS_ERROR_FONT)).append("<br>");
        } else {
            buf.append(t.toString()).append("<br>");
        }
        buf.append(this.getErrorWithStackHtml(openDiv, hideText, showText, stackText, closeDiv, false));
        String html = UIFactory.getIconHtml(UIFactory.IconType.ERROR_LARGE) + SPACE + SPACE + buf.toString();
        String result = applyMargin ? UIFactory.applyMargin(UIFactory.applyErrorBackgroundToHtml(html), 10, 0, 0, 0) : UIFactory.applyErrorBackgroundToHtml(html);
        return Message.raw(result, new Object[0]);
    }

    public Message getLineBreak() {
        return Message.raw("<br>", new Object[0]);
    }

    public Message getTab() {
        return new MessageBuilder(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).toMessage();
    }

    public Message getTaskSeparator() {
        return Message.raw(UIFactory.HTML_SEPARATOR, new Object[0]);
    }

    public Message getFormattedAfterUrlClick(String url, Message lastText) {
        String urlText = this.getErrorWithStackHtml(url, false);
        String newUrlText = this.getErrorWithStackHtml(url, true);
        String lastTextStr = String.valueOf(lastText);
        int index = lastTextStr.indexOf(urlText);
        if (index == -1) {
            LOG.log(Level.FINE, "lastText: " + lastText + "does not contain: " + urlText);
        } else {
            lastTextStr = lastTextStr.substring(0, index) + newUrlText + lastTextStr.substring(index + urlText.length());
        }
        return Message.raw(lastTextStr, new Object[0]);
    }

    private String getHtml(String text) {
        StringBuilder buffer = new StringBuilder();
        if (text != null) {
            text = text.replaceAll("\r\n", "\n");
            String[] lines = text.split("[\n\r\u0085\u2028\u2029]");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    buffer.append("<br>");
                }
                buffer.append(this.escape(lines[i]));
            }
        }
        return buffer.toString();
    }

    private String escape(String rawString) {
        StringBuilder buffer = new StringBuilder();
        block6: for (int i = 0; i < rawString.length(); ++i) {
            char c = rawString.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private String getHtmlStack(Throwable ex) {
        StackTraceElement[] stack;
        StringBuilder buf = new StringBuilder();
        buf.append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(this.getHtml(ex.toString())).append("<br>");
        for (StackTraceElement aStack : stack = ex.getStackTrace()) {
            buf.append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(SPACE).append(this.getHtml(aStack.toString())).append("<br>");
        }
        return buf.toString();
    }

    private String getErrorWithStackHtml(String openDiv, String hideText, String showText, String stackText, String closeDiv, boolean hide) {
        StringBuilder buf = new StringBuilder();
        String params = this.getUrlParams(openDiv, hideText, showText, stackText, closeDiv, hide);
        try {
            String text = hide ? hideText : showText;
            buf.append(openDiv).append("<a href=\"http://").append(URLEncoder.encode(params, "UTF-8")).append("\">").append(text).append("</a>");
            if (hide) {
                buf.append("<br>").append(stackText);
            }
            buf.append(closeDiv);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("UTF-8 is not supported ", uee);
        }
        return buf.toString();
    }

    private String getUrlParams(String openDiv, String hideText, String showText, String stackText, String closeDiv, boolean hide) {
        StringBuilder buf = new StringBuilder();
        buf.append(openDiv).append(this.PARAM_SEPARATOR);
        buf.append(hideText).append(this.PARAM_SEPARATOR);
        buf.append(showText).append(this.PARAM_SEPARATOR);
        buf.append(stackText).append(this.PARAM_SEPARATOR);
        buf.append(closeDiv).append(this.PARAM_SEPARATOR);
        buf.append(hide);
        return buf.toString();
    }

    private String getErrorWithStackHtml(String url, boolean inverse) {
        String p = url.substring("http://".length());
        try {
            p = URLDecoder.decode(p, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("UTF-8 is not supported ", uee);
        }
        String[] params = p.split(this.PARAM_SEPARATOR);
        int i = 0;
        String openDiv = params[i++];
        String hideText = params[i++];
        String showText = params[i++];
        String stackText = params[i++];
        String closeDiv = params[i++];
        boolean isHide = Boolean.valueOf(params[i]);
        if (isHide) {
            return this.getErrorWithStackHtml(openDiv, hideText, showText, stackText, closeDiv, !inverse);
        }
        return this.getErrorWithStackHtml(openDiv, hideText, showText, stackText, closeDiv, inverse);
    }
}

