/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationDefinitionVisitor;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregationRelationDefinition<C extends ConfigurationClient, S extends Configuration>
extends RelationDefinition<C, S> {
    private final int maxOccurs;
    private final int minOccurs;
    private final ManagedObjectPath<?, ?> path;
    private final String pluralName;

    private AggregationRelationDefinition(RelationDefinition.Common<C, S> common, String pluralName, ManagedObjectPath<?, ?> path, int minOccurs, int maxOccurs) throws IllegalArgumentException {
        super(common);
        Validator.ensureNotNull(path);
        if (minOccurs < 0) {
            throw new IllegalArgumentException("minOccurs is less than zero");
        }
        if (maxOccurs != 0 && maxOccurs < minOccurs) {
            throw new IllegalArgumentException("maxOccurs is less than minOccurs");
        }
        this.pluralName = pluralName;
        this.path = path;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    @Override
    public <R, P> R accept(RelationDefinitionVisitor<R, P> v, P p) {
        return v.visitAggregation(this, p);
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public ManagedObjectPath<?, ?> getPath() {
        return this.path;
    }

    public final String getPluralName() {
        return this.pluralName;
    }

    @Override
    public final void toString(StringBuilder builder) {
        builder.append("name=");
        builder.append(this.getName());
        builder.append(" type=aggregation parent=");
        builder.append(this.getParentDefinition().getName());
        builder.append(" child=");
        builder.append(this.getChildDefinition().getName());
        builder.append(" minOccurs=");
        builder.append(this.minOccurs);
        if (this.maxOccurs != 0) {
            builder.append(" maxOccurs=");
            builder.append(this.maxOccurs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<C extends ConfigurationClient, S extends Configuration>
    extends RelationDefinition.AbstractBuilder<C, S, AggregationRelationDefinition<C, S>> {
        private int maxOccurs = 0;
        private int minOccurs = 0;
        private ManagedObjectPath<?, ?> path;
        private final String pluralName;

        public Builder(AbstractManagedObjectDefinition<?, ?> pd, String name, String pluralName, AbstractManagedObjectDefinition<C, S> cd) {
            super(pd, name, cd);
            this.pluralName = pluralName;
        }

        public void setMaxOccurs(int maxOccurs) {
            this.maxOccurs = maxOccurs;
        }

        public void setMinOccurs(int minOccurs) {
            this.minOccurs = minOccurs;
        }

        public void setPath(ManagedObjectPath<?, ?> path) {
            this.path = path;
        }

        @Override
        protected AggregationRelationDefinition<C, S> buildInstance(RelationDefinition.Common<C, S> common) {
            return new AggregationRelationDefinition(common, this.pluralName, this.path, this.minOccurs, this.maxOccurs);
        }
    }
}

