/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.RootCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public final class ClassLoaderProvider {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CORE_MANIFEST = "core.manifest";
    private static final String EXTENSION_MANIFEST = "extension.manifest";
    private static final String LIB_DIR = "lib";
    private static final String EXTENSIONS_DIR = "extensions";
    private static final ClassLoaderProvider INSTANCE = new ClassLoaderProvider();
    private Set<File> jarFiles = new HashSet<File>();
    private MyURLClassLoader loader = null;

    public static ClassLoaderProvider getInstance() {
        return INSTANCE;
    }

    private ClassLoaderProvider() {
    }

    public synchronized void addExtension(String ... extensions) throws InitializationException, IllegalStateException, IllegalArgumentException {
        Validator.ensureNotNull(extensions);
        if (this.loader == null) {
            throw new IllegalStateException("Class loader provider is disabled.");
        }
        File libPath = new File(DirectoryServer.getServerRoot(), LIB_DIR);
        File extensionsPath = new File(libPath, EXTENSIONS_DIR);
        ArrayList<File> files = new ArrayList<File>(extensions.length);
        for (String extension : extensions) {
            File file = new File(extensionsPath, extension);
            if (!extensionsPath.equals(file.getParentFile())) {
                throw new IllegalArgumentException("Illegal file name: " + extension);
            }
            files.add(file);
        }
        this.addExtension(files.toArray(new File[files.size()]));
    }

    public synchronized void disable() throws IllegalStateException {
        if (this.loader == null) {
            throw new IllegalStateException("Class loader provider already disabled.");
        }
        this.loader = null;
        this.jarFiles = new HashSet<File>();
    }

    public synchronized void enable() throws InitializationException, IllegalStateException {
        this.enable(RootCfgDefn.class.getClassLoader());
    }

    public synchronized void enable(ClassLoader parent) throws InitializationException, IllegalStateException {
        if (this.loader != null) {
            throw new IllegalStateException("Class loader provider already enabled.");
        }
        this.loader = parent != null ? new MyURLClassLoader(parent) : new MyURLClassLoader();
        this.initializeCoreComponents();
        this.initializeAllExtensions();
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public synchronized boolean isEnabled() {
        return this.loader != null;
    }

    private synchronized void addExtension(File ... extensions) throws InitializationException {
        LinkedList<JarFile> jars = new LinkedList<JarFile>();
        for (File extension : extensions) {
            if (this.jarFiles.contains(extension)) continue;
            jars.add(this.loadJarFile(extension));
            try {
                this.loader.addJarFile(extension);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = AdminMessages.ERR_ADMIN_CANNOT_OPEN_JAR_FILE.get(extension.getName(), extension.getParent(), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(message);
            }
            this.jarFiles.add(extension);
        }
        for (JarFile jar : jars) {
            this.initializeExtension(jar);
        }
    }

    private void initializeAllExtensions() throws InitializationException {
        File libPath = new File(DirectoryServer.getServerRoot(), LIB_DIR);
        File extensionsPath = new File(libPath, EXTENSIONS_DIR);
        try {
            if (!extensionsPath.exists()) {
                Message message = AdminMessages.ERR_ADMIN_NO_EXTENSIONS_DIR.get(String.valueOf(extensionsPath));
                ErrorLogger.logError(message);
                return;
            }
            if (!extensionsPath.isDirectory()) {
                Message message = AdminMessages.ERR_ADMIN_EXTENSIONS_DIR_NOT_DIRECTORY.get(String.valueOf(extensionsPath));
                throw new InitializationException(message);
            }
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.isFile()) {
                        return false;
                    }
                    String name = pathname.getName();
                    return name.endsWith(".jar");
                }
            };
            this.addExtension(extensionsPath.listFiles(filter));
        }
        catch (InitializationException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw e;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_EXTENSIONS_CANNOT_LIST_FILES.get(String.valueOf(extensionsPath), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    private void initializeCoreComponents() throws InitializationException {
        InputStream is = RootCfgDefn.class.getResourceAsStream("/admin/core.manifest");
        if (is == null) {
            Message message = AdminMessages.ERR_ADMIN_CANNOT_FIND_CORE_MANIFEST.get(CORE_MANIFEST);
            throw new InitializationException(message);
        }
        try {
            this.loadDefinitionClasses(is);
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_READ_CORE_MANIFEST.get(CORE_MANIFEST, StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_LOAD_CLASS_FROM_CORE_MANIFEST.get(CORE_MANIFEST, StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message);
        }
    }

    private void initializeExtension(JarFile jarFile) throws InitializationException {
        JarEntry entry = jarFile.getJarEntry("admin/extension.manifest");
        if (entry != null) {
            InputStream is;
            try {
                is = jarFile.getInputStream(entry);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = AdminMessages.ERR_ADMIN_CANNOT_READ_EXTENSION_MANIFEST.get(EXTENSION_MANIFEST, jarFile.getName(), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(message);
            }
            try {
                this.loadDefinitionClasses(is);
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = AdminMessages.ERR_ADMIN_CANNOT_READ_EXTENSION_MANIFEST.get(EXTENSION_MANIFEST, jarFile.getName(), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(message);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = AdminMessages.ERR_ADMIN_CANNOT_LOAD_CLASS_FROM_EXTENSION_MANIFEST.get(EXTENSION_MANIFEST, jarFile.getName(), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(message);
            }
        }
    }

    private void loadDefinitionClasses(InputStream is) throws IOException, ClassNotFoundException, LinkageError, ExceptionInInitializerError {
        String className;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((className = reader.readLine()) != null) {
            if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
            TRACER.debugMessage(DebugLogLevel.INFO, "Loading class " + className);
            Class.forName(className, true, this.loader);
        }
    }

    private JarFile loadJarFile(File jar) throws InitializationException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(jar);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_OPEN_JAR_FILE.get(jar.getName(), jar.getParent(), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message);
        }
        return jarFile;
    }

    private static final class MyURLClassLoader
    extends URLClassLoader {
        public MyURLClassLoader() {
            super(new URL[0]);
        }

        public MyURLClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void addJarFile(File jarFile) throws SecurityException, MalformedURLException {
            this.addURL(jarFile.toURI().toURL());
        }
    }
}

