/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import org.opends.messages.Message;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.OperationsException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IllegalManagedObjectNameException
extends OperationsException {
    private static final long serialVersionUID = 7491748228684293291L;
    private final String illegalName;
    private final PropertyDefinition<?> namingPropertyDefinition;

    public IllegalManagedObjectNameException(String illegalName) {
        this(illegalName, (PropertyDefinition<?>)null);
    }

    public IllegalManagedObjectNameException(String illegalName, PropertyDefinition<?> namingPropertyDefinition) {
        this.illegalName = illegalName;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    public String getIllegalName() {
        return this.illegalName;
    }

    public PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }

    @Override
    public Message getMessageObject() {
        if (this.illegalName.length() == 0) {
            return Message.raw("Empty managed object names are not permitted", new Object[0]);
        }
        if (this.illegalName.trim().length() == 0) {
            return Message.raw("Blank managed object names are not permitted", new Object[0]);
        }
        if (this.namingPropertyDefinition != null) {
            try {
                this.namingPropertyDefinition.decodeValue(this.illegalName);
            }
            catch (IllegalPropertyValueStringException e) {
                String msg = "The managed object name \"%s\" is not a valid value for the naming property \"%s\", which must have the following syntax: %s";
                PropertyDefinitionUsageBuilder builder = new PropertyDefinitionUsageBuilder(true);
                return Message.raw(String.format(msg, this.illegalName, this.namingPropertyDefinition.getName(), builder.getUsage(this.namingPropertyDefinition)), new Object[0]);
            }
        }
        return Message.raw("The managed object name \"" + this.illegalName + "\" is not permitted", new Object[0]);
    }
}

