/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import org.opends.admin.ads.util.ApplicationKeyManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecureConnectionCliParser
extends SubCommandArgumentParser {
    protected BooleanArgument showUsageArg = null;
    protected StringArgument hostNameArg = null;
    protected IntegerArgument portArg = null;
    protected StringArgument bindDnArg = null;
    protected FileBasedArgument bindPasswordFileArg = null;
    protected StringArgument bindPasswordArg = null;
    protected BooleanArgument verboseArg = null;
    protected BooleanArgument trustAllArg = null;
    protected StringArgument trustStorePathArg = null;
    protected StringArgument trustStorePasswordArg = null;
    protected FileBasedArgument trustStorePasswordFileArg = null;
    protected StringArgument keyStorePathArg = null;
    protected StringArgument keyStorePasswordArg = null;
    protected FileBasedArgument keyStorePasswordFileArg = null;
    protected StringArgument certNicknameArg = null;
    protected BooleanArgument useSSLArg = null;
    protected BooleanArgument startTLSArg = null;
    public static final Character INTERACTIVE_OPTION_SHORT = Character.valueOf('i');
    public static final String QUIET_OPTION_LONG = "quiet";
    public static final String INTERACTIVE_OPTION_LONG = "interactive";
    public static final Character QUIET_OPTION_SHORT = Character.valueOf('Q');
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected static String EOL = System.getProperty("line.separator");
    private static final Logger LOG = Logger.getLogger(SecureConnectionCliParser.class.getName());

    protected SecureConnectionCliParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public String getBindDN() {
        if (this.bindDnArg.isPresent()) {
            return this.bindDnArg.getValue();
        }
        return this.bindDnArg.getDefaultValue();
    }

    protected String getBindPassword(String dn, OutputStream out, OutputStream err, StringArgument clearArg, FileBasedArgument fileArg) {
        if (clearArg.isPresent()) {
            String bindPasswordValue = clearArg.getValue();
            if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
                try {
                    out.write(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(dn).getBytes());
                    char[] pwChars = PasswordReader.readPassword();
                    bindPasswordValue = new String(pwChars);
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    try {
                        err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                        err.write(EOL.getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return bindPasswordValue;
        }
        if (fileArg.isPresent()) {
            return fileArg.getValue();
        }
        try {
            out.write(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(dn).toString().getBytes());
            char[] pwChars = PasswordReader.readPassword();
            return new String(pwChars);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            try {
                err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                err.write(EOL.getBytes());
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
    }

    public String getBindPassword(String dn, OutputStream out, OutputStream err) {
        return this.getBindPassword(dn, out, err, this.bindPasswordArg, this.bindPasswordFileArg);
    }

    public String getBindPassword(StringArgument clearArg, FileBasedArgument fileArg) {
        String pwd = clearArg.isPresent() ? clearArg.getValue() : (fileArg.isPresent() ? fileArg.getValue() : null);
        return pwd;
    }

    public String getBindPassword() {
        return this.getBindPassword(this.bindPasswordArg, this.bindPasswordFileArg);
    }

    protected LinkedHashSet<Argument> createGlobalArguments(OutputStream outStream) throws ArgumentException {
        LinkedHashSet<Argument> set = new LinkedHashSet<Argument>();
        this.showUsageArg = new BooleanArgument("showUsage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
        this.setUsageArgument(this.showUsageArg, outStream);
        set.add(this.showUsageArg);
        this.useSSLArg = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_DESCRIPTION_USE_SSL.get());
        set.add(this.useSSLArg);
        this.startTLSArg = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_DESCRIPTION_START_TLS.get());
        set.add(this.startTLSArg);
        this.hostNameArg = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "localhost", null, ToolMessages.INFO_DESCRIPTION_HOST.get());
        set.add(this.hostNameArg);
        this.portArg = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, ToolMessages.INFO_DESCRIPTION_PORT.get());
        set.add(this.portArg);
        this.bindDnArg = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", "cn=Directory Manager", null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
        set.add(this.bindDnArg);
        this.bindPasswordArg = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
        set.add(this.bindPasswordArg);
        this.bindPasswordFileArg = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
        set.add(this.bindPasswordFileArg);
        this.trustAllArg = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", ToolMessages.INFO_DESCRIPTION_TRUSTALL.get());
        set.add(this.trustAllArg);
        this.trustStorePathArg = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get());
        set.add(this.trustStorePathArg);
        this.trustStorePasswordArg = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get());
        set.add(this.trustStorePasswordArg);
        this.trustStorePasswordFileArg = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get());
        set.add(this.trustStorePasswordFileArg);
        this.keyStorePathArg = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPATH.get());
        set.add(this.keyStorePathArg);
        this.keyStorePasswordArg = new StringArgument("keyStorePassword", null, "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD.get());
        set.add(this.keyStorePasswordArg);
        this.keyStorePasswordFileArg = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
        set.add(this.keyStorePasswordFileArg);
        this.certNicknameArg = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
        set.add(this.certNicknameArg);
        this.verboseArg = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
        set.add(this.verboseArg);
        return set;
    }

    protected void initializeGlobalArguments(Collection<Argument> args) throws ArgumentException {
        for (Argument arg : args) {
            this.addGlobalArgument(arg);
        }
    }

    public String getHostName() {
        if (this.hostNameArg.isPresent()) {
            return this.hostNameArg.getValue();
        }
        return this.hostNameArg.getDefaultValue();
    }

    public String getPort() {
        if (this.portArg.isPresent()) {
            return this.portArg.getValue();
        }
        return this.portArg.getDefaultValue();
    }

    public int validateGlobalOptions(MessageBuilder buf) {
        Message message;
        ArrayList<Message> errors = new ArrayList<Message>();
        if (this.bindPasswordArg.isPresent() && this.bindPasswordFileArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.bindPasswordArg.getLongIdentifier(), this.bindPasswordFileArg.getLongIdentifier());
            errors.add(message);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePathArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustAllArg.getLongIdentifier(), this.trustStorePathArg.getLongIdentifier());
            errors.add(message);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustAllArg.getLongIdentifier(), this.trustStorePasswordArg.getLongIdentifier());
            errors.add(message);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustAllArg.getLongIdentifier(), this.trustStorePasswordFileArg.getLongIdentifier());
            errors.add(message);
        }
        if (this.trustStorePasswordArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustStorePasswordArg.getLongIdentifier(), this.trustStorePasswordFileArg.getLongIdentifier());
            errors.add(message);
        }
        if (this.startTLSArg.isPresent() && this.useSSLArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.startTLSArg.getLongIdentifier(), this.useSSLArg.getLongIdentifier());
            errors.add(message);
        }
        if (errors.size() > 0) {
            for (Message error : errors) {
                if (buf.length() > 0) {
                    buf.append(EOL);
                }
                buf.append(error);
            }
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        return DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
    }

    public int validateGlobalOptions(PrintStream err) {
        MessageBuilder buf = new MessageBuilder();
        int returnValue = this.validateGlobalOptions(buf);
        if (buf.length() > 0) {
            err.println(StaticUtils.wrapText(buf.toString(), ServerConstants.MAX_LINE_WIDTH));
        }
        return returnValue;
    }

    public boolean isVerbose() {
        return this.verboseArg.isPresent();
    }

    public boolean useSSL() {
        return this.useSSLArg.isPresent();
    }

    public boolean startTLS() {
        return this.startTLSArg.isPresent();
    }

    public ApplicationTrustManager getTrustManager() {
        ApplicationTrustManager truststoreManager = null;
        KeyStore truststore = null;
        if (this.trustAllArg.isPresent()) {
            return null;
        }
        if (this.trustStorePathArg.isPresent()) {
            try {
                FileInputStream fos = new FileInputStream(this.trustStorePathArg.getValue());
                String trustStorePasswordStringValue = null;
                char[] trustStorePasswordValue = null;
                if (this.trustStorePasswordArg.isPresent()) {
                    trustStorePasswordStringValue = this.trustStorePasswordArg.getValue();
                } else if (this.trustStorePasswordFileArg.isPresent()) {
                    trustStorePasswordStringValue = this.trustStorePasswordFileArg.getValue();
                }
                if (trustStorePasswordStringValue != null) {
                    trustStorePasswordStringValue = System.getProperty("javax.net.ssl.trustStorePassword");
                }
                if (trustStorePasswordStringValue != null) {
                    trustStorePasswordValue = trustStorePasswordStringValue.toCharArray();
                }
                truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                truststore.load(fos, trustStorePasswordValue);
                fos.close();
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
        }
        truststoreManager = new ApplicationTrustManager(truststore);
        return truststoreManager;
    }

    public KeyManager getKeyManager() {
        KeyStore keyStore = null;
        String keyStorePasswordStringValue = null;
        char[] keyStorePasswordValue = null;
        if (this.keyStorePathArg.isPresent()) {
            try {
                FileInputStream fos = new FileInputStream(this.keyStorePathArg.getValue());
                if (this.keyStorePasswordArg.isPresent()) {
                    keyStorePasswordStringValue = this.keyStorePasswordArg.getValue();
                } else if (this.keyStorePasswordFileArg.isPresent()) {
                    keyStorePasswordStringValue = this.keyStorePasswordFileArg.getValue();
                }
                if (keyStorePasswordStringValue != null) {
                    keyStorePasswordValue = keyStorePasswordStringValue.toCharArray();
                }
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(fos, keyStorePasswordValue);
                fos.close();
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            char[] password = null;
            if (keyStorePasswordStringValue != null) {
                password = keyStorePasswordStringValue.toCharArray();
            }
            ApplicationKeyManager akm = new ApplicationKeyManager(keyStore, password);
            if (this.certNicknameArg.isPresent()) {
                return new SelectableCertificateKeyManager(akm, this.certNicknameArg.getValue());
            }
            return akm;
        }
        return null;
    }
}

