/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.server.ServerManagedObjectDecodingException;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

final class ConfigExceptionFactory {
    private static final ConfigExceptionFactory INSTANCE = new ConfigExceptionFactory();

    private ConfigExceptionFactory() {
    }

    public static ConfigExceptionFactory getInstance() {
        return INSTANCE;
    }

    public ConfigException createDecodingExceptionAdaptor(DN dn, DefinitionDecodingException e) {
        Message message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DECODING_PROBLEM.get(String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
        return new ConfigException(message, (Throwable)e);
    }

    public ConfigException createDecodingExceptionAdaptor(ServerManagedObjectDecodingException e) {
        DN dn = e.getPartialManagedObject().getDN();
        Message message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DECODING_PROBLEM.get(String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
        return new ConfigException(message, (Throwable)e);
    }

    public ConfigException createClassLoadingExceptionAdaptor(DN dn, String className, Exception e) {
        Message message = AdminMessages.ERR_ADMIN_CANNOT_INSTANTIATE_CLASS.get(String.valueOf(className), String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
        return new ConfigException(message, (Throwable)e);
    }
}

