/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DefinitionResolver;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyNotFoundException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.server.ConfigAddListenerAdaptor;
import org.opends.server.admin.server.ConfigChangeListenerAdaptor;
import org.opends.server.admin.server.ConfigDeleteListenerAdaptor;
import org.opends.server.admin.server.ConfigExceptionFactory;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.DelayedConfigAddListener;
import org.opends.server.admin.server.ServerManagedObjectDecodingException;
import org.opends.server.admin.std.meta.RootCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerManagedObject<S extends Configuration>
implements PropertyProvider {
    private static final ServerManagedObject<RootCfg> ROOT = new ServerManagedObject<RootCfg>(ManagedObjectPath.emptyPath(), RootCfgDefn.getInstance(), Collections.<PropertyDefinition<?>, SortedSet<?>>emptyMap(), null);
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConfigEntry configEntry;
    private final ManagedObjectDefinition<?, S> definition;
    private final ManagedObjectPath<?, ?> path;
    private final Map<PropertyDefinition<?>, SortedSet<?>> properties;

    static <S extends Configuration> ServerManagedObject<? extends S> decode(ManagedObjectPath<?, ?> path, AbstractManagedObjectDefinition<?, S> definition, ConfigEntry configEntry) throws DefinitionDecodingException, ServerManagedObjectDecodingException {
        return ServerManagedObject.decode(path, definition, configEntry, null);
    }

    static <S extends Configuration> ServerManagedObject<? extends S> decode(ManagedObjectPath<?, ?> path, AbstractManagedObjectDefinition<?, S> definition, ConfigEntry configEntry, ConfigEntry newConfigEntry) throws DefinitionDecodingException, ServerManagedObjectDecodingException {
        MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
        ManagedObjectDefinition<?, S> mod = definition.resolveManagedObjectDefinition(resolver);
        LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
        HashMap properties = new HashMap();
        for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
            List<String> values = ServerManagedObject.getAttribute(mod, pd, configEntry);
            try {
                ServerManagedObject.decodeProperty(properties, path, pd, values, newConfigEntry);
            }
            catch (PropertyException e) {
                exceptions.add(e);
            }
        }
        ServerManagedObject<S> mo = ServerManagedObject.decodeAux(path, mod, properties, configEntry);
        if (exceptions.isEmpty()) {
            return mo;
        }
        throw new ServerManagedObjectDecodingException(mo, exceptions);
    }

    static ServerManagedObject<RootCfg> getRootManagedObject() {
        return ROOT;
    }

    private static <S extends Configuration> ServerManagedObject<S> decodeAux(ManagedObjectPath<?, ?> path, ManagedObjectDefinition<?, S> d, Map<PropertyDefinition<?>, SortedSet<?>> properties, ConfigEntry configEntry) {
        return new ServerManagedObject<S>(path, d, properties, configEntry);
    }

    private static <T> void decodeProperty(Map<PropertyDefinition<?>, SortedSet<?>> properties, ManagedObjectPath<?, ?> path, PropertyDefinition<T> pd, List<String> stringValues, ConfigEntry newConfigEntry) throws PropertyException {
        PropertyException exception = null;
        TreeSet<T> values = new TreeSet<T>(pd);
        if (!stringValues.isEmpty()) {
            for (String value : stringValues) {
                try {
                    values.add(pd.decodeValue(value));
                }
                catch (IllegalPropertyValueStringException e) {
                    exception = e;
                }
            }
        } else {
            try {
                values.addAll(DefaultValueFinder.getDefaultValues(path, pd, newConfigEntry));
            }
            catch (DefaultBehaviorException e) {
                exception = e;
            }
        }
        if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
            exception = new PropertyIsSingleValuedException(pd);
            Object value = values.first();
            values.clear();
            values.add(value);
        }
        if (values.isEmpty() && pd.hasOption(PropertyOption.MANDATORY) && exception == null) {
            exception = new PropertyIsMandatoryException(pd);
        }
        properties.put(pd, values);
        if (exception != null) {
            throw exception;
        }
    }

    private static List<String> getAttribute(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd, ConfigEntry configEntry) {
        String attrID = LDAPProfile.getInstance().getAttributeName(d, pd);
        AttributeType type = DirectoryServer.getAttributeType(attrID, true);
        AttributeValueDecoder<String> decoder = new AttributeValueDecoder<String>(){

            @Override
            public String decode(AttributeValue value) throws DirectoryException {
                return value.getStringValue();
            }
        };
        LinkedList<String> values = new LinkedList<String>();
        try {
            configEntry.getEntry().getAttributeValues(type, decoder, values);
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
        return values;
    }

    private static ConfigEntry getManagedObjectConfigEntry(DN dn) throws ConfigException {
        ConfigEntry configEntry;
        try {
            configEntry = DirectoryServer.getConfigEntry(dn);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_GET_MANAGED_OBJECT.get(String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        if (configEntry == null) {
            Message message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST.get(String.valueOf(dn));
            throw new ConfigException(message);
        }
        return configEntry;
    }

    private ServerManagedObject(ManagedObjectPath<?, ?> path, ManagedObjectDefinition<?, S> d, Map<PropertyDefinition<?>, SortedSet<?>> properties, ConfigEntry configEntry) {
        this.definition = d;
        this.path = path;
        this.properties = properties;
        this.configEntry = configEntry;
    }

    public <M extends Configuration> void deregisterAddListener(InstantiableRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(OptionalRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        this.deregisterAddListener(baseDN, listener);
    }

    public void deregisterChangeListener(ConfigurationChangeListener<? super S> listener) {
        for (ConfigChangeListener l : this.configEntry.getChangeListeners()) {
            ConfigChangeListenerAdaptor adaptor;
            if (!(l instanceof ConfigChangeListenerAdaptor) || (adaptor = (ConfigChangeListenerAdaptor)l).getConfigurationChangeListener() != listener) continue;
            this.configEntry.deregisterChangeListener(adaptor);
        }
    }

    public <M extends Configuration> void deregisterDeleteListener(InstantiableRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(OptionalRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(InstantiableRelationDefinition<?, M> d, String name) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        ManagedObjectPath<?, M> childPath = this.path.child(d, name);
        return this.getChild(childPath, d);
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(OptionalRelationDefinition<?, M> d) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        ManagedObjectPath<?, M> childPath = this.path.child(d);
        return this.getChild(childPath, d);
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(SingletonRelationDefinition<?, M> d) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        ManagedObjectPath<?, M> childPath = this.path.child(d);
        return this.getChild(childPath, d);
    }

    public S getConfiguration() {
        return this.definition.createServerConfiguration(this);
    }

    public DN getDN() {
        if (this.configEntry != null) {
            return this.configEntry.getDN();
        }
        return DN.nullDN();
    }

    public ManagedObjectDefinition<?, S> getManagedObjectDefinition() {
        return this.definition;
    }

    public ManagedObjectPath<?, ?> getManagedObjectPath() {
        return this.path;
    }

    public <T> T getPropertyValue(PropertyDefinition<T> d) throws IllegalArgumentException {
        Collection values = this.getPropertyValues((PropertyDefinition)d);
        if (values.isEmpty()) {
            return null;
        }
        return (T)values.iterator().next();
    }

    public <T> SortedSet<T> getPropertyValues(PropertyDefinition<T> d) throws IllegalArgumentException {
        if (!this.properties.containsKey(d)) {
            throw new IllegalArgumentException("Unknown property " + d.getName());
        }
        return new TreeSet(this.properties.get(d));
    }

    public boolean hasChild(OptionalRelationDefinition<?, ?> d) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN targetDN = DNBuilder.create(this.path, d);
        try {
            return ServerManagedObject.getManagedObjectConfigEntry(targetDN) != null;
        }
        catch (ConfigException e) {
            return false;
        }
    }

    public String[] listChildren(InstantiableRelationDefinition<?, ?> d) throws IllegalArgumentException {
        ConfigEntry configEntry;
        this.validateRelationDefinition(d);
        DN targetDN = DNBuilder.create(this.path, d);
        try {
            configEntry = DirectoryServer.getConfigEntry(targetDN);
        }
        catch (ConfigException e) {
            return new String[0];
        }
        if (configEntry == null) {
            return new String[0];
        }
        Set children = configEntry.getChildren().keySet();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (DN child : children) {
            AttributeValue av = child.getRDN().getAttributeValue(0);
            names.add(av.getStringValue().trim());
        }
        return names.toArray(new String[names.size()]);
    }

    public <M extends Configuration> void registerAddListener(InstantiableRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerAddListener(OptionalRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public void registerChangeListener(ConfigurationChangeListener<? super S> listener) {
        ConfigChangeListenerAdaptor<? super S> adaptor = new ConfigChangeListenerAdaptor<S>(this.path, this.definition, listener);
        this.configEntry.registerChangeListener(adaptor);
    }

    public <M extends Configuration> void registerDeleteListener(InstantiableRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerDeleteListener(OptionalRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    void setConfigEntry(ConfigEntry configEntry) {
        this.configEntry = configEntry;
    }

    private <M extends Configuration> void deregisterAddListener(DN baseDN, ConfigurationAddListener<M> listener) {
        block4: {
            try {
                ConfigEntry configEntry = this.getListenerConfigEntry(baseDN);
                if (configEntry != null) {
                    for (ConfigAddListener l : configEntry.getAddListeners()) {
                        ConfigAddListenerAdaptor adaptor;
                        if (!(l instanceof ConfigAddListenerAdaptor) || (adaptor = (ConfigAddListenerAdaptor)l).getConfigurationAddListener() != listener) continue;
                        configEntry.deregisterAddListener(adaptor);
                    }
                }
            }
            catch (ConfigException e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private <M> void deregisterDeleteListener(DN baseDN, ConfigurationDeleteListener<M> listener) {
        block4: {
            try {
                ConfigEntry configEntry = this.getListenerConfigEntry(baseDN);
                if (configEntry != null) {
                    for (ConfigDeleteListener l : configEntry.getDeleteListeners()) {
                        ConfigDeleteListenerAdaptor adaptor;
                        if (!(l instanceof ConfigDeleteListenerAdaptor) || (adaptor = (ConfigDeleteListenerAdaptor)l).getConfigurationDeleteListener() != listener) continue;
                        configEntry.deregisterDeleteListener(adaptor);
                    }
                }
            }
            catch (ConfigException e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private <M extends Configuration> ServerManagedObject<? extends M> getChild(ManagedObjectPath<?, ?> childPath, RelationDefinition<?, M> d) throws ConfigException {
        DN targetDN = DNBuilder.create(childPath);
        ConfigEntry configEntry = ServerManagedObject.getManagedObjectConfigEntry(targetDN);
        try {
            return ServerManagedObject.decode(childPath, d.getChildDefinition(), configEntry);
        }
        catch (DefinitionDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(targetDN, e);
        }
        catch (ServerManagedObjectDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
    }

    private ConfigEntry getListenerConfigEntry(DN dn) throws ConfigException {
        ConfigEntry configEntry;
        try {
            configEntry = DirectoryServer.getConfigEntry(dn);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_GET_LISTENER_BASE.get(String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return configEntry;
    }

    private void registerAddListener(DN baseDN, ConfigAddListener adaptor) throws IllegalArgumentException, ConfigException {
        ConfigEntry relationEntry = this.getListenerConfigEntry(baseDN);
        if (relationEntry != null) {
            relationEntry.registerAddListener(adaptor);
        } else {
            DelayedConfigAddListener delayedListener = new DelayedConfigAddListener(baseDN, adaptor);
            this.registerDelayedListener(baseDN, delayedListener);
        }
    }

    private void registerDelayedListener(DN baseDN, ConfigAddListener delayedListener) throws ConfigException {
        for (DN parentDN = baseDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
            ConfigEntry relationEntry = this.getListenerConfigEntry(parentDN);
            if (relationEntry == null) {
                delayedListener = new DelayedConfigAddListener(parentDN, delayedListener);
                continue;
            }
            relationEntry.registerAddListener(delayedListener);
            return;
        }
        Message message = AdminMessages.ERR_ADMIN_UNABLE_TO_REGISTER_LISTENER.get(String.valueOf(baseDN));
        throw new ConfigException(message);
    }

    private void registerDeleteListener(DN baseDN, ConfigDeleteListener adaptor) throws ConfigException {
        ConfigEntry relationEntry = this.getListenerConfigEntry(baseDN);
        if (relationEntry != null) {
            relationEntry.registerDeleteListener(adaptor);
        } else {
            DelayedConfigAddListener delayedListener = new DelayedConfigAddListener(baseDN, adaptor);
            this.registerDelayedListener(baseDN, delayedListener);
        }
    }

    private void validateRelationDefinition(RelationDefinition<?, ?> rd) throws IllegalArgumentException {
        RelationDefinition<?, ?> tmp = this.definition.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + this.definition.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyDefinitionResolver
    implements DefinitionResolver {
        private final ConfigEntry entry;

        private MyDefinitionResolver(ConfigEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean matches(AbstractManagedObjectDefinition<?, ?> d) {
            String oc = LDAPProfile.getInstance().getObjectClass(d);
            return this.entry.hasObjectClass(oc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultValueFinder<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private DefaultBehaviorException exception = null;
        private ManagedObjectPath<?, ?> nextPath = null;
        private PropertyDefinition<T> nextProperty = null;
        private ConfigEntry newConfigEntry;

        public static <T> Collection<T> getDefaultValues(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd, ConfigEntry newConfigEntry) throws DefaultBehaviorException {
            DefaultValueFinder<T> v = new DefaultValueFinder<T>(newConfigEntry);
            return super.find(p, pd);
        }

        private DefaultValueFinder(ConfigEntry newConfigEntry) {
            this.newConfigEntry = newConfigEntry;
        }

        @Override
        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        @Override
        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
            Collection<String> stringValues = d.getDefaultValues();
            ArrayList<T> values = new ArrayList<T>(stringValues.size());
            for (String stringValue : stringValues) {
                try {
                    values.add(this.nextProperty.decodeValue(stringValue));
                }
                catch (IllegalPropertyValueStringException e) {
                    this.exception = new DefaultBehaviorException(this.nextProperty, (Throwable)e);
                    break;
                }
            }
            return values;
        }

        @Override
        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(this.nextPath), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        private Collection<T> find(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd) throws DefaultBehaviorException {
            this.nextPath = p;
            this.nextProperty = pd;
            Collection values = (Collection)this.nextProperty.getDefaultBehaviorProvider().accept(this, null);
            if (this.exception != null) {
                throw this.exception;
            }
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                throw new DefaultBehaviorException(pd, (Throwable)new PropertyIsSingleValuedException(pd));
            }
            return values;
        }

        private Collection<T> getInheritedProperty(ManagedObjectPath target, AbstractManagedObjectDefinition<?, ?> d, String propertyName) throws DefaultBehaviorException {
            AbstractManagedObjectDefinition supr = target.getManagedObjectDefinition();
            if (!supr.isParentOf(d)) {
                throw new DefaultBehaviorException(this.nextProperty, (Throwable)new DefinitionDecodingException(DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION));
            }
            PropertyDefinition<T> pd1 = this.nextProperty;
            try {
                PropertyDefinition pd2;
                DN dn = DNBuilder.create(target);
                ConfigEntry configEntry = this.newConfigEntry != null && this.newConfigEntry.getDN().equals(dn) ? this.newConfigEntry : ServerManagedObject.getManagedObjectConfigEntry(dn);
                MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
                ManagedObjectDefinition<?, ?> mod = d.resolveManagedObjectDefinition(resolver);
                try {
                    PropertyDefinition<?> pdTmp = mod.getPropertyDefinition(propertyName);
                    pd2 = (PropertyDefinition)pd1.getClass().cast(pdTmp);
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                catch (ClassCastException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                List stringValues = ServerManagedObject.getAttribute(mod, pd2, configEntry);
                if (stringValues.isEmpty()) {
                    Collection<T> tmp = this.find(target, pd2);
                    ArrayList<T> values = new ArrayList<T>(tmp.size());
                    for (T value : tmp) {
                        pd1.validateValue(value);
                        values.add(value);
                    }
                    return values;
                }
                ArrayList<T> values = new ArrayList<T>(stringValues.size());
                for (String s : stringValues) {
                    values.add(pd1.decodeValue(s));
                }
                return values;
            }
            catch (DefinitionDecodingException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (PropertyNotFoundException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (IllegalPropertyValueException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (IllegalPropertyValueStringException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (ConfigException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
        }
    }
}

