/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.TraditionalWorkQueueCfgClient;
import org.opends.server.admin.std.meta.WorkQueueCfgDefn;
import org.opends.server.admin.std.server.TraditionalWorkQueueCfg;
import org.opends.server.admin.std.server.WorkQueueCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraditionalWorkQueueCfgDefn
extends ManagedObjectDefinition<TraditionalWorkQueueCfgClient, TraditionalWorkQueueCfg> {
    private static final TraditionalWorkQueueCfgDefn INSTANCE = new TraditionalWorkQueueCfgDefn();
    private static final IntegerPropertyDefinition PD_MAX_WORK_QUEUE_CAPACITY;
    private static final IntegerPropertyDefinition PD_NUM_WORKER_THREADS;

    public static TraditionalWorkQueueCfgDefn getInstance() {
        return INSTANCE;
    }

    private TraditionalWorkQueueCfgDefn() {
        super("traditional-work-queue", WorkQueueCfgDefn.getInstance());
    }

    @Override
    public TraditionalWorkQueueCfgClient createClientConfiguration(ManagedObject<? extends TraditionalWorkQueueCfgClient> impl) {
        return new TraditionalWorkQueueCfgClientImpl(impl);
    }

    @Override
    public TraditionalWorkQueueCfg createServerConfiguration(ServerManagedObject<? extends TraditionalWorkQueueCfg> impl) {
        return new TraditionalWorkQueueCfgServerImpl(impl);
    }

    @Override
    public Class<TraditionalWorkQueueCfg> getServerConfigurationClass() {
        return TraditionalWorkQueueCfg.class;
    }

    public IntegerPropertyDefinition getMaxWorkQueueCapacityPropertyDefinition() {
        return PD_MAX_WORK_QUEUE_CAPACITY;
    }

    public IntegerPropertyDefinition getNumWorkerThreadsPropertyDefinition() {
        return PD_NUM_WORKER_THREADS;
    }

    public ClassPropertyDefinition getWorkQueueClassPropertyDefinition() {
        return WorkQueueCfgDefn.getInstance().getWorkQueueClassPropertyDefinition();
    }

    static {
        IntegerPropertyDefinition.Builder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-work-queue-capacity");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-work-queue-capacity"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "max-work-queue-capacity"));
        builder.setLowerLimit(0);
        PD_MAX_WORK_QUEUE_CAPACITY = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_WORK_QUEUE_CAPACITY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-worker-threads");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "num-worker-threads"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        builder.setLowerLimit(1);
        PD_NUM_WORKER_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_WORKER_THREADS);
        INSTANCE.registerTag(Tag.valueOf("core"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraditionalWorkQueueCfgServerImpl
    implements TraditionalWorkQueueCfg {
        private ServerManagedObject<? extends TraditionalWorkQueueCfg> impl;

        private TraditionalWorkQueueCfgServerImpl(ServerManagedObject<? extends TraditionalWorkQueueCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addTraditionalChangeListener(ConfigurationChangeListener<TraditionalWorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeTraditionalChangeListener(ConfigurationChangeListener<TraditionalWorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public Integer getMaxWorkQueueCapacity() {
            return this.impl.getPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition());
        }

        @Override
        public int getNumWorkerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public String getWorkQueueClass() {
            return this.impl.getPropertyValue(INSTANCE.getWorkQueueClassPropertyDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends TraditionalWorkQueueCfgClient, ? extends TraditionalWorkQueueCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraditionalWorkQueueCfgClientImpl
    implements TraditionalWorkQueueCfgClient {
        private ManagedObject<? extends TraditionalWorkQueueCfgClient> impl;

        private TraditionalWorkQueueCfgClientImpl(ManagedObject<? extends TraditionalWorkQueueCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Integer getMaxWorkQueueCapacity() {
            return this.impl.getPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition());
        }

        @Override
        public void setMaxWorkQueueCapacity(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition(), value);
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void setNumWorkerThreads(int value) {
            this.impl.setPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition(), value);
        }

        @Override
        public String getWorkQueueClass() {
            return this.impl.getPropertyValue(INSTANCE.getWorkQueueClassPropertyDefinition());
        }

        @Override
        public void setWorkQueueClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getWorkQueueClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends TraditionalWorkQueueCfgClient, ? extends TraditionalWorkQueueCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

