/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api.plugin;

import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.IntermediateResponsePluginResult;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PostConnectPluginResult;
import org.opends.server.api.plugin.PostDisconnectPluginResult;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PostResponsePluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.api.plugin.SearchEntryPluginResult;
import org.opends.server.api.plugin.SearchReferencePluginResult;
import org.opends.server.api.plugin.StartupPluginResult;
import org.opends.server.api.plugin.SubordinateModifyDNPluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.operation.PostOperationAbandonOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationBindOperation;
import org.opends.server.types.operation.PostOperationCompareOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PostOperationUnbindOperation;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PostResponseCompareOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.types.operation.PostResponseSearchOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationBindOperation;
import org.opends.server.types.operation.PreOperationCompareOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationExtendedOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.PreParseAbandonOperation;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseBindOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.types.operation.PreParseUnbindOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.types.operation.SubordinateModifyDNOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class DirectoryServerPlugin<T extends PluginCfg> {
    private DN pluginDN;
    private Set<PluginType> pluginTypes;

    protected DirectoryServerPlugin() {
    }

    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public final void initializeInternal(DN pluginDN, Set<PluginType> pluginTypes) {
        this.pluginDN = pluginDN;
        this.pluginTypes = pluginTypes;
    }

    public abstract void initializePlugin(Set<PluginType> var1, T var2) throws ConfigException, InitializationException;

    public void finalizePlugin() {
    }

    public final DN getPluginEntryDN() {
        return this.pluginDN;
    }

    public final Set<PluginType> getPluginTypes() {
        return this.pluginTypes;
    }

    public StartupPluginResult doStartup() {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.STARTUP.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public void doShutdown(Message reason) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SHUTDOWN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostConnectPluginResult doPostConnect(ClientConnection clientConnection) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_CONNECT.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostDisconnectPluginResult doPostDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        Message msg = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_DISCONNECT.getName());
        throw new UnsupportedOperationException(msg.toString());
    }

    public LDIFPluginResult doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.LDIF_IMPORT.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public LDIFPluginResult doLDIFExport(LDIFExportConfig exportConfig, Entry entry) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.LDIF_EXPORT.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseAbandonOperation abandonOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_ABANDON.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationAbandonOperation abandonOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_ABANDON.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseCompareOperation compareOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationCompareOperation compareOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationCompareOperation compareOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseCompareOperation compareOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseExtendedOperation extendedOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationExtendedOperation extendedOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationExtendedOperation extendedOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseExtendedOperation extendedOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public SubordinateModifyDNPluginResult processSubordinateModifyDN(SubordinateModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry, List<Modification> modifications) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SUBORDINATE_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseSearchOperation searchOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreOperationPluginResult doPreOperation(PreOperationSearchOperation searchOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public SearchEntryPluginResult processSearchEntry(SearchEntrySearchOperation searchOperation, SearchResultEntry searchEntry) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SEARCH_RESULT_ENTRY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public SearchReferencePluginResult processSearchReference(SearchReferenceSearchOperation searchOperation, SearchResultReference searchReference) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SEARCH_RESULT_REFERENCE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationSearchOperation searchOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostResponsePluginResult doPostResponse(PostResponseSearchOperation searchOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PreParsePluginResult doPreParse(PreParseUnbindOperation unbindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_UNBIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PostOperationPluginResult doPostOperation(PostOperationUnbindOperation unbindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_UNBIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public IntermediateResponsePluginResult processIntermediateResponse(IntermediateResponse intermediateResponse) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.INTERMEDIATE_RESPONSE.getName());
        throw new UnsupportedOperationException(message.toString());
    }
}

