/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api.plugin;

import org.opends.messages.Message;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class StartupPluginResult {
    public static final StartupPluginResult SUCCESS = new StartupPluginResult();
    private final boolean completedSuccessfully;
    private final boolean continueStartup;
    private final Message errorMessage;

    private StartupPluginResult() {
        this(true, true, null);
    }

    public StartupPluginResult(boolean completedSuccessfully, boolean continueStartup, Message errorMessage) {
        this.completedSuccessfully = completedSuccessfully;
        this.continueStartup = continueStartup;
        this.errorMessage = errorMessage;
    }

    public boolean completedSuccessfully() {
        return this.completedSuccessfully;
    }

    public boolean continueStartup() {
        return this.continueStartup;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("StartupPluginResult(completedSuccessfully=");
        buffer.append(this.completedSuccessfully);
        buffer.append(", continueStartup=");
        buffer.append(this.continueStartup);
        buffer.append(", errorID=");
        if (this.errorMessage != null) {
            buffer.append(this.errorMessage.getDescriptor().getId());
        } else {
            buffer.append(-1);
        }
        buffer.append(", errorMessage=\"");
        buffer.append(this.errorMessage);
        buffer.append("\")");
    }
}

