/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApproximateIndexer
extends Indexer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private ApproximateMatchingRule approximateRule;
    private AttributeType attributeType;

    public ApproximateIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.approximateRule = attributeType.getApproximateMatchingRule();
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".approximate";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction txn, Entry entry, Set<ASN1OctetString> keys) {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null) {
            this.indexAttribute(attrList, keys);
        }
    }

    @Override
    public void replaceEntry(Transaction txn, Entry oldEntry, Entry newEntry, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) {
        List<Attribute> attrList = oldEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> oldSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, oldSet);
        attrList = newEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> newSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, newSet);
        HashSet<ASN1OctetString> removeSet = new HashSet<ASN1OctetString>(oldSet);
        removeSet.removeAll(newSet);
        for (ASN1OctetString k : removeSet) {
            delKeys.add(k);
        }
        HashSet<ASN1OctetString> addSet = new HashSet<ASN1OctetString>(newSet);
        addSet.removeAll(oldSet);
        for (ASN1OctetString k : addSet) {
            addKeys.add(k);
        }
    }

    @Override
    public void modifyEntry(Transaction txn, Entry oldEntry, Entry newEntry, List<Modification> mods, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) {
        this.replaceEntry(txn, oldEntry, newEntry, addKeys, delKeys);
    }

    private void indexAttribute(List<Attribute> attrList, Set<ASN1OctetString> keys) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            this.indexValues(attr.getValues(), keys);
        }
    }

    private void indexValues(Set<AttributeValue> values, Set<ASN1OctetString> keys) {
        if (values == null) {
            return;
        }
        for (AttributeValue value : values) {
            try {
                byte[] keyBytes = this.approximateRule.normalizeValue(value.getValue()).value();
                keys.add(new ASN1OctetString(keyBytes));
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }
}

