/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.EnvironmentConfig;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.std.meta.JEBackendCfgDefn;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public class ConfigurableEnvironment {
    private static final DebugTracer TRACER;
    public static final String ATTR_DATABASE_CACHE_PERCENT = "ds-cfg-database-cache-percent";
    public static final String ATTR_DATABASE_CACHE_SIZE = "ds-cfg-database-cache-size";
    public static final String ATTR_DATABASE_TXN_NO_SYNC = "ds-cfg-database-txn-no-sync";
    public static final String ATTR_DATABASE_TXN_WRITE_NO_SYNC = "ds-cfg-database-txn-write-no-sync";
    public static final String ATTR_DATABASE_RUN_CLEANER = "ds-cfg-database-run-cleaner";
    public static final String ATTR_CLEANER_MIN_UTILIZATION = "ds-cfg-database-cleaner-min-utilization";
    public static final String ATTR_DATABASE_LOG_FILE_MAX = "ds-cfg-database-log-file-max";
    public static final String ATTR_EVICTOR_LRU_ONLY = "ds-cfg-database-evictor-lru-only";
    public static final String ATTR_EVICTOR_NODES_PER_SCAN = "ds-cfg-database-evictor-nodes-per-scan";
    public static final String ATTR_LOGGING_FILE_HANDLER_ON = "ds-cfg-database-logging-file-handler-on";
    public static final String ATTR_LOGGING_LEVEL = "ds-cfg-database-logging-level";
    public static final String ATTR_CHECKPOINTER_BYTES_INTERVAL = "ds-cfg-database-checkpointer-bytes-interval";
    public static final String ATTR_CHECKPOINTER_WAKEUP_INTERVAL = "ds-cfg-database-checkpointer-wakeup-interval";
    public static final String ATTR_NUM_LOCK_TABLES = "ds-cfg-database-lock-num-lock-tables";
    public static final String ATTR_NUM_CLEANER_THREADS = "ds-cfg-database-cleaner-num-threads";
    private static HashMap<String, String> attrMap;
    private static HashMap<String, Method> methodMap;
    private static HashMap<String, PropertyDefinition> defnMap;

    private static void registerProp(String propertyName, String attrName) throws Exception {
        String baseName = attrName.substring(7);
        StringBuilder builder = new StringBuilder();
        boolean capitalize = true;
        for (int i = 0; i < baseName.length(); ++i) {
            char c = baseName.charAt(i);
            if (c == '-') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                builder.append(Character.toUpperCase(c));
            } else {
                builder.append(c);
            }
            capitalize = false;
        }
        String methodBaseName = builder.toString();
        Class<JEBackendCfg> configClass = JEBackendCfg.class;
        JEBackendCfgDefn defn = JEBackendCfgDefn.getInstance();
        Class<?> defClass = defn.getClass();
        PropertyDefinition propDefn = (PropertyDefinition)defClass.getMethod("get" + methodBaseName + "PropertyDefinition", new Class[0]).invoke((Object)defn, new Object[0]);
        String methodName = propDefn instanceof BooleanPropertyDefinition ? "is" + methodBaseName : "get" + methodBaseName;
        defnMap.put(attrName, propDefn);
        methodMap.put(attrName, configClass.getMethod(methodName, new Class[0]));
        attrMap.put(propertyName, attrName);
    }

    public static String getAttributeForProperty(String jeProperty) {
        return attrMap.get(jeProperty);
    }

    private static String getPropertyValue(JEBackendCfg cfg, String attrName) {
        try {
            PropertyDefinition propDefn = defnMap.get(attrName);
            Method method = methodMap.get(attrName);
            if (propDefn instanceof DurationPropertyDefinition) {
                Long value = (Long)method.invoke((Object)cfg, new Object[0]);
                DurationPropertyDefinition durationPropDefn = (DurationPropertyDefinition)propDefn;
                value = 1000L * durationPropDefn.getBaseUnit().toMilliSeconds(value.longValue());
                return String.valueOf(value);
            }
            Object value = method.invoke((Object)cfg, new Object[0]);
            return String.valueOf(value);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return "";
        }
    }

    public static EnvironmentConfig defaultConfig() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setConfigParam("je.env.sharedLatches", "true");
        envConfig.setConfigParam("je.cleaner.expunge", "true");
        return envConfig;
    }

    public static EnvironmentConfig parseConfigEntry(JEBackendCfg cfg) throws ConfigException {
        EnvironmentConfig envConfig = ConfigurableEnvironment.defaultConfig();
        envConfig.setTxnNoSync(cfg.isDatabaseTxnNoSync());
        envConfig.setTxnWriteNoSync(cfg.isDatabaseTxnWriteNoSync());
        for (Map.Entry<String, String> mapEntry : attrMap.entrySet()) {
            String jeProperty = mapEntry.getKey();
            String attrName = mapEntry.getValue();
            String value = ConfigurableEnvironment.getPropertyValue(cfg, attrName);
            envConfig.setConfigParam(jeProperty, value);
        }
        return envConfig;
    }

    static {
        block2: {
            TRACER = DebugLogger.getTracer();
            attrMap = new HashMap();
            methodMap = new HashMap();
            defnMap = new HashMap();
            try {
                ConfigurableEnvironment.registerProp("je.maxMemoryPercent", ATTR_DATABASE_CACHE_PERCENT);
                ConfigurableEnvironment.registerProp("je.maxMemory", ATTR_DATABASE_CACHE_SIZE);
                ConfigurableEnvironment.registerProp("je.cleaner.minUtilization", ATTR_CLEANER_MIN_UTILIZATION);
                ConfigurableEnvironment.registerProp("je.env.runCleaner", ATTR_DATABASE_RUN_CLEANER);
                ConfigurableEnvironment.registerProp("je.evictor.lruOnly", ATTR_EVICTOR_LRU_ONLY);
                ConfigurableEnvironment.registerProp("je.evictor.nodesPerScan", ATTR_EVICTOR_NODES_PER_SCAN);
                ConfigurableEnvironment.registerProp("je.log.fileMax", ATTR_DATABASE_LOG_FILE_MAX);
                ConfigurableEnvironment.registerProp("java.util.logging.FileHandler.on", ATTR_LOGGING_FILE_HANDLER_ON);
                ConfigurableEnvironment.registerProp("java.util.logging.level", ATTR_LOGGING_LEVEL);
                ConfigurableEnvironment.registerProp("je.checkpointer.bytesInterval", ATTR_CHECKPOINTER_BYTES_INTERVAL);
                ConfigurableEnvironment.registerProp("je.checkpointer.wakeupInterval", ATTR_CHECKPOINTER_WAKEUP_INTERVAL);
                ConfigurableEnvironment.registerProp("je.lock.nLockTables", ATTR_NUM_LOCK_TABLES);
                ConfigurableEnvironment.registerProp("je.cleaner.threads", ATTR_NUM_CLEANER_THREADS);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }
}

