/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DN2ID
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Comparator<byte[]> dn2idComparator = new EntryContainer.KeyReverseComparator();

    DN2ID(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        DatabaseConfig dn2idConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dn2idConfig.setReadOnly(true);
            dn2idConfig.setAllowCreate(false);
            dn2idConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dn2idConfig.setAllowCreate(true);
            dn2idConfig.setTransactional(false);
            dn2idConfig.setDeferredWrite(true);
        } else {
            dn2idConfig.setAllowCreate(true);
            dn2idConfig.setTransactional(true);
        }
        this.dbConfig = dn2idConfig;
        this.dbConfig.setBtreeComparator(this.dn2idComparator.getClass());
    }

    private static DatabaseEntry DNdata(DN dn) {
        byte[] normDN = StaticUtils.getBytes(dn.toNormalizedString());
        return new DatabaseEntry(normDN);
    }

    public boolean insert(Transaction txn, DN dn, EntryID id) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = DN2ID.DNdata(dn);
        OperationStatus status = this.insert(txn, key, data = id.getDatabaseEntry());
        return status == OperationStatus.SUCCESS;
    }

    public boolean put(Transaction txn, DN dn, EntryID id) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = DN2ID.DNdata(dn);
        OperationStatus status = this.put(txn, key, data = id.getDatabaseEntry());
        return status == OperationStatus.SUCCESS;
    }

    public boolean putRaw(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.put(txn, key, data);
        return status == OperationStatus.SUCCESS;
    }

    public boolean remove(Transaction txn, DN dn) throws DatabaseException {
        DatabaseEntry key = DN2ID.DNdata(dn);
        OperationStatus status = this.delete(txn, key);
        return status == OperationStatus.SUCCESS;
    }

    public EntryID get(Transaction txn, DN dn) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = DN2ID.DNdata(dn);
        OperationStatus status = this.read(txn, key, data = new DatabaseEntry(), LockMode.DEFAULT);
        if (status != OperationStatus.SUCCESS) {
            return null;
        }
        return new EntryID(data);
    }

    public Comparator<byte[]> getComparator() {
        return this.dn2idComparator;
    }
}

