/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DN2URI
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Comparator<byte[]> dn2uriComparator;
    public AttributeType referralType = DirectoryServer.getAttributeType("ref");

    DN2URI(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.dn2uriComparator = new EntryContainer.KeyReverseComparator();
        DatabaseConfig dn2uriConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dn2uriConfig.setReadOnly(true);
            dn2uriConfig.setSortedDuplicates(true);
            dn2uriConfig.setAllowCreate(false);
            dn2uriConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dn2uriConfig.setSortedDuplicates(true);
            dn2uriConfig.setAllowCreate(true);
            dn2uriConfig.setTransactional(false);
            dn2uriConfig.setDeferredWrite(true);
        } else {
            dn2uriConfig.setSortedDuplicates(true);
            dn2uriConfig.setAllowCreate(true);
            dn2uriConfig.setTransactional(true);
        }
        this.dbConfig = dn2uriConfig;
        this.dbConfig.setBtreeComparator(this.dn2uriComparator.getClass());
    }

    public boolean insert(Transaction txn, DN dn, String labeledURI) throws DatabaseException {
        byte[] URIBytes;
        DatabaseEntry data;
        byte[] normDN = StaticUtils.getBytes(dn.toNormalizedString());
        DatabaseEntry key = new DatabaseEntry(normDN);
        OperationStatus status = this.put(txn, key, data = new DatabaseEntry(URIBytes = StaticUtils.getBytes(labeledURI)));
        return status == OperationStatus.SUCCESS;
    }

    public boolean delete(Transaction txn, DN dn) throws DatabaseException {
        byte[] normDN = StaticUtils.getBytes(dn.toNormalizedString());
        DatabaseEntry key = new DatabaseEntry(normDN);
        OperationStatus status = this.delete(txn, key);
        return status == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Transaction txn, DN dn, String labeledURI) throws DatabaseException {
        OperationStatus status;
        CursorConfig cursorConfig = null;
        byte[] normDN = StaticUtils.getBytes(dn.toNormalizedString());
        byte[] URIBytes = StaticUtils.getBytes(labeledURI);
        DatabaseEntry key = new DatabaseEntry(normDN);
        DatabaseEntry data = new DatabaseEntry(URIBytes);
        Cursor cursor = this.openCursor(txn, cursorConfig);
        try {
            status = cursor.getSearchBoth(key, data, null);
            if (status == OperationStatus.SUCCESS) {
                status = cursor.delete();
            }
        }
        finally {
            cursor.close();
        }
        return status == OperationStatus.SUCCESS;
    }

    public void modifyEntry(Transaction txn, Entry before, Entry after, List<Modification> mods) throws DatabaseException {
        DN entryDN = before.getDN();
        block6: for (Modification mod : mods) {
            Attribute modAttr = mod.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (!modAttrType.equals(this.referralType)) continue;
            Attribute a = mod.getAttribute();
            switch (mod.getModificationType()) {
                case ADD: {
                    if (a == null) break;
                    for (AttributeValue v : a.getValues()) {
                        this.insert(txn, entryDN, v.getStringValue());
                    }
                    continue block6;
                }
                case DELETE: {
                    if (a == null || !a.hasValue()) {
                        this.delete(txn, entryDN);
                        break;
                    }
                    for (AttributeValue v : a.getValues()) {
                        this.delete(txn, entryDN, v.getStringValue());
                    }
                    continue block6;
                }
                case INCREMENT: {
                    break;
                }
                case REPLACE: {
                    this.delete(txn, entryDN);
                    if (a == null) break;
                    for (AttributeValue v : a.getValues()) {
                        this.insert(txn, entryDN, v.getStringValue());
                    }
                    break;
                }
            }
        }
    }

    public void replaceEntry(Transaction txn, Entry before, Entry after) throws DatabaseException {
        this.deleteEntry(txn, before);
        this.addEntry(txn, after);
    }

    public boolean addEntry(Transaction txn, Entry entry) throws DatabaseException {
        boolean success = true;
        LinkedHashSet<String> labeledURIs = entry.getReferralURLs();
        if (labeledURIs != null) {
            DN dn = entry.getDN();
            for (String labeledURI : labeledURIs) {
                if (this.insert(txn, dn, labeledURI)) continue;
                success = false;
            }
        }
        return success;
    }

    public void deleteEntry(Transaction txn, Entry entry) throws DatabaseException {
        LinkedHashSet<String> labeledURIs = entry.getReferralURLs();
        if (labeledURIs != null) {
            this.delete(txn, entry.getDN());
        }
    }

    public void checkTargetForReferral(Entry entry, SearchScope searchScope) throws DirectoryException {
        LinkedHashSet<String> referralURLs = entry.getReferralURLs();
        if (referralURLs != null) {
            this.throwReferralException(entry.getDN(), entry.getDN(), referralURLs, searchScope);
        }
    }

    public void throwReferralException(DN targetDN, DN referralDN, Set<String> labeledURIs, SearchScope searchScope) throws DirectoryException {
        ArrayList<String> URIList = new ArrayList<String>(labeledURIs.size());
        Iterator<String> i$ = labeledURIs.iterator();
        while (i$.hasNext()) {
            String uri;
            block8: {
                String labeledURI;
                uri = labeledURI = i$.next();
                int i = labeledURI.indexOf(32);
                if (i != -1) {
                    uri = labeledURI.substring(0, i);
                }
                try {
                    LDAPURL ldapurl = LDAPURL.decode(uri, false);
                    if (ldapurl.getScheme().equalsIgnoreCase("ldap")) {
                        DN urlBaseDN = targetDN;
                        if (!referralDN.equals(ldapurl.getBaseDN())) {
                            urlBaseDN = EntryContainer.modDN(targetDN, referralDN.getNumComponents(), ldapurl.getBaseDN());
                        }
                        ldapurl.setBaseDN(urlBaseDN);
                        if (searchScope == null) {
                            StringBuilder builder = new StringBuilder(uri.length());
                            ldapurl.toString(builder, true);
                            uri = builder.toString();
                        } else {
                            ldapurl.getAttributes().clear();
                            ldapurl.setScope(searchScope);
                            ldapurl.setFilter(null);
                            uri = ldapurl.toString();
                        }
                    }
                }
                catch (DirectoryException e) {
                    if (!DebugLogger.debugEnabled()) break block8;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            URIList.add(uri);
        }
        Message msg = JebMessages.INFO_JEB_REFERRAL_RESULT_MESSAGE.get(String.valueOf(referralDN));
        throw new DirectoryException(ResultCode.REFERRAL, msg, referralDN, URIList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetEntryReferrals(DN targetDN, SearchScope searchScope) throws DirectoryException {
        block10: {
            Transaction txn = null;
            CursorConfig cursorConfig = null;
            try {
                Cursor cursor = this.openCursor(txn, cursorConfig);
                try {
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    DN dn = this.entryContainer.getParentWithinBase(targetDN);
                    while (dn != null) {
                        String normDN = dn.toNormalizedString();
                        key.setData(StaticUtils.getBytes(normDN));
                        OperationStatus status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
                        if (status == OperationStatus.SUCCESS) {
                            LinkedHashSet<String> labeledURIs = new LinkedHashSet<String>(cursor.count());
                            do {
                                String labeledURI = new String(data.getData(), "UTF-8");
                                labeledURIs.add(labeledURI);
                            } while ((status = cursor.getNextDup(key, data, LockMode.DEFAULT)) == OperationStatus.SUCCESS);
                            this.throwReferralException(targetDN, dn, labeledURIs, searchScope);
                        }
                        dn = this.entryContainer.getParentWithinBase(dn);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (DatabaseException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!DebugLogger.debugEnabled()) break block10;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean returnSearchReferences(SearchOperation searchOp) throws DirectoryException {
        Transaction txn = null;
        CursorConfig cursorConfig = null;
        DN baseDN = searchOp.getBaseDN();
        String normBaseDN = baseDN.toNormalizedString();
        byte[] suffix = StaticUtils.getBytes("," + normBaseDN);
        byte[] end = null;
        DatabaseEntry data = new DatabaseEntry();
        DatabaseEntry key = new DatabaseEntry(suffix);
        try {
            Cursor cursor = this.openCursor(txn, cursorConfig);
            try {
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                while (status == OperationStatus.SUCCESS) {
                    int cmp;
                    if (end == null) {
                        end = (byte[])suffix.clone();
                        end[0] = (byte)(end[0] + 1);
                    }
                    if ((cmp = this.dn2uriComparator.compare(key.getData(), end)) >= 0) {
                        return true;
                    }
                    DN dn = DN.decode(new ASN1OctetString(key.getData()));
                    if (searchOp.getScope() != SearchScope.SINGLE_LEVEL || dn.getNumComponents() == baseDN.getNumComponents() + 1) {
                        ArrayList<String> URIList = new ArrayList<String>(cursor.count());
                        do {
                            String uri;
                            block20: {
                                String labeledURI;
                                uri = labeledURI = new String(data.getData(), "UTF-8");
                                int i = labeledURI.indexOf(32);
                                if (i != -1) {
                                    uri = labeledURI.substring(0, i);
                                }
                                try {
                                    LDAPURL ldapurl = LDAPURL.decode(uri, false);
                                    if (ldapurl.getScheme().equalsIgnoreCase("ldap")) {
                                        if (ldapurl.getBaseDN().isNullDN()) {
                                            ldapurl.setBaseDN(dn);
                                        }
                                        ldapurl.getAttributes().clear();
                                        if (searchOp.getScope() == SearchScope.SINGLE_LEVEL) {
                                            ldapurl.setScope(SearchScope.BASE_OBJECT);
                                        } else {
                                            ldapurl.setScope(SearchScope.WHOLE_SUBTREE);
                                        }
                                        ldapurl.setFilter(null);
                                        uri = ldapurl.toString();
                                    }
                                }
                                catch (DirectoryException e) {
                                    if (!DebugLogger.debugEnabled()) break block20;
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                            }
                            URIList.add(uri);
                        } while ((status = cursor.getNextDup(key, data, LockMode.DEFAULT)) == OperationStatus.SUCCESS);
                        SearchResultReference reference = new SearchResultReference(URIList);
                        if (!searchOp.returnReference(dn, reference)) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    status = cursor.getNextNoDup(key, data, LockMode.DEFAULT);
                }
                return true;
            }
            finally {
                cursor.close();
            }
        }
        catch (DatabaseException e) {
            if (!DebugLogger.debugEnabled()) return true;
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            if (!DebugLogger.debugEnabled()) return true;
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
        }
        return true;
    }

    public Comparator<byte[]> getComparator() {
        return this.dn2uriComparator;
    }
}

