/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.controls.VLVResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SortOrder;
import org.opends.server.util.StaticUtils;

public class EntryIDSetSorter {
    public static EntryIDSet sort(EntryContainer entryContainer, EntryIDSet entryIDSet, SearchOperation searchOperation, SortOrder sortOrder, VLVRequestControl vlvRequest) throws DirectoryException {
        long[] sortedIDs;
        if (!entryIDSet.isDefined()) {
            return new EntryIDSet();
        }
        ID2Entry id2Entry = entryContainer.getID2Entry();
        DN baseDN = searchOperation.getBaseDN();
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        TreeMap<SortValues, EntryID> sortMap = new TreeMap<SortValues, EntryID>();
        for (EntryID id : entryIDSet) {
            try {
                Entry e = id2Entry.get(null, id);
                if (!e.matchesBaseAndScope(baseDN, scope) || !filter.matchesEntry(e)) continue;
                sortMap.put(new SortValues(id, e, sortOrder), id);
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_ENTRYIDSORTER_CANNOT_EXAMINE_ENTRY.get(String.valueOf(id), StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        if (vlvRequest != null) {
            int beforeCount = vlvRequest.getBeforeCount();
            int afterCount = vlvRequest.getAfterCount();
            if (vlvRequest.getTargetType() == -96) {
                int listOffset;
                int startPos;
                int targetOffset = vlvRequest.getOffset();
                if (targetOffset < 0) {
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset, sortMap.size(), 61));
                    Message message = JebMessages.ERR_ENTRYIDSORTER_NEGATIVE_START_POS.get();
                    throw new DirectoryException(ResultCode.VIRTUAL_LIST_VIEW_ERROR, message);
                }
                if (targetOffset == 0) {
                    targetOffset = 1;
                }
                if ((startPos = (listOffset = targetOffset - 1) - beforeCount) < 0) {
                    startPos = 0;
                    beforeCount = listOffset;
                } else if (startPos >= sortMap.size()) {
                    targetOffset = sortMap.size() + 1;
                    listOffset = sortMap.size();
                    startPos = listOffset - beforeCount;
                    afterCount = 0;
                }
                int count = 1 + beforeCount + afterCount;
                sortedIDs = new long[count];
                int treePos = 0;
                int arrayPos = 0;
                for (EntryID id : sortMap.values()) {
                    if (treePos++ < startPos) continue;
                    sortedIDs[arrayPos++] = id.longValue();
                    if (arrayPos < count) continue;
                    break;
                }
                if (arrayPos < count) {
                    long[] newIDArray = new long[arrayPos];
                    System.arraycopy(sortedIDs, 0, newIDArray, 0, arrayPos);
                    sortedIDs = newIDArray;
                }
                searchOperation.addResponseControl(new VLVResponseControl(targetOffset, sortMap.size(), 0));
            } else {
                AttributeValue assertionValue = new AttributeValue(sortOrder.getSortKeys()[0].getAttributeType(), vlvRequest.getGreaterThanOrEqualAssertion());
                boolean targetFound = false;
                int targetOffset = 0;
                int includedBeforeCount = 0;
                int includedAfterCount = 0;
                int listSize = 0;
                LinkedList<EntryID> idList = new LinkedList<EntryID>();
                for (Map.Entry entry : sortMap.entrySet()) {
                    SortValues sortValues = (SortValues)entry.getKey();
                    EntryID id = (EntryID)entry.getValue();
                    if (targetFound) {
                        idList.add(id);
                        ++listSize;
                        if (++includedAfterCount < afterCount) continue;
                        break;
                    }
                    targetFound = sortValues.compareTo(assertionValue) >= 0;
                    ++targetOffset;
                    if (targetFound) {
                        idList.add(id);
                        ++listSize;
                        continue;
                    }
                    if (beforeCount <= 0 || beforeCount <= 0) continue;
                    idList.add(id);
                    if (++includedBeforeCount > beforeCount) {
                        idList.removeFirst();
                        --includedBeforeCount;
                        continue;
                    }
                    ++listSize;
                }
                if (!targetFound) {
                    targetOffset = sortMap.size() + 1;
                }
                sortedIDs = new long[listSize];
                Iterator idIterator = idList.iterator();
                for (int i = 0; i < listSize; ++i) {
                    sortedIDs[i] = ((EntryID)idIterator.next()).longValue();
                }
                searchOperation.addResponseControl(new VLVResponseControl(targetOffset, sortMap.size(), 0));
            }
        } else {
            sortedIDs = new long[sortMap.size()];
            int i = 0;
            for (EntryID id : sortMap.values()) {
                sortedIDs[i++] = id.longValue();
            }
        }
        return new EntryIDSet(sortedIDs, 0, sortedIDs.length);
    }
}

